#!/usr/bin/env python

# pip install GitPython unidiff

from io import BytesIO
from difflib import Differ
import git
from unidiff import PatchSet
from git import Repo


def noCheckVersion(line):
    return False

def svgVersion(line):
    line = str(line)[1:].strip()
    res = line.startswith("<version>") and line.endswith("</version>")
    #print(f"check: '{line}' {res}")
    return res

def version_hunk(hunk, verFun):
    for line in hunk:
        if line.is_context:
            continue
        if not verFun(str(line)):
            print(f"Fail: {line}")
            return False
    return True


def gmtVersion(line):
    line = str(line)[1:].strip()
    res = line.startswith("# version ")
    #print(f"check: '{line}' {res}")
    return res


def main():
    repo = Repo(".")

    cltfPaths = [
        "src/doc/sphinx/source/examples",
        "src/test/resources/edu/sc/seis/TauP/cmdLineTest",
        #"src/test/resources/edu/sc/seis/TauP/cmdLineTest/taup_path_-o_stdout_--mod_ak135_--svg_-h_10_-p_P_S_PedOP_--scatter_200_-5_--deg_40"
    ]

    git_cmd = repo.git
    diffs = repo.index.diff(None)
    for d in diffs:
        for cpath in cltfPaths:
            if d.a_path.startswith(cpath):
                difftxt = git_cmd.diff( "-U0", d.a_path)
                patch_set = PatchSet(BytesIO(difftxt.encode(encoding='utf-8')), encoding='utf-8')
                for patched_file in patch_set:
                    verFun = noCheckVersion
                    if "--svg" in patched_file.path:
                        verFun = svgVersion
                    elif "--gmt" in patched_file.path:
                        verFun = gmtVersion
                    notVersion=[]
                    for hunk in patched_file:
                        if not version_hunk(hunk, verFun):
                            notVersion.append(hunk)
                    if len(notVersion) > 0:
                        print(f"{d.a_path} has non-version changes.")
                        for h in notVersion:
                            for l in h:
                                print(l)
                    else:
                        git_cmd.restore(patched_file.path)
    print(f"Num diffs: {len(diffs)}")

if __name__ == "__main__":
    main()
