/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.TauP_PhaseDescribe;
import edu.sc.seis.TauP.cmdline.TauP_ReflTransPlot;
import edu.sc.seis.TauP.cmdline.TauP_VelocityDison;
import edu.sc.seis.TauP.cmdline.TauP_VelocityMerge;
import edu.sc.seis.TauP.cmdline.TauP_VelocityPlot;
import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public abstract class TauP_Tool
implements Callable<Integer> {
    @CommandLine.Option(names={"--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    protected Properties toolProps;
    public AbstractOutputTypeArgs abstractOutputTypeArgs;
    public static final String OPTIONS_HEADING = "%nOptions:%n%n";
    public static final boolean ABREV_SYNOPSIS = false;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public TauP_Tool(AbstractOutputTypeArgs outputTypeArgs) {
        this.abstractOutputTypeArgs = outputTypeArgs;
        this.toolProps = TauP_Tool.configDefaults();
    }

    @Override
    public Integer call() throws Exception {
        Outputs.configure(this.toolProps);
        SeismicPhaseFactory.configure(this.toolProps);
        this.init();
        try {
            this.validateArguments();
        }
        catch (TauPException | IllegalArgumentException e) {
            if (this.spec != null) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), e.getMessage(), e);
            }
            throw e;
        }
        this.start();
        return 0;
    }

    @CommandLine.Option(names={"--debug"}, description={"enable debugging output"})
    public void setDEBUG(boolean debug) {
        TauPConfig.DEBUG = debug;
    }

    public boolean isDEBUG() {
        return TauPConfig.DEBUG;
    }

    @CommandLine.Option(names={"--verbose"}, description={"enable verbose output"})
    public void setVerbose(boolean verbose) {
        TauPConfig.VERBOSE = verbose;
    }

    public boolean isVerbose() {
        return TauPConfig.VERBOSE || TauPConfig.DEBUG;
    }

    public List<String> getCmdLineArgs() {
        return this.spec.commandLine().getParseResult().expandedArgs();
    }

    public static Properties configDefaults() {
        Properties toolProps;
        try {
            toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            toolProps = new Properties();
        }
        Outputs.configure(toolProps);
        SeismicPhaseFactory.configure(toolProps);
        return toolProps;
    }

    public abstract String getOutputFormat();

    public void setOutputFormat(String val) {
        this.abstractOutputTypeArgs.setOutputFormat(val);
    }

    public void setOutFileBase(String outFileBase) {
        this.abstractOutputTypeArgs.setOutFileBase(outFileBase);
    }

    public String getOutFileExtension() {
        return this.abstractOutputTypeArgs.getOutFileExtension();
    }

    public void setOutFileExtension(String outFileExtension) {
        this.abstractOutputTypeArgs.setOutFileExtension(outFileExtension);
    }

    @CommandLine.Option(names={"--prop"}, description={"load defaults from properties file"})
    public void setToolPropsFilename(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new FileNotFoundException(filename);
        }
        BufferedReader r = new BufferedReader(new FileReader(filename));
        this.toolProps.load(r);
    }

    public abstract void init() throws TauPException;

    public abstract void start() throws IOException, TauPException;

    public abstract void destroy() throws TauPException;

    public static String toolNameFromClass(Class toolClass) {
        String className = toolClass.getName();
        String toolName = className = className.substring(className.lastIndexOf(46) + 1);
        if (toolName.startsWith("TauP_")) {
            toolName = toolName.replace('_', ' ');
        }
        if (toolClass.equals(TauP_VelocityPlot.class)) {
            toolName = "taup velplot";
        } else if (toolClass.equals(TauP_VelocityMerge.class)) {
            toolName = "taup velmerge";
        } else if (toolClass.equals(TauP_PhaseDescribe.class)) {
            toolName = "taup phase";
        } else if (toolClass.equals(TauP_VelocityDison.class)) {
            toolName = "taup discon";
        } else if (toolClass.equals(TauP_ReflTransPlot.class)) {
            toolName = "taup refltrans";
        }
        return toolName.toLowerCase();
    }

    public abstract void validateArguments() throws TauPException;
}

