/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PhaseParseException;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import edu.sc.seis.TauP.cmdline.args.PhaseArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import picocli.CommandLine;

public abstract class TauP_AbstractPhaseTool
extends TauP_Tool {
    protected List<PhaseName> phaseNames = null;
    @CommandLine.Mixin
    ModelArgs modelArgs = new ModelArgs();
    private List<SeismicPhase> phases = null;
    @CommandLine.ArgGroup(heading="Phase Names %n", exclusive=false)
    PhaseArgs phaseArgs = new PhaseArgs();

    public TauP_AbstractPhaseTool(AbstractOutputTypeArgs outputTypeArgs) {
        super(outputTypeArgs);
        this.phaseArgs.setTool(this);
    }

    public TimeResult createTimeResult(boolean isWithAmplitude, SeismicSource sourceArgs, List<Arrival> arrivalList) throws PhaseParseException {
        return new TimeResult(this.modelArgs.getModelName(), this.modelArgs.getSourceDepths(), this.modelArgs.getReceiverDepths(), this.getPhaseArgs().parsePhaseNameList(), this.getScatterer(), isWithAmplitude, sourceArgs, arrivalList);
    }

    public double getRadiusOfEarth() {
        try {
            return this.modelArgs.getTauModel().getRadiusOfEarth();
        }
        catch (TauModelException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PhaseName> parsePhaseNameList() throws PhaseParseException {
        if (this.phaseNames == null) {
            this.phaseNames = this.phaseArgs.parsePhaseNameList();
        }
        return this.phaseNames;
    }

    public void setPhaseNameList(List<PhaseName> phaseNames) {
        this.clearPhases();
        this.phaseNames = phaseNames;
    }

    @Override
    public void init() throws TauPException {
    }

    public void setPhaseNames(List<String> phaseNames) throws PhaseParseException {
        this.clearPhaseNames();
        for (String phasename : phaseNames) {
            this.appendPhaseName(phasename);
        }
    }

    public synchronized void appendPhaseName(String phaseName) throws PhaseParseException {
        for (String s : PhaseArgs.extractPhaseNames(phaseName)) {
            this.appendPhaseName(PhaseName.parseName(s));
        }
    }

    public synchronized void appendPhaseName(PhaseName phaseName) {
        if (phaseName.name == null || phaseName.name.isEmpty()) {
            return;
        }
        if (this.phaseNames == null) {
            this.phaseNames = new ArrayList<PhaseName>();
        }
        this.phaseNames.add(phaseName);
    }

    public int getNumPhases() {
        try {
            return this.parsePhaseNameList().size();
        }
        catch (PhaseParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearPhaseNames() {
        this.phases = null;
        this.phaseNames = null;
    }

    public void setSingleSourceDepth(double depth) {
        this.modelArgs.setSourceDepths(Collections.singletonList(depth));
        this.toolProps.put("taup.source.depth", Double.toString(depth));
        this.clearPhases();
    }

    public void setSingleReceiverDepth(double receiverDepth) {
        this.modelArgs.setReceiverDepths(Collections.singletonList(receiverDepth));
        this.clearPhases();
    }

    public double getScattererDepth() {
        return this.modelArgs.getScatterer().depth;
    }

    public Scatterer getScatterer() {
        return this.modelArgs.getScatterer();
    }

    public void setScatterer(Scatterer scatterer) {
        this.clearPhases();
        this.modelArgs.setScatterer(scatterer.depth, scatterer.dist.getDegrees(this.getRadiusOfEarth()));
    }

    public String getTauModelName() {
        return this.modelArgs.getModelName();
    }

    public TauModel getTauModelDepthCorrected(double sourceDepth) throws TauModelException {
        return this.modelArgs.depthCorrected(sourceDepth);
    }

    public void setModelName(String modelName) {
        this.modelArgs.setModelName(modelName);
    }

    public void setTauModel(TauModel tMod) {
        this.clearPhases();
        this.modelArgs.setModelName(tMod.getModelName());
        this.modelArgs.setTMod(tMod);
        this.toolProps.put("taup.model.name", tMod.getModelName());
        if (this.isVerbose()) {
            Alert.info("Model set to " + tMod.getModelName() + " with moho=" + tMod.getMohoDepth() + " cmb=" + tMod.getCmbDepth() + " iocb=" + tMod.getIocbDepth() + " radius=" + tMod.getRadiusOfEarth());
        }
    }

    public void clearPhases() {
        this.phases = null;
    }

    public List<SeismicPhase> calcSeismicPhases(double sourceDepth) throws TauPException {
        return this.calcSeismicPhases(sourceDepth, this.getReceiverDepths(), this.modelArgs.getScatterer());
    }

    public List<SeismicPhase> calcSeismicPhases(double sourceDepth, List<Double> receiverDepths, Scatterer scatterer) throws TauModelException {
        return SeismicPhaseFactory.calculateSeismicPhases(this.modelArgs.depthCorrected(sourceDepth), this.parsePhaseNameList(), sourceDepth, receiverDepths, scatterer);
    }

    public List<Double> getSourceDepths() throws TauPException {
        ArrayList<Double> out = new ArrayList<Double>(this.modelArgs.getSourceDepths());
        if (out.isEmpty()) {
            out.add(Double.parseDouble(this.toolProps.getProperty("taup.source.depth", "0.0")));
        }
        return out;
    }

    public List<Double> getReceiverDepths() throws TauPException {
        List<Double> out = this.modelArgs.getReceiverDepths();
        if (out.isEmpty()) {
            out.add(0.0);
        }
        return out;
    }

    public List<SeismicPhase> getSeismicPhases() throws TauPException {
        if (this.phases == null) {
            this.phases = new ArrayList<SeismicPhase>();
            List<Double> receiverDepths = this.getReceiverDepths();
            for (Double sourceDepth : this.getSourceDepths()) {
                this.phases.addAll(this.calcSeismicPhases(sourceDepth, receiverDepths, this.modelArgs.getScatterer()));
            }
        }
        return this.phases;
    }

    public PhaseArgs getPhaseArgs() {
        return this.phaseArgs;
    }
}

