/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.file.FileSystems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TauModelLoader {
    protected static String packageName = "/edu/sc/seis/TauP/StdModels";
    public static List<String> defaultModelList = List.of("iasp91", "ak135", "ak135favg", "ak135fcont", "ak135fsyngine", "prem");
    public static Map<String, VelocityModel> otherVelocityModels = new HashMap<String, VelocityModel>();
    static HashMap<String, SoftReference<TauModel>> tModCache = new HashMap();

    public static TauModel load(String modelName) throws TauModelException {
        return TauModelLoader.load(modelName, System.getProperty("taup.model.path"));
    }

    public static TauModel load(String modelName, String searchPath) throws TauModelException {
        return TauModelLoader.load(modelName, searchPath, true);
    }

    public static TauModel load(String modelName, String searchPath, boolean verbose) throws TauModelException {
        TauModel out = TauModelLoader.loadFromCache(modelName);
        if (out == null) {
            out = TauModelLoader.internalLoad(modelName, searchPath, verbose);
            TauModelLoader.addToCache(modelName, out);
        }
        return out;
    }

    public static void addToCache(String modelName, TauModel tMod) {
        tModCache.put(modelName, new SoftReference<TauModel>(tMod));
    }

    public static TauModel internalLoad(String modelName, String searchPath, boolean verbose) throws TauModelException {
        try {
            File modelFile;
            ZipFile zippy;
            ZipEntry zipEntry;
            File jarFile;
            String pathEntry;
            int pathSepIndex;
            int offset;
            String taupPath;
            String classPath;
            Object filename;
            block22: {
                filename = modelName.endsWith(".taup") ? modelName : modelName + ".taup";
                classPath = System.getProperty("java.class.path");
                taupPath = searchPath;
                offset = 0;
                if (otherVelocityModels.containsKey(modelName)) {
                    try {
                        VelocityModel vmod = TauModelLoader.loadVelocityModel(modelName);
                        if (vmod != null) {
                            return TauModelLoader.createTauModel(vmod);
                        }
                    }
                    catch (Exception e) {
                        throw new TauModelException("Can't find any saved models for " + modelName + " and creation from velocity model failed.", e);
                    }
                }
                Class<?> c = null;
                try {
                    c = Class.forName("edu.sc.seis.TauP.TauModelLoader");
                    InputStream in = c.getResourceAsStream(packageName + "/" + (String)filename);
                    if (in != null) {
                        return TauModel.readModelFromStream(in);
                    }
                }
                catch (InvalidClassException ex) {
                    throw new TauModelException("TauModel file not compatible with current version, recreate: " + c.getResource(packageName + "/" + (String)filename), ex);
                }
                catch (Exception ex) {
                    if (!verbose) break block22;
                    Alert.warning("couldn't load as resource: " + (String)filename + "\n message: " + ex.getMessage());
                }
            }
            while (offset < classPath.length()) {
                pathSepIndex = classPath.indexOf(File.pathSeparatorChar, offset);
                if (pathSepIndex != -1) {
                    pathEntry = classPath.substring(offset, pathSepIndex);
                    offset = pathSepIndex + 1;
                } else {
                    pathEntry = classPath.substring(offset);
                    offset = classPath.length();
                }
                if (!(jarFile = new File(pathEntry)).exists() || !jarFile.isFile() || !jarFile.getName().equals("taup.jar") || !jarFile.canRead() || (zipEntry = (zippy = new ZipFile(jarFile)).getEntry("StdModels/" + (String)filename)) == null) continue;
                return TauModel.readModelFromStream(zippy.getInputStream(zipEntry));
            }
            offset = 0;
            if (taupPath != null) {
                while (offset < taupPath.length()) {
                    pathSepIndex = taupPath.indexOf(File.pathSeparatorChar, offset);
                    if (pathSepIndex != -1) {
                        pathEntry = taupPath.substring(offset, pathSepIndex);
                        offset = pathSepIndex + 1;
                    } else {
                        pathEntry = taupPath.substring(offset);
                        offset = taupPath.length();
                    }
                    if (pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip")) {
                        jarFile = new File(pathEntry);
                        if (!jarFile.exists() || !jarFile.isFile() || !jarFile.canRead() || (zipEntry = (zippy = new ZipFile(jarFile)).getEntry("Models/" + (String)filename)) == null) continue;
                        return TauModel.readModelFromStream(zippy.getInputStream(zipEntry));
                    }
                    modelFile = new File(pathEntry + "/" + (String)filename);
                    if (!modelFile.exists() || !modelFile.isFile() || !modelFile.canRead()) continue;
                    return TauModel.readModel(modelFile.getCanonicalPath());
                }
            }
            if ((modelFile = new File((String)filename)).exists() && modelFile.isFile() && modelFile.canRead()) {
                return TauModel.readModel(modelFile.getCanonicalPath());
            }
            try {
                VelocityModel vmod = TauModelLoader.loadVelocityModel(modelName);
                if (vmod != null) {
                    return TauModelLoader.createTauModel(vmod);
                }
            }
            catch (Exception e) {
                throw new TauModelException("Can't find any saved models for " + modelName + " and creation from velocity model failed.", e);
            }
            throw new TauModelException("Can't find any saved models for " + modelName);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
    }

    public static VelocityModel loadVelocityModel(String modelName) throws IOException, VelocityModelException {
        return TauModelLoader.loadVelocityModel(modelName, null);
    }

    public static VelocityModel loadVelocityModel(String modelName, String fileType) throws IOException, VelocityModelException {
        if (otherVelocityModels.containsKey(modelName)) {
            VelocityModel vMod = otherVelocityModels.get(modelName);
            if (vMod == null) {
                throw new VelocityModelException("Velocity model " + modelName + " is null");
            }
            return vMod;
        }
        if (modelName == null) {
            modelName = "iasp91";
            fileType = "tvel";
        }
        String basemodelName = modelName;
        int dirSepIndex = modelName.lastIndexOf(FileSystems.getDefault().getSeparator());
        if (dirSepIndex != -1) {
            basemodelName = modelName.substring(dirSepIndex + 1);
        }
        if (basemodelName.endsWith(".tvel")) {
            if (fileType == null) {
                fileType = "tvel";
            }
            basemodelName = basemodelName.substring(0, basemodelName.length() - 5);
        } else if (basemodelName.endsWith(".nd")) {
            if (fileType == null) {
                fileType = "nd";
            }
            basemodelName = basemodelName.substring(0, basemodelName.length() - 3);
        }
        VelocityModel vMod = null;
        if (dirSepIndex == -1) {
            InputStreamReader inReader;
            String filename;
            InputStream in;
            Class<TauModelLoader> c = TauModelLoader.class;
            if ((fileType == null || fileType.equals("nd")) && (in = c.getResourceAsStream(packageName + "/" + (filename = basemodelName + ".nd"))) != null) {
                inReader = new InputStreamReader(in);
                vMod = VelocityModel.readNDFile(inReader, modelName);
                ((Reader)inReader).close();
            }
            if (vMod == null && (in = c.getResourceAsStream(packageName + "/" + (filename = basemodelName + ".tvel"))) != null) {
                inReader = new InputStreamReader(in);
                vMod = VelocityModel.readTVelFile(inReader, modelName);
                ((Reader)inReader).close();
            }
        }
        if (vMod == null) {
            String[] types = new String[]{"", "." + fileType};
            if (fileType == null) {
                types = new String[]{"", ".nd", ".tvel"};
            }
            for (int i = 0; i < types.length; ++i) {
                String vmodFile = modelName + types[i];
                File modelFile = new File(vmodFile);
                if (!modelFile.exists() || !modelFile.isFile() || !modelFile.canRead()) continue;
                vMod = VelocityModel.readVelocityFile(modelFile.getPath(), types[i]);
                break;
            }
        }
        return vMod;
    }

    public static TauModel createTauModel(VelocityModel vMod) throws SlownessModelException, TauModelException, IOException {
        return TauModelLoader.createTauModel(vMod, PropertyLoader.load());
    }

    public static TauModel createTauModel(VelocityModel vMod, Properties toolProps) throws SlownessModelException, TauModelException {
        if (vMod == null) {
            throw new IllegalArgumentException("vMod cannot be null");
        }
        if (!vMod.getSpherical()) {
            throw new SlownessModelException("Flat slowness model not yet implemented.");
        }
        SlownessModel.DEBUG = TauPConfig.DEBUG;
        SphericalSModel sMod = new SphericalSModel(vMod, Double.parseDouble(toolProps.getProperty("taup.create.minDeltaP", "0.1")), Double.parseDouble(toolProps.getProperty("taup.create.maxDeltaP", "11.0")), Double.parseDouble(toolProps.getProperty("taup.create.maxDepthInterval", "115.0")), Double.parseDouble(toolProps.getProperty("taup.create.maxRangeInterval", "2.5")) * Math.PI / 180.0, Double.parseDouble(toolProps.getProperty("taup.create.maxInterpError", "0.05")), Boolean.parseBoolean(toolProps.getProperty("taup.create.allowInnerCoreS", "true")), 1.0E-16);
        if (TauPConfig.VERBOSE) {
            Alert.debug("Parameters are:");
            Alert.debug("taup.create.minDeltaP = " + sMod.getMinDeltaP() + " sec / radian");
            Alert.debug("taup.create.maxDeltaP = " + sMod.getMaxDeltaP() + " sec / radian");
            Alert.debug("taup.create.maxDepthInterval = " + sMod.getMaxDepthInterval() + " kilometers");
            Alert.debug("taup.create.maxRangeInterval = " + sMod.getMaxRangeInterval() + " degrees");
            Alert.debug("taup.create.maxInterpError = " + sMod.getMaxInterpError() + " seconds");
            Alert.debug("taup.create.allowInnerCoreS = " + sMod.isAllowInnerCoreS());
            Alert.debug("Slow model  " + sMod.getNumLayers(true) + " P layers," + sMod.getNumLayers(false) + " S layers");
        }
        if (TauPConfig.DEBUG) {
            Alert.debug(sMod.toString());
        }
        TauModel.DEBUG = TauPConfig.DEBUG;
        SlownessModel.DEBUG = TauPConfig.DEBUG;
        return new TauModel(sMod);
    }

    protected static TauModel loadFromCache(String modelName) {
        SoftReference<TauModel> sr = tModCache.get(modelName);
        if (sr != null) {
            TauModel out = sr.get();
            if (out == null) {
                tModCache.remove(modelName);
            }
            return out;
        }
        return null;
    }

    public static void clearCache() {
        tModCache.clear();
    }
}

