/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.ReflTransFreeSurface;
import edu.sc.seis.TauP.VelocityModelException;

public class ReflTransSolidFreeSurface
extends ReflTransFreeSurface {
    protected Complex fsA;

    public ReflTransSolidFreeSurface(double inVp, double inVs, double inDensity) throws VelocityModelException {
        super(inVp, inVs, inDensity, 0.0, 0.0, 0.0);
        if (this.topVp * this.topVs * this.topDensity == 0.0) {
            throw new VelocityModelException("Free Surface Solid-solid reflection and transmission coefficients must have non-zero layer params: in:" + this.topVp + " " + this.topVs + " " + this.topDensity);
        }
    }

    @Override
    public Complex getComplexRpp(double rayParam) {
        this.calcTempVars(rayParam, true);
        Complex numerator = Complex.plus(-1.0 * (1.0 / this.sqTopVs - 2.0 * this.sqRP) * (1.0 / this.sqTopVs - 2.0 * this.sqRP), Complex.times(this.topVertSlownessP, this.topVertSlownessS).times(4.0 * this.sqRP));
        return Complex.over(numerator, this.fsA);
    }

    @Override
    public Complex getComplexRps(double rayParam) {
        this.calcTempVars(rayParam, true);
        double realNumerator = 4.0 * (this.topVp / this.topVs) * this.rp * (1.0 / this.sqTopVs - 2.0 * this.sqRP);
        return Complex.over(Complex.times(realNumerator, this.topVertSlownessP), this.fsA);
    }

    @Override
    public Complex getComplexTpp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public Complex getComplexTps(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public Complex getComplexRsp(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = 4.0 * (this.topVs / this.topVp) * this.rp * (1.0 / this.sqTopVs - 2.0 * this.sqRP);
        return Complex.over(Complex.times(realNumerator, this.topVertSlownessS), this.fsA);
    }

    @Override
    public Complex getComplexRss(double rayParam) {
        this.calcTempVars(rayParam, false);
        double realNumerator = (1.0 / this.sqTopVs - 2.0 * this.sqRP) * (1.0 / this.sqTopVs - 2.0 * this.sqRP);
        Complex numerator = Complex.minus(realNumerator, this.topVertSlownessP.times(this.topVertSlownessS).times(4.0 * this.sqRP));
        return Complex.over(numerator, this.fsA);
    }

    @Override
    public Complex getComplexTsp(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public Complex getComplexTss(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public Complex getComplexRshsh(double rayParam) {
        return new Complex(1.0);
    }

    @Override
    public Complex getComplexTshsh(double rayParam) throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public ReflTrans flip() throws VelocityModelException {
        throw new VelocityModelException("Not legal for free surface");
    }

    @Override
    public double getFreeSurfaceReceiverFunSh(double rayParam) {
        return 2.0;
    }

    @Override
    public double getFreeSurfaceReceiverFunP_r(double rayParam) {
        return Complex.abs(this.getFreeSurfaceReceiverFunP(rayParam)[0]);
    }

    @Override
    public double getFreeSurfaceReceiverFunP_z(double rayParam) {
        return Complex.abs(this.getFreeSurfaceReceiverFunP(rayParam)[1]);
    }

    @Override
    public Complex[] getFreeSurfaceReceiverFunP(double rayParam) {
        this.calcTempVars(rayParam, true);
        double betaRpFactor = 1.0 / (this.topVs * this.topVs) - 2.0 * this.sqRP;
        Complex reyleighDenom = this.topVertSlownessS.times(this.topVertSlownessP).times(4.0 * this.sqRP).plus(betaRpFactor * betaRpFactor);
        Complex etarpFactor = this.topVertSlownessS.times(this.topVertSlownessS).minus(this.sqRP);
        Complex rDisp = this.topVertSlownessS.times(this.topVertSlownessP).times(4.0 * this.topVp * rayParam / (this.topVs * this.topVs)).over(reyleighDenom);
        Complex zDisp = this.topVertSlownessP.times(2.0 * this.topVp / (this.topVs * this.topVs)).times(etarpFactor).over(reyleighDenom);
        if (Complex.abs(zDisp) > 10.0) {
            zDisp = new Complex(10.0);
        }
        if (Complex.abs(rDisp) > 10.0) {
            rDisp = new Complex(10.0);
        }
        return new Complex[]{rDisp, zDisp};
    }

    @Override
    public double getFreeSurfaceReceiverFunSv_r(double rayParam) {
        return Complex.abs(this.getFreeSurfaceReceiverFunSv(rayParam)[0]);
    }

    @Override
    public double getFreeSurfaceReceiverFunSv_z(double rayParam) {
        return Complex.abs(this.getFreeSurfaceReceiverFunSv(rayParam)[1]);
    }

    @Override
    public Complex[] getFreeSurfaceReceiverFunSv(double rayParam) {
        this.calcTempVars(rayParam, false);
        double betaRpFactor = 1.0 / (this.topVs * this.topVs) - 2.0 * this.sqRP;
        Complex reyleighDenom = this.topVertSlownessS.times(this.topVertSlownessP).times(4.0 * this.sqRP).plus(betaRpFactor * betaRpFactor);
        Complex etarpFactor = this.topVertSlownessS.times(this.topVertSlownessS).minus(this.sqRP);
        Complex rDisp = this.topVertSlownessS.times(2.0 / this.topVs).times(etarpFactor).over(reyleighDenom);
        Complex zDisp = this.topVertSlownessS.times(this.topVertSlownessP).times(-4.0 * rayParam / this.topVs).over(reyleighDenom);
        if (Complex.abs(zDisp) > 10.0) {
            zDisp = new Complex(10.0);
        }
        if (Complex.abs(rDisp) > 10.0) {
            rDisp = new Complex(10.0);
        }
        return new Complex[]{rDisp, zDisp};
    }

    public String toString() {
        return "Solid-free surface:  in: Vp: " + this.topVp + " Vs: " + this.topVs + " d: " + this.topDensity;
    }

    @Override
    protected void calcTempVars(double rayParam, boolean inIsPWave) {
        if (rayParam < 0.0) {
            throw new IllegalArgumentException("rayParam cannot be negative");
        }
        this.rp = rayParam;
        if (rayParam != this.lastRayParam || inIsPWave != this.lastInIsPWave) {
            this.lastRayParam = -1.0;
            this.sqRP = this.rp * this.rp;
            this.topVertSlownessP = this.calcInVerticalSlownessP(this.rp);
            this.topVertSlownessS = this.calcInVerticalSlownessS(this.rp);
            this.fsA = Complex.plus(new Complex((1.0 / this.sqTopVs - 2.0 * this.sqRP) * (1.0 / this.sqTopVs - 2.0 * this.sqRP)), Complex.times(this.topVertSlownessP, this.topVertSlownessS).times(4.0 * this.sqRP));
            this.lastRayParam = rayParam;
            this.lastInIsPWave = inIsPWave;
        }
    }
}

