/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.FaultPlane;
import edu.sc.seis.TauP.MomentMagnitude;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import java.util.List;
import picocli.CommandLine;

public class SeismicSourceArgs {
    Float mw = null;
    @CommandLine.Option(names={"--attenuationfreq"}, defaultValue="1.0", description={"attenuation frequency for amplitude calculations, default is ${DEFAULT-VALUE}"})
    Float attenuationFreq = null;
    @CommandLine.Option(names={"--numattenuationfreq"}, defaultValue="64", description={" number attenuation frequencies for amplitude calculations, default is ${DEFAULT-VALUE}"})
    int numFrequencies = 64;
    List<Float> strikeDipRake = null;

    @CommandLine.Option(names={"--mw"}, defaultValue="4.0", description={"scale amplitude by source moment magnitude, default is ${DEFAULT-VALUE}"})
    public void setMw(float mw) {
        this.mw = Float.valueOf(mw);
    }

    public float getMw() {
        if (this.mw == null) {
            return MomentMagnitude.MAG4;
        }
        return this.mw.floatValue();
    }

    public double getMoment() {
        return MomentMagnitude.mw_to_N_m(this.getMw());
    }

    public float getAttenuationFrequency() {
        if (this.attenuationFreq == null) {
            return 1.0f;
        }
        return this.attenuationFreq.floatValue();
    }

    public int getNumFrequencies() {
        return this.numFrequencies;
    }

    @CommandLine.Option(names={"--strikediprake"}, paramLabel="strike dip rake", hideParamSyntax=true, arity="3", description={"fault strike, dip and rake for amplitude calculations. If not given radiation pattern is unity in all directions."})
    public void setStrikeDipRake(List<Float> sdr) {
        if (sdr.isEmpty()) {
            this.strikeDipRake = null;
        } else if (sdr.size() != 3) {
            Object valStr = "";
            for (Float f : sdr) {
                valStr = (String)valStr + " " + f;
            }
            throw new IllegalArgumentException(String.format("Invalid number of params '%d' for option '--strikediprake': must give 3 values: %s", sdr.size(), valStr));
        }
        this.strikeDipRake = sdr;
    }

    public boolean hasStrikeDipRake() {
        return this.strikeDipRake != null;
    }

    public List<Float> getStrikeDipRake() {
        return this.strikeDipRake;
    }

    public FaultPlane getFaultPlane() {
        if (this.strikeDipRake != null) {
            return new FaultPlane(this.strikeDipRake.get(0).floatValue(), this.strikeDipRake.get(1).floatValue(), this.strikeDipRake.get(2).floatValue());
        }
        return null;
    }

    public void validateArguments() {
        if (this.strikeDipRake != null) {
            if (this.strikeDipRake.size() != 3) {
                throw new IllegalArgumentException("StrikeDipRake must have 3 values, but was: " + this.strikeDipRake.size());
            }
            if (this.strikeDipRake.get(0).floatValue() < -180.0f || 360.0f < this.strikeDipRake.get(0).floatValue()) {
                throw new IllegalArgumentException("Strike should be -180 to 360, but was " + this.strikeDipRake.get(0));
            }
            if (this.strikeDipRake.get(1).floatValue() < -90.0f || 90.0f < this.strikeDipRake.get(1).floatValue()) {
                throw new IllegalArgumentException("Dip should be -90 to 90, but was " + this.strikeDipRake.get(1));
            }
            if (this.strikeDipRake.get(2).floatValue() < -180.0f || 180.0f < this.strikeDipRake.get(2).floatValue()) {
                throw new IllegalArgumentException("Rake should be -180 to 180, but was " + this.strikeDipRake.get(2));
            }
        }
    }

    public void validateArgumentsForAmplitude(ModelArgs modelArgs, List<RayCalculateable> rayList) throws TauPException {
        if (modelArgs.getTauModel().getVelocityModel().densityIsDefault()) {
            throw new TauModelException("model " + modelArgs.getModelName() + " does not include density, but amplitude requires density.");
        }
        if (modelArgs.getTauModel().getVelocityModel().QIsDefault()) {
            throw new TauModelException("model " + modelArgs.getModelName() + " does not include Q, but amplitude requires Q. Please choose a different model.");
        }
        if (this.hasStrikeDipRake()) {
            for (RayCalculateable rc : rayList) {
                if (rc.hasAzimuth()) continue;
                throw new IllegalArgumentException("Amplitude with Strike,Dip,Rake requires azimuth: " + rc);
            }
        }
    }

    public String toString() {
        return this.getMw() + " Mw, strike: " + this.strikeDipRake.get(0) + ", dip: " + this.strikeDipRake.get(1) + ", rake: " + this.strikeDipRake.get(2);
    }

    public SeismicSource getSeismicSource() {
        return new SeismicSource(this.getMw(), this.hasStrikeDipRake() ? this.getFaultPlane() : null);
    }
}

