/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.LatLonSimple;
import edu.sc.seis.seisFile.Location;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class LatLonArgs {
    @CommandLine.Option(names={"--sta", "--station"}, arity="2", paramLabel="lat lon", hideParamSyntax=true, description={"station latitude and longitude. Creates a distance if event is also given."})
    protected List<Double> stationLatLonList = new ArrayList<Double>();
    @CommandLine.Option(names={"--evt", "--event"}, arity="2", paramLabel="lat lon", hideParamSyntax=true, description={"event latitude and longitude.  Creates a distance if station is also given."})
    protected List<Double> eventLatLonList = new ArrayList<Double>();

    public void setStationLatLon(List<Double> stationLatLon) {
        this.stationLatLonList = stationLatLon;
    }

    public List<LatLonLocatable> getStationLocations() {
        ArrayList<LatLonLocatable> out = new ArrayList<LatLonLocatable>();
        for (int i = 0; i < this.stationLatLonList.size(); i += 2) {
            LatLonSimple loc = new LatLonSimple(this.stationLatLonList.get(i).doubleValue(), this.stationLatLonList.get(i + 1).doubleValue());
            out.add((LatLonLocatable)loc);
        }
        return out;
    }

    public boolean hasStationLatLon() {
        return !this.stationLatLonList.isEmpty();
    }

    public void setEventLatLon(List<Double> eventLatLon) {
        this.eventLatLonList = eventLatLon;
    }

    public List<LatLonLocatable> getEventLocations() {
        ArrayList<LatLonLocatable> out = new ArrayList<LatLonLocatable>();
        for (int i = 0; i < this.eventLatLonList.size(); i += 2) {
            LatLonSimple loc = new LatLonSimple(this.eventLatLonList.get(i).doubleValue(), this.eventLatLonList.get(i + 1).doubleValue());
            out.add((LatLonLocatable)loc);
        }
        return out;
    }

    public boolean hasEventLatLon() {
        return !this.eventLatLonList.isEmpty();
    }

    public void validateArguments() {
        for (LatLonLocatable loc : this.getEventLocations()) {
            if (!(loc.asLocation().getLatitude() < -90.0) && !(loc.asLocation().getLatitude() > 90.0)) continue;
            String desc = loc.getLocationDescription();
            throw new IllegalArgumentException("Latitude must be -90 <= lat <= 90, but was " + loc.asLocation().getLatitude() + " for " + desc);
        }
        for (LatLonLocatable staLoc : this.getStationLocations()) {
            Location loc = staLoc.asLocation();
            if (!(loc.getLatitude() < -90.0) && !(loc.getLatitude() > 90.0)) continue;
            String desc = loc.getDescription();
            desc = desc != null ? desc : loc.getLatitude() + "/" + loc.getLongitude();
            throw new IllegalArgumentException("Latitude must be -90 <= lat <= 90, but was " + loc.getLatitude() + " for " + desc);
        }
    }
}

