/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseLayerFactoryAllFail;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class SeismicPhaseLayerFactory {
    String layerName;
    public static final String SURFACE_OF_EARTH = "surface of earth";
    public static final String CRUST_MANTLE = "crust/mantle";
    public static final String OUTER_CORE = "outer core";
    public static final String INNER_CORE = "inner core";
    public static final String CENTER_OF_EARTH = "center of earth";
    public static final char EMPTY = ' ';
    char p_leg = (char)32;
    char up_p_leg = (char)32;
    char s_leg = (char)32;
    char up_s_leg = (char)32;
    TauModel tMod;
    int topBranchNum;
    int botBranchNum;
    double topDepth;
    double botDepth;
    double depthTolerance = 10.0;
    SeismicPhaseFactory baseFactory;
    SeismicPhaseLayerFactory aboveLayerFactory;
    SeismicPhaseLayerFactory belowLayerFactory;

    public SeismicPhaseLayerFactory(SeismicPhaseFactory baseFactory, String layerName, int topBranchNum, int botBranchNum) {
        this.baseFactory = baseFactory;
        this.tMod = baseFactory.tMod;
        this.layerName = layerName;
        this.topBranchNum = topBranchNum;
        this.topDepth = topBranchNum == -1 ? 0.0 : (topBranchNum == this.tMod.getNumBranches() ? this.tMod.getRadiusOfEarth() : this.tMod.getTauBranch(topBranchNum, true).getTopDepth());
        this.botBranchNum = botBranchNum;
        this.botDepth = botBranchNum == -1 ? 0.0 : (botBranchNum == this.tMod.getNumBranches() ? this.tMod.getRadiusOfEarth() : this.tMod.getTauBranch(botBranchNum, true).getBotDepth());
    }

    public static SeismicPhaseLayerFactory crustMantleFactory(SeismicPhaseFactory baseFactory) {
        if (baseFactory.tMod.isDegenerateCrustMantle()) {
            String reason = "Model with no mantle, cmb at surface";
            return new SeismicPhaseLayerFactoryAllFail(baseFactory, CRUST_MANTLE, -1, -1, reason);
        }
        SeismicPhaseLayerFactory factory = new SeismicPhaseLayerFactory(baseFactory, CRUST_MANTLE, 0, baseFactory.tMod.getCmbBranch() - 1);
        factory.p_leg = (char)80;
        factory.up_p_leg = (char)112;
        factory.s_leg = (char)83;
        factory.up_s_leg = (char)115;
        return factory;
    }

    public static SeismicPhaseLayerFactory outerCoreFactory(SeismicPhaseFactory baseFactory) {
        if (baseFactory.tMod.isDegenerateOuterCore()) {
            String reason = "Model with no core, cmb at iocb";
            return new SeismicPhaseLayerFactoryAllFail(baseFactory, OUTER_CORE, baseFactory.tMod.getCmbBranch(), baseFactory.tMod.getIocbBranch() - 1, reason);
        }
        SeismicPhaseLayerFactory factory = new SeismicPhaseLayerFactory(baseFactory, OUTER_CORE, baseFactory.tMod.getCmbBranch(), baseFactory.tMod.getIocbBranch() - 1);
        factory.p_leg = (char)75;
        factory.up_p_leg = (char)107;
        factory.s_leg = (char)46;
        factory.up_s_leg = (char)46;
        return factory;
    }

    public static SeismicPhaseLayerFactory innerCoreFactory(SeismicPhaseFactory baseFactory) {
        if (baseFactory.tMod.isDegenerateInnerCore()) {
            String reason = "Model with no inner core, iocb at center of earth";
            return new SeismicPhaseLayerFactoryAllFail(baseFactory, INNER_CORE, baseFactory.tMod.getIocbBranch(), baseFactory.tMod.getNumBranches() - 1, reason);
        }
        SeismicPhaseLayerFactory factory = new SeismicPhaseLayerFactory(baseFactory, INNER_CORE, baseFactory.tMod.getIocbBranch(), baseFactory.tMod.getNumBranches() - 1);
        factory.p_leg = (char)73;
        factory.up_p_leg = (char)121;
        factory.s_leg = (char)74;
        factory.up_s_leg = (char)106;
        return factory;
    }

    public static List<SeismicPhaseLayerFactory> createFactory(SeismicPhaseFactory baseFactory) {
        SeismicPhaseLayerFactory crustMantle = SeismicPhaseLayerFactory.crustMantleFactory(baseFactory);
        SeismicPhaseLayerFactory outerCore = SeismicPhaseLayerFactory.outerCoreFactory(baseFactory);
        SeismicPhaseLayerFactory innerCore = SeismicPhaseLayerFactory.innerCoreFactory(baseFactory);
        crustMantle.aboveLayerFactory = new SeismicPhaseLayerFactoryAllFail(baseFactory, SURFACE_OF_EARTH, 0, 0, "No layers above surface");
        crustMantle.belowLayerFactory = outerCore;
        outerCore.aboveLayerFactory = crustMantle;
        outerCore.belowLayerFactory = innerCore;
        innerCore.aboveLayerFactory = outerCore;
        innerCore.belowLayerFactory = new SeismicPhaseLayerFactoryAllFail(baseFactory, CENTER_OF_EARTH, baseFactory.tMod.getNumBranches(), baseFactory.tMod.getNumBranches(), "No layers below inner core");
        return List.of(crustMantle, outerCore, innerCore);
    }

    public ProtoSeismicPhase parse(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, String nextNextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        if (PhaseSymbols.isExclusiveDowngoingSymbol(currLeg)) {
            proto = this.currLegIsExclusiveDowngoing(proto, prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else if (PhaseSymbols.isUpgoingSymbol(currLeg)) {
            proto = this.currLegIsUpLeg(proto, prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else if (PhaseSymbols.is(currLeg, this.p_leg) || PhaseSymbols.is(currLeg, this.s_leg)) {
            proto = this.currLegIsDownLeg(proto, prevLeg, currLeg, nextLeg, nextNextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else if (PhaseSymbols.isDiffracted(currLeg) || PhaseSymbols.isDiffractedDown(currLeg)) {
            proto = this.currLegIsDiffracted(proto, prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else if (PhaseSymbols.isHead(currLeg)) {
            this.currLegIsHead(proto, prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else if (Objects.equals(this.layerName, CRUST_MANTLE) && (PhaseSymbols.is(currLeg, "Pg") || PhaseSymbols.is(currLeg, "Sg"))) {
            proto = this.currLegIs_Pg_Sg(proto, prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
        } else {
            String reason = "parse() failed, Unknown phase in " + this.layerName + ": " + currLeg;
            proto.failNext(reason);
            return proto;
        }
        return proto;
    }

    /*
     * Enabled aggressive block sorting
     */
    ProtoSeismicPhase currLegIsExclusiveDowngoing(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (PhaseSymbols.is(nextLeg, "END")) {
            if (this.baseFactory.receiverDepth > 0.0) {
                PhaseInteraction endAction = PhaseInteraction.END_DOWN;
                proto.addToBranch(this.baseFactory.downgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            String reason = "impossible except for 0 dist 0 source depth which can be called p or P";
            return this.baseFactory.failWithMessage(proto, reason);
        }
        if (PhaseSymbols.isDiffracted(nextLeg) && (nextLeg.charAt(0) == this.p_leg || nextLeg.charAt(0) == this.s_leg)) {
            PhaseInteraction endAction = PhaseInteraction.DIFFRACT;
            proto.addToBranch(this.botBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = LegPuller.extractBoundaryId(nextLeg, 0, false);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                return proto;
            }
            if (!this.tMod.isHeadWaveBranch(disconBranch, isPWave)) {
                return this.baseFactory.failWithMessage(proto, "Unable to head wave, " + currLeg + ", " + disconBranch + ", " + headDepth + " is not positive velocity discontinuity.");
            }
            PhaseInteraction endAction = PhaseInteraction.HEAD;
            proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (nextLeg.charAt(0) == this.getBelowPLegSymbol().charValue() || nextLeg.charAt(0) == this.getBelowSLegSymbol().charValue()) {
            PhaseInteraction endAction = PhaseInteraction.TRANSDOWN;
            proto.addToBranch(this.botBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.isDiffracted(nextLeg) || PhaseSymbols.isDiffractedDown(nextLeg)) {
            String numString = LegPuller.extractBoundaryId(nextLeg, 0, false);
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                return proto;
            }
            PhaseInteraction endAction = PhaseInteraction.DIFFRACT;
            proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.is(nextLeg, 'm')) {
            PhaseInteraction endAction = PhaseInteraction.TRANSDOWN;
            proto.addToBranch(this.tMod.getMohoBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.is(nextLeg, "c") || PhaseSymbols.is(nextLeg, "i")) {
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                return proto;
            }
            PhaseInteraction endAction = PhaseInteraction.REFLECT_TOPSIDE;
            proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (LegPuller.isBoundary(nextLeg)) {
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                return proto;
            }
            PhaseInteraction endAction = PhaseInteraction.TRANSDOWN;
            proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (!PhaseSymbols.isReflectSymbol(nextLeg)) return this.baseFactory.failWithMessage(proto, " Phase not recognized (1): " + currLeg + " followed by " + nextLeg);
        PhaseInteraction endAction = PhaseSymbols.isCriticalReflectSymbol(nextLeg) ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
        int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg.substring(1), this.depthTolerance);
        if (currBranch > disconBranch - 1) return this.baseFactory.failWithMessage(proto, " Phase not recognized in " + this.layerName + ": " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch + " < disconBranch=" + disconBranch);
        if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
            return proto;
        }
        proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        return proto;
    }

    /*
     * Enabled aggressive block sorting
     */
    ProtoSeismicPhase currLegIsUpLeg(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (PhaseSymbols.isTopsideReflectSymbol(nextLeg, 0)) {
            return this.baseFactory.failWithMessage(proto, " p and s and k must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
        }
        if (PhaseSymbols.isUpDiffracted(currLeg, 0)) {
            PhaseInteraction endAction;
            String depthString = LegPuller.extractBoundaryId(currLeg, 1, false);
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, depthString, this.depthTolerance);
            if (currBranch >= disconBranch) {
                if (!this.validateDisconWithinLayers(proto, disconBranch, currLeg)) {
                    return proto;
                }
                endAction = PhaseInteraction.TRANSUPDIFFRACT;
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            }
            proto.addFlatBranch(isPWave, PhaseInteraction.TRANSUPDIFFRACT, PhaseInteraction.DIFFRACTTURN, currLeg);
            if (PhaseSymbols.is(nextLeg, "END")) {
                endAction = PhaseInteraction.END;
                proto.addToBranch(this.baseFactory.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            if (PhaseSymbols.startsWith(nextLeg, '^')) {
                String nextdepthString = nextLeg.substring(1);
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                int reflectDisconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextdepthString, this.depthTolerance);
                if (!this.validateDisconWithinLayers(proto, reflectDisconBranch, nextLeg)) {
                    return proto;
                }
                if (reflectDisconBranch >= disconBranch) {
                    String reason = "Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg;
                    return this.baseFactory.failWithMessage(proto, reason);
                }
                proto.addToBranch(reflectDisconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            if (nextLeg.charAt(0) != this.p_leg && nextLeg.charAt(0) != this.s_leg) {
                if (nextLeg.charAt(0) == this.up_p_leg) return proto;
                if (nextLeg.charAt(0) != this.up_s_leg) return this.baseFactory.failWithMessage(proto, " Phase not recognized (p12): " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch);
                return proto;
            }
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            proto.addToBranch(0, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.startsWith(nextLeg, '^')) {
            String depthString = nextLeg.substring(1);
            PhaseInteraction endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, depthString, this.depthTolerance);
            if (currBranch < disconBranch) return this.baseFactory.failWithMessage(proto, " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch + " > disconBranch=" + disconBranch);
            if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
                return proto;
            }
            proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.is(nextLeg, 'm') && currBranch >= this.tMod.getMohoBranch()) {
            PhaseInteraction endAction = PhaseInteraction.TRANSUP;
            proto.addToBranch(this.tMod.getMohoBranch(), isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (nextLeg.charAt(0) == this.p_leg || nextLeg.charAt(0) == this.s_leg || PhaseSymbols.is(nextLeg, "END")) {
            int disconBranch;
            if (PhaseSymbols.is(nextLeg, "END")) {
                disconBranch = this.baseFactory.upgoingRecBranch;
                if (currBranch < this.baseFactory.upgoingRecBranch) {
                    String reason = " (currBranch " + currBranch + " < receiverBranch() " + this.baseFactory.upgoingRecBranch + ", so there cannot be a upgoing " + currLeg + " phase for this sourceDepth, receiverDepth and/or path.";
                    return this.baseFactory.failWithMessage(proto, reason);
                }
            } else {
                disconBranch = this.topBranchNum;
            }
            PhaseInteraction endAction = PhaseSymbols.is(nextLeg, "END") ? PhaseInteraction.END : PhaseInteraction.REFLECT_UNDERSIDE;
            proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (PhaseSymbols.is(nextLeg, this.up_p_leg)) return this.baseFactory.failWithMessage(proto, " Phase not recognized (2): " + currLeg + " followed by " + nextLeg);
        if (PhaseSymbols.is(nextLeg, this.up_s_leg)) {
            return this.baseFactory.failWithMessage(proto, " Phase not recognized (2): " + currLeg + " followed by " + nextLeg);
        }
        if (this.belowLayerFactory.isLayerLeg(nextLeg)) {
            return this.baseFactory.failWithMessage(proto, " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", must be upgoing and so cannot hit lower layers.");
        }
        if (!PhaseSymbols.isBoundary(nextLeg)) {
            if (!this.aboveLayerFactory.isLayerLeg(nextLeg)) return this.baseFactory.failWithMessage(proto, " Phase not recognized (3 else): " + legNum + " " + currLeg + " followed by " + nextLeg);
            PhaseInteraction endAction = PhaseInteraction.TRANSUP;
            proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg, this.depthTolerance);
        if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
            return proto;
        }
        PhaseInteraction endAction = PhaseInteraction.TRANSUP;
        proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
        return proto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProtoSeismicPhase currLegIsDownLeg(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, String nextNextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction = null;
        PhaseInteraction prevEndAction = proto.getEndAction();
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (nextLeg.charAt(0) == this.p_leg || nextLeg.charAt(0) == this.s_leg || PhaseSymbols.is(nextLeg, "END")) {
            boolean isDowngoing = true;
            if (prevEndAction != PhaseInteraction.START) {
                isDowngoing = PhaseInteraction.isDowngoingActionAfter(prevEndAction);
            }
            if (prevEndAction == PhaseInteraction.START || prevEndAction == PhaseInteraction.TRANSDOWN || prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE || prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                endAction = PhaseInteraction.TURN;
                proto.addToBranch(this.botBranchNum, isPWave, isPWave, endAction, currLeg);
                isDowngoing = false;
            }
            if (PhaseSymbols.is(nextLeg, "END") && this.possibleToEnd(isDowngoing)) {
                endAction = PhaseInteraction.END;
                if (isDowngoing) {
                    proto.addToBranch(this.baseFactory.downgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                    return proto;
                } else {
                    proto.addToBranch(this.baseFactory.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                }
                return proto;
            } else {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            }
            return proto;
        }
        if (PhaseSymbols.isTopsideReflectSymbol(nextLeg, 0)) {
            endAction = PhaseSymbols.isCriticalReflectSymbol(nextLeg) ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = PhaseSymbols.is(nextLeg, 'i') ? this.tMod.getIocbBranch() : (PhaseSymbols.is(nextLeg, 'c') ? this.tMod.getCmbBranch() : LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg.substring(1), this.depthTolerance));
            if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                return proto;
            }
            if (currBranch <= disconBranch - 1) {
                proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            String reason = "can't topside reflect if already below";
            return this.baseFactory.failWithMessage(proto, reason);
        }
        if (PhaseSymbols.isUndersideReflectSymbol(nextLeg, 0)) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, depthString, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
                return proto;
            }
            if (disconBranch == this.tMod.getNumBranches()) {
                String reason = "Attempt to underside reflect from center of earth: " + nextLeg;
                return this.baseFactory.failWithMessage(proto, reason);
            }
            if (this.getBelowFactory() != null && this.getBelowFactory().isLayerLeg(prevLeg)) {
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            } else if (PhaseSymbols.isUndersideReflectSymbol(prevLeg, 0) || this.isLayerLeg(prevLeg) || PhaseInteraction.isDowngoingActionAfter(prevEndAction) || PhaseSymbols.isBoundary(prevLeg) || PhaseSymbols.is(prevLeg, "START")) {
                proto.addToBranch(this.botBranchNum, isPWave, isPWave, PhaseInteraction.TURN, currLeg);
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            } else {
                if (!(PhaseSymbols.isTopsideReflectSymbol(prevLeg, 0) && disconBranch < LegPuller.closestDisconBranchToDepth(this.tMod, prevLeg.substring(1), this.depthTolerance) || PhaseSymbols.is(prevLeg, 'm') && disconBranch < this.tMod.getMohoBranch()) && (!PhaseSymbols.is(prevLeg, "c") || disconBranch >= this.tMod.getCmbBranch())) return this.baseFactory.failWithMessage(proto, " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch + " > disconBranch=" + disconBranch + " , prev=" + prevLeg);
                if (disconBranch == this.tMod.getNumBranches()) {
                    String reason = "Attempt to reflect from center of earth: " + nextLeg;
                    return this.baseFactory.failWithMessage(proto, reason);
                }
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            }
            return proto;
        }
        if (PhaseSymbols.is(nextLeg, "c")) {
            if (this.tMod.getCmbBranch() == this.tMod.getNumBranches()) {
                String reason = "Attempt to reflect from center of earth: " + nextLeg;
                return this.baseFactory.failWithMessage(proto, reason);
            }
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            proto.addToBranch(this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (this.getBelowFactory() != null && this.getBelowFactory().isLayerLeg(nextLeg) && this.getBelowFactory().isLayerLeg(prevLeg)) {
            return this.baseFactory.failWithMessage(proto, " Phase not recognized (5.5): " + currLeg + " followed by " + nextLeg + " and preceeded by " + prevLeg + " when currBranch=" + currBranch);
        }
        if (this.getBelowFactory() != null && this.getBelowFactory().isLayerLeg(nextLeg)) {
            endAction = PhaseInteraction.TRANSDOWN;
            proto.addToBranch(this.botBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (this.getAboveFactory() != null && this.getAboveFactory().isLayerLeg(nextLeg)) {
            if (proto.getEndAction() == PhaseInteraction.START && PhaseSymbols.isDowngoingSymbol(currLeg) || PhaseInteraction.isDowngoingActionAfter(proto.getEndAction())) {
                endAction = PhaseInteraction.TURN;
                proto.addToBranch(this.botBranchNum, isPWave, isPWave, endAction, currLeg);
            }
            endAction = PhaseInteraction.TRANSUP;
            if (PhaseSymbols.isDiffracted(nextLeg)) {
                endAction = PhaseInteraction.TRANSUPDIFFRACT;
            }
            proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        if (LegPuller.isBoundary(nextLeg) && (PhaseSymbols.is(nextLeg, 'm') || this.topDepth < LegPuller.legAsDepthBoundary(this.tMod, nextLeg) && LegPuller.legAsDepthBoundary(this.tMod, nextLeg) < this.botDepth)) {
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, nextLeg, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
                return proto;
            }
            if (this.baseFactory.DEBUG) {
                Alert.debug("DisconBranch=" + disconBranch + " for " + nextLeg);
                Alert.debug("  " + this.tMod.getTauBranch(disconBranch, isPWave).getTopDepth());
            }
            if (prevEndAction == PhaseInteraction.TURN || prevEndAction == PhaseInteraction.REFLECT_TOPSIDE || prevEndAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL || prevEndAction == PhaseInteraction.TRANSUP) {
                if (disconBranch > currBranch) {
                    return this.baseFactory.failWithMessage(proto, " Phase not recognized (6): " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch + " > disconBranch=" + disconBranch);
                }
                endAction = PhaseInteraction.TRANSUP;
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            if (nextNextLeg.charAt(0) == this.up_p_leg || nextNextLeg.charAt(0) == this.up_s_leg) {
                endAction = PhaseInteraction.TURN;
                proto.addToBranch(this.botBranchNum, isPWave, isPWave, endAction, currLeg);
                endAction = PhaseInteraction.TRANSUP;
                proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            if (!PhaseSymbols.is(nextNextLeg, this.p_leg) && !PhaseSymbols.is(nextNextLeg, this.s_leg)) return this.baseFactory.failWithMessage(proto, " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " followed by " + nextNextLeg);
            if (disconBranch > currBranch) {
                endAction = PhaseInteraction.TRANSDOWN;
                proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            String reason = "Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + currLeg + " " + nextLeg + " " + nextNextLeg + ", so this phase, " + this.baseFactory.getName() + " is illegal for this sourceDepth.";
            return this.baseFactory.failWithMessage(proto, reason);
        }
        if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = LegPuller.extractBoundaryId(nextLeg, 0, false);
            try {
                int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
                if (!this.validateDisconWithinLayers(proto, disconBranch - 1, nextLeg)) {
                    return proto;
                }
                if (!this.tMod.isHeadWaveBranch(disconBranch, isPWave)) {
                    return this.baseFactory.failWithMessage(proto, "Unable to head wave, " + currLeg + ", " + disconBranch + ", " + numString + " is not positive velocity discontinuity.");
                }
                endAction = PhaseInteraction.HEAD;
                proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return proto;
            }
            catch (NumberFormatException e) {
                return this.baseFactory.failWithMessage(proto, " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " expected number but was `" + numString + "`");
            }
        }
        if (!PhaseSymbols.isDiffracted(nextLeg) && !PhaseSymbols.isDiffractedDown(nextLeg)) return this.baseFactory.failWithMessage(proto, " Phase not recognized (8): " + currLeg + " followed by " + nextLeg);
        String numString = LegPuller.extractBoundaryId(nextLeg, 0, false);
        try {
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
            if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
                return proto;
            }
            if (prevEndAction == PhaseInteraction.START || prevEndAction == PhaseInteraction.TRANSDOWN || prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE || prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                endAction = PhaseInteraction.TURN;
                proto.addToBranch(this.botBranchNum, isPWave, isPWave, endAction, currLeg);
            }
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        }
        catch (NumberFormatException e) {
            return this.baseFactory.failWithMessage(proto, " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " expected number but was `" + numString + "`");
        }
    }

    ProtoSeismicPhase currLegIsDiffracted(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        SeismicPhaseSegment prevSegment;
        int disconBranch;
        PhaseInteraction prevEndAction = proto.getEndAction();
        int prevEndBranch = proto.isEmpty() ? this.tMod.getSourceBranch() - 1 : proto.endSegment().endBranch;
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (proto.isEmpty()) {
            currBranch = this.tMod.getSourceBranch() - 1;
        }
        int depthIdx = 0;
        if (PhaseSymbols.startsWith(currLeg, this.p_leg) || PhaseSymbols.startsWith(currLeg, this.s_leg)) {
            depthIdx = 1;
        }
        String numString = "";
        if (PhaseSymbols.isDiffracted(currLeg) && currLeg.length() == "diff".length() + 1 || PhaseSymbols.isDiffractedDown(currLeg) && currLeg.length() == "diffdn".length() + 1) {
            disconBranch = this.botBranchNum + 1;
        } else {
            numString = LegPuller.extractBoundaryId(currLeg, depthIdx, false);
            disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
        }
        if (!this.validateDisconWithinLayers(proto, disconBranch - 1, currLeg)) {
            return proto;
        }
        SeismicPhaseSegment seismicPhaseSegment = prevSegment = !proto.segmentList.isEmpty() ? proto.endSegment() : null;
        if (!this.tMod.isDiffractionBranch(disconBranch, isPWave)) {
            return this.baseFactory.failWithMessage(proto, "Unable to diffract, not diffraction depth " + currLeg + ", " + disconBranch + " at " + this.tMod.getTauBranch(disconBranch, isPWave).getTopDepth() + " km, " + numString + " is not velocity discontinuity.");
        }
        PhaseInteraction endAction = PhaseInteraction.DIFFRACT;
        if (prevEndBranch < disconBranch - 1 || prevEndBranch == disconBranch - 1 && prevSegment != null && prevSegment.endsAtTop()) {
            proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        } else if (currBranch != disconBranch - 1 || prevSegment.endAction != PhaseInteraction.DIFFRACT && prevSegment.endAction != PhaseInteraction.TRANSUPDIFFRACT && prevSegment.endAction != PhaseInteraction.TRANSUP) {
            return this.baseFactory.failWithMessage(proto, "Unable to diffract, below the right branch to diffract " + currBranch + " of " + proto.phaseName + " " + (disconBranch - 1) + " " + SeismicPhaseFactory.endActionString(prevEndAction) + " " + prevSegment + " " + (Serializable)(prevSegment != null ? Boolean.valueOf(prevSegment.endsAtTop()) : ""));
        }
        if (currLeg.endsWith("diffdn") || currBranch == this.botBranchNum && (nextLeg.charAt(0) == this.getBelowPLegSymbol().charValue() || nextLeg.charAt(0) == this.getBelowSLegSymbol().charValue())) {
            proto.addFlatBranch(isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
            endAction = PhaseInteraction.TRANSDOWN;
            ++currBranch;
        } else {
            proto.addFlatBranch(isPWave, endAction, PhaseInteraction.DIFFRACTTURN, currLeg);
            if (PhaseSymbols.is(nextLeg, "END")) {
                endAction = PhaseInteraction.END;
                proto.addToBranch(this.baseFactory.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            } else if (PhaseSymbols.startsWith(nextLeg, '^')) {
                String depthString = nextLeg.substring(1);
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                int reflectDisconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, depthString, this.depthTolerance);
                if (reflectDisconBranch >= disconBranch) {
                    String reason = "Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg;
                    return this.baseFactory.failWithMessage(proto, reason);
                }
                if (!this.validateDisconWithinLayers(proto, reflectDisconBranch, nextLeg)) {
                    return proto;
                }
                proto.addToBranch(reflectDisconBranch, isPWave, nextIsPWave, endAction, currLeg);
            } else if (PhaseSymbols.startsWith(nextLeg, this.p_leg) || PhaseSymbols.startsWith(nextLeg, this.s_leg)) {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            } else if (nextLeg.charAt(0) == this.getAbovePLegSymbol().charValue() || nextLeg.charAt(0) == this.getAboveSLegSymbol().charValue() || nextLeg.charAt(0) == this.getAboveUpPLegSymbol().charValue() || nextLeg.charAt(0) == this.getAboveUpSLegSymbol().charValue()) {
                endAction = PhaseInteraction.TRANSUP;
                proto.addToBranch(this.topBranchNum, isPWave, nextIsPWave, endAction, currLeg);
            } else if (nextLeg.charAt(0) != this.up_p_leg && nextLeg.charAt(0) != this.up_s_leg) {
                return this.baseFactory.failWithMessage(proto, " Phase not recognized (12): " + currLeg + " followed by " + nextLeg + " when currBranch=" + currBranch);
            }
        }
        return proto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProtoSeismicPhase currLegIs_Pg_Sg(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (!PhaseSymbols.is(currLeg, this.p_leg + "g") && !PhaseSymbols.is(currLeg, this.s_leg + "g")) return this.baseFactory.failWithMessage(proto, " Phase not recognized for P,S: " + currLeg + " followed by " + nextLeg);
        if (currBranch >= this.tMod.getMohoBranch()) {
            String reason = "(currBranch >= tMod.getMohoBranch() " + currBranch + " " + this.tMod.getMohoBranch() + " so there cannot be a " + currLeg + " phase for this sourceDepth and/or path.";
            return this.baseFactory.failWithMessage(proto, reason);
        }
        PhaseInteraction endAction = PhaseInteraction.TURN;
        proto.addToBranch(this.tMod.getMohoBranch() - 1, isPWave, isPWave, endAction, currLeg);
        if (PhaseSymbols.is(nextLeg, "END")) {
            endAction = PhaseInteraction.END;
            proto.addToBranch(this.baseFactory.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        } else if (PhaseSymbols.startsWith(nextLeg, 'P') || PhaseSymbols.startsWith(nextLeg, 'S')) {
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            proto.addToBranch(0, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        } else {
            if (!PhaseSymbols.startsWith(nextLeg, '^')) return this.baseFactory.failWithMessage(proto, " Phase not recognized (12): " + currLeg + " followed by " + nextLeg);
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, depthString, this.depthTolerance);
            if (disconBranch >= this.tMod.getMohoBranch()) {
                String reason = "Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg;
                return this.baseFactory.failWithMessage(proto, reason);
            }
            if (!this.validateDisconWithinLayers(proto, disconBranch, nextLeg)) {
                return proto;
            }
            proto.addToBranch(disconBranch, isPWave, nextIsPWave, endAction, currLeg);
        }
        return proto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProtoSeismicPhase currLegIsHead(ProtoSeismicPhase proto, String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        int disconBranch;
        String numString;
        int currBranch = this.baseFactory.calcStartBranch(proto, currLeg);
        if (!currLeg.endsWith("n") || currLeg.length() < 2) return this.baseFactory.failWithMessage(proto, " Phase not recognized for non-standard diffraction: " + currLeg + " followed by " + nextLeg);
        if (currLeg.length() == 2 && (currLeg.charAt(0) == 'P' || currLeg.charAt(0) == 'S')) {
            numString = "m";
            disconBranch = this.tMod.getMohoBranch();
        } else {
            int depthIdx = 0;
            if (PhaseSymbols.startsWith(currLeg, 'P') || PhaseSymbols.startsWith(currLeg, 'S') || PhaseSymbols.startsWith(currLeg, 'K') || PhaseSymbols.startsWith(currLeg, 'I') || PhaseSymbols.startsWith(currLeg, 'J')) {
                depthIdx = 1;
            }
            numString = LegPuller.extractBoundaryId(currLeg, depthIdx, false);
            disconBranch = LegPuller.closestDisconBranchToDepth(this.tMod, numString, this.depthTolerance);
        }
        if (!this.validateDisconWithinLayers(proto, disconBranch - 1, currLeg)) {
            return proto;
        }
        if (!this.tMod.isHeadWaveBranch(disconBranch, isPWave)) {
            return this.baseFactory.failWithMessage(proto, "Unable to head wave, " + currLeg + ", " + disconBranch + ", " + numString + " is not positive velocity discontinuity.");
        }
        PhaseInteraction endAction = PhaseInteraction.HEAD;
        proto.addToBranch(disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        if (PhaseSymbols.startsWith(nextLeg, this.getBelowPLegSymbol().charValue()) || PhaseSymbols.startsWith(nextLeg, this.getBelowSLegSymbol().charValue())) {
            proto.addFlatBranch(isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
        } else {
            proto.addFlatBranch(isPWave, endAction, PhaseInteraction.TRANSUP, currLeg);
        }
        currBranch = disconBranch;
        if (PhaseSymbols.is(nextLeg, "END")) {
            endAction = PhaseInteraction.END;
            proto.addToBranch(this.baseFactory.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return proto;
        } else {
            if (this.topBranchNum != 0 || nextLeg.charAt(0) != this.p_leg && nextLeg.charAt(0) != this.s_leg) return this.baseFactory.failWithMessage(proto, " Phase not recognized for non-standard diffraction: " + currLeg + " followed by " + nextLeg);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            proto.addToBranch(0, isPWave, nextIsPWave, endAction, currLeg);
        }
        return proto;
    }

    public SeismicPhaseLayerFactory getAboveFactory() {
        SeismicPhaseLayerFactory b = this.aboveLayerFactory;
        while (b != null && b instanceof SeismicPhaseLayerFactoryAllFail) {
            b = b.aboveLayerFactory;
        }
        return b;
    }

    public SeismicPhaseLayerFactory getBelowFactory() {
        SeismicPhaseLayerFactory b = this.belowLayerFactory;
        while (b != null && b instanceof SeismicPhaseLayerFactoryAllFail) {
            b = b.belowLayerFactory;
        }
        return b;
    }

    public Character getPLegSymbol() {
        return Character.valueOf(this.p_leg);
    }

    public Character getBelowPLegSymbol() {
        SeismicPhaseLayerFactory b = this.getBelowFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return b.getPLegSymbol();
    }

    public Character getAbovePLegSymbol() {
        SeismicPhaseLayerFactory b = this.getAboveFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return b.getPLegSymbol();
    }

    public Character getAboveUpPLegSymbol() {
        SeismicPhaseLayerFactory b = this.getAboveFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return Character.valueOf(b.up_p_leg);
    }

    public Character getSLegSymbol() {
        return Character.valueOf(this.s_leg);
    }

    public Character getBelowSLegSymbol() {
        SeismicPhaseLayerFactory b = this.getBelowFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return b.getSLegSymbol();
    }

    public Character getAboveSLegSymbol() {
        SeismicPhaseLayerFactory b = this.getAboveFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return b.getSLegSymbol();
    }

    public Character getAboveUpSLegSymbol() {
        SeismicPhaseLayerFactory b = this.getAboveFactory();
        if (b == null) {
            return Character.valueOf(' ');
        }
        return Character.valueOf(b.up_s_leg);
    }

    public boolean isLayerLeg(String leg) {
        char c = leg.charAt(0);
        return c == this.p_leg || c == this.s_leg || c == this.up_p_leg || c == this.up_s_leg;
    }

    public boolean possibleToEnd(boolean isDowngoing) {
        if (isDowngoing && this.baseFactory.upgoingRecBranch >= this.topBranchNum) {
            return true;
        }
        return !isDowngoing && this.baseFactory.downgoingRecBranch <= this.botBranchNum;
    }

    public boolean validateDisconWithinLayers(ProtoSeismicPhase proto, int disconNum, String currLeg) {
        if (disconNum <= -1) {
            this.baseFactory.failWithMessage(proto, "No boundary in model within " + this.depthTolerance + " km of " + disconNum + " " + currLeg);
            return false;
        }
        if (this.topBranchNum <= disconNum && disconNum <= this.botBranchNum) {
            return true;
        }
        this.baseFactory.failWithMessage(proto, "Illegal phase, cannot reach discontinuity " + disconNum + " at depth " + this.tMod.getTauBranch(disconNum, true).getTopDepth() + " for phase symbol " + currLeg + ", " + this.layerName);
        return false;
    }
}

