/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import java.util.ArrayList;
import java.util.List;

public class ScatteredArrival
extends Arrival {
    private final Arrival inboundArrival;
    private final Arrival scatteredArrival;
    private final boolean isBackscatter;

    public static String formScatterPhaseName(String inboundName, String scatterName, boolean isBackscatter) {
        if (isBackscatter) {
            return inboundName + "O" + scatterName;
        }
        return inboundName + "o" + scatterName;
    }

    public ScatteredArrival(ScatteredSeismicPhase phase, RayCalculateable searchVal, Arrival inboundArrival, Arrival scatteredArrival, boolean isBackscatter) {
        super(phase, null, inboundArrival.getTime() + scatteredArrival.getTime(), ScatteredArrival.calcScatteredArrivalDist(inboundArrival, scatteredArrival, isBackscatter), scatteredArrival.getRayParam(), scatteredArrival.getRayParamIndex(), searchVal, ScatteredArrival.formScatterPhaseName(inboundArrival.getName(), scatteredArrival.getName(), isBackscatter), ScatteredArrival.formScatterPhaseName(inboundArrival.getPuristName(), scatteredArrival.getPuristName(), isBackscatter), inboundArrival.getPhase().getSourceDepth(), scatteredArrival.getPhase().getReceiverDepth(), inboundArrival.getPhase().calcTakeoffAngle(inboundArrival.getRayParam()), scatteredArrival.getPhase().calcIncidentAngle(scatteredArrival.getRayParam()), scatteredArrival.getDRayParamDDelta());
        this.inboundArrival = inboundArrival;
        this.scatteredArrival = scatteredArrival;
        this.isBackscatter = isBackscatter;
    }

    public ScatteredSeismicPhase getScatteredSeismicPhase() {
        return (ScatteredSeismicPhase)this.getPhase();
    }

    public Arrival getInboundArrival() {
        return this.inboundArrival;
    }

    public Arrival getScatteredArrival() {
        return this.scatteredArrival;
    }

    public boolean isBackscatter() {
        return this.isBackscatter;
    }

    @Override
    public boolean isLongWayAround() {
        return false;
    }

    public boolean isInboundNegativeDirection() {
        return this.getScatteredSeismicPhase().getScattererDistanceDeg() < 0.0;
    }

    public boolean isScatterNegativeDirection() {
        double scatDist = this.getScatteredSeismicPhase().getScattererDistanceDeg();
        return scatDist >= 0.0 && this.isBackscatter() || scatDist < 0.0 && !this.isBackscatter();
    }

    public static int calcScatterNegDistFactor(double scatDist, boolean isBackscatter) {
        if (scatDist >= 0.0 && isBackscatter || scatDist < 0.0 && !isBackscatter) {
            return -1;
        }
        return 1;
    }

    public static double calcScatteredArrivalDist(Arrival inboundArrival, Arrival scatteredArrival, boolean isBackscatter) {
        double outDist = isBackscatter ? (inboundArrival.getDist() < 0.0 ? inboundArrival.getDist() + scatteredArrival.getDist() : inboundArrival.getDist() - scatteredArrival.getDist()) : (inboundArrival.getDist() < 0.0 ? inboundArrival.getDist() - scatteredArrival.getDist() : inboundArrival.getDist() + scatteredArrival.getDist());
        return outDist;
    }

    @Override
    public List<SeismicPhaseSegment> listPhaseSegments() {
        ArrayList<SeismicPhaseSegment> out = new ArrayList<SeismicPhaseSegment>();
        out.addAll(this.inboundArrival.listPhaseSegments());
        out.addAll(this.scatteredArrival.listPhaseSegments());
        return out;
    }
}

