/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.ShootableRay;
import edu.sc.seis.TauP.TauPException;
import java.util.ArrayList;
import java.util.List;

public class IncidentAngleRay
extends ShootableRay {
    Double incidentAngle;

    public IncidentAngleRay(Double incidentAngle) {
        this.incidentAngle = incidentAngle;
        this.setDescription("Incident: " + incidentAngle);
    }

    public static IncidentAngleRay ofIncidentAngle(Double d) {
        return new IncidentAngleRay(d);
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) throws TauPException {
        RayParamRay rayParamRay = this.forPhase(phase);
        if (rayParamRay == null) {
            return new ArrayList<Arrival>();
        }
        List<Arrival> arrivals = rayParamRay.calculate(phase);
        for (Arrival a : arrivals) {
            a.setSearchValue(this);
        }
        return arrivals;
    }

    public RayParamRay forPhase(SeismicPhase phase) {
        double rayParam;
        try {
            if (this.incidentAngle < 90.0 && phase.getFinalPhaseSegment().isDownGoing) {
                return null;
            }
            if (this.incidentAngle > 90.0 && !phase.getFinalPhaseSegment().isDownGoing) {
                return null;
            }
            rayParam = phase.calcRayParamForIncidentAngle(this.incidentAngle);
        }
        catch (NoArrivalException e) {
            return null;
        }
        return new RayParamRay(rayParam);
    }

    public Double getIncidentAngle() {
        return this.incidentAngle;
    }
}

