/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import edu.sc.seis.seisFile.sac.SacConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Locale;

public class SacHeader {
    private static final ThreadLocal<DecimalFormat> decimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#####.####", new DecimalFormatSymbols(Locale.US));
        }
    };
    public static final int DEFAULT_LABEL_WIDTH = 10;
    public static final int DEFAULT_WIDE_WIDTH = 31;
    public static final int DEFAULT_VALUE_WIDTH = 10;
    boolean byteOrder = true;
    private float delta = -12345.0f;
    private float depmin = -12345.0f;
    private float depmax = -12345.0f;
    private float scale = -12345.0f;
    private float odelta = -12345.0f;
    private float b = -12345.0f;
    private float e = -12345.0f;
    private float o = -12345.0f;
    private float a = -12345.0f;
    private float fmt = -12345.0f;
    private float t0 = -12345.0f;
    private float t1 = -12345.0f;
    private float t2 = -12345.0f;
    private float t3 = -12345.0f;
    private float t4 = -12345.0f;
    private float t5 = -12345.0f;
    private float t6 = -12345.0f;
    private float t7 = -12345.0f;
    private float t8 = -12345.0f;
    private float t9 = -12345.0f;
    private float f = -12345.0f;
    private float resp0 = -12345.0f;
    private float resp1 = -12345.0f;
    private float resp2 = -12345.0f;
    private float resp3 = -12345.0f;
    private float resp4 = -12345.0f;
    private float resp5 = -12345.0f;
    private float resp6 = -12345.0f;
    private float resp7 = -12345.0f;
    private float resp8 = -12345.0f;
    private float resp9 = -12345.0f;
    private float stla = -12345.0f;
    private float stlo = -12345.0f;
    private float stel = -12345.0f;
    private float stdp = -12345.0f;
    private float evla = -12345.0f;
    private float evlo = -12345.0f;
    private float evel = -12345.0f;
    private float evdp = -12345.0f;
    private float mag = -12345.0f;
    private float user0 = -12345.0f;
    private float user1 = -12345.0f;
    private float user2 = -12345.0f;
    private float user3 = -12345.0f;
    private float user4 = -12345.0f;
    private float user5 = -12345.0f;
    private float user6 = -12345.0f;
    private float user7 = -12345.0f;
    private float user8 = -12345.0f;
    private float user9 = -12345.0f;
    private float dist = -12345.0f;
    private float az = -12345.0f;
    private float baz = -12345.0f;
    private float gcarc = -12345.0f;
    private float sb = -12345.0f;
    private float sdelta = -12345.0f;
    private float depmen = -12345.0f;
    private float cmpaz = -12345.0f;
    private float cmpinc = -12345.0f;
    private float xminimum = -12345.0f;
    private float xmaximum = -12345.0f;
    private float yminimum = -12345.0f;
    private float ymaximum = -12345.0f;
    private float unused6 = -12345.0f;
    private float unused7 = -12345.0f;
    private float unused8 = -12345.0f;
    private float unused9 = -12345.0f;
    private float unused10 = -12345.0f;
    private float unused11 = -12345.0f;
    private float unused12 = -12345.0f;
    private int nzyear = -12345;
    private int nzjday = -12345;
    private int nzhour = -12345;
    private int nzmin = -12345;
    private int nzsec = -12345;
    private int nzmsec = -12345;
    private int nvhdr = 6;
    private int norid = -12345;
    private int nevid = -12345;
    private int npts = -12345;
    private int nsnpts = -12345;
    private int nwfid = -12345;
    private int nxsize = -12345;
    private int nysize = -12345;
    private int unused15 = -12345;
    private int iftype = -12345;
    private int idep = -12345;
    private int iztype = -12345;
    private int unused16 = -12345;
    private int iinst = -12345;
    private int istreg = -12345;
    private int ievreg = -12345;
    private int ievtyp = -12345;
    private int iqual = -12345;
    private int isynth = -12345;
    private int imagtyp = -12345;
    private int imagsrc = -12345;
    private int unused19 = -12345;
    private int unused20 = -12345;
    private int unused21 = -12345;
    private int unused22 = -12345;
    private int unused23 = -12345;
    private int unused24 = -12345;
    private int unused25 = -12345;
    private int unused26 = -12345;
    private int leven = -12345;
    private int lpspol = -12345;
    private int lovrok = -12345;
    private int lcalda = -12345;
    private int unused27 = -12345;
    private String kstnm = "-12345  ";
    private String kevnm = "-12345          ";
    private String khole = "-12345  ";
    private String ko = "-12345  ";
    private String ka = "-12345  ";
    private String kt0 = "-12345  ";
    private String kt1 = "-12345  ";
    private String kt2 = "-12345  ";
    private String kt3 = "-12345  ";
    private String kt4 = "-12345  ";
    private String kt5 = "-12345  ";
    private String kt6 = "-12345  ";
    private String kt7 = "-12345  ";
    private String kt8 = "-12345  ";
    private String kt9 = "-12345  ";
    private String kf = "-12345  ";
    private String kuser0 = "-12345  ";
    private String kuser1 = "-12345  ";
    private String kuser2 = "-12345  ";
    private String kcmpnm = "-12345  ";
    private String knetwk = "-12345  ";
    private String kdatrd = "-12345  ";
    private String kinst = "-12345  ";

    public SacHeader() {
    }

    public SacHeader(String filename) throws IOException {
        this(new File(filename));
    }

    public SacHeader(DataInput indis) throws IOException {
        this.readHeader(indis);
    }

    public SacHeader(File sacFile) throws IOException {
        if (sacFile.length() < 632L) {
            throw new IOException(sacFile.getName() + " does not appear to be a sac file! File size (" + sacFile.length() + " is less than sac's header size (632)");
        }
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(sacFile)));){
            this.readHeader(dis);
        }
    }

    public static SacHeader createEmptyEvenSampledTimeSeriesHeader() {
        SacHeader header = new SacHeader();
        header.leven = 1;
        header.iftype = 1;
        header.npts = 0;
        header.b = 0.0f;
        header.e = 0.0f;
        header.delta = 1.0f;
        header.idep = 5;
        return header;
    }

    void readHeader(DataInput indis) throws IOException {
        byte[] headerBuf = new byte[632];
        indis.readFully(headerBuf);
        if (headerBuf[304] == 6 && headerBuf[305] == 0 && headerBuf[306] == 0 && headerBuf[307] == 0) {
            this.byteOrder = false;
            for (int i = 0; i < 440; i += 4) {
                byte tmp = headerBuf[i];
                headerBuf[i] = headerBuf[i + 3];
                headerBuf[i + 3] = tmp;
                tmp = headerBuf[i + 1];
                headerBuf[i + 1] = headerBuf[i + 2];
                headerBuf[i + 2] = tmp;
            }
        } else if (headerBuf[304] != 0 || headerBuf[305] != 0 || headerBuf[306] != 0 || headerBuf[307] != 6) {
            throw new IOException("Does not appear to be a SAC file, NVHDR header bytes should be (int) 6 but found " + headerBuf[304] + " " + headerBuf[305] + " " + headerBuf[306] + " " + headerBuf[307]);
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(headerBuf));
        this.delta = dis.readFloat();
        this.depmin = dis.readFloat();
        this.depmax = dis.readFloat();
        this.scale = dis.readFloat();
        this.odelta = dis.readFloat();
        this.b = dis.readFloat();
        this.e = dis.readFloat();
        this.o = dis.readFloat();
        this.a = dis.readFloat();
        this.fmt = dis.readFloat();
        this.t0 = dis.readFloat();
        this.t1 = dis.readFloat();
        this.t2 = dis.readFloat();
        this.t3 = dis.readFloat();
        this.t4 = dis.readFloat();
        this.t5 = dis.readFloat();
        this.t6 = dis.readFloat();
        this.t7 = dis.readFloat();
        this.t8 = dis.readFloat();
        this.t9 = dis.readFloat();
        this.f = dis.readFloat();
        this.resp0 = dis.readFloat();
        this.resp1 = dis.readFloat();
        this.resp2 = dis.readFloat();
        this.resp3 = dis.readFloat();
        this.resp4 = dis.readFloat();
        this.resp5 = dis.readFloat();
        this.resp6 = dis.readFloat();
        this.resp7 = dis.readFloat();
        this.resp8 = dis.readFloat();
        this.resp9 = dis.readFloat();
        this.stla = dis.readFloat();
        this.stlo = dis.readFloat();
        this.stel = dis.readFloat();
        this.stdp = dis.readFloat();
        this.evla = dis.readFloat();
        this.evlo = dis.readFloat();
        this.evel = dis.readFloat();
        this.evdp = dis.readFloat();
        this.mag = dis.readFloat();
        this.user0 = dis.readFloat();
        this.user1 = dis.readFloat();
        this.user2 = dis.readFloat();
        this.user3 = dis.readFloat();
        this.user4 = dis.readFloat();
        this.user5 = dis.readFloat();
        this.user6 = dis.readFloat();
        this.user7 = dis.readFloat();
        this.user8 = dis.readFloat();
        this.user9 = dis.readFloat();
        this.dist = dis.readFloat();
        this.az = dis.readFloat();
        this.baz = dis.readFloat();
        this.gcarc = dis.readFloat();
        this.sb = dis.readFloat();
        this.sdelta = dis.readFloat();
        this.depmen = dis.readFloat();
        this.cmpaz = dis.readFloat();
        this.cmpinc = dis.readFloat();
        this.xminimum = dis.readFloat();
        this.xmaximum = dis.readFloat();
        this.yminimum = dis.readFloat();
        this.ymaximum = dis.readFloat();
        this.unused6 = dis.readFloat();
        this.unused7 = dis.readFloat();
        this.unused8 = dis.readFloat();
        this.unused9 = dis.readFloat();
        this.unused10 = dis.readFloat();
        this.unused11 = dis.readFloat();
        this.unused12 = dis.readFloat();
        this.nzyear = dis.readInt();
        this.nzjday = dis.readInt();
        this.nzhour = dis.readInt();
        this.nzmin = dis.readInt();
        this.nzsec = dis.readInt();
        this.nzmsec = dis.readInt();
        this.nvhdr = dis.readInt();
        this.norid = dis.readInt();
        this.nevid = dis.readInt();
        this.npts = dis.readInt();
        this.nsnpts = dis.readInt();
        this.nwfid = dis.readInt();
        this.nxsize = dis.readInt();
        this.nysize = dis.readInt();
        this.unused15 = dis.readInt();
        this.iftype = dis.readInt();
        this.idep = dis.readInt();
        this.iztype = dis.readInt();
        this.unused16 = dis.readInt();
        this.iinst = dis.readInt();
        this.istreg = dis.readInt();
        this.ievreg = dis.readInt();
        this.ievtyp = dis.readInt();
        this.iqual = dis.readInt();
        this.isynth = dis.readInt();
        this.imagtyp = dis.readInt();
        this.imagsrc = dis.readInt();
        this.unused19 = dis.readInt();
        this.unused20 = dis.readInt();
        this.unused21 = dis.readInt();
        this.unused22 = dis.readInt();
        this.unused23 = dis.readInt();
        this.unused24 = dis.readInt();
        this.unused25 = dis.readInt();
        this.unused26 = dis.readInt();
        this.leven = dis.readInt();
        this.lpspol = dis.readInt();
        this.lovrok = dis.readInt();
        this.lcalda = dis.readInt();
        this.unused27 = dis.readInt();
        byte[] eightBytes = new byte[8];
        byte[] sixteenBytes = new byte[16];
        dis.readFully(eightBytes);
        this.kstnm = new String(eightBytes);
        dis.readFully(sixteenBytes);
        this.kevnm = new String(sixteenBytes);
        dis.readFully(eightBytes);
        this.khole = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ko = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ka = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt3 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt4 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt5 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt6 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt7 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt8 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt9 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kf = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kcmpnm = new String(eightBytes);
        dis.readFully(eightBytes);
        this.knetwk = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kdatrd = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kinst = new String(eightBytes);
    }

    final void writeFloat(DataOutput dos, float val) throws IOException {
        if (!this.byteOrder) {
            dos.writeInt(SacHeader.swapBytes(Float.floatToRawIntBits(val)));
        } else {
            dos.writeFloat(val);
        }
    }

    private final void writeInt(DataOutput dos, int val) throws IOException {
        if (!this.byteOrder) {
            dos.writeInt(SacHeader.swapBytes(val));
        } else {
            dos.writeInt(val);
        }
    }

    public void writeHeader(File file) throws FileNotFoundException, IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.writeHeader(dos);
        }
    }

    public void writeHeader(DataOutput dos) throws IOException {
        this.writeFloat(dos, this.delta);
        this.writeFloat(dos, this.depmin);
        this.writeFloat(dos, this.depmax);
        this.writeFloat(dos, this.scale);
        this.writeFloat(dos, this.odelta);
        this.writeFloat(dos, this.b);
        this.writeFloat(dos, this.e);
        this.writeFloat(dos, this.o);
        this.writeFloat(dos, this.a);
        this.writeFloat(dos, this.fmt);
        this.writeFloat(dos, this.t0);
        this.writeFloat(dos, this.t1);
        this.writeFloat(dos, this.t2);
        this.writeFloat(dos, this.t3);
        this.writeFloat(dos, this.t4);
        this.writeFloat(dos, this.t5);
        this.writeFloat(dos, this.t6);
        this.writeFloat(dos, this.t7);
        this.writeFloat(dos, this.t8);
        this.writeFloat(dos, this.t9);
        this.writeFloat(dos, this.f);
        this.writeFloat(dos, this.resp0);
        this.writeFloat(dos, this.resp1);
        this.writeFloat(dos, this.resp2);
        this.writeFloat(dos, this.resp3);
        this.writeFloat(dos, this.resp4);
        this.writeFloat(dos, this.resp5);
        this.writeFloat(dos, this.resp6);
        this.writeFloat(dos, this.resp7);
        this.writeFloat(dos, this.resp8);
        this.writeFloat(dos, this.resp9);
        this.writeFloat(dos, this.stla);
        this.writeFloat(dos, this.stlo);
        this.writeFloat(dos, this.stel);
        this.writeFloat(dos, this.stdp);
        this.writeFloat(dos, this.evla);
        this.writeFloat(dos, this.evlo);
        this.writeFloat(dos, this.evel);
        this.writeFloat(dos, this.evdp);
        this.writeFloat(dos, this.mag);
        this.writeFloat(dos, this.user0);
        this.writeFloat(dos, this.user1);
        this.writeFloat(dos, this.user2);
        this.writeFloat(dos, this.user3);
        this.writeFloat(dos, this.user4);
        this.writeFloat(dos, this.user5);
        this.writeFloat(dos, this.user6);
        this.writeFloat(dos, this.user7);
        this.writeFloat(dos, this.user8);
        this.writeFloat(dos, this.user9);
        this.writeFloat(dos, this.dist);
        this.writeFloat(dos, this.az);
        this.writeFloat(dos, this.baz);
        this.writeFloat(dos, this.gcarc);
        this.writeFloat(dos, this.sb);
        this.writeFloat(dos, this.sdelta);
        this.writeFloat(dos, this.depmen);
        this.writeFloat(dos, this.cmpaz);
        this.writeFloat(dos, this.cmpinc);
        this.writeFloat(dos, this.xminimum);
        this.writeFloat(dos, this.xmaximum);
        this.writeFloat(dos, this.yminimum);
        this.writeFloat(dos, this.ymaximum);
        this.writeFloat(dos, this.unused6);
        this.writeFloat(dos, this.unused7);
        this.writeFloat(dos, this.unused8);
        this.writeFloat(dos, this.unused9);
        this.writeFloat(dos, this.unused10);
        this.writeFloat(dos, this.unused11);
        this.writeFloat(dos, this.unused12);
        this.writeInt(dos, this.nzyear);
        this.writeInt(dos, this.nzjday);
        this.writeInt(dos, this.nzhour);
        this.writeInt(dos, this.nzmin);
        this.writeInt(dos, this.nzsec);
        this.writeInt(dos, this.nzmsec);
        this.writeInt(dos, this.nvhdr);
        this.writeInt(dos, this.norid);
        this.writeInt(dos, this.nevid);
        this.writeInt(dos, this.npts);
        this.writeInt(dos, this.nsnpts);
        this.writeInt(dos, this.nwfid);
        this.writeInt(dos, this.nxsize);
        this.writeInt(dos, this.nysize);
        this.writeInt(dos, this.unused15);
        this.writeInt(dos, this.iftype);
        this.writeInt(dos, this.idep);
        this.writeInt(dos, this.iztype);
        this.writeInt(dos, this.unused16);
        this.writeInt(dos, this.iinst);
        this.writeInt(dos, this.istreg);
        this.writeInt(dos, this.ievreg);
        this.writeInt(dos, this.ievtyp);
        this.writeInt(dos, this.iqual);
        this.writeInt(dos, this.isynth);
        this.writeInt(dos, this.imagtyp);
        this.writeInt(dos, this.imagsrc);
        this.writeInt(dos, this.unused19);
        this.writeInt(dos, this.unused20);
        this.writeInt(dos, this.unused21);
        this.writeInt(dos, this.unused22);
        this.writeInt(dos, this.unused23);
        this.writeInt(dos, this.unused24);
        this.writeInt(dos, this.unused25);
        this.writeInt(dos, this.unused26);
        this.writeInt(dos, this.leven);
        this.writeInt(dos, this.lpspol);
        this.writeInt(dos, this.lovrok);
        this.writeInt(dos, this.lcalda);
        this.writeInt(dos, this.unused27);
        dos.writeBytes(SacHeader.trimLen(this.kstnm, 8));
        dos.writeBytes(SacHeader.trimLen(this.kevnm, 16));
        dos.writeBytes(SacHeader.trimLen(this.khole, 8));
        dos.writeBytes(SacHeader.trimLen(this.ko, 8));
        dos.writeBytes(SacHeader.trimLen(this.ka, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt0, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt1, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt2, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt3, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt4, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt5, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt6, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt7, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt8, 8));
        dos.writeBytes(SacHeader.trimLen(this.kt9, 8));
        dos.writeBytes(SacHeader.trimLen(this.kf, 8));
        dos.writeBytes(SacHeader.trimLen(this.kuser0, 8));
        dos.writeBytes(SacHeader.trimLen(this.kuser1, 8));
        dos.writeBytes(SacHeader.trimLen(this.kuser2, 8));
        dos.writeBytes(SacHeader.trimLen(this.kcmpnm, 8));
        dos.writeBytes(SacHeader.trimLen(this.knetwk, 8));
        dos.writeBytes(SacHeader.trimLen(this.kdatrd, 8));
        dos.writeBytes(SacHeader.trimLen(this.kinst, 8));
    }

    public FDSNSourceId getSourceId() throws FDSNSourceIdException {
        String sta;
        String net = this.getKnetwk().trim();
        if (net.isEmpty() || SacConstants.isUndef(this.getKnetwk())) {
            net = "XX";
        }
        if ((sta = this.getKstnm().trim()).isEmpty() || SacConstants.isUndef(this.getKstnm())) {
            sta = "ABC";
        }
        String loc = this.getKhole().trim();
        if (SacConstants.isUndef(this.getKhole())) {
            loc = "";
        }
        Object cmp = this.getKcmpnm().trim();
        if (SacConstants.isUndef(this.getKcmpnm())) {
            float sampleRate = this.getSampleRate();
            if (this.getSampleRate() == -12345.0f) {
                sampleRate = 10.0f;
            }
            cmp = FDSNSourceId.bandCodeForRate(Double.valueOf(sampleRate), 0.0) + "HU";
        }
        FDSNSourceId sid = FDSNSourceId.fromNSLC(net, sta, loc, (String)cmp);
        return sid;
    }

    public void setSourceId(FDSNSourceId sid) {
        if (!sid.getNetworkCode().isEmpty()) {
            this.setKnetwk(sid.getNetworkCode());
        }
        if (!sid.getStationCode().isEmpty()) {
            this.setKstnm(sid.getStationCode());
        }
        if (!sid.getLocationCode().isEmpty()) {
            this.setKhole(sid.getLocationCode());
        }
        if (!sid.getChannelCode().isEmpty()) {
            this.setKcmpnm(sid.getChannelCode());
        }
    }

    public final void setLittleEndian() {
        this.byteOrder = false;
    }

    public final void setBigEndian() {
        this.byteOrder = true;
    }

    public static final short swapBytes(short val) {
        return (short)(((val & 0xFF00) >> 8) + ((val & 0xFF) << 8));
    }

    public static final int swapBytes(int val) {
        return ((val & 0xFF000000) >>> 24) + ((val & 0xFF0000) >> 8) + ((val & 0xFF00) << 8) + ((val & 0xFF) << 24);
    }

    public static final long swapBytes(long val) {
        return ((val & 0xFF00000000000000L) >>> 56) + ((val & 0xFF000000000000L) >> 40) + ((val & 0xFF0000000000L) >> 24) + ((val & 0xFF00000000L) >> 8) + ((val & 0xFF000000L) << 8) + ((val & 0xFF0000L) << 24) + ((val & 0xFF00L) << 40) + ((val & 0xFFL) << 56);
    }

    public static String trimLen(String s, int len) {
        if (((String)s).length() > len) {
            s = ((String)s).substring(0, len - 1);
        }
        while (((String)s).length() < len) {
            s = (String)s + " ";
        }
        return s;
    }

    public static String format(String label, float f) {
        return SacHeader.format(label, decimalFormat.get().format(f), 10, 10);
    }

    public static String format(String label, int val) {
        return SacHeader.format(label, "" + val, 10, 10);
    }

    public static String format(String label, String val, int labelWidth, int valWidth) {
        while (((String)label).length() < labelWidth) {
            label = " " + (String)label;
        }
        while (((String)val).length() < valWidth) {
            val = " " + (String)val;
        }
        return (String)label + " = " + (String)val;
    }

    public static String formatLine(String s1, float f1, String s2, float f2, String s3, float f3, String s4, float f4, String s5, float f5) {
        return SacHeader.format(s1, f1) + SacHeader.format(s2, f2) + SacHeader.format(s3, f3) + SacHeader.format(s4, f4) + SacHeader.format(s5, f5);
    }

    public void printHeader() {
        this.printHeader(new PrintWriter(System.out, true));
    }

    public void printHeader(PrintWriter out) {
        out.println(SacHeader.formatLine("delta", this.delta, "depmin", this.depmin, "depmax", this.depmax, "scale", this.scale, "odelta", this.odelta));
        out.println(SacHeader.formatLine("b", this.b, "e", this.e, "o", this.o, "a", this.a, "fmt", this.fmt));
        out.println(SacHeader.formatLine("t0", this.t0, "t1", this.t1, "t2", this.t2, "t3", this.t3, "t4", this.t4));
        out.println(SacHeader.formatLine("t5", this.t5, "t6", this.t6, "t7", this.t7, "t8", this.t8, "t9", this.t9));
        out.println(SacHeader.formatLine("f", this.f, "resp0", this.resp0, "resp1", this.resp1, "resp2", this.resp2, "resp3", this.resp3));
        out.println(SacHeader.formatLine("resp4", this.resp4, "resp5", this.resp5, "resp6", this.resp6, "resp7", this.resp7, "resp8", this.resp8));
        out.println(SacHeader.formatLine("resp9", this.resp9, "stla", this.stla, "stlo", this.stlo, "stel", this.stel, "stdp", this.stdp));
        out.println(SacHeader.formatLine("evla", this.evla, "evlo", this.evlo, "evel", this.evel, "evdp", this.evdp, "mag", this.mag));
        out.println(SacHeader.formatLine("user0", this.user0, "user1", this.user1, "user2", this.user2, "user3", this.user3, "user4", this.user4));
        out.println(SacHeader.formatLine("user5", this.user5, "user6", this.user6, "user7", this.user7, "user8", this.user8, "user9", this.user9));
        out.println(SacHeader.formatLine("dist", this.dist, "az", this.az, "baz", this.baz, "gcarc", this.gcarc, "sb", this.sb));
        out.println(SacHeader.formatLine("sdelta", this.sdelta, "depmen", this.depmen, "cmpaz", this.cmpaz, "cmpinc", this.cmpinc, "xminimum", this.xminimum));
        out.println(SacHeader.formatLine("xmaximum", this.xmaximum, "yminimum", this.yminimum, "ymaximum", this.ymaximum, "unused6", this.unused6, "unused7", this.unused7));
        out.println(SacHeader.formatLine("unused8", this.unused8, "unused9", this.unused9, "unused10", this.unused10, "unused11", this.unused11, "unused12", this.unused12));
        out.println(SacHeader.formatLine("nzyear", this.nzyear, "nzjday", this.nzjday, "nzhour", this.nzhour, "nzmin", this.nzmin, "nzsec", this.nzsec));
        out.println(SacHeader.formatLine("nzmsec", this.nzmsec, "nvhdr", this.nvhdr, "norid", this.norid, "nevid", this.nevid, "npts", this.npts));
        out.println(SacHeader.formatLine("nsnpts", this.nsnpts, "nwfid", this.nwfid, "nxsize", this.nxsize, "nysize", this.nysize, "unused15", this.unused15));
        out.println(SacHeader.formatLine("iftype", this.iftype, "idep", this.idep, "iztype", this.iztype, "unused16", this.unused16, "iinst", this.iinst));
        out.println(SacHeader.formatLine("istreg", this.istreg, "ievreg", this.ievreg, "ievtyp", this.ievtyp, "iqual", this.iqual, "isynth", this.isynth));
        out.println(SacHeader.formatLine("imagtyp", this.imagtyp, "imagsrc", this.imagsrc, "unused19", this.unused19, "unused20", this.unused20, "unused21", this.unused21));
        out.println(SacHeader.formatLine("unused22", this.unused22, "unused23", this.unused23, "unused24", this.unused24, "unused25", this.unused25, "unused26", this.unused26));
        out.println(SacHeader.formatLine("leven", this.leven, "lpspol", this.lpspol, "lovrok", this.lovrok, "lcalda", this.lcalda, "unused27", this.unused27));
        out.println(SacHeader.format("kstnm", this.kstnm, 10, 10) + SacHeader.format("kevnm", this.kevnm, 10, 31) + SacHeader.format("khole", this.khole, 12, 10));
        out.println(SacHeader.format("ko", this.ko, 10, 10) + SacHeader.format("ka = ", this.ka, 10, 10) + SacHeader.format("kt0", this.kt0, 10, 10) + SacHeader.format("kt1", this.kt1, 10, 10));
        out.println(SacHeader.format("kt2", this.kt2, 10, 10) + SacHeader.format("kt3 = ", this.kt3, 10, 10) + SacHeader.format("kt4", this.kt4, 10, 10) + SacHeader.format("kt5", this.kt5, 10, 10));
        out.println(SacHeader.format("kt6", this.kt6, 10, 10) + SacHeader.format("kt7 = ", this.kt7, 10, 10) + SacHeader.format("kt8", this.kt8, 10, 10) + SacHeader.format("kt9", this.kt9, 10, 10));
        out.println(SacHeader.format("kf", this.kf, 10, 10) + SacHeader.format("kuser0 = ", this.kuser0, 10, 10) + SacHeader.format("kuser1", this.kuser1, 10, 10) + SacHeader.format("kuser2", this.kuser2, 10, 10));
        out.println(SacHeader.format("kcmpnm", this.kcmpnm, 10, 10) + SacHeader.format("knetwk = ", this.knetwk, 10, 10) + SacHeader.format("kdatrd", this.kdatrd, 10, 10) + SacHeader.format("kinst", this.kinst, 10, 10));
    }

    public boolean getByteOrder() {
        return this.byteOrder;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float delta) {
        this.delta = delta;
    }

    public float getSampleRate() {
        return 1.0f / this.getDelta();
    }

    public float getSamplePeriod() {
        return this.getDelta();
    }

    public float getDepmin() {
        return this.depmin;
    }

    public void setDepmin(float depmin) {
        this.depmin = depmin;
    }

    public float getDepmax() {
        return this.depmax;
    }

    public void setDepmax(float depmax) {
        this.depmax = depmax;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getOdelta() {
        return this.odelta;
    }

    public void setOdelta(float odelta) {
        this.odelta = odelta;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
    }

    public float getE() {
        return this.e;
    }

    public void setE(float e) {
        this.e = e;
    }

    public float getO() {
        return this.o;
    }

    public void setO(float o) {
        this.o = o;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
    }

    public float getFmt() {
        return this.fmt;
    }

    public void setFmt(float fmt) {
        this.fmt = fmt;
    }

    public float getTHeader(int index) {
        switch (index) {
            case 0: {
                return this.getT0();
            }
            case 1: {
                return this.getT1();
            }
            case 2: {
                return this.getT2();
            }
            case 3: {
                return this.getT3();
            }
            case 4: {
                return this.getT4();
            }
            case 5: {
                return this.getT5();
            }
            case 6: {
                return this.getT6();
            }
            case 7: {
                return this.getT7();
            }
            case 8: {
                return this.getT8();
            }
            case 9: {
                return this.getT9();
            }
        }
        throw new IllegalArgumentException("Illegal T header index, " + index + ", must be 0-9");
    }

    public void setTHeader(int index, float val) {
        switch (index) {
            case 0: {
                this.setT0(val);
                break;
            }
            case 1: {
                this.setT1(val);
                break;
            }
            case 2: {
                this.setT2(val);
                break;
            }
            case 3: {
                this.setT3(val);
                break;
            }
            case 4: {
                this.setT4(val);
                break;
            }
            case 5: {
                this.setT5(val);
                break;
            }
            case 6: {
                this.setT6(val);
                break;
            }
            case 7: {
                this.setT7(val);
                break;
            }
            case 8: {
                this.setT8(val);
                break;
            }
            case 9: {
                this.setT9(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + index + ", must be 0-9");
            }
        }
    }

    public void setTHeader(int index, float val, String kLabel) {
        switch (index) {
            case 0: {
                this.setT0(val);
                this.setKt0(kLabel);
                break;
            }
            case 1: {
                this.setT1(val);
                this.setKt1(kLabel);
                break;
            }
            case 2: {
                this.setT2(val);
                this.setKt2(kLabel);
                break;
            }
            case 3: {
                this.setT3(val);
                this.setKt3(kLabel);
                break;
            }
            case 4: {
                this.setT4(val);
                this.setKt4(kLabel);
                break;
            }
            case 5: {
                this.setT5(val);
                this.setKt5(kLabel);
                break;
            }
            case 6: {
                this.setT6(val);
                this.setKt6(kLabel);
                break;
            }
            case 7: {
                this.setT7(val);
                this.setKt7(kLabel);
                break;
            }
            case 8: {
                this.setT8(val);
                this.setKt8(kLabel);
                break;
            }
            case 9: {
                this.setT9(val);
                this.setKt9(kLabel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + index + ", must be 0-9");
            }
        }
    }

    public String getKTHeader(int index) {
        switch (index) {
            case 0: {
                return this.getKt0();
            }
            case 1: {
                return this.getKt1();
            }
            case 2: {
                return this.getKt2();
            }
            case 3: {
                return this.getKt3();
            }
            case 4: {
                return this.getKt4();
            }
            case 5: {
                return this.getKt5();
            }
            case 6: {
                return this.getKt6();
            }
            case 7: {
                return this.getKt7();
            }
            case 8: {
                return this.getKt8();
            }
            case 9: {
                return this.getKt9();
            }
        }
        throw new IllegalArgumentException("Illegal T header index, " + index + ", must be 0-9");
    }

    public void setKtHeader(int index, String val) {
        switch (index) {
            case 0: {
                this.setKt0(val);
                break;
            }
            case 1: {
                this.setKt1(val);
                break;
            }
            case 2: {
                this.setKt2(val);
                break;
            }
            case 3: {
                this.setKt3(val);
                break;
            }
            case 4: {
                this.setKt4(val);
                break;
            }
            case 5: {
                this.setKt5(val);
                break;
            }
            case 6: {
                this.setKt6(val);
                break;
            }
            case 7: {
                this.setKt7(val);
                break;
            }
            case 8: {
                this.setKt8(val);
                break;
            }
            case 9: {
                this.setKt9(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + index + ", must be 0-9");
            }
        }
    }

    public float getT0() {
        return this.t0;
    }

    public void setT0(float t0) {
        this.t0 = t0;
    }

    public float getT1() {
        return this.t1;
    }

    public void setT1(float t1) {
        this.t1 = t1;
    }

    public float getT2() {
        return this.t2;
    }

    public void setT2(float t2) {
        this.t2 = t2;
    }

    public float getT3() {
        return this.t3;
    }

    public void setT3(float t3) {
        this.t3 = t3;
    }

    public float getT4() {
        return this.t4;
    }

    public void setT4(float t4) {
        this.t4 = t4;
    }

    public float getT5() {
        return this.t5;
    }

    public void setT5(float t5) {
        this.t5 = t5;
    }

    public float getT6() {
        return this.t6;
    }

    public void setT6(float t6) {
        this.t6 = t6;
    }

    public float getT7() {
        return this.t7;
    }

    public void setT7(float t7) {
        this.t7 = t7;
    }

    public float getT8() {
        return this.t8;
    }

    public void setT8(float t8) {
        this.t8 = t8;
    }

    public float getT9() {
        return this.t9;
    }

    public void setT9(float t9) {
        this.t9 = t9;
    }

    public float getF() {
        return this.f;
    }

    public void setF(float f) {
        this.f = f;
    }

    public float getResp0() {
        return this.resp0;
    }

    public void setResp0(float resp0) {
        this.resp0 = resp0;
    }

    public float getResp1() {
        return this.resp1;
    }

    public void setResp1(float resp1) {
        this.resp1 = resp1;
    }

    public float getResp2() {
        return this.resp2;
    }

    public void setResp2(float resp2) {
        this.resp2 = resp2;
    }

    public float getResp3() {
        return this.resp3;
    }

    public void setResp3(float resp3) {
        this.resp3 = resp3;
    }

    public float getResp4() {
        return this.resp4;
    }

    public void setResp4(float resp4) {
        this.resp4 = resp4;
    }

    public float getResp5() {
        return this.resp5;
    }

    public void setResp5(float resp5) {
        this.resp5 = resp5;
    }

    public float getResp6() {
        return this.resp6;
    }

    public void setResp6(float resp6) {
        this.resp6 = resp6;
    }

    public float getResp7() {
        return this.resp7;
    }

    public void setResp7(float resp7) {
        this.resp7 = resp7;
    }

    public float getResp8() {
        return this.resp8;
    }

    public void setResp8(float resp8) {
        this.resp8 = resp8;
    }

    public float getResp9() {
        return this.resp9;
    }

    public void setResp9(float resp9) {
        this.resp9 = resp9;
    }

    public float getStla() {
        return this.stla;
    }

    public void setStla(float stla) {
        this.stla = stla;
    }

    public float getStlo() {
        return this.stlo;
    }

    public void setStlo(float stlo) {
        this.stlo = stlo;
    }

    public float getStel() {
        return this.stel;
    }

    public void setStel(float stel) {
        this.stel = stel;
    }

    public float getStdp() {
        return this.stdp;
    }

    public void setStdp(float stdp) {
        this.stdp = stdp;
    }

    public float getEvla() {
        return this.evla;
    }

    public void setEvla(float evla) {
        this.evla = evla;
    }

    public float getEvlo() {
        return this.evlo;
    }

    public void setEvlo(float evlo) {
        this.evlo = evlo;
    }

    public float getEvel() {
        return this.evel;
    }

    public void setEvel(float evel) {
        this.evel = evel;
    }

    public float getEvdp() {
        return this.evdp;
    }

    public void setEvdp(float evdp) {
        this.evdp = evdp;
    }

    public float getEvdpkm() {
        return this.getEvdp() / 1000.0f;
    }

    public void setEvdpkm(float evdpkm) {
        this.setEvdp(evdpkm * 1000.0f);
    }

    public float getMag() {
        return this.mag;
    }

    public void setMag(float mag) {
        this.mag = mag;
    }

    public float getUserHeader(int index) {
        switch (index) {
            case 0: {
                return this.getUser0();
            }
            case 1: {
                return this.getUser1();
            }
            case 2: {
                return this.getUser2();
            }
            case 3: {
                return this.getUser3();
            }
            case 4: {
                return this.getUser4();
            }
            case 5: {
                return this.getUser5();
            }
            case 6: {
                return this.getUser6();
            }
            case 7: {
                return this.getUser7();
            }
            case 8: {
                return this.getUser8();
            }
            case 9: {
                return this.getUser9();
            }
        }
        throw new IllegalArgumentException("Illegal User header index, " + index + ", must be 0-9");
    }

    public void setUserHeader(int index, float val) {
        switch (index) {
            case 0: {
                this.setUser0(val);
                break;
            }
            case 1: {
                this.setUser1(val);
                break;
            }
            case 2: {
                this.setUser2(val);
                break;
            }
            case 3: {
                this.setUser3(val);
                break;
            }
            case 4: {
                this.setUser4(val);
                break;
            }
            case 5: {
                this.setUser5(val);
                break;
            }
            case 6: {
                this.setUser6(val);
                break;
            }
            case 7: {
                this.setUser7(val);
                break;
            }
            case 8: {
                this.setUser8(val);
                break;
            }
            case 9: {
                this.setUser9(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal User header index, " + index + ", must be 0-9");
            }
        }
    }

    public float getUser0() {
        return this.user0;
    }

    public void setUser0(float user0) {
        this.user0 = user0;
    }

    public float getUser1() {
        return this.user1;
    }

    public void setUser1(float user1) {
        this.user1 = user1;
    }

    public float getUser2() {
        return this.user2;
    }

    public void setUser2(float user2) {
        this.user2 = user2;
    }

    public float getUser3() {
        return this.user3;
    }

    public void setUser3(float user3) {
        this.user3 = user3;
    }

    public float getUser4() {
        return this.user4;
    }

    public void setUser4(float user4) {
        this.user4 = user4;
    }

    public float getUser5() {
        return this.user5;
    }

    public void setUser5(float user5) {
        this.user5 = user5;
    }

    public float getUser6() {
        return this.user6;
    }

    public void setUser6(float user6) {
        this.user6 = user6;
    }

    public float getUser7() {
        return this.user7;
    }

    public void setUser7(float user7) {
        this.user7 = user7;
    }

    public float getUser8() {
        return this.user8;
    }

    public void setUser8(float user8) {
        this.user8 = user8;
    }

    public float getUser9() {
        return this.user9;
    }

    public void setUser9(float user9) {
        this.user9 = user9;
    }

    public float getDist() {
        return this.dist;
    }

    public void setDist(float dist) {
        this.dist = dist;
    }

    public float getAz() {
        return this.az;
    }

    public void setAz(float az) {
        this.az = az;
    }

    public float getBaz() {
        return this.baz;
    }

    public void setBaz(float baz) {
        this.baz = baz;
    }

    public float getGcarc() {
        return this.gcarc;
    }

    public void setGcarc(float gcarc) {
        this.gcarc = gcarc;
    }

    public float getSb() {
        return this.sb;
    }

    public void setSb(float sb) {
        this.sb = sb;
    }

    public float getSdelta() {
        return this.sdelta;
    }

    public void setSdelta(float sdelta) {
        this.sdelta = sdelta;
    }

    public float getDepmen() {
        return this.depmen;
    }

    public void setDepmen(float depmen) {
        this.depmen = depmen;
    }

    public float getCmpaz() {
        return this.cmpaz;
    }

    public void setCmpaz(float cmpaz) {
        this.cmpaz = cmpaz;
    }

    public float getCmpinc() {
        return this.cmpinc;
    }

    public void setCmpinc(float cmpinc) {
        this.cmpinc = cmpinc;
    }

    public float getXminimum() {
        return this.xminimum;
    }

    public void setXminimum(float xminimum) {
        this.xminimum = xminimum;
    }

    public float getXmaximum() {
        return this.xmaximum;
    }

    public void setXmaximum(float xmaximum) {
        this.xmaximum = xmaximum;
    }

    public float getYminimum() {
        return this.yminimum;
    }

    public void setYminimum(float yminimum) {
        this.yminimum = yminimum;
    }

    public float getYmaximum() {
        return this.ymaximum;
    }

    public void setYmaximum(float ymaximum) {
        this.ymaximum = ymaximum;
    }

    public float getUnused6() {
        return this.unused6;
    }

    public void setUnused6(float unused6) {
        this.unused6 = unused6;
    }

    public float getUnused7() {
        return this.unused7;
    }

    public void setUnused7(float unused7) {
        this.unused7 = unused7;
    }

    public float getUnused8() {
        return this.unused8;
    }

    public void setUnused8(float unused8) {
        this.unused8 = unused8;
    }

    public float getUnused9() {
        return this.unused9;
    }

    public void setUnused9(float unused9) {
        this.unused9 = unused9;
    }

    public float getUnused10() {
        return this.unused10;
    }

    public void setUnused10(float unused10) {
        this.unused10 = unused10;
    }

    public float getUnused11() {
        return this.unused11;
    }

    public void setUnused11(float unused11) {
        this.unused11 = unused11;
    }

    public float getUnused12() {
        return this.unused12;
    }

    public void setUnused12(float unused12) {
        this.unused12 = unused12;
    }

    public int getNzyear() {
        return this.nzyear;
    }

    public void setNzyear(int nzyear) {
        this.nzyear = nzyear;
    }

    public int getNzjday() {
        return this.nzjday;
    }

    public void setNzjday(int nzjday) {
        this.nzjday = nzjday;
    }

    public int getNzhour() {
        return this.nzhour;
    }

    public void setNzhour(int nzhour) {
        this.nzhour = nzhour;
    }

    public int getNzmin() {
        return this.nzmin;
    }

    public void setNzmin(int nzmin) {
        this.nzmin = nzmin;
    }

    public int getNzsec() {
        return this.nzsec;
    }

    public void setNzsec(int nzsec) {
        this.nzsec = nzsec;
    }

    public int getNzmsec() {
        return this.nzmsec;
    }

    public void setNzmsec(int nzmsec) {
        this.nzmsec = nzmsec;
    }

    public void setNzTime(ZonedDateTime start) {
        this.setNzyear(start.getYear());
        this.setNzjday(start.getDayOfYear());
        this.setNzhour(start.getHour());
        this.setNzmin(start.getMinute());
        this.setNzsec(start.getSecond());
        this.setNzmsec(start.getNano() / 1000000);
    }

    public void setNzTime(Instant start) {
        this.setNzTime(start.atZone(TimeUtils.TZ_UTC));
    }

    public ZonedDateTime getNzTime() {
        ZonedDateTime nz = ZonedDateTime.of(this.getNzyear(), 1, 1, this.getNzhour(), this.getNzmin(), this.getNzsec(), this.getNzmsec() * 1000000, TimeUtils.TZ_UTC);
        return nz.plusDays(this.getNzjday() - 1);
    }

    public int getNvhdr() {
        return this.nvhdr;
    }

    public void setNvhdr(int nvhdr) {
        this.nvhdr = nvhdr;
    }

    public int getNorid() {
        return this.norid;
    }

    public void setNorid(int norid) {
        this.norid = norid;
    }

    public int getNevid() {
        return this.nevid;
    }

    public void setNevid(int nevid) {
        this.nevid = nevid;
    }

    public int getNpts() {
        return this.npts;
    }

    public void setNpts(int npts) {
        this.npts = npts;
    }

    public int getNsnpts() {
        return this.nsnpts;
    }

    public void setNsnpts(int nsnpts) {
        this.nsnpts = nsnpts;
    }

    public int getNwfid() {
        return this.nwfid;
    }

    public void setNwfid(int nwfid) {
        this.nwfid = nwfid;
    }

    public int getNxsize() {
        return this.nxsize;
    }

    public void setNxsize(int nxsize) {
        this.nxsize = nxsize;
    }

    public int getNysize() {
        return this.nysize;
    }

    public void setNysize(int nysize) {
        this.nysize = nysize;
    }

    public int getUnused15() {
        return this.unused15;
    }

    public void setUnused15(int unused15) {
        this.unused15 = unused15;
    }

    public int getIftype() {
        return this.iftype;
    }

    public void setIftype(int iftype) {
        this.iftype = iftype;
    }

    public int getIdep() {
        return this.idep;
    }

    public void setIdep(int idep) {
        this.idep = idep;
    }

    public int getIztype() {
        return this.iztype;
    }

    public void setIztype(int iztype) {
        this.iztype = iztype;
    }

    public int getUnused16() {
        return this.unused16;
    }

    public void setUnused16(int unused16) {
        this.unused16 = unused16;
    }

    public int getIinst() {
        return this.iinst;
    }

    public void setIinst(int iinst) {
        this.iinst = iinst;
    }

    public int getIstreg() {
        return this.istreg;
    }

    public void setIstreg(int istreg) {
        this.istreg = istreg;
    }

    public int getIevreg() {
        return this.ievreg;
    }

    public void setIevreg(int ievreg) {
        this.ievreg = ievreg;
    }

    public int getIevtyp() {
        return this.ievtyp;
    }

    public void setIevtyp(int ievtyp) {
        this.ievtyp = ievtyp;
    }

    public int getIqual() {
        return this.iqual;
    }

    public void setIqual(int iqual) {
        this.iqual = iqual;
    }

    public int getIsynth() {
        return this.isynth;
    }

    public void setIsynth(int isynth) {
        this.isynth = isynth;
    }

    public int getImagtyp() {
        return this.imagtyp;
    }

    public void setImagtyp(int imagtyp) {
        this.imagtyp = imagtyp;
    }

    public String getMagnitudeType() {
        switch (this.getImagtyp()) {
            case 52: {
                return "mb";
            }
            case 53: {
                return "Ms";
            }
            case 54: {
                return "ml";
            }
            case 56: {
                return "md";
            }
            case 55: {
                return "Mw";
            }
        }
        return "m";
    }

    public int getImagsrc() {
        return this.imagsrc;
    }

    public void setImagsrc(int imagsrc) {
        this.imagsrc = imagsrc;
    }

    public int getUnused19() {
        return this.unused19;
    }

    public void setUnused19(int unused19) {
        this.unused19 = unused19;
    }

    public int getUnused20() {
        return this.unused20;
    }

    public void setUnused20(int unused20) {
        this.unused20 = unused20;
    }

    public int getUnused21() {
        return this.unused21;
    }

    public void setUnused21(int unused21) {
        this.unused21 = unused21;
    }

    public int getUnused22() {
        return this.unused22;
    }

    public void setUnused22(int unused22) {
        this.unused22 = unused22;
    }

    public int getUnused23() {
        return this.unused23;
    }

    public void setUnused23(int unused23) {
        this.unused23 = unused23;
    }

    public int getUnused24() {
        return this.unused24;
    }

    public void setUnused24(int unused24) {
        this.unused24 = unused24;
    }

    public int getUnused25() {
        return this.unused25;
    }

    public void setUnused25(int unused25) {
        this.unused25 = unused25;
    }

    public int getUnused26() {
        return this.unused26;
    }

    public void setUnused26(int unused26) {
        this.unused26 = unused26;
    }

    public int getLeven() {
        return this.leven;
    }

    public void setLeven(int leven) {
        this.leven = leven;
    }

    public int getLpspol() {
        return this.lpspol;
    }

    public void setLpspol(int lpspol) {
        this.lpspol = lpspol;
    }

    public int getLovrok() {
        return this.lovrok;
    }

    public void setLovrok(int lovrok) {
        this.lovrok = lovrok;
    }

    public int getLcalda() {
        return this.lcalda;
    }

    public void setLcalda(int lcalda) {
        this.lcalda = lcalda;
    }

    public int getUnused27() {
        return this.unused27;
    }

    public void setUnused27(int unused27) {
        this.unused27 = unused27;
    }

    public String getKstnm() {
        return this.kstnm;
    }

    public void setKstnm(String kstnm) {
        this.kstnm = kstnm;
    }

    public String getKevnm() {
        return this.kevnm;
    }

    public void setKevnm(String kevnm) {
        this.kevnm = kevnm;
    }

    public String getKhole() {
        return this.khole;
    }

    public void setKhole(String khole) {
        this.khole = khole;
    }

    public String getKo() {
        return this.ko;
    }

    public void setKo(String ko) {
        this.ko = ko;
    }

    public String getKa() {
        return this.ka;
    }

    public void setKa(String ka) {
        this.ka = ka;
    }

    public String getKt0() {
        return this.kt0;
    }

    public void setKt0(String kt0) {
        this.kt0 = kt0;
    }

    public String getKt1() {
        return this.kt1;
    }

    public void setKt1(String kt1) {
        this.kt1 = kt1;
    }

    public String getKt2() {
        return this.kt2;
    }

    public void setKt2(String kt2) {
        this.kt2 = kt2;
    }

    public String getKt3() {
        return this.kt3;
    }

    public void setKt3(String kt3) {
        this.kt3 = kt3;
    }

    public String getKt4() {
        return this.kt4;
    }

    public void setKt4(String kt4) {
        this.kt4 = kt4;
    }

    public String getKt5() {
        return this.kt5;
    }

    public void setKt5(String kt5) {
        this.kt5 = kt5;
    }

    public String getKt6() {
        return this.kt6;
    }

    public void setKt6(String kt6) {
        this.kt6 = kt6;
    }

    public String getKt7() {
        return this.kt7;
    }

    public void setKt7(String kt7) {
        this.kt7 = kt7;
    }

    public String getKt8() {
        return this.kt8;
    }

    public void setKt8(String kt8) {
        this.kt8 = kt8;
    }

    public String getKt9() {
        return this.kt9;
    }

    public void setKt9(String kt9) {
        this.kt9 = kt9;
    }

    public String getKf() {
        return this.kf;
    }

    public void setKf(String kf) {
        this.kf = kf;
    }

    public String getKuser0() {
        return this.kuser0;
    }

    public void setKuser0(String kuser0) {
        this.kuser0 = kuser0;
    }

    public String getKuser1() {
        return this.kuser1;
    }

    public void setKuser1(String kuser1) {
        this.kuser1 = kuser1;
    }

    public String getKuser2() {
        return this.kuser2;
    }

    public void setKuser2(String kuser2) {
        this.kuser2 = kuser2;
    }

    public String getKcmpnm() {
        return this.kcmpnm;
    }

    public void setKcmpnm(String kcmpnm) {
        this.kcmpnm = kcmpnm;
    }

    public String getKnetwk() {
        return this.knetwk;
    }

    public void setKnetwk(String knetwk) {
        this.knetwk = knetwk;
    }

    public String getKdatrd() {
        return this.kdatrd;
    }

    public void setKdatrd(String kdatrd) {
        this.kdatrd = kdatrd;
    }

    public String getKinst() {
        return this.kinst;
    }

    public void setKinst(String kinst) {
        this.kinst = kinst;
    }

    public void setByteOrder(boolean byteOrder) {
        this.byteOrder = byteOrder;
    }
}

