/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class NodalPlane {
    RealQuantity strike;
    RealQuantity dip;
    RealQuantity rake;

    public NodalPlane(XMLEventReader reader, String elementName) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("strike")) {
                    this.strike = new RealQuantity(reader, "strike");
                    continue;
                }
                if (elName.equals("dip")) {
                    this.dip = new RealQuantity(reader, "dip");
                    continue;
                }
                if (elName.equals("rake")) {
                    this.rake = new RealQuantity(reader, "rake");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public RealQuantity getDip() {
        return this.dip;
    }

    public RealQuantity getRake() {
        return this.rake;
    }

    public RealQuantity getStrike() {
        return this.strike;
    }

    public void setDip(RealQuantity dip) {
        this.dip = dip;
    }

    public void setRake(RealQuantity rake) {
        this.rake = rake;
    }

    public void setStrike(RealQuantity strike) {
        this.strike = strike;
    }
}

