/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventIterator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EventParameters {
    String description;
    CreationInfo creationInfo;
    EventIterator events;
    List<Comment> commentList = new ArrayList<Comment>();

    public EventParameters(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("eventParameters", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("event")) {
                    this.events = new EventIterator(reader, this);
                    break;
                }
                this.processOneStartElement(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setEvents(EventIterator events) {
        this.events = events;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    void processOneStartElement(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        XMLEvent e = reader.peek();
        if (e.isStartElement()) {
            String elName = e.asStartElement().getName().getLocalPart();
            if (elName.equals("description")) {
                this.description = StaxUtil.pullText(reader, "description");
            } else if (elName.equals("creationInfo")) {
                this.creationInfo = new CreationInfo(reader);
            } else if (elName.equals("comment")) {
                this.commentList.add(new Comment(reader));
            } else {
                StaxUtil.skipToMatchingEnd(reader);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public EventIterator getEvents() {
        if (this.events == null) {
            this.events = new EventIterator(null, this){

                @Override
                public boolean hasNext() throws XMLStreamException {
                    return false;
                }

                @Override
                public Event next() throws XMLStreamException, SeisFileException {
                    throw new SeisFileException("No mo events");
                }
            };
        }
        return this.events;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }
}

