(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const SI = {
        VA: {
            name: {
                singular: 'Volt-Ampere',
                plural: 'Volt-Amperes',
            },
            to_anchor: 1,
        },
        mVA: {
            name: {
                singular: 'Millivolt-Ampere',
                plural: 'Millivolt-Amperes',
            },
            to_anchor: 0.001,
        },
        kVA: {
            name: {
                singular: 'Kilovolt-Ampere',
                plural: 'Kilovolt-Amperes',
            },
            to_anchor: 1000,
        },
        MVA: {
            name: {
                singular: 'Megavolt-Ampere',
                plural: 'Megavolt-Amperes',
            },
            to_anchor: 1000000,
        },
        GVA: {
            name: {
                singular: 'Gigavolt-Ampere',
                plural: 'Gigavolt-Amperes',
            },
            to_anchor: 1000000000,
        },
    };
    const measure = {
        systems: {
            SI,
        },
    };
    exports.default = measure;
});
