/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.IncidentAngleRay;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.RayParamKmRay;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.TakeoffAngleRay;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.args.DistanceRayArgs;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.LatLonAzBazArgs;
import edu.sc.seis.TauP.cmdline.args.QmlStaxmlArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.seisFile.LatLonLocatable;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class DistanceArgs {
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..*", heading="Distance is given by:%n")
    DistanceRayArgs distArgs = new DistanceRayArgs();
    @CommandLine.ArgGroup(validate=false, heading="Lat,Lon influenced by:%n")
    LatLonAzBazArgs latLonArgs = new LatLonAzBazArgs();
    @CommandLine.Mixin
    GeodeticArgs geodeticArgs = new GeodeticArgs();
    @CommandLine.Mixin
    QmlStaxmlArgs qmlStaxmlArgs = new QmlStaxmlArgs();

    /*
     * WARNING - void declaration
     */
    public List<DistanceRay> getDistances() throws TauPException {
        ArrayList<DistanceRay> out = new ArrayList<DistanceRay>();
        ArrayList<DistanceRay> simpleDistanceList = new ArrayList<DistanceRay>();
        for (Double d : this.distArgs.degreesList) {
            simpleDistanceList.add(DistanceRay.ofDegrees(d));
        }
        for (Double d : this.distArgs.exactDegreesList) {
            simpleDistanceList.add(DistanceRay.ofExactDegrees(d));
        }
        if (!this.distArgs.degreeRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeDeg(this.distArgs.degreeRange)) {
                simpleDistanceList.add(DistanceRay.ofDegrees(d));
            }
        }
        for (Double d : this.distArgs.distKilometersList) {
            simpleDistanceList.add(DistanceRay.ofKilometers(d));
        }
        for (Double d : this.distArgs.exactDistKilometersList) {
            simpleDistanceList.add(DistanceRay.ofExactKilometers(d));
        }
        if (!this.distArgs.kilometerRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeKm(this.distArgs.kilometerRange)) {
                simpleDistanceList.add(DistanceRay.ofKilometers(d));
            }
        }
        if (!this.distArgs.exactDegreeRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeDeg(this.distArgs.exactDegreeRange)) {
                simpleDistanceList.add(DistanceRay.ofExactDegrees(d));
            }
        }
        if (!this.distArgs.exactKilometerRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeKm(this.distArgs.exactKilometerRange)) {
                simpleDistanceList.add(DistanceRay.ofExactKilometers(d));
            }
        }
        if (this.getAzimuth() != null) {
            for (DistanceRay dr : simpleDistanceList) {
                if (dr.hasAzimuth()) continue;
                dr.setAzimuth(this.getAzimuth());
            }
        } else if (this.getBackAzimuth() != null) {
            for (DistanceRay dr : simpleDistanceList) {
                if (dr.hasBackAzimuth()) continue;
                dr.setBackAzimuth(this.getBackAzimuth());
            }
        }
        boolean hasEvent = this.hasEventLatLon();
        List<Object> quakes = new ArrayList();
        if (hasEvent) {
            quakes = this.getEventLatLon();
            hasEvent = !quakes.isEmpty();
        }
        boolean hasStation = this.hasStationLatLon();
        List<Object> stationList = new ArrayList();
        if (hasStation) {
            stationList = this.getStationLatLon();
        }
        boolean bl = hasStation = !stationList.isEmpty();
        if (hasEvent && this.getAzimuth() != null && !hasStation) {
            ArrayList<DistanceRay> evtOut = new ArrayList<DistanceRay>();
            for (DistanceRay dr : simpleDistanceList) {
                if (dr.isLatLonable()) {
                    evtOut.add(dr);
                    continue;
                }
                for (LatLonLocatable latLonLocatable : quakes) {
                    DistanceRay evtDr = DistanceRay.duplicate(dr);
                    evtDr.withEventAzimuth(latLonLocatable, this.getAzimuth());
                    evtDr.setDescription(latLonLocatable.getLocationDescription() + " to az " + Outputs.formatDistance(this.getAzimuth()).trim());
                    evtDr.insertSeismicSource(latLonLocatable);
                    evtOut.add(evtDr);
                }
            }
            out.addAll(evtOut);
        } else if (!hasEvent && hasStation && this.getBackAzimuth() != null) {
            ArrayList<DistanceRay> staOut = new ArrayList<DistanceRay>();
            for (DistanceRay dr : simpleDistanceList) {
                if (dr.isLatLonable()) {
                    staOut.add(dr);
                    continue;
                }
                for (LatLonLocatable latLonLocatable : stationList) {
                    DistanceRay staDr = DistanceRay.duplicate(dr);
                    staDr.withStationBackAzimuth(latLonLocatable, this.getBackAzimuth());
                    staDr.setDescription("baz " + Outputs.formatDistance(this.getAzimuth()) + " to " + latLonLocatable.getLocationDescription());
                    staOut.add(staDr);
                }
            }
            out.addAll(staOut);
        } else if (hasEvent && hasStation) {
            out.addAll(simpleDistanceList);
            for (LatLonLocatable latLonLocatable : quakes) {
                for (LatLonLocatable latLonLocatable2 : stationList) {
                    void var11_22;
                    if (this.geodeticArgs.isGeodetic()) {
                        DistanceAngleRay distanceAngleRay = DistanceRay.ofGeodeticEventStation(latLonLocatable, latLonLocatable2, this.geodeticArgs.getInverseEllipFlattening());
                    } else {
                        DistanceAngleRay distanceAngleRay = DistanceRay.ofEventStation(latLonLocatable, latLonLocatable2);
                    }
                    var11_22.setDescription(latLonLocatable.getLocationDescription() + " to " + latLonLocatable2.getLocationDescription());
                    out.add((DistanceRay)var11_22);
                }
            }
        } else {
            out.addAll(simpleDistanceList);
        }
        return out;
    }

    public List<RayParamKmRay> getRayParamKmRays() throws TauPException {
        ArrayList<RayParamKmRay> rpList = new ArrayList<RayParamKmRay>();
        for (Double d : this.distArgs.shootKmRaypList) {
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet for az from event...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    RayParamKmRay evtDr = new RayParamKmRay(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet for baz from station...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    RayParamKmRay staDr = new RayParamKmRay(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(new RayParamKmRay(d));
        }
        return rpList;
    }

    public List<RayParamRay> getRayParamDegRays() throws TauPException {
        ArrayList<RayParamRay> rpList = new ArrayList<RayParamRay>();
        for (Double d : this.distArgs.shootRaypList) {
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    RayParamRay evtDr = RayParamRay.ofRayParamSDegree(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet for baz from station...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    RayParamRay staDr = RayParamRay.ofRayParamSDegree(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(RayParamRay.ofRayParamSDegree(d));
        }
        return rpList;
    }

    public List<RayParamRay> getRayParamRadianRays() throws TauPException {
        ArrayList<RayParamRay> rpList = new ArrayList<RayParamRay>();
        for (Double d : this.distArgs.shootRadianRaypList) {
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    RayParamRay evtDr = RayParamRay.ofRayParamSRadian(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet for baz from station...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    RayParamRay staDr = RayParamRay.ofRayParamSRadian(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(RayParamRay.ofRayParamSRadian(d));
        }
        return rpList;
    }

    public List<RayParamIndexRay> getRayParamIndexRays() throws TauPException {
        ArrayList<RayParamIndexRay> rpList = new ArrayList<RayParamIndexRay>();
        for (Integer d : this.distArgs.shootIndexRaypList) {
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    RayParamIndexRay evtDr = new RayParamIndexRay(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    RayParamIndexRay staDr = new RayParamIndexRay(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(new RayParamIndexRay(d));
        }
        return rpList;
    }

    public List<TakeoffAngleRay> getTakeoffAngleRays() throws TauPException {
        ArrayList<TakeoffAngleRay> rpList = new ArrayList<TakeoffAngleRay>();
        ArrayList<Double> takeoffInputList = new ArrayList<Double>();
        takeoffInputList.addAll(this.distArgs.takeoffAngle);
        if (!this.distArgs.takeoffRange.isEmpty()) {
            takeoffInputList.addAll(DistanceArgs.createListFromRangeDeg(this.distArgs.takeoffRange));
        }
        for (Double d : takeoffInputList) {
            if (d < 0.0 || d > 180.0) {
                throw new IllegalArgumentException("Takeoff angle should be between 0 and 180 degrees: " + d);
            }
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    TakeoffAngleRay evtDr = new TakeoffAngleRay(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    TakeoffAngleRay staDr = new TakeoffAngleRay(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(TakeoffAngleRay.ofTakeoffAngle(d));
        }
        return rpList;
    }

    public List<IncidentAngleRay> getIncidentAngleRays() throws TauPException {
        ArrayList<IncidentAngleRay> rpList = new ArrayList<IncidentAngleRay>();
        ArrayList<Double> incidentAngleInputList = new ArrayList<Double>();
        incidentAngleInputList.addAll(this.distArgs.incidentAngle);
        if (!this.distArgs.incidentRange.isEmpty()) {
            incidentAngleInputList.addAll(DistanceArgs.createListFromRangeDeg(this.distArgs.incidentRange));
        }
        for (Double d : incidentAngleInputList) {
            if (d < 0.0 || d > 180.0) {
                throw new IllegalArgumentException("Incident angle should be between 0 and 180 degrees: " + d);
            }
            if (this.hasEventLatLon() && !this.hasStationLatLon() && this.getAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable evt : this.getEventLatLon()) {
                    IncidentAngleRay evtDr = new IncidentAngleRay(d);
                    evtDr.withEventAzimuth(evt, this.getAzimuth());
                    rpList.add(evtDr);
                }
                continue;
            }
            if (!this.hasEventLatLon() && this.hasStationLatLon() && this.getBackAzimuth() != null) {
                if (this.geodeticArgs.isGeodetic()) {
                    throw new IllegalArgumentException("geodetic not yet...");
                }
                for (LatLonLocatable sta : this.getStationLatLon()) {
                    IncidentAngleRay staDr = new IncidentAngleRay(d);
                    staDr.withStationBackAzimuth(sta, this.getBackAzimuth());
                    rpList.add(staDr);
                }
                continue;
            }
            rpList.add(IncidentAngleRay.ofIncidentAngle(d));
        }
        return rpList;
    }

    public static List<Double> createListFromRangeDeg(List<Double> minMaxStep) {
        double step = 10.0;
        double start = 0.0;
        double stop = 180.0;
        return DistanceArgs.createListFromRange(minMaxStep, start, stop, step);
    }

    public static List<Double> createListFromRangeKm(List<Double> minMaxStep) {
        double step = 100.0;
        double start = 0.0;
        double stop = 1000.0;
        return DistanceArgs.createListFromRange(minMaxStep, start, stop, step);
    }

    public static List<Double> createListFromRange(List<Double> minMaxStep, double defaultStart, double defaultStop, double defaultStep) {
        double step = defaultStep;
        double start = defaultStart;
        double stop = defaultStop;
        switch (minMaxStep.size()) {
            case 3: {
                step = minMaxStep.get(2);
            }
            case 2: {
                start = minMaxStep.get(0);
                stop = minMaxStep.get(1);
                break;
            }
            case 1: {
                step = minMaxStep.get(0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("range length should be 1-3 but was " + minMaxStep.size());
            }
        }
        if (step == 0.0) {
            throw new IllegalArgumentException("Step cannot be zero");
        }
        if (step < 0.0 && start < stop || step > 0.0 && start > stop) {
            double tmp = start;
            start = stop;
            stop = tmp;
        }
        ArrayList<Double> out = new ArrayList<Double>();
        for (double d = start; d <= stop; d += step) {
            out.add(d);
        }
        return out;
    }

    public List<RayCalculateable> getRayCalculatables() throws TauPException {
        return this.getRayCalculatables(null);
    }

    public List<RayCalculateable> getRayCalculatables(SeismicSourceArgs sourceArgs) throws TauPException {
        ArrayList<RayCalculateable> out = new ArrayList<RayCalculateable>();
        out.addAll(this.getDistances());
        out.addAll(this.getRayParamDegRays());
        out.addAll(this.getRayParamKmRays());
        out.addAll(this.getRayParamRadianRays());
        out.addAll(this.getTakeoffAngleRays());
        out.addAll(this.getIncidentAngleRays());
        out.addAll(this.getRayParamIndexRays());
        if (this.hasAzimuth()) {
            for (RayCalculateable rc : out) {
                if (rc.hasAzimuth()) continue;
                rc.setAzimuth(this.getAzimuth());
            }
        }
        if (sourceArgs != null && sourceArgs.hasStrikeDipRake()) {
            for (RayCalculateable rc : out) {
                if (rc.hasFaultPlane()) continue;
                float Mw = rc.hasMw() ? rc.getMw() : sourceArgs.getMw();
                rc.setSeismicSource(new SeismicSource(Mw, sourceArgs.getFaultPlane()));
            }
        }
        return out;
    }

    public Double getAzimuth() {
        return this.latLonArgs.azimuth;
    }

    public void setAzimuth(double val) {
        this.latLonArgs.azimuth = val;
    }

    public boolean hasAzimuth() {
        return this.latLonArgs.hasAzimuth();
    }

    public Double getBackAzimuth() {
        return this.latLonArgs.backAzimuth;
    }

    public boolean hasBackAzimuth() {
        return this.latLonArgs.hasBackAzimuth();
    }

    public void setBackAzimuth(double val) {
        this.latLonArgs.backAzimuth = val;
    }

    public boolean hasEventLatLon() {
        return this.latLonArgs.hasEventLatLon() || this.qmlStaxmlArgs.hasQml();
    }

    public boolean hasStationLatLon() {
        return this.latLonArgs.hasStationLatLon() || this.qmlStaxmlArgs.hasStationXML();
    }

    public void validateArguments() {
        if (!(!this.distArgs.allEmpty() || this.hasEventLatLon() && this.hasStationLatLon())) {
            throw new IllegalArgumentException("Must specify at least one distance or station, event.");
        }
        for (Double d : this.distArgs.takeoffAngle) {
            if (!(d < 0.0) && !(d > 180.0)) continue;
            throw new IllegalArgumentException("Takeoff angle should be between 0 and 180 degrees: " + d);
        }
        if (this.hasEventLatLon() && this.hasStationLatLon() && (this.hasAzimuth() || this.hasBackAzimuth())) {
            throw new IllegalArgumentException("Cannot specify azimuth or back azimuth when both station and event are given");
        }
        if (this.hasAzimuth() && this.hasBackAzimuth()) {
            throw new IllegalArgumentException("Cannot specify both azimuth and back azimuth");
        }
        this.latLonArgs.validateArguments();
        this.geodeticArgs.validateArguments();
    }

    public boolean isAllIndexRays() {
        return this.distArgs.allIndexRays;
    }

    public List<LatLonLocatable> getStationLatLon() throws TauPException {
        ArrayList<LatLonLocatable> staList = new ArrayList<LatLonLocatable>();
        staList.addAll(this.latLonArgs.getStationLocations());
        staList.addAll(this.qmlStaxmlArgs.getStationLocations());
        return staList;
    }

    public List<LatLonLocatable> getEventLatLon() throws TauPException {
        ArrayList<LatLonLocatable> eventLocs = new ArrayList<LatLonLocatable>();
        eventLocs.addAll(this.latLonArgs.getEventLocations());
        eventLocs.addAll(this.qmlStaxmlArgs.getEventLocations());
        return eventLocs;
    }

    public void setDegreeList(List<Double> degreesList) {
        this.distArgs.degreesList = degreesList;
    }

    public void setTakeoffAngles(List<Double> degreesList) {
        this.distArgs.takeoffAngle = degreesList;
    }

    public void setShootRayParams(List<Double> rayParamList) {
        this.distArgs.shootRaypList = rayParamList;
    }

    public void setShootRayParamKM(List<Double> rayParamKMList) {
        this.distArgs.shootKmRaypList = rayParamKMList;
    }

    public void clear() {
        this.latLonArgs.stationLatLonList.clear();
        this.latLonArgs.eventLatLonList.clear();
        this.distArgs.takeoffAngle.clear();
        this.distArgs.incidentAngle.clear();
        this.distArgs.degreesList.clear();
        this.distArgs.distKilometersList.clear();
        this.distArgs.shootRaypList.clear();
        this.distArgs.shootKmRaypList.clear();
        this.distArgs.shootRadianRaypList.clear();
        this.distArgs.shootIndexRaypList.clear();
    }
}

