/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.ToolRun;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import picocli.CommandLine;

public class PythonBindings {
    public static List<String> outputFormatOptions = List.of("gmt", "html", "json", "csv", "svg", "text", "locsat", "ms3", "sac", "taup", "nameddiscon");
    public static List<String> ignoreOptions = new ArrayList<String>(List.of("help", "version", "debug", "verbose", "prop", "output", "nd", "tvel", "quakeml", "staxml", "phasefile", "sid", "eid"));
    public static List<String> ignoreCommands;

    public static String createPython(TauP_Tool tool) {
        StringWriter swConstructor = new StringWriter();
        PrintWriter writer = new PrintWriter(swConstructor);
        StringWriter swBody = new StringWriter();
        PrintWriter bodyWriter = new PrintWriter(swBody);
        StringWriter swParams = new StringWriter();
        PrintWriter paramsWriter = new PrintWriter(swParams);
        CommandLine cmd = new CommandLine(tool);
        cmd.setOut(new PrintWriter(System.out));
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        String toolname = TauP_Tool.toolNameFromClass(tool.getClass());
        if (toolname.startsWith("taup ")) {
            toolname = toolname.substring(5);
        }
        PythonBindings.autoCodeGenComment(writer);
        List<String> timeResultTools = List.of("time", "pierce", "path");
        if (timeResultTools.contains(toolname)) {
            writer.println("from .dataclass import TimeResult");
            writer.println();
        } else if (toolname.equals("distaz")) {
            writer.println("from .dataclass import DistazResult");
            writer.println();
        } else if (toolname.equals("curve")) {
            writer.println("from .dataclass import CurveResult");
            writer.println();
        } else if (toolname.equals("wavefront")) {
            writer.println("from .dataclass import WavefrontResult");
            writer.println();
        }
        String capToolname = PythonBindings.capitalize(toolname);
        String IN = "    ";
        writer.println("class " + capToolname + "Query:");
        writer.println("  def __init__(self):");
        writer.println("    self.toolname= \"" + toolname + "\"");
        writer.println();
        paramsWriter.println();
        paramsWriter.println("  def create_params(self):");
        paramsWriter.println("    \"\"\"");
        paramsWriter.println("    Create dict of params suitible for passing to requests query call.");
        paramsWriter.println("    \"\"\"");
        paramsWriter.println("    params = {");
        paramsWriter.println("      \"format\": \"json\",");
        paramsWriter.println("    }");
        HashSet<String> knownSimpleTypes = new HashSet<String>();
        ArrayList<String> doneOptions = new ArrayList<String>();
        ArrayList<CommandLine.Model.OptionSpec> sortedOptions = new ArrayList<CommandLine.Model.OptionSpec>(spec.options());
        sortedOptions.sort(Comparator.comparing(CommandLine.Model.OptionSpec::longestName));
        for (CommandLine.Model.OptionSpec op : sortedOptions) {
            if (doneOptions.contains(op.longestName())) {
                System.err.println("Found duplicate op: " + String.valueOf(op));
                continue;
            }
            doneOptions.add(op.longestName());
            String name = PythonBindings.dashlessArgName(op.longestName());
            if (ignoreOptions.contains(name)) continue;
            String simpleType = PythonBindings.typeFromJavaType(op);
            knownSimpleTypes.add(simpleType);
            String defVal = "None";
            if (simpleType.equals("List")) {
                defVal = "[]";
            }
            writer.println(IN + "self._" + name + "=" + defVal);
            PythonBindings.createGetSet(bodyWriter, op);
            if (simpleType.equals("List")) {
                paramsWriter.println("    if len(self._" + name + ") > 0:");
            } else {
                paramsWriter.println("    if self._" + name + " is not None:");
            }
            paramsWriter.println("      params[\"" + name + "\"] = self._" + name);
        }
        if (timeResultTools.contains(toolname) || toolname.equals("distaz") || toolname.equals("curve") || toolname.equals("wavefront")) {
            writer.println();
            writer.println("  def calc(self, taupServer):");
            writer.println("    \"\"\"");
            writer.println("    Sends all params to the server, returns the result parsed from JSON into dataclasses.");
            writer.println("    \"\"\"");
            writer.println("    params = self.create_params()");
            if (timeResultTools.contains(toolname)) {
                writer.println("    return TimeResult.from_json(self.calcJson(taupServer))");
            } else if (toolname.equals("distaz")) {
                writer.println("    return DistazResult.from_json(self.calcJson(taupServer))");
            } else if (toolname.equals("curve")) {
                writer.println("    return CurveResult.from_json(self.calcJson(taupServer))");
            } else if (toolname.equals("wavefront")) {
                writer.println("    return WavefrontResult.from_json(self.calcJson(taupServer))");
            }
        }
        writer.println();
        writer.println("  def calcJson(self, taupServer):");
        writer.println("    \"\"\"");
        writer.println("    Sends all params to the server, returns the result parsed from JSON.");
        writer.println("    \"\"\"");
        writer.println("    params = self.create_params()");
        writer.println("    return taupServer.queryJson(params, self.toolname)");
        writer.println();
        ArrayList<String> doneFormats = new ArrayList<String>();
        for (String format : outputFormatOptions) {
            if (format.equals("json")) continue;
            for (CommandLine.Model.OptionSpec op : sortedOptions) {
                for (String opname : op.names()) {
                    if (!opname.equals("--" + format) || doneFormats.contains(format)) continue;
                    doneFormats.add(format);
                    System.err.println("Found format: " + format + " for " + op.longestName() + " name: " + opname);
                    writer.println();
                    writer.println("  def calc" + PythonBindings.capitalize(format) + "(self, taupServer):");
                    writer.println("    \"\"\"");
                    writer.println("    Sends all params to the server, returns the result as a text version of " + format + ".");
                    writer.println("    \"\"\"");
                    writer.println("    params = self.create_params()");
                    writer.println("    return taupServer.query" + PythonBindings.capitalize(format) + "(params, self.toolname)");
                    writer.println();
                }
            }
        }
        paramsWriter.println("    return params");
        paramsWriter.println();
        paramsWriter.close();
        writer.println();
        writer.close();
        bodyWriter.close();
        bodyWriter.println();
        System.err.println("Known Simple Types:");
        for (String s : knownSimpleTypes) {
            System.err.println(s);
        }
        return swConstructor.toString() + String.valueOf(swBody) + String.valueOf(swParams);
    }

    public static void autoCodeGenComment(PrintWriter writer) {
        writer.println();
        writer.println("# autogenerated from picocli command line arguments in TauP");
        writer.println("# For The TauP Toolkit, version: " + BuildVersion.getVersion());
        writer.println();
    }

    public static void createGetSet(PrintWriter bodyWriter, CommandLine.Model.OptionSpec op) {
        String varname = PythonBindings.dashlessArgName(op.longestName());
        String simpleType = PythonBindings.typeFromJavaType(op);
        for (String opname : op.names()) {
            opname = PythonBindings.dashlessArgName(opname);
            bodyWriter.println("  def get_" + opname + "(self):");
            bodyWriter.println("    \"\"\"");
            bodyWriter.println("    returns current value of " + varname + " as a " + simpleType);
            bodyWriter.println("    \"\"\"");
            bodyWriter.println("    return self._" + varname);
            bodyWriter.println();
            if (PythonBindings.specialSetter(bodyWriter, op, opname)) continue;
            bodyWriter.println("  def " + opname + "(self, val):");
            PythonBindings.desc(bodyWriter, op, opname);
            if (simpleType.equals("List")) {
                bodyWriter.println("    if not hasattr(val, \"__getitem__\"):");
                if (op.arity().max() == 1) {
                    bodyWriter.println("      val = [ val ]");
                } else {
                    bodyWriter.println("      raise Exception(f\"" + opname + "() requires a list, not {val}\")");
                }
            }
            bodyWriter.println("    self._" + varname + " = val");
            bodyWriter.println("    return self");
            bodyWriter.println();
            if (!simpleType.equals("List")) continue;
            bodyWriter.println();
            bodyWriter.println("  def and" + PythonBindings.capitalize(opname) + "(self, val):");
            PythonBindings.desc(bodyWriter, op, opname, true);
            bodyWriter.println("    self._" + varname + ".append(val)");
            bodyWriter.println("    return self");
            bodyWriter.println();
        }
    }

    public static void desc(PrintWriter bodyWriter, CommandLine.Model.OptionSpec op, String opname) {
        PythonBindings.desc(bodyWriter, op, opname, false);
    }

    public static void desc(PrintWriter bodyWriter, CommandLine.Model.OptionSpec op, String opname, boolean isAppend) {
        String varname = PythonBindings.dashlessArgName(op.longestName());
        String simpleType = PythonBindings.typeFromJavaType(op);
        bodyWriter.println("    \"\"\"");
        if (isAppend) {
            bodyWriter.print("    Append a value to the " + varname + " parameter, ");
        } else {
            bodyWriter.print("    Sets the " + varname + " parameter, ");
        }
        if (op.typeInfo().isEnum()) {
            List<String> enums = op.typeInfo().getEnumConstantNames();
            bodyWriter.println("a choice of one of:");
            bodyWriter.print("     " + String.join((CharSequence)", ", enums));
        } else if (isAppend) {
            bodyWriter.print(" of type " + PythonBindings.subtypeFromJavaType(op));
        } else {
            bodyWriter.print("of type " + simpleType);
        }
        if (!op.typeInfo().getActualGenericTypeArguments().isEmpty() && !isAppend) {
            bodyWriter.print(" of " + PythonBindings.subtypeFromJavaType(op));
        }
        bodyWriter.println();
        if (simpleType.equals("List") && !isAppend) {
            if (op.arity().max() == 1) {
                bodyWriter.println("    If a single " + PythonBindings.subtypeFromJavaType(op) + " is passed in, it is automatically wrapped in a list. So");
                bodyWriter.println("    params." + opname + "( value )");
                bodyWriter.println("    and");
                bodyWriter.println("    params." + opname + "( [ value ] )");
                bodyWriter.println("    are equivalent.");
            } else if (varname.endsWith("range") && op.arity().max() == 3) {
                bodyWriter.println("    step or min,max or min,max,step");
            }
        }
        bodyWriter.println();
        for (String descStr : op.description()) {
            bodyWriter.println("    " + descStr.trim());
        }
        bodyWriter.println();
        for (String n : op.names()) {
            if (!opname.equals(PythonBindings.dashlessArgName(n))) continue;
            bodyWriter.println("    Known as ``" + n + "`` in command line.");
        }
        if (!opname.equals(varname)) {
            bodyWriter.println("    Also known as ``" + op.longestName() + "`` in command line.");
        }
        bodyWriter.println();
        bodyWriter.println("    :param val: value to set " + varname + " to");
        bodyWriter.println("    \"\"\"");
    }

    public static boolean specialSetter(PrintWriter bodyWriter, CommandLine.Model.OptionSpec op, String opname) {
        String varname = PythonBindings.dashlessArgName(op.longestName());
        if (varname.equals("scatter")) {
            bodyWriter.println("  def " + opname + "(self, depth, degree):");
            PythonBindings.desc(bodyWriter, op, opname);
            bodyWriter.println("    self._" + varname + " = [depth, degree]");
            bodyWriter.println("    return self");
            bodyWriter.println();
            return true;
        }
        if (varname.equals("station") || varname.equals("event")) {
            bodyWriter.println("  def " + opname + "(self, lat, lon):");
            PythonBindings.desc(bodyWriter, op, opname);
            bodyWriter.println("    self._" + varname + " = [lat, lon]");
            bodyWriter.println("    return self");
            bodyWriter.println();
            bodyWriter.println("  def and" + PythonBindings.capitalize(opname) + "(self, lat, lon):");
            PythonBindings.desc(bodyWriter, op, opname);
            bodyWriter.println("    self._" + varname + " += [lat, lon]");
            bodyWriter.println("    return self");
            bodyWriter.println();
            return true;
        }
        return false;
    }

    public static String subtypeFromJavaType(CommandLine.Model.OptionSpec op) {
        String subtype = "";
        if (!op.typeInfo().getActualGenericTypeArguments().isEmpty()) {
            subtype = PythonBindings.typeFromJavaType(op.typeInfo().getActualGenericTypeArguments().get(0));
        }
        return subtype;
    }

    public static String typeFromJavaType(CommandLine.Model.OptionSpec op) {
        String type = op.typeInfo().getClassName();
        return PythonBindings.typeFromJavaType(type);
    }

    public static String typeFromJavaType(String type) {
        switch (type) {
            case "java.lang.String": {
                return "String";
            }
            case "java.util.List": {
                return "List";
            }
            case "java.lang.Float": 
            case "float": {
                return "Float";
            }
            case "java.lang.Double": 
            case "double": {
                return "Double";
            }
            case "java.lang.Integer": 
            case "int": {
                return "Integer";
            }
            case "boolean": {
                return "Boolean";
            }
        }
        return type;
    }

    public static String dashlessArgName(String argName) {
        if (argName.startsWith("--")) {
            argName = argName.substring(2);
        } else if (argName.startsWith("-")) {
            argName = argName.substring(1);
        }
        return argName;
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static List<String> knownTools() {
        CommandLine cmd = new CommandLine(new ToolRun());
        cmd.setOut(new PrintWriter(System.out));
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        ArrayList<String> out = new ArrayList<String>();
        for (String subcmd : spec.subcommands().keySet()) {
            if (ignoreCommands.contains(subcmd)) continue;
            out.add(subcmd);
        }
        return out;
    }

    public static void main(String[] args) {
        try {
            String capToolname;
            File dir = new File(".");
            for (String toolname : PythonBindings.knownTools()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(new File(dir, toolname + ".py")));
                out.write(PythonBindings.createPython(ToolRun.getToolForName(toolname)));
                out.close();
            }
            File taupversionFile = new File(dir, "taupversion.py");
            PrintWriter taupversion = new PrintWriter(new BufferedWriter(new FileWriter(taupversionFile)));
            taupversion.println();
            taupversion.println("# Version of TauP the python code corresponds to. ");
            taupversion.println("# Use with other versions may not work.");
            taupversion.println("TAUP_VERSION = \"" + BuildVersion.getVersion() + "\"");
            taupversion.println();
            taupversion.println("TAUP_DOWNLOAD = \"https://doi.org/10.5281/zenodo.15426279\"");
            taupversion.println();
            taupversion.close();
            File initFile = new File(dir, "__init__.py");
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(initFile)));
            out.println("__version__ = \"0.1.0\"");
            out.println();
            out.println("from .taupversion import TAUP_VERSION");
            out.println("from .http_server import TauPServer");
            for (String toolname : PythonBindings.knownTools()) {
                capToolname = toolname.substring(0, 1).toUpperCase() + toolname.substring(1);
                out.println("from ." + toolname + " import " + capToolname + "Query");
            }
            out.println("from .dataclass import (");
            out.println("    Amplitude, Arrival, Curve, CurveSegment, Daz, Fault, Isochron,");
            out.println("    PathSegment, RelativeArrival, Scatter, Source, TimeDist, TimeResult,");
            out.println("    Wavefront, WavefrontResult");
            out.println(")");
            out.println();
            out.println("__all__ = [");
            out.println("    \"TAUP_VERSION\",");
            out.println("    \"TauPServer\",");
            for (String toolname : PythonBindings.knownTools()) {
                capToolname = toolname.substring(0, 1).toUpperCase() + toolname.substring(1);
                out.println("    \"" + capToolname + "Query\",");
            }
            out.println("    \"Amplitude\",");
            out.println("    \"Arrival\",");
            out.println("    \"Curve\",");
            out.println("    \"CurveSegment\",");
            out.println("    \"Daz\",");
            out.println("    \"Fault\",");
            out.println("    \"Isochron\",");
            out.println("    \"PathSegment\",");
            out.println("    \"RelativeArrival\",");
            out.println("    \"Scatter\",");
            out.println("    \"Source\",");
            out.println("    \"TimeDist\",");
            out.println("    \"TimeResult\",");
            out.println("    \"Wavefront\",");
            out.println("    \"WavefrontResult\"");
            out.println("]");
            out.close();
            PythonBindings.knownTools();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ignoreOptions.addAll(outputFormatOptions);
        ignoreCommands = List.of("help", "web", "generate-completion", "setsac", "setms3", "create", "spikes");
    }
}

