/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SphericalCoordinate;

public class Vector {
    double x;
    double y;
    double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SphericalCoordinate toSpherical() {
        double r = this.magnitude();
        double phi = Math.acos(this.z / r);
        double theta = Math.atan2(this.y, this.x);
        return new SphericalCoordinate(phi, theta, r);
    }

    public Vector plus(Vector b) {
        return new Vector(this.x + b.x, this.y + b.y, this.z + b.z);
    }

    public Vector minus(Vector b) {
        return new Vector(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector normalize() {
        double mag = this.magnitude();
        return new Vector(this.x / mag, this.y / mag, this.z / mag);
    }

    public Vector negate() {
        return new Vector(-1.0 * this.x, -1.0 * this.y, -1.0 * this.z);
    }

    public static double dotProduct(Vector a, Vector b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static Vector crossProduct(Vector a, Vector b) {
        return new Vector(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

