/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.PhaseParseException;
import java.io.Serializable;
import java.util.ArrayList;

public class PhaseName
implements Serializable {
    public String name;
    public int sacTNum = -1;
    public ArrayList<Integer> sacTNumTriplication = new ArrayList();

    public static PhaseName parseName(String name) throws PhaseParseException {
        String[] phaseAndHeader = name.split("-");
        if (phaseAndHeader.length == 1) {
            return new PhaseName(phaseAndHeader[0]);
        }
        return new PhaseName(phaseAndHeader[0], phaseAndHeader[1]);
    }

    PhaseName(String name) throws PhaseParseException {
        this.name = name;
        LegPuller.legPuller(name);
    }

    public PhaseName(String name, int sacTNum) throws PhaseParseException {
        this(name);
        this.sacTNum = sacTNum;
        this.sacTNumTriplication.add(sacTNum);
    }

    public PhaseName(String name, String sacTNumList) throws PhaseParseException {
        this(name);
        this.parseSacTNums(sacTNumList);
    }

    void parseSacTNums(String sacTNumList) throws PhaseParseException {
        for (int j = 0; j < sacTNumList.length(); ++j) {
            int intForChar;
            char c = sacTNumList.charAt(j);
            if (Character.isDigit(c)) {
                intForChar = Integer.parseInt("" + c);
            } else if (c == 'a') {
                intForChar = 10;
            } else if (c == 'x') {
                intForChar = 11;
            } else {
                throw new PhaseParseException("Problem with phase=" + this.name + ", unknown SAC header TNum: " + c, this.name, j);
            }
            if (this.sacTNumTriplication.contains(intForChar)) {
                throw new PhaseParseException("SAC TNum is duplicated for phase " + this.name + ", in " + sacTNumList, this.name, j);
            }
            this.sacTNumTriplication.add(intForChar);
        }
        if (!this.sacTNumTriplication.isEmpty()) {
            this.sacTNum = this.sacTNumTriplication.get(0);
        }
    }

    public boolean equals(PhaseName obj) {
        return obj.name.equals(this.name) && obj.sacTNum == this.sacTNum;
    }

    public String getName() {
        return this.name;
    }

    public int sacTNumForTriplication(int index) {
        return this.sacTNumTriplication.get(index);
    }

    public String toString() {
        return this.name;
    }
}

