/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.RadiationAmplitude;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;

public class ArrivalAmplitude {
    public static final float DEFAULT_ATTENUATION_FREQUENCY = 1.0f;
    public static final float DEFAULT_MW = 4.0f;
    public static final String DEFAULT_MW_STR = "4.0";
    public static final int DEFAULT_NUM_FREQUENCIES = 64;
    float factorpsv;
    float factorsh;
    float geospread;
    float attenuation;
    float freeFactor;
    float[] radiationPattern;
    float radiationTerm;
    float mgtokg;
    float refltranpsv;
    float refltransh;
    SeismicSource source;

    public ArrivalAmplitude(Arrival arr) throws TauModelException, SlownessModelException {
        this.geospread = (float)arr.getAmplitudeGeometricSpreadingFactor();
        this.source = arr.getRayCalculateable().seismicSource;
        this.factorpsv = (float)arr.getAmplitudeFactorPSV();
        this.factorsh = (float)arr.getAmplitudeFactorSH();
        this.attenuation = (float)arr.calcAttenuation();
        this.freeFactor = (float)arr.calcFreeFactor();
        this.radiationPattern = new float[3];
        RadiationAmplitude drp = arr.calcRadiationPattern();
        this.radiationPattern[0] = (float)drp.getRadialAmplitude();
        this.radiationPattern[1] = (float)drp.getPhiAmplitude();
        this.radiationPattern[2] = (float)drp.getThetaAmplitude();
        this.radiationTerm = (float)arr.calcRadiationTerm();
        this.mgtokg = 0.001f;
        this.refltranpsv = (float)arr.getEnergyFluxFactorReflTransPSV();
        this.refltransh = (float)arr.getEnergyFluxFactorReflTransSH();
    }
}

