/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.BeachballResult;
import edu.sc.seis.TauP.BeachballType;
import edu.sc.seis.TauP.FaultPlane;
import edu.sc.seis.TauP.FibonacciSphere;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RadiationAmplitude;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalCoordinate;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.Vector;
import edu.sc.seis.TauP.cmdline.TauP_AbstractRayTool;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.TauP.gson.ScatteredArrivalSerializer;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.FocalMechanism;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="beachball", description={"Plot beachball for focal mechanism."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Beachball
extends TauP_AbstractRayTool {
    @CommandLine.Mixin
    GraphicOutputTypeArgs outputTypeArgs;
    @CommandLine.Mixin
    ColoringArgs coloring = new ColoringArgs();
    @CommandLine.Mixin
    SeismicSourceArgs sourceArgs = new SeismicSourceArgs();
    BeachballType beachballType = BeachballType.ampp;
    int numPoints = 2000;
    @CommandLine.Option(names={"--colorphases"}, description={"Color takeoff range for phases."}, defaultValue="false")
    public boolean colorPhases = false;

    public TauP_Beachball() {
        super(new GraphicOutputTypeArgs("text", "taup_beachball"));
        this.outputTypeArgs = (GraphicOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    public TauP_Beachball(String modelName) {
        this();
        this.modelArgs.setModelName(modelName);
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void start() throws IOException, TauPException {
        PrintWriter writer;
        List<RayCalculateable> distanceValues = this.getDistanceArgs().getRayCalculatables(this.sourceArgs);
        HashSet<FaultPlane> uniqFaultPlaneList = new HashSet<FaultPlane>();
        if (this.sourceArgs.hasStrikeDipRake()) {
            uniqFaultPlaneList.add(this.sourceArgs.getFaultPlane());
        } else {
            for (RayCalculateable ray : distanceValues) {
                if (ray.hasFaultPlane()) continue;
                Alert.warning("Missing fault plane for ray: " + String.valueOf(ray));
            }
        }
        for (RayCalculateable ray : distanceValues) {
            FocalMechanism fm;
            Event event;
            Object ll;
            if (ray.hasSeismicSource() && ray.getSeismicSource().hasNodalPlane()) {
                uniqFaultPlaneList.add(ray.getSeismicSource().getNodalPlane1());
                continue;
            }
            if (!ray.hasSource() || !((ll = ray.getSource()) instanceof Event) || (event = (Event)ll).getFocalMechanismList().isEmpty() || (fm = (FocalMechanism)event.getFocalMechanismList().get(0)).getNodalPlane().length <= 0) continue;
            FaultPlane fp = new FaultPlane(fm.getNodalPlane()[0]);
            uniqFaultPlaneList.add(fp);
            SeismicSource es = new SeismicSource(event.getPreferredMagnitude().getMag().getValue().floatValue(), fp);
            ray.setSeismicSource(es);
        }
        if (this.getOutputFormat().equals("html")) {
            writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            StringBuilder extraCSS = new StringBuilder();
            extraCSS.append("div.beachball svg {\n");
            extraCSS.append("  height: 500px;\n");
            extraCSS.append("}\n");
            extraCSS.append(HTMLUtil.createTableCSS());
            HTMLUtil.createHtmlStart(writer, "TauP Beachball", extraCSS, false);
            writer.println("<li>");
            for (RayCalculateable ray : distanceValues) {
                if (ray.hasFaultPlane()) continue;
                writer.println("<li>Missing fault plane for ray: " + String.valueOf(ray) + "</li>");
            }
            writer.println("</li>");
            for (FaultPlane faultPlane : uniqFaultPlaneList) {
                ArrayList distanceValuesPerSource = new ArrayList();
                for (RayCalculateable ray : distanceValues) {
                    if (!ray.getFaultPlane().equals(faultPlane)) continue;
                    distanceValuesPerSource.add(ray);
                }
                List<Object> arrivalList = new ArrayList();
                if (!this.phaseArgs.isEmpty()) {
                    arrivalList = this.calcAll(this.getSeismicPhases(), distanceValuesPerSource);
                }
                String modelLine = String.join((CharSequence)"", TauP_Time.createModelHeaderLine(this.getTauModelName(), this.getScatterer()));
                writer.println("<h5>" + modelLine + " " + String.valueOf(faultPlane) + "</h5>");
                Vector p = faultPlane.pAxis();
                SphericalCoordinate coordP = p.toSpherical();
                writer.println("<h5>P: takeoff: " + Outputs.formatLatLon(coordP.getTakeoffAngleDegree()) + " az: " + Outputs.formatLatLon(coordP.getAzimuthDegree()) + "</h5>");
                Vector t = faultPlane.tAxis();
                SphericalCoordinate coordT = t.toSpherical();
                writer.println("<h5>T: takeoff: " + Outputs.formatLatLon(coordT.getTakeoffAngleDegree()) + " az: " + Outputs.formatLatLon(coordT.getAzimuthDegree()) + "</h5>");
                Vector n = faultPlane.nullAxis();
                SphericalCoordinate coordN = n.toSpherical();
                writer.println("<h5>N: takeoff: " + Outputs.formatLatLon(coordN.getTakeoffAngleDegree()) + " az: " + Outputs.formatLatLon(coordN.getAzimuthDegree()) + "</h5>");
                if (!arrivalList.isEmpty()) {
                    TauP_Time.printArrivalsAsHtmlTable(writer, arrivalList, this.getTauModelName(), this.getScatterer(), false, this.sourceArgs, new ArrayList<String>(), "beachball", false);
                }
                for (BeachballType bb : List.of(BeachballType.ampp, BeachballType.amps, BeachballType.ampsv, BeachballType.ampsh)) {
                    writer.println("<div class=\"beachball\">");
                    writer.println("  <h5>Amplitude: " + String.valueOf((Object)bb) + "</h5>");
                    this.printResultSVG(writer, faultPlane, arrivalList, bb);
                    writer.println("</div>");
                }
            }
            HTMLUtil.addSortTableJS(writer);
            writer.println(HTMLUtil.createHtmlEnding());
            writer.close();
        } else if (this.getOutputFormat().equals("json")) {
            writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            for (FaultPlane faultPlane : uniqFaultPlaneList) {
                ArrayList<RayCalculateable> distanceValuesPerSource = new ArrayList<RayCalculateable>();
                for (RayCalculateable ray : distanceValues) {
                    if (!ray.getFaultPlane().equals(faultPlane)) continue;
                    distanceValuesPerSource.add(ray);
                }
                List<Arrival> arrivalList = this.calcAll(this.getSeismicPhases(), distanceValuesPerSource);
                this.printResultJson(writer, faultPlane, arrivalList);
            }
        } else {
            throw new TauPException("Ooops, only --html works now");
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        this.sourceArgs.validateArguments();
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> shootables) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            for (RayCalculateable shoot : shootables) {
                if (!TauP_Time.isRayOkForPhase(shoot, phase)) continue;
                arrivals.addAll(shoot.calculate(phase));
            }
        }
        Arrival.sortArrivals(arrivals);
        return arrivals;
    }

    public List<RadiationAmplitude> calcRadiationPattern(FaultPlane faultPlane, int num_pts) {
        ArrayList<RadiationAmplitude> result = new ArrayList<RadiationAmplitude>(num_pts);
        List<SphericalCoordinate> fibPoints = FibonacciSphere.calc(num_pts);
        for (SphericalCoordinate coord : fibPoints) {
            RadiationAmplitude radiationPattern = new RadiationAmplitude();
            if (this.sourceArgs != null) {
                radiationPattern = faultPlane.calcRadiationPatDegree(coord.getAzimuthDegree(), coord.getTakeoffAngleDegree());
            }
            result.add(radiationPattern);
        }
        return result;
    }

    @Override
    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws IOException, TauPException {
        throw new TauPException("Oops, need source args per arrival");
    }

    public void printResult(PrintWriter out, List<Arrival> arrivalList, FaultPlane faultPlane) throws IOException, TauPException {
        if (this.getOutputFormat().equals("json")) {
            throw new TauPException("JSON output not yet implemented");
        }
        if (this.getOutputFormat().equals("svg")) {
            this.printResultSVG(out, faultPlane, arrivalList, this.beachballType);
        } else if (this.getOutputFormat().equals("html")) {
            this.printResultHtml(out, faultPlane, arrivalList);
        } else {
            throw new TauPException("Text/GMT output not yet implemented");
        }
    }

    public void printResultSVG(PrintWriter writer, FaultPlane faultPlane, List<Arrival> arrivalList, BeachballType bbType) throws TauPException {
        if (faultPlane == null) {
            for (Arrival arrival : arrivalList) {
                if (!arrival.getRayCalculateable().hasFaultPlane()) continue;
                faultPlane = arrival.getRayCalculateable().getFaultPlane();
                break;
            }
        }
        float pixelWidth = this.outputTypeArgs.getPixelWidth();
        int plotOffset = 0;
        StringBuilder extraCSS = TauP_Beachball.getBeachballExtraCSS();
        StringBuilder extraDefs = new StringBuilder();
        extraDefs.append("<marker\n");
        extraDefs.append("      id=\"arrow\"\n");
        extraDefs.append("      viewBox=\"0 0 10 10\"\n");
        extraDefs.append("      refX=\"5\"\n");
        extraDefs.append("      refY=\"5\"\n");
        extraDefs.append("      markerWidth=\"3\"\n");
        extraDefs.append("      markerHeight=\"3\"\n");
        extraDefs.append("      orient=\"auto-start-reverse\">\n");
        extraDefs.append("      <path d=\"M 0 0 L 10 5 L 0 10 z\" />\n");
        extraDefs.append("    </marker>");
        SvgUtil.xyplotScriptBeginning(writer, TauP_Beachball.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), pixelWidth, plotOffset, this.coloring.getColorList(), extraCSS, null, extraDefs);
        float scale = pixelWidth / 2.0f;
        float hpw = pixelWidth / 2.0f;
        writer.println("<g transform=\"scale(1,-1) translate(" + pixelWidth / 2.0f + ", -" + pixelWidth / 2.0f + ")\" >  <!-- flip scale -->");
        if (!this.phaseArgs.isEmpty() && this.colorPhases) {
            this.drawPhasesSVG(writer, scale, this.getSeismicPhases(), bbType);
        }
        writer.println("<g class=\"axis\">");
        writer.println("<line x1=\"0\" y1=\"" + -1.0f * hpw + "\" x2=\"0\" y2=\"" + hpw + "\" />");
        writer.println("<line x1=\"" + -1.0f * hpw + "\" y1=\"0\" x2=\"" + hpw + "\" y2=\"0\" />");
        writer.println("<circle cx=\"0\" cy=\"0\" r=\"" + hpw + "\" />");
        writer.println("</g> <!-- end axis -->");
        this.drawFaultsSVG(writer, faultPlane, scale);
        this.drawRadiationPatternSVG(writer, faultPlane, scale, bbType);
        writer.println("</g> <!-- end flip scale -->");
        this.drawPTNAxes(writer, faultPlane, scale);
        this.drawArrivalsSVG(writer, scale, arrivalList);
        writer.println("</svg>");
    }

    private static StringBuilder getBeachballExtraCSS() {
        StringBuilder extraCSS = new StringBuilder();
        extraCSS.append("g.radpattern line {\n");
        extraCSS.append("  stroke: black;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.axis line {\n");
        extraCSS.append("  stroke: red;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.axis circle {\n");
        extraCSS.append("  stroke: red;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.fault polyline {\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.fault polyline.aux {\n");
        extraCSS.append("  stroke: seagreen;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.fault line {\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("circle.compress {\n");
        extraCSS.append("  fill: skyblue;\n");
        extraCSS.append("  stroke: skyblue;\n");
        extraCSS.append("}\n");
        extraCSS.append("circle.dilitate {\n");
        extraCSS.append("  fill: white;\n");
        extraCSS.append("  stroke: lightgrey;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.eigen circle.compress {\n");
        extraCSS.append("  fill: blue;\n");
        extraCSS.append("  stroke: blue;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.eigen text.compress {\n");
        extraCSS.append("  fill: blue;\n");
        extraCSS.append("  stroke: blue;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.eigen circle.dilitate {\n");
        extraCSS.append("  fill: green;\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.eigen text.dilitate {\n");
        extraCSS.append("  fill: green;\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.arrival circle.compress {\n");
        extraCSS.append("  fill: blue;\n");
        extraCSS.append("  stroke: blue;\n");
        extraCSS.append("}\n");
        extraCSS.append("g.arrival circle.dilitate {\n");
        extraCSS.append("  fill: green;\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("circle.phase.min {\n");
        extraCSS.append("  fill: white;\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        extraCSS.append("circle.phase.max {\n");
        extraCSS.append("  fill: papayawhip;\n");
        extraCSS.append("  fill-opacity: 0.5;\n");
        extraCSS.append("  stroke: green;\n");
        extraCSS.append("}\n");
        return extraCSS;
    }

    public void drawPhasesSVG(PrintWriter writer, float scale, List<SeismicPhase> phaseList, BeachballType bbType) {
        writer.println("<g class=\"phase\">");
        for (SeismicPhase phase : phaseList) {
            if (bbType.equals((Object)BeachballType.ampp) != phase.sourceSegmentIsPWave()) continue;
            ArrayList<Double> takeoffList = new ArrayList<Double>();
            takeoffList.add(phase.calcTakeoffAngleDegree(phase.getMaxRayParam()));
            takeoffList.add(phase.calcTakeoffAngleDegree(phase.getMinRayParam()));
            takeoffList.sort(Comparator.reverseOrder());
            String minmaxclass = "max";
            Iterator iterator = takeoffList.iterator();
            while (iterator.hasNext()) {
                double takeoff = (Double)iterator.next();
                SphericalCoordinate coord = SphericalCoordinate.fromAzTakeoffDegree(0.0, takeoff);
                double sterR = coord.stereoR();
                double x1 = scale * 0.0f;
                double y1 = scale * 0.0f;
                writer.println("<circle class=\"phase " + phase.getName() + " " + minmaxclass + "\" cx=\"" + x1 + "\" cy=\"" + y1 + "\" r=\"" + sterR * (double)scale + "\" />");
                minmaxclass = "min";
            }
        }
        writer.println("</g>");
    }

    public void drawArrivalsSVG(PrintWriter writer, float scale, List<Arrival> arrivalList) throws SlownessModelException, TauModelException {
        writer.println("<g class=\"arrival\">");
        for (Arrival arr : arrivalList) {
            if (!arr.getRayCalculateable().hasAzimuth()) continue;
            double takeoff = arr.getTakeoffAngleDegree();
            double az = arr.getRayCalculateable().getAzimuth();
            SphericalCoordinate coord = SphericalCoordinate.fromAzTakeoffDegree(az, takeoff);
            Vector v = coord.toCartesian();
            String compression = arr.getAmplitudeFactorPSV() > 0.0 ? "compress" : "dilitate";
            this.drawLabeledDot(writer, v, scale, arr.getName(), compression, arr.toString());
        }
        writer.println("</g>");
    }

    public void drawFaultsSVG(PrintWriter writer, FaultPlane faultPlane, float scale) {
        writer.println("<g class=\"fault\">");
        writer.print("<polyline class=\"fault\", points=\"");
        for (int i = 180; i < 360; ++i) {
            Vector fvec = faultPlane.faultVector(i);
            SphericalCoordinate co = fvec.toSpherical();
            double sterR = co.stereoR();
            double sterX = sterR * Math.cos(co.getTheta());
            double sterY = sterR * Math.sin(co.getTheta());
            double x = (double)scale * sterX;
            double y = (double)scale * sterY;
            writer.print(x + "," + y + " ");
        }
        writer.println("\" />");
        writer.print("<polyline class=\"fault aux\", points=\"");
        FaultPlane auxPlane = faultPlane.auxPlane();
        for (int i = 180; i < 360; ++i) {
            Vector fvec = auxPlane.faultVector(i);
            SphericalCoordinate co = fvec.toSpherical();
            double sterR = co.stereoR();
            double sterX = sterR * Math.cos(co.getTheta());
            double sterY = sterR * Math.sin(co.getTheta());
            double x = (double)scale * sterX;
            double y = (double)scale * sterY;
            writer.print(x + "," + y + " ");
        }
        writer.println("\" />");
        writer.println("</g>");
    }

    public void drawRadiationPatternSVG(PrintWriter writer, FaultPlane faultPlane, float scale, BeachballType bbType) {
        List<RadiationAmplitude> radPattern = this.calcRadiationPattern(faultPlane, this.numPoints);
        writer.println("<g class=\"radpattern\">");
        float ampScale = 0.1f;
        for (RadiationAmplitude radAmp : radPattern) {
            if (radAmp.getCoord().getTakeoffAngleDegree() > 90.0) continue;
            double sterR = radAmp.getCoord().stereoR();
            double sterX = sterR * Math.cos(radAmp.getCoord().getTheta());
            double sterY = sterR * Math.sin(radAmp.getCoord().getTheta());
            double ampX = 0.0;
            double ampY = 0.0;
            String compression = "";
            if (bbType.equals((Object)BeachballType.ampp)) {
                ampX = Math.cos(radAmp.getCoord().getTheta()) * radAmp.getRadialAmplitude() * (double)ampScale;
                ampY = Math.sin(radAmp.getCoord().getTheta()) * radAmp.getRadialAmplitude() * (double)ampScale;
                String string = compression = radAmp.getRadialAmplitude() > 0.0 ? "compress" : "dilitate";
            }
            if (bbType.equals((Object)BeachballType.ampsv) || bbType.equals((Object)BeachballType.amps)) {
                ampX += Math.cos(radAmp.getCoord().getTheta()) * radAmp.getPhiAmplitude() * (double)ampScale;
                ampY += Math.sin(radAmp.getCoord().getTheta()) * radAmp.getPhiAmplitude() * (double)ampScale;
                String string = compression = radAmp.getPhiAmplitude() > 0.0 ? "compress" : "dilitate";
            }
            if (bbType.equals((Object)BeachballType.ampsh) || bbType.equals((Object)BeachballType.amps)) {
                ampX += -Math.sin(radAmp.getCoord().getTheta()) * radAmp.getThetaAmplitude() * (double)ampScale;
                ampY += Math.cos(radAmp.getCoord().getTheta()) * radAmp.getThetaAmplitude() * (double)ampScale;
                String string = compression = radAmp.getThetaAmplitude() > 0.0 ? "compress" : "dilitate";
            }
            if (bbType.equals((Object)BeachballType.amps)) {
                compression = radAmp.getThetaAmplitude() * radAmp.getPhiAmplitude() > 0.0 ? "compress" : "dilitate";
            }
            double x1 = (double)scale * sterX;
            double y1 = (double)scale * sterY;
            double x2 = (double)scale * (sterX + ampX);
            double y2 = (double)scale * (sterY + ampY);
            writer.println("<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" marker-end=\"url(#arrow)\" />");
            writer.println("<circle class=\"" + compression + "\" cx=\"" + x1 + "\" cy=\"" + y1 + "\" r=\"2\" />");
        }
        writer.println("</g>");
    }

    public void drawPTNAxes(PrintWriter writer, FaultPlane faultPlane, float scale) {
        writer.println("<g class=\"eigen\">");
        this.drawLabeledDot(writer, faultPlane.pAxis(), scale, "P", "compress", "P Axis");
        this.drawLabeledDot(writer, faultPlane.tAxis(), scale, "T", "dilitate", "T Axis");
        this.drawLabeledDot(writer, faultPlane.nullAxis(), scale, "N", "", "Null Axis");
        writer.println("</g>");
    }

    public void drawLabeledDot(PrintWriter writer, Vector z, float scale, String label, String cssclass, String tooltip) {
        SphericalCoordinate coordZ = z.toSpherical();
        if (coordZ.getTakeoffAngleDegree() > 90.0) {
            z = z.negate();
            coordZ = z.toSpherical();
        }
        double sterR = coordZ.stereoR();
        double sterX = sterR * Math.cos(coordZ.getTheta());
        double sterY = sterR * Math.sin(coordZ.getTheta());
        double x1 = (double)scale * (1.0 + sterX);
        double y1 = (double)scale * (1.0 - sterY);
        writer.println("<g>");
        if (tooltip != null && tooltip.length() > 0) {
            writer.println("<title>" + tooltip + "</title>");
        }
        writer.println("<circle class=\"arrival " + cssclass + "\" cx=\"" + x1 + "\" cy=\"" + y1 + "\" r=\"2\" />");
        writer.println("<text class=\"arrival " + cssclass + "\" x=\"" + x1 + "\" y=\"" + y1 + "\" >" + label + "</text>");
        writer.println("</g>");
    }

    public void printResultHtml(PrintWriter writer, FaultPlane faultPlane, List<Arrival> arrivalList) throws TauPException {
        HTMLUtil.createHtmlStart(writer, "TauP Beachball", "", false);
        String modelLine = String.join((CharSequence)"", TauP_Time.createModelHeaderLine(this.getTauModelName(), this.getScatterer()));
        writer.println("<h5>" + modelLine + "</h5>");
        for (BeachballType bb : List.of(BeachballType.ampp, BeachballType.ampsv, BeachballType.ampsh)) {
            this.printResultSVG(writer, faultPlane, arrivalList, bb);
        }
        writer.println(HTMLUtil.createHtmlEnding());
    }

    public void printResultJson(PrintWriter writer, FaultPlane faultPlane, List<Arrival> arrivalList) throws TauPException {
        boolean withPierce = false;
        boolean withPath = false;
        boolean withAmp = true;
        boolean withDerivative = false;
        List<RadiationAmplitude> radPattern = this.calcRadiationPattern(faultPlane, this.numPoints);
        SeismicSource seismicSource = new SeismicSource(4.0f, faultPlane);
        BeachballResult bbResult = new BeachballResult(this.modelArgs.getModelName(), this.modelArgs.getSourceDepths(), this.modelArgs.getReceiverDepths(), this.getPhaseArgs().parsePhaseNameList(), this.getScatterer(), withAmp, seismicSource, arrivalList, radPattern);
        GsonBuilder gsonBuilder = GsonUtil.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(withPierce, withPath, withAmp, withDerivative));
        gsonBuilder.registerTypeAdapter(ScatteredArrival.class, (Object)new ScatteredArrivalSerializer(withPierce, withPath, withAmp, withDerivative));
        writer.println(gsonBuilder.create().toJson((Object)bbResult));
    }

    public BeachballType getBeachballType() {
        return this.beachballType;
    }

    @CommandLine.Option(names={"-b", "--bbtype"}, paramLabel="type", description={"Beachball data type, default is ${DEFAULT-VALUE}, one of ${COMPLETION-CANDIDATES}"}, defaultValue="ampp")
    public void setBeachballType(BeachballType beachballType) {
        this.beachballType = beachballType;
    }
}

