/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Blockette1001;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import edu.sc.seis.seisFile.mseed3.MSeed3EH;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import edu.sc.seis.seisFile.mseed3.ehbag.Marker;
import edu.sc.seis.seisFile.mseed3.ehbag.Path;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.json.JSONObject;

public class MSeed3Convert {
    public static SacTimeSeries convert3ToSac(MSeed3Record ms3) throws SeedFormatException, CodecException {
        MSeed3EH eh = new MSeed3EH(ms3.getExtraHeaders());
        JSONObject bag = eh.getBagEH();
        SacHeader header = new SacHeader();
        header.setSourceId(ms3.getSourceId());
        header.setIftype(1);
        if (eh.gcarc() != null) {
            header.setGcarc(eh.gcarc().floatValue());
        }
        if (bag.has("path")) {
            JSONObject path = bag.getJSONObject("path");
            if (path.has("az")) {
                header.setAz(path.getFloat("az"));
            }
            if (path.has("baz")) {
                header.setBaz(path.getFloat("baz"));
            }
        }
        Instant refTime = ms3.getStartInstant();
        if (eh.quakeTime() != null) {
            Duration duration = Duration.between(refTime, eh.quakeTime());
            float timeDiff = (float)duration.toNanos() / 1.0E9f;
            header.setO(timeDiff);
        }
        header.setNzTime(refTime);
        if (eh.quakeLocation() != null) {
            Location quakeLoc = eh.quakeLocation();
            header.setEvla((float)quakeLoc.getLatitude());
            header.setEvlo((float)quakeLoc.getLongitude());
            if (quakeLoc.hasDepth()) {
                header.setEvdp(quakeLoc.getDepthMeter().floatValue());
            }
        }
        if (bag.has("ch")) {
            JSONObject chanObj = eh.getBagEH().getJSONObject("ch");
            if (chanObj.has("la") && chanObj.has("lo")) {
                Location chanLoc = eh.channelLocation();
                header.setStla((float)chanLoc.getLatitude());
                header.setStlo((float)chanLoc.getLongitude());
                if (chanLoc.hasDepth()) {
                    header.setStdp(chanLoc.getDepthMeter().floatValue());
                }
            }
            if (chanObj.has("az")) {
                header.setCmpaz(chanObj.getFloat("az"));
            }
            if (chanObj.has("dip")) {
                header.setCmpinc(90.0f - chanObj.getFloat("dip"));
            }
        }
        int markNum = 0;
        for (Marker m : eh.getMarkers()) {
            Duration duration = Duration.between(refTime, m.getTime());
            float timeDiff = (float)duration.toNanos() / 1.0E9f;
            if (m.getName().equals("origin")) continue;
            if (m.getName().equals("A")) {
                header.setA(timeDiff);
                header.setKa(m.getName());
                continue;
            }
            if (markNum > 9) continue;
            header.setTHeader(markNum, timeDiff, m.getName());
            ++markNum;
        }
        float[] yData = ms3.decompress().getAsFloat();
        if (eh.getTimeseriesUnit() != null) {
            float factor = 1.0f;
            if (eh.getTimeseriesUnit().equals("V")) {
                factor = 1.0f;
                header.setIdep(50);
            } else if (eh.getTimeseriesUnit().equals("m")) {
                factor = 1.0E9f;
                header.setIdep(6);
            } else if (eh.getTimeseriesUnit().equals("mm")) {
                factor = 1000000.0f;
                header.setIdep(6);
            } else if (eh.getTimeseriesUnit().equals("\u00b5m")) {
                factor = 1000.0f;
                header.setIdep(6);
            } else if (eh.getTimeseriesUnit().equals("nm")) {
                factor = 1.0f;
                header.setIdep(6);
            } else if (eh.getTimeseriesUnit().equals("m/s")) {
                factor = 1.0E9f;
                header.setIdep(7);
            } else if (eh.getTimeseriesUnit().equals("mm/s")) {
                factor = 1000000.0f;
                header.setIdep(7);
            } else if (eh.getTimeseriesUnit().equals("\u00b5m/s")) {
                factor = 1000.0f;
                header.setIdep(7);
            } else if (eh.getTimeseriesUnit().equals("nm/s")) {
                factor = 1.0f;
                header.setIdep(7);
            } else if (eh.getTimeseriesUnit().equals("m/s**2")) {
                factor = 1.0E9f;
                header.setIdep(8);
            } else if (eh.getTimeseriesUnit().equals("mm/s**2")) {
                factor = 1000000.0f;
                header.setIdep(8);
            } else if (eh.getTimeseriesUnit().equals("\u00b5m/s**2")) {
                factor = 1000.0f;
                header.setIdep(8);
            } else if (eh.getTimeseriesUnit().equals("nm/s**2")) {
                factor = 1.0f;
                header.setIdep(8);
            } else {
                factor = 1.0f;
                header.setIdep(-12345);
            }
            for (int i = 0; i < yData.length; ++i) {
                yData[i] = yData[i] * factor;
            }
        }
        SacTimeSeries sac = new SacTimeSeries(header, yData);
        return sac;
    }

    public static MSeed3Record convertSacTo3(SacTimeSeries sac) throws SeedFormatException, FDSNSourceIdException {
        ZonedDateTime mTime;
        MSeed3Record ms3 = new MSeed3Record();
        SacHeader sacHeader = sac.getHeader();
        ms3.year = sacHeader.getNzyear();
        ms3.dayOfYear = sacHeader.getNzjday();
        ms3.hour = sacHeader.getNzhour();
        ms3.minute = sacHeader.getNzmin();
        ms3.second = sacHeader.getNzsec();
        ms3.nanosecond = sacHeader.getNzmsec() * 1000000;
        Instant start = ms3.getStartInstant();
        ms3.setSourceId(sac.getSourceId());
        ms3.setStartDateTime(start.plusMillis(Math.round(sacHeader.getB() * 1000.0f)));
        if (sacHeader.getIftype() != 1) {
            throw new SeedFormatException("Sac file is not ITIME: " + sacHeader.getIftype());
        }
        ms3.setTimeseries(sac.getY());
        MSeed3EH ms3eh = new MSeed3EH();
        Path path = new Path(MSeed3Convert.checkUndef(Float.valueOf(sacHeader.getGcarc())), MSeed3Convert.checkUndef(Float.valueOf(sacHeader.getAz())), MSeed3Convert.checkUndef(Float.valueOf(sacHeader.getBaz())));
        if (path.notAllNull()) {
            ms3eh.addToBag(path);
        }
        if (!SacConstants.isUndef(sacHeader.getO())) {
            mTime = start.plusMillis(Math.round(sacHeader.getO() * 1000.0f)).atZone(ZoneId.of("UTC"));
            Marker mark = new Marker("origin", mTime, "md", "");
            ms3eh.addToBag(mark);
        }
        if (!SacConstants.isUndef(sacHeader.getA())) {
            mTime = start.plusMillis(Math.round(sacHeader.getA() * 1000.0f)).atZone(ZoneId.of("UTC"));
            String desc = sacHeader.getKa();
            desc = SacConstants.isUndef(desc) ? "" : desc;
            Marker mark = new Marker("A", mTime, "", desc);
            ms3eh.addToBag(mark);
        }
        for (int i = 0; i < 9; ++i) {
            if (SacConstants.isUndef(sacHeader.getTHeader(i))) continue;
            ZonedDateTime mTime2 = start.plusMillis(Math.round(sacHeader.getTHeader(i) * 1000.0f)).atZone(ZoneId.of("UTC"));
            Object mName = sacHeader.getKTHeader(i);
            mName = ((String)mName).equals("-12345  ") ? "" : ((String)mName).trim();
            String mDesc = "T" + i;
            if (((String)mName).isEmpty()) {
                mName = mDesc;
            }
            Marker mark = new Marker((String)mName, mTime2, "", mDesc);
            ms3eh.addToBag(mark);
        }
        if (!(SacConstants.isUndef(sacHeader.getEvla()) || SacConstants.isUndef(sacHeader.getEvlo()) || SacConstants.isUndef(sacHeader.getO()))) {
            float depth = sacHeader.getEvdp() != -12345.0f ? sacHeader.getEvdp() : 0.0f;
            Instant otime = start.plusMillis(Math.round(sacHeader.getO() * 1000.0f));
            ms3eh.addOriginToBag(sacHeader.getEvla(), sacHeader.getEvlo(), depth, otime);
            if (!SacConstants.isUndef(sacHeader.getKevnm())) {
                ms3eh.getBagEH().getJSONObject("ev").put("id", (Object)sacHeader.getKevnm());
            }
        }
        if (sacHeader.getMag() != -12345.0f) {
            ms3eh.addMagnitudeToBag(sacHeader.getMag(), sacHeader.getMagnitudeType());
        }
        if (sacHeader.getStla() != -12345.0f && sacHeader.getStlo() != -12345.0f) {
            Station sta = new Station();
            sta.setLatitude(sacHeader.getStla());
            sta.setLongitude(sacHeader.getStlo());
            Channel chan = new Channel(sta);
            if (sacHeader.getStel() != -12345.0f) {
                chan.setElevation(sacHeader.getStel());
            }
            if (sacHeader.getStdp() != -12345.0f) {
                chan.setDepth(sacHeader.getStdp());
            }
            if (sacHeader.getCmpaz() != -12345.0f) {
                chan.setAzimuth(sacHeader.getCmpaz());
            }
            if (sacHeader.getCmpinc() != -12345.0f) {
                chan.setDip(90.0f - sacHeader.getCmpinc());
            }
            ms3eh.addToBag(chan);
        }
        if (sacHeader.getIdep() != -12345) {
            switch (sacHeader.getIdep()) {
                case 6: {
                    ms3eh.setTimeseriesUnit("nm");
                    break;
                }
                case 7: {
                    ms3eh.setTimeseriesUnit("nm/s");
                    break;
                }
                case 8: {
                    ms3eh.setTimeseriesUnit("nm/s2");
                    break;
                }
                case 50: {
                    ms3eh.setTimeseriesUnit("V");
                }
            }
        }
        ms3.setExtraHeaders(ms3eh.getEH());
        return ms3;
    }

    public static Float checkUndef(Float sacVal) {
        if (sacVal.floatValue() != -12345.0f) {
            return sacVal;
        }
        return null;
    }

    public static MSeed3Record convert2to3(DataRecord dr) throws SeedFormatException, FDSNSourceIdException {
        MSeed3Record ms3Header = new MSeed3Record();
        DataHeader ms2H = dr.getHeader();
        ms3Header.flags = (byte)((ms2H.getActivityFlags() & 1) * 2 + (ms2H.getIOClockFlags() & 0x40) * 4 + (ms2H.getDataQualityFlags() & 0x10) * 8);
        ms3Header.setPublicationVersion((byte)0);
        ms3Header.year = ms2H.getStartBtime().year;
        ms3Header.dayOfYear = ms2H.getStartBtime().jday;
        ms3Header.hour = ms2H.getStartBtime().hour;
        ms3Header.minute = ms2H.getStartBtime().min;
        ms3Header.second = ms2H.getStartBtime().sec;
        ms3Header.nanosecond = ms2H.getStartBtime().tenthMilli * 100000;
        ms3Header.sampleRatePeriod = dr.getSampleRate() >= 1.0f ? (double)dr.getSampleRate() : -1.0 / (double)dr.getSampleRate();
        Blockette1000 b1000 = (Blockette1000)dr.getUniqueBlockette(1000);
        if (b1000 == null) {
            throw new MissingBlockette1000(dr.getHeader());
        }
        ms3Header.timeseriesEncodingFormat = b1000.getEncodingFormat();
        ms3Header.publicationVersion = 0;
        ms3Header.dataByteLength = dr.getData().length;
        ms3Header.setSourceId(FDSNSourceId.fromNSLC(dr.getHeader().getNetworkCode(), dr.getHeader().getStationIdentifier(), dr.getHeader().getLocationIdentifier(), dr.getHeader().getChannelIdentifier()));
        ms3Header.numSamples = ms2H.getNumSamples();
        ms3Header.recordCRC = 0;
        JSONObject ms3Extras = new JSONObject();
        JSONObject fdsnExtras = new JSONObject();
        if (ms2H.getTypeCode() != '\u0000' && ms2H.getTypeCode() != 'D') {
            fdsnExtras.put("DataQuality", (int)ms2H.getTypeCode());
        }
        int nanos = 0;
        Blockette[] blockettes = dr.getBlockettes(100);
        if (blockettes.length != 0) {
            Blockette100 b100 = (Blockette100)blockettes[0];
            ms3Header.setSampleRatePeriod(b100.getActualSampleRate());
        }
        if ((blockettes = dr.getBlockettes(1001)).length != 0) {
            Blockette1001 b1001 = (Blockette1001)blockettes[0];
            nanos = 1000 * b1001.getMicrosecond();
            ms3Extras.put("TQ", (int)b1001.getTimingQuality());
        }
        if (dr.getHeader().getStartBtime().sec == 60) {
            ms3Extras.put("TimeLeapSecond", 1);
        }
        ms3Header.setNanosecond(ms3Header.getNanosecond() + nanos);
        if (ms3Header.nanosecond < 0) {
            --ms3Header.second;
            ms3Header.nanosecond += 1000000000;
            if (ms3Header.second < 0) {
                ms3Header.second += 60;
                --ms3Header.minute;
                if (ms3Header.minute < 0) {
                    ms3Header.minute += 60;
                    --ms3Header.hour;
                    if (ms3Header.hour < 0) {
                        ms3Header.hour += 24;
                        ms3Header.dayOfYear = -1;
                        if (ms3Header.dayOfYear < 0) {
                            ms3Header.dayOfYear += 365;
                            --ms3Header.year;
                        }
                    }
                }
            }
        }
        ms3Header.setExtraHeaders(ms3Extras.toString());
        ms3Header.timeseriesBytes = dr.getData();
        return ms3Header;
    }
}

