/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed3;

import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FDSNStationSourceId {
    public static final String sourceIdRegExString = "FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})";
    public static final Pattern sourceIdRegEx = Pattern.compile("FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})");
    protected String networkCode;
    protected String stationCode;

    public FDSNStationSourceId(String networkCode, String stationCode) {
        this.networkCode = networkCode;
        this.stationCode = stationCode;
    }

    public static FDSNStationSourceId parse(String sourceIdUrl) throws FDSNSourceIdException {
        Matcher m = sourceIdRegEx.matcher(sourceIdUrl);
        if (m.matches()) {
            return new FDSNStationSourceId(m.group(1), m.group(2));
        }
        throw new FDSNSourceIdException("Parse error, does not match regular expression: " + sourceIdUrl + "  FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})");
    }

    public static FDSNStationSourceId createUnknown() throws FDSNSourceIdException {
        return new FDSNStationSourceId("XX", "ABC");
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String toString() {
        return "FDSN:" + this.networkCode + "_" + this.stationCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FDSNSourceId)) {
            return false;
        }
        FDSNSourceId that = (FDSNSourceId)o;
        return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.stationCode, that.stationCode);
    }

    public int hashCode() {
        return Objects.hash(this.networkCode, this.stationCode);
    }
}

