/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;

public class ControlHeader {
    protected int sequenceNum;
    protected byte typeCode;
    protected boolean continuationCode;

    public static ControlHeader read(DataInput in) throws IOException, SeedFormatException {
        boolean continuationCode;
        byte[] seqBytes = new byte[6];
        in.readFully(seqBytes);
        String seqNumString = new String(seqBytes);
        int sequenceNum = 0;
        if (!seqNumString.equals("      ")) {
            try {
                sequenceNum = Integer.valueOf(seqNumString);
            }
            catch (NumberFormatException e) {
                System.err.println("seq num unreadable, setting to 0 " + e.toString());
            }
        }
        byte typeCode = in.readByte();
        byte b = in.readByte();
        if (b == 32) {
            continuationCode = false;
        } else if (b == 42) {
            continuationCode = true;
        } else {
            throw new SeedFormatException("ControlHeader, expected space or *, but got " + b);
        }
        if (typeCode == 68 || typeCode == 82 || typeCode == 81 || typeCode == 77) {
            return DataHeader.read(in, sequenceNum, (char)typeCode, continuationCode);
        }
        return new ControlHeader(sequenceNum, typeCode, continuationCode);
    }

    protected void write(DataOutput dos) throws IOException {
        DecimalFormat sequenceNumFormat = new DecimalFormat("000000");
        String sequenceNumString = sequenceNumFormat.format(this.getSequenceNum());
        byte[] sequenceNumByteArray = null;
        try {
            sequenceNumByteArray = sequenceNumString.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int continuationCodeByte = this.continuationCode ? 42 : 32;
        try {
            dos.write(sequenceNumByteArray);
            dos.write(this.typeCode);
            dos.write(continuationCodeByte);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.writeASCII(out, "");
    }

    public void writeASCII(PrintWriter out, String indent) throws IOException {
        out.print(indent + "seq=" + this.getSequenceNum());
        out.print(" type=" + this.getTypeCode());
        out.println(" cont=" + this.isContinuation());
    }

    public ControlHeader(int sequenceNum, byte typeCode, boolean continuationCode) {
        this.sequenceNum = sequenceNum;
        this.typeCode = typeCode;
        this.continuationCode = continuationCode;
    }

    public ControlHeader(int sequenceNum, char typeCode, boolean continuationCode) {
        this(sequenceNum, (byte)typeCode, continuationCode);
    }

    public short getSize() {
        return 8;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public char getTypeCode() {
        return (char)this.typeCode;
    }

    public boolean isContinuation() {
        return this.continuationCode;
    }

    public String toString() {
        return this.getTypeCode() + "  " + this.getSequenceNum();
    }

    public static void tester(String fileName) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            ControlHeader controlHeaderObject = new ControlHeader(23, 68, true);
            controlHeaderObject.write(dos);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ControlHeader.tester(args[0]);
    }
}

