/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxElementProcessor;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventParameters;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class EventIterator {
    XMLEventReader reader;
    final EventParameters parent;

    public EventIterator(XMLEventReader reader, EventParameters parent) {
        this.reader = reader;
        this.parent = parent;
    }

    public boolean hasNext() throws XMLStreamException, SeisFileException {
        return StaxUtil.hasNext(this.reader, "event", "quakeml", new StaxElementProcessor(){

            @Override
            public void processNextStartElement(XMLEventReader reader) throws XMLStreamException, SeisFileException {
                EventIterator.this.parent.processOneStartElement(reader);
            }
        });
    }

    public Event next() throws XMLStreamException, SeisFileException {
        if (this.hasNext()) {
            return new Event(this.reader);
        }
        return null;
    }
}

