/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.OverlayVelocityModelArgs;
import edu.sc.seis.TauP.cmdline.args.VelModelOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="velmerge", description={"Merge part of one model into another."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_VelocityMerge
extends TauP_Tool {
    public static String DEFAULT_OUTFILE = "velocity_model";
    @CommandLine.ArgGroup(multiplicity="1", heading="Base Velocity Model %n")
    VelocityModelArgs inputFileArgs = new VelocityModelArgs();
    String outfile = "stdout";
    @CommandLine.ArgGroup(multiplicity="1", heading="Merge Velocity Model %n")
    OverlayVelocityModelArgs overlayModelArgs = new OverlayVelocityModelArgs();
    @CommandLine.Option(names={"--smoothtop"}, description={"smooth merge at top"})
    boolean smoothTop = false;
    @CommandLine.Option(names={"--smoothbot"}, description={"smooth merge at bottom"})
    boolean smoothBottom = false;
    @CommandLine.Option(names={"--elev"}, description={"increase topmost layer by elevation (meters)"})
    float elevation = 0.0f;
    VelModelOutputTypeArgs outputTypeArgs = (VelModelOutputTypeArgs)this.abstractOutputTypeArgs;

    public TauP_VelocityMerge() {
        super(new VelModelOutputTypeArgs(DEFAULT_OUTFILE));
        this.setOutFileExtension("nd");
    }

    @Override
    public void start() throws TauPException, IOException {
        PrintWriter dos;
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.inputFileArgs.getModelFilename(), this.inputFileArgs.getVelFileType());
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.inputFileArgs.getModelFilename() + ", tried internally and from file");
        }
        VelocityModel outVMod = vMod;
        if (this.overlayModelArgs.getModelFilename() != null && !this.overlayModelArgs.getModelFilename().isEmpty()) {
            if (this.isDEBUG()) {
                Alert.debug("base model: " + vMod.getModelName());
                Alert.debug("merge model: " + this.overlayModelArgs.getModelFilename());
            }
            VelocityModel overlayVMod = TauModelLoader.loadVelocityModel(this.overlayModelArgs.getModelFilename(), this.overlayModelArgs.getVelFileType());
            outVMod = vMod.replaceLayers(overlayVMod.getLayers(), overlayVMod.getModelName(), this.smoothTop, this.smoothBottom);
            outVMod.setModelName(vMod.getModelName() + "_" + overlayVMod.getModelName());
        } else if (this.isDEBUG()) {
            Alert.debug("base model: " + vMod.getModelName());
            Alert.debug("no merge model requested.");
        }
        if (this.elevation != 0.0f) {
            outVMod = outVMod.elevationLayer(this.elevation, this.overlayModelArgs.getModelFilename());
        }
        if (Objects.equals(this.getOutFile(), "stdout") || Objects.equals(this.getOutFile(), "-")) {
            dos = new PrintWriter(new OutputStreamWriter(System.out));
        } else {
            if (this.isDEBUG()) {
                Alert.debug("Save to " + this.getOutFile());
            }
            dos = new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile())));
        }
        if (Objects.equals(this.getOutputFormat(), "nd") || Objects.equals(this.getOutputFormat(), "text")) {
            outVMod.writeToND(dos);
        } else {
            if (Objects.equals(this.getOutputFormat(), "tvel")) {
                throw new RuntimeException("tvel output not yet implemented");
            }
            if (Objects.equals(this.getOutputFormat(), "json")) {
                Gson gson = GsonUtil.createGsonBuilder().create();
                dos.println(gson.toJson((Object)outVMod));
            } else {
                throw new TauPException("Unknown output format: " + this.getOutputFormat());
            }
        }
        dos.flush();
    }

    @Override
    public void validateArguments() throws TauModelException {
        if (this.overlayModelArgs.getModelFilename() == null || this.overlayModelArgs.getModelFilename().isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "merge model cannot be empty, use one of --ndmerge or --tvelmerge");
        }
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public String getOutputFormat() {
        String type = this.inputFileArgs.getVelFileType();
        if (type == null) {
            type = "nd";
        }
        return type;
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"output to file, default is stdout."})
    public void setOutFile(String outfile) {
        this.outfile = outfile;
    }

    public String getOutFile() {
        return this.outfile;
    }
}

