/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractRayTool;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.cmdline.args.AmplitudeArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.TauP.gson.ScatteredArrivalSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="pierce", description={"Calculate pierce points for phases at discontinuities in the model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Pierce
extends TauP_AbstractRayTool {
    protected boolean onlyTurnPoints = false;
    protected boolean onlyRevPoints = false;
    protected boolean onlyUnderPoints = false;
    protected boolean onlyAddPoints = false;
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs;
    @CommandLine.Option(names={"--first", "--onlyfirst"}, description={"only output the first arrival for each phase, no triplications"})
    protected boolean onlyFirst = false;
    @CommandLine.Mixin
    AmplitudeArgs sourceArgs = new AmplitudeArgs();

    public TauP_Pierce() {
        super(new TextOutputTypeArgs("text", "-"));
        this.outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    public TauP_Pierce(TauModel tMod) {
        this();
        this.setTauModel(tMod);
    }

    public TauP_Pierce(String modelName) throws TauModelException {
        this();
        this.modelArgs.setModelName(modelName);
    }

    @CommandLine.Option(names={"--turn"}, description={"only prints bottom turning points, e.g. v"})
    public void setOnlyTurnPoints(boolean onlyTurnPoints) {
        this.onlyTurnPoints = onlyTurnPoints;
    }

    @CommandLine.Option(names={"--rev"}, description={"only prints underside and bottom turn points, e.g. ^ and v"})
    public void setOnlyRevPoints(boolean onlyRevPoints) {
        this.onlyRevPoints = onlyRevPoints;
    }

    @CommandLine.Option(names={"--under"}, description={"only prints underside reflection points, e.g. ^"})
    public void setOnlyUnderPoints(boolean onlyUnderPoints) {
        this.onlyUnderPoints = onlyUnderPoints;
    }

    @CommandLine.Option(names={"--nodiscon"}, description={"only prints pierce points for the depths added with -pierce"})
    public void setOnlyAddPoints(boolean onlyAddPoints) {
        this.onlyAddPoints = onlyAddPoints;
    }

    @CommandLine.Option(names={"--pierce"}, paramLabel="depth", description={"additional depth for calculating pierce points"}, split=",")
    public void setAddDepth(List<Double> addDepths) {
        this.modelArgs.setModelSplitDepths(addDepths);
    }

    public void appendAddDepths(String depthString) {
        this.modelArgs.unsetDepthCorrected();
        this.modelArgs.getModelSplitDepths().addAll(this.parseAddDepthsList(depthString));
    }

    protected List<Double> parseAddDepthsList(String depthList) {
        ArrayList<Double> out = new ArrayList<Double>();
        depthList = depthList.replace(' ', ',');
        for (String dstr : depthList.split(",")) {
            if (dstr.isEmpty()) continue;
            out.add(Double.parseDouble(dstr));
        }
        return out;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public AmplitudeArgs getSourceArgs() {
        return this.sourceArgs;
    }

    public boolean isWithAmplitude() {
        return this.getSourceArgs().isWithAmplitude();
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> rayCalcList) throws TauPException {
        List<Arrival> arrivalList = TauP_Time.internalCalcAll(phaseList, rayCalcList, this.onlyFirst);
        for (Arrival arrival : arrivalList) {
            arrival.getPierce();
        }
        return arrivalList;
    }

    public GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBld = GsonUtil.createGsonBuilder();
        gsonBld.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(true, false, this.isWithAmplitude()));
        gsonBld.registerTypeAdapter(ScatteredArrival.class, (Object)new ScatteredArrivalSerializer(true, false, this.isWithAmplitude()));
        return gsonBld;
    }

    @Override
    public void start() throws IOException, TauPException {
        List<RayCalculateable> distanceValues = this.getDistanceArgs().getRayCalculatables(this.sourceArgs);
        List<Arrival> arrivalList = this.calcAll(this.getSeismicPhases(), distanceValues);
        if (this.getDistanceArgs().isAllIndexRays()) {
            List<Arrival> indexArrivalList = TauP_Time.calcAllIndexRays(this.getSeismicPhases());
            arrivalList.addAll(indexArrivalList);
        }
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        this.printResult(writer, arrivalList);
        writer.close();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws IOException, TauPException {
        if (this.getOutputFormat().equals("json")) {
            TimeResult result = this.createTimeResult(this.isWithAmplitude(), this.sourceArgs, arrivalList);
            GsonBuilder gsonBld = this.createGsonBuilder();
            out.println(gsonBld.create().toJson((Object)result));
        } else if (this.getOutputFormat().equals("html")) {
            this.printResultHtml(out, arrivalList);
        } else {
            this.printResultText(out, arrivalList);
        }
        out.flush();
    }

    public void printResultText(PrintWriter out, List<Arrival> arrivalList) {
        this.printPierceAsText(out, arrivalList);
    }

    public void printPierceAsText(PrintWriter out, List<Arrival> arrivalList) {
        for (Arrival arrival : arrivalList) {
            out.println("> " + arrival.getCommentLine());
            TimeDist[] pierce = arrival.getPierce();
            double prevDepth = pierce[0].getDepth();
            for (int j = 0; j < pierce.length; ++j) {
                double calcDist = pierce[j].getDistDeg();
                double nextDepth = j < pierce.length - 1 ? pierce[j + 1].getDepth() : pierce[j].getDepth();
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyRevPoints && this.getScatterer() != null && pierce[j].getDepth() == this.getScatterer().depth && pierce[j].getDistDeg() == this.getScatterer().dist.getDegrees(arrival.getTauModel().getRadiusOfEarth()) || this.onlyAddPoints && this.isAddDepth(pierce[j].getDepth()) || this.onlyRevPoints && (prevDepth - pierce[j].getDepth()) * (pierce[j].getDepth() - nextDepth) < 0.0 || this.onlyTurnPoints && j != 0 && prevDepth - pierce[j].getDepth() <= 0.0 && pierce[j].getDepth() - nextDepth >= 0.0 || this.onlyUnderPoints && j != 0 && j != pierce.length - 1 && prevDepth - pierce[j].getDepth() >= 0.0 && pierce[j].getDepth() - nextDepth <= 0.0) {
                    out.write(Outputs.formatDistance(calcDist));
                    out.write(Outputs.formatDepth(pierce[j].getDepth()));
                    out.write(Outputs.formatTime(pierce[j].getTime()));
                    if (arrival.isLatLonable()) {
                        double[] latlon = arrival.getLatLonable().calcLatLon(calcDist, arrival.getDistDeg());
                        out.write("  " + Outputs.formatLatLon(latlon[0]) + "  " + Outputs.formatLatLon(latlon[1]));
                    }
                    out.write("\n");
                }
                prevDepth = pierce[j].getDepth();
            }
        }
    }

    public void printResultHtml(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        this.printPierceAsHtml(out, arrivalList);
    }

    public void printPierceAsHtml(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        HTMLUtil.createHtmlStart(out, "TauP Pierce", HTMLUtil.createTableCSS(), true);
        String modelLine = String.join((CharSequence)"", TauP_Time.createModelHeaderLine(this.getTauModelName(), this.getScatterer()));
        out.println("<h5>" + modelLine + "</h5>");
        ArrayList<String> headers = new ArrayList<String>();
        headers.addAll(List.of("Distance (deg)", "Depth (km)", "Time (s)"));
        boolean latLon = false;
        for (Arrival arrival : arrivalList) {
            if (!arrival.isLatLonable()) continue;
            latLon = true;
            break;
        }
        if (latLon) {
            headers.addAll(List.of("Lat", "Lon"));
        }
        for (Arrival arrival : arrivalList) {
            TimeDist[] pierce = arrival.getPierce();
            double prevDepth = pierce[0].getDepth();
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (int j = 0; j < pierce.length; ++j) {
                ArrayList<String> row = new ArrayList<String>();
                double calcDist = pierce[j].getDistDeg();
                double nextDepth = j < pierce.length - 1 ? pierce[j + 1].getDepth() : pierce[j].getDepth();
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyRevPoints && this.getScatterer() != null && pierce[j].getDepth() == this.getScatterer().depth && pierce[j].getDistDeg() == this.getScatterer().dist.getDegrees(arrival.getTauModel().getRadiusOfEarth()) || this.onlyAddPoints && this.isAddDepth(pierce[j].getDepth()) || this.onlyRevPoints && (prevDepth - pierce[j].getDepth()) * (pierce[j].getDepth() - nextDepth) < 0.0 || this.onlyTurnPoints && j != 0 && prevDepth - pierce[j].getDepth() <= 0.0 && pierce[j].getDepth() - nextDepth >= 0.0 || this.onlyUnderPoints && j != 0 && j != pierce.length - 1 && prevDepth - pierce[j].getDepth() >= 0.0 && pierce[j].getDepth() - nextDepth <= 0.0) {
                    row.add(Outputs.formatDistance(calcDist));
                    row.add(Outputs.formatDepth(pierce[j].getDepth()));
                    row.add(Outputs.formatTime(pierce[j].getTime()));
                    if (arrival.isLatLonable()) {
                        double[] latlon = arrival.getLatLonable().calcLatLon(calcDist, arrival.getDistDeg());
                        row.add(Outputs.formatLatLon(latlon[0]));
                        row.add(Outputs.formatLatLon(latlon[1]));
                    }
                }
                prevDepth = pierce[j].getDepth();
                values.add(row);
            }
            out.println("<details open=\"true\">");
            out.println("  <summary>" + arrival.getCommentLine() + "</summary>");
            out.println(HTMLUtil.createBasicTable(headers, values));
            out.println("</details>");
        }
        out.println(HTMLUtil.createHtmlEnding());
    }

    public synchronized boolean isAddDepth(double depth) {
        for (Double aDouble : this.modelArgs.getModelSplitDepths()) {
            if (depth != aDouble) continue;
            return true;
        }
        return false;
    }
}

