/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public interface SeismicPhase
extends Serializable,
Cloneable {
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public boolean phasesExistsInModel();

    public Arrival getEarliestArrival(double var1);

    public double getMinDistanceDeg();

    public double getMinDistance();

    public double getMaxDistanceDeg();

    public double getMaxDistance();

    public double getMaxRayParam();

    public double getMinRayParam();

    public double getMinTime();

    public double getMaxTime();

    public String getName();

    public String getPuristName();

    public double getSourceDepth();

    public double getReceiverDepth();

    public boolean hasArrivals();

    public String describe();

    public String describeShort();

    public TauModel getTauModel();

    public static Arrival getEarliestArrival(List<SeismicPhase> phases, double degrees) {
        Arrival minArrival = null;
        for (SeismicPhase seismicPhase : phases) {
            Arrival currArrival = seismicPhase.getEarliestArrival(degrees);
            if (currArrival == null || minArrival != null && !(minArrival.getTime() > currArrival.getTime())) continue;
            minArrival = currArrival;
        }
        return minArrival;
    }

    public boolean isFail();

    public String failReason();

    public int getMaxRayParamIndex();

    public int getMinRayParamIndex();

    public List<List<SeismicPhaseSegment>> getListPhaseSegments();

    public SeismicPhaseSegment getInitialPhaseSegment();

    public SeismicPhaseSegment getFinalPhaseSegment();

    public int countFlatLegs();

    public double getRayParams(int var1);

    public double[] getRayParams();

    public double getDist(int var1);

    public double[] getDist();

    public double getTime(int var1);

    public double[] getTime();

    public double getTau(int var1);

    public double[] getTau();

    public static double distanceTrim180(double deg) {
        double tempDeg = deg;
        if (tempDeg < 0.0) {
            tempDeg *= -1.0;
        }
        while (tempDeg > 360.0) {
            tempDeg -= 360.0;
        }
        if (tempDeg > 180.0) {
            tempDeg = 360.0 - tempDeg;
        }
        return tempDeg;
    }

    public Arrival createArrivalAtIndex(int var1);

    public Arrival shootRay(double var1) throws TauPException;

    public boolean isAllPWave();

    public boolean isAllSWave();

    public double calcRayParamForTakeoffAngle(double var1) throws NoArrivalException;

    public double calcRayParamForIncidentAngle(double var1) throws NoArrivalException;

    public double velocityAtSource();

    public double velocityAtReceiver();

    public double densityAtReceiver();

    public double densityAtSource();

    public double calcTakeoffAngleDegree(double var1);

    public double calcTakeoffAngle(double var1);

    public double calcIncidentAngle(double var1);

    public double calcIncidentAngleDegree(double var1);

    public boolean sourceSegmentIsPWave();

    public boolean finalSegmentIsPWave();

    public List<ArrivalPathSegment> calcSegmentPaths(Arrival var1) throws NoArrivalException, SlownessModelException, TauModelException;

    public String toString();

    public void dump();

    public SeismicPhase interpolatePhase(double var1);

    public double calcEnergyFluxFactorReflTranPSV(Arrival var1) throws VelocityModelException, SlownessModelException, NoArrivalException;

    public double calcEnergyFluxFactorReflTranSH(Arrival var1) throws VelocityModelException, SlownessModelException, NoArrivalException;

    public List<TimeDist> interpPierceTimeDist(Arrival var1) throws NoArrivalException, TauModelException;

    public double calcTstar(Arrival var1) throws NoArrivalException;

    public static List<double[]> splitForRepeatRayParam(double[] rayParams, double[] values) {
        ArrayList<double[]> out = new ArrayList<double[]>();
        int partialStart = 0;
        if (rayParams.length != values.length) {
            throw new IllegalArgumentException("rayParams and values must be same length: " + rayParams.length + " " + values.length);
        }
        for (int i = 0; i < values.length - 1; ++i) {
            if (rayParams[i] != rayParams[i + 1] || rayParams.length <= 2) continue;
            double[] partialValues = new double[1 + i - partialStart];
            System.arraycopy(values, partialStart, partialValues, 0, partialValues.length);
            out.add(partialValues);
            partialStart = i + 1;
        }
        double[] partialValues = new double[values.length - partialStart];
        System.arraycopy(values, partialStart, partialValues, 0, partialValues.length);
        out.add(partialValues);
        return out;
    }

    public static String baseDescribe(SeismicPhase phase) {
        Object desc = "";
        if (phase.phasesExistsInModel()) {
            Object mod180Min = "";
            if (phase.getMinDistanceDeg() > 180.0 || phase.getMinDistanceDeg() < -180.0) {
                mod180Min = " (" + Outputs.formatDistanceNoPad(SeismicPhase.distanceTrim180(phase.getMinDistanceDeg())) + ") ";
            }
            Object mod180Max = "";
            if (phase.getMaxDistanceDeg() > 180.0 || phase.getMaxDistanceDeg() < -180.0) {
                mod180Max = " (" + Outputs.formatDistanceNoPad(SeismicPhase.distanceTrim180(phase.getMaxDistanceDeg())) + ") ";
            }
            desc = (String)desc + "  exists from " + Outputs.formatDistanceNoPad(phase.getMinDistanceDeg()) + (String)mod180Min + " to " + Outputs.formatDistanceNoPad(phase.getMaxDistanceDeg()) + (String)mod180Max + " degrees in the " + phase.getTauModel().getModelName() + " model.\n";
            desc = phase.getMaxRayParam() > phase.getMinRayParam() ? (String)desc + "  with ray parameter from " + Outputs.formatRayParam(phase.getMaxRayParam() / 57.29577951308232) + " down to " + Outputs.formatRayParam(phase.getMinRayParam() / 57.29577951308232) + " sec/deg.\n" : (String)desc + "  with degenerate ray parameter of " + Outputs.formatRayParam(phase.getMaxRayParam() / 57.29577951308232) + " sec/deg.\n";
            desc = (String)desc + "  travel times from " + Outputs.formatTimeNoPad(phase.getMinTime()) + " to " + Outputs.formatTimeNoPad(phase.getMaxTime()) + " sec";
            StringBuilder builder = new StringBuilder();
            for (ShadowZone shad : phase.getShadowZones()) {
                Arrival pre = shad.getPreArrival();
                Arrival post = shad.getPostArrival();
                builder.append("\n  with shadow zone between " + Outputs.formatDistance(pre.getDistDeg()) + " and " + Outputs.formatDistance(post.getDistDeg()) + " deg");
            }
            builder.append(".\n");
            desc = (String)desc + builder.toString();
        } else {
            desc = (String)desc + "  FAILS to exist, because no ray parameters satisfy the path.\n";
        }
        return desc;
    }

    public static String segmentDescribe(SeismicPhase phase) {
        return SeismicPhaseSegment.segmentListDescribe(phase.getListPhaseSegments());
    }

    public int getNumRays();

    public List<ShadowZone> getShadowZones();
}

