/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistAz;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.seisFile.LatLonLocatable;
import java.util.List;

public abstract class RayCalculateable {
    protected LatLonLocatable staLatLon = null;
    protected LatLonLocatable evtLatLon = null;
    protected Double azimuth = null;
    protected Double backAzimuth = null;
    protected boolean geodetic = false;
    protected Double invFlattening = null;
    protected String description = null;
    protected SeismicSourceArgs sourceArgs = null;

    public abstract List<Arrival> calculate(SeismicPhase var1) throws TauPException;

    public void withEventAzimuth(LatLonLocatable evt, double azimuth) {
        this.evtLatLon = evt;
        this.azimuth = azimuth;
        this.backAzimuth = null;
    }

    public void withStationBackAzimuth(LatLonLocatable sta, double backazimuth) {
        this.staLatLon = sta;
        this.azimuth = null;
        this.backAzimuth = backazimuth;
    }

    public abstract boolean isLatLonable();

    public abstract LatLonable getLatLonable();

    public boolean hasSourceDepth() {
        return this.evtLatLon != null && this.evtLatLon.asLocation().hasDepth();
    }

    public Double getSourceDepth() {
        return this.evtLatLon != null ? this.evtLatLon.asLocation().getDepthKm() : null;
    }

    public boolean hasSource() {
        return this.evtLatLon != null;
    }

    public LatLonLocatable getSource() {
        return this.evtLatLon;
    }

    public boolean hasReceiverDepth() {
        return this.staLatLon != null && this.staLatLon.asLocation().hasDepth();
    }

    public Double getReceiverDepth() {
        return this.staLatLon != null ? this.staLatLon.asLocation().getDepthKm() : null;
    }

    public boolean hasReceiver() {
        return this.staLatLon != null;
    }

    public LatLonLocatable getReceiver() {
        return this.staLatLon;
    }

    public boolean hasAzimuth() {
        return this.azimuth != null || this.staLatLon != null && this.evtLatLon != null;
    }

    public boolean isGeodetic() {
        return this.geodetic;
    }

    public Double getInvFlattening() {
        return this.invFlattening;
    }

    public Double getNormalizedAzimuth() {
        Double az = this.getAzimuth();
        return RayCalculateable.normalizAzimuth(az);
    }

    public static Double normalizAzimuth(Double az) {
        if (az != null && (az = Double.valueOf(az % 360.0)) > 180.0) {
            az = az - 360.0;
        }
        return az;
    }

    public Double getAzimuth() {
        if (this.azimuth != null) {
            return this.azimuth;
        }
        if (this.staLatLon != null && this.backAzimuth != null) {
            if (this.getLatLonable().isGeodetic()) {
                return null;
            }
            return null;
        }
        if (this.evtLatLon != null && this.staLatLon != null) {
            if (this.getLatLonable().isGeodetic()) {
                DistAz distAz = new DistAz(this.evtLatLon.asLocation(), this.staLatLon.asLocation(), (double)this.invFlattening);
                return distAz.getAz();
            }
            return SphericalCoords.azimuth(this.evtLatLon.asLocation(), this.staLatLon.asLocation());
        }
        throw new RuntimeException("should not happen");
    }

    public void setAzimuth(Double azimuth) {
        this.azimuth = azimuth;
    }

    public boolean hasBackAzimuth() {
        return this.backAzimuth != null || this.evtLatLon != null && this.staLatLon != null;
    }

    public Double getNormalizedBackAzimuth() {
        Double baz = this.getBackAzimuth();
        return RayCalculateable.normalizAzimuth(baz);
    }

    public Double getBackAzimuth() {
        if (this.backAzimuth != null) {
            return this.backAzimuth;
        }
        if (this.staLatLon != null && this.azimuth != null) {
            if (this.getLatLonable().isGeodetic()) {
                return null;
            }
            return null;
        }
        if (this.evtLatLon != null && this.staLatLon != null) {
            if (this.getLatLonable().isGeodetic()) {
                DistAz distAz = new DistAz(this.evtLatLon, this.staLatLon, (double)this.invFlattening);
                return distAz.getBaz();
            }
            return SphericalCoords.azimuth(this.staLatLon, this.evtLatLon);
        }
        throw new RuntimeException("should not happen");
    }

    public void setBackAzimuth(Double backAzimuth) {
        this.backAzimuth = backAzimuth;
    }

    public boolean hasSourceArgs() {
        return this.sourceArgs != null;
    }

    public void setSourceArgs(SeismicSourceArgs sourceArgs) {
        this.sourceArgs = sourceArgs;
    }

    public SeismicSourceArgs getSourceArgs() {
        return this.sourceArgs;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String toString() {
        if (this.hasDescription()) {
            return this.getDescription();
        }
        return "";
    }
}

