/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SeismicPhaseWalk;
import edu.sc.seis.TauP.ShadowOrProto;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TauPException;
import java.util.ArrayList;
import java.util.List;

public class ProtoSeismicPhase
implements Comparable<ProtoSeismicPhase> {
    final List<SeismicPhaseSegment> segmentList;
    TauModel tMod;
    boolean isFail = false;
    String failReason = null;
    String phaseName;
    final double receiverDepth;

    public ProtoSeismicPhase(List<SeismicPhaseSegment> segmentList, double receiverDepth) {
        this(segmentList, receiverDepth, null);
        this.tMod = segmentList.get((int)0).tMod;
        SeismicPhaseSegment prev = null;
        for (SeismicPhaseSegment seg : segmentList) {
            if (prev != null) {
                seg.prevEndAction = prev.endAction;
            }
            prev = seg;
        }
        try {
            this.validateSegList();
        }
        catch (TauModelException e) {
            throw new RuntimeException(e);
        }
    }

    ProtoSeismicPhase(List<SeismicPhaseSegment> segmentList, double receiverDepth, String phaseName) {
        this.segmentList = segmentList;
        this.receiverDepth = receiverDepth;
        this.phaseName = phaseName;
        if (!segmentList.isEmpty()) {
            this.tMod = segmentList.get((int)0).tMod;
        }
    }

    public static ProtoSeismicPhase startEmpty(String phaseName, TauModel tMod, double receiverDepth) {
        ProtoSeismicPhase proto = new ProtoSeismicPhase(new ArrayList<SeismicPhaseSegment>(), receiverDepth, phaseName);
        proto.phaseName = phaseName;
        proto.tMod = tMod;
        if (tMod == null) {
            throw new IllegalArgumentException("TauModel cannot be null");
        }
        return proto;
    }

    public static ProtoSeismicPhase start(SeismicPhaseSegment startSeg, double receiverDepth) {
        if (startSeg == null) {
            throw new RuntimeException("Start Segment cannot be null");
        }
        return new ProtoSeismicPhase(new ArrayList<SeismicPhaseSegment>(List.of(startSeg)), receiverDepth);
    }

    public static ProtoSeismicPhase failNewPhase(TauModel tMod, boolean isPWave, boolean isDownGoing, double receiverDepth, String phaseName, String reason) {
        ProtoSeismicPhase failed = ProtoSeismicPhase.startEmpty(phaseName, tMod, receiverDepth);
        int startBranchNum = tMod.getSourceBranch();
        failed.add(SeismicPhaseSegment.failSegment(tMod, startBranchNum, startBranchNum, isPWave, isDownGoing, phaseName));
        failed.isFail = true;
        failed.failReason = reason;
        if (TauPConfig.DEBUG) {
            Alert.debug("FAIL: " + reason + " within phase " + phaseName);
        }
        return failed;
    }

    public static ProtoSeismicPhase startNewPhase(TauModel tMod, boolean isPWave, PhaseInteraction endAction, boolean isDownGoing, double receiverDepth) throws TauPException {
        double maxRayParam;
        int startBranchNum = tMod.getSourceBranch();
        if (!isDownGoing) {
            --startBranchNum;
        }
        String legName = ProtoSeismicPhase.legNameForSegment(tMod, startBranchNum, isPWave, isDownGoing, false, endAction);
        ProtoSeismicPhase proto = ProtoSeismicPhase.startEmpty(legName, tMod, receiverDepth);
        TauBranch startBranch = tMod.getTauBranch(startBranchNum, isPWave);
        double minRayParam = 0.0;
        SlownessModel sMod = tMod.getSlownessModel();
        if (isDownGoing) {
            if (tMod.getSourceDepth() == tMod.getRadiusOfEarth()) {
                throw new TauPException("Cannot be downgoing for source at center of earth: " + tMod.getSourceDepth());
            }
            SlownessLayer slownessLayer = sMod.getSlownessLayer(sMod.layerNumberBelow(tMod.getSourceDepth(), isPWave), isPWave);
            maxRayParam = slownessLayer.getTopP();
            switch (endAction) {
                case TURN: {
                    minRayParam = startBranch.getMinRayParam();
                    break;
                }
                case REFLECT_TOPSIDE: 
                case TRANSDOWN: {
                    maxRayParam = startBranch.getMinTurnRayParam();
                    break;
                }
                case REFLECT_TOPSIDE_CRITICAL: {
                    maxRayParam = startBranch.getMinTurnRayParam();
                    minRayParam = startBranch.getMinRayParam();
                    break;
                }
                default: {
                    throw new TauPException("Don't understand endAction " + endAction + " when downgoing");
                }
            }
        } else {
            if (tMod.getSourceDepth() == 0.0) {
                throw new TauPException("Cannot be upgoing for zero depth source");
            }
            SlownessLayer slownessLayer = sMod.getSlownessLayer(sMod.layerNumberAbove(tMod.getSourceDepth(), isPWave), isPWave);
            maxRayParam = slownessLayer.getBotP();
            switch (endAction) {
                case REFLECT_UNDERSIDE: 
                case TRANSUP: {
                    maxRayParam = Math.max(maxRayParam, startBranch.getMinTurnRayParam());
                    break;
                }
                default: {
                    throw new TauPException("Don't understand endAction " + endAction + " when upgoing");
                }
            }
        }
        proto.add(new SeismicPhaseSegment(tMod, startBranchNum, startBranchNum, isPWave, endAction, isDownGoing, legName, minRayParam, maxRayParam));
        return proto;
    }

    public SeismicPhaseSegment failNext(String reason) {
        if (TauPConfig.DEBUG) {
            Alert.debug("Fail: " + reason + " empty: " + this.segmentList.isEmpty());
        }
        SeismicPhaseSegment failSeg = SeismicPhaseSegment.failSegment(this.tMod);
        this.segmentList.add(failSeg);
        this.isFail = true;
        this.failReason = reason;
        return failSeg;
    }

    public ProtoSeismicPhase nextSegment(boolean isPWave, PhaseInteraction endAction) throws TauModelException {
        int startBranchNum;
        boolean isDowngoing;
        ArrayList<SeismicPhaseSegment> out = new ArrayList<SeismicPhaseSegment>(this.segmentList);
        SeismicPhaseSegment endSeg = this.segmentList.isEmpty() ? null : this.segmentList.get(this.segmentList.size() - 1);
        TauModel tMod = endSeg != null ? endSeg.getTauModel() : null;
        int priorEndBranchNum = endSeg != null ? endSeg.endBranch : -1;
        switch (endAction) {
            case TURN: 
            case REFLECT_TOPSIDE: 
            case TRANSDOWN: 
            case REFLECT_TOPSIDE_CRITICAL: 
            case REFLECT_UNDERSIDE: 
            case TRANSUP: 
            case REFLECT_UNDERSIDE_CRITICAL: 
            case END: 
            case END_DOWN: {
                isDowngoing = PhaseInteraction.isDowngoingActionBefore(endAction);
                break;
            }
            case FAIL: {
                SeismicPhaseSegment nextSeg = SeismicPhaseSegment.failSegment(tMod, priorEndBranchNum, priorEndBranchNum, isPWave, true, "");
                out.add(nextSeg);
                if (endSeg != null) {
                    nextSeg.prevEndAction = endSeg.endAction;
                }
                ProtoSeismicPhase failProto = new ProtoSeismicPhase(out, this.receiverDepth);
                failProto.isFail = true;
                return failProto;
            }
            case START: {
                throw new IllegalArgumentException("End action cannot be START: " + endAction);
            }
            default: {
                throw new IllegalArgumentException("End action case not yet impl: " + endAction);
            }
        }
        if (!isDowngoing && endSeg != null && endSeg.endBranch == 0 && endSeg.endAction != PhaseInteraction.TURN) {
            SeismicPhaseSegment nextSeg = SeismicPhaseSegment.failSegment(tMod, priorEndBranchNum, priorEndBranchNum, isPWave, true, "");
            this.isFail = true;
            this.failReason = "phase upgoing at surface";
            out.add(nextSeg);
            nextSeg.prevEndAction = endSeg.endAction;
            return new ProtoSeismicPhase(out, this.receiverDepth);
        }
        switch (endSeg.endAction) {
            case TRANSUP: {
                startBranchNum = priorEndBranchNum - 1;
                break;
            }
            case TRANSDOWN: {
                startBranchNum = priorEndBranchNum + 1;
                break;
            }
            default: {
                startBranchNum = priorEndBranchNum;
            }
        }
        int endBranchNum = ProtoSeismicPhase.findEndDiscon(tMod, startBranchNum, isPWave, isDowngoing);
        if (endBranchNum == 0 && endAction == PhaseInteraction.TRANSUP) {
            SeismicPhaseSegment nextSeg = SeismicPhaseSegment.failSegment(tMod, startBranchNum, endBranchNum, isPWave, false, "");
            this.isFail = true;
            this.failReason = "phase transup at surface";
            out.add(nextSeg);
            nextSeg.prevEndAction = endSeg.endAction;
            return new ProtoSeismicPhase(out, this.receiverDepth);
        }
        boolean isFlat = false;
        String nextLegName = SeismicPhaseWalk.legNameForTauBranch(tMod, startBranchNum, isPWave, isFlat, isDowngoing);
        TauBranch startBranch = tMod.getTauBranch(startBranchNum, isPWave);
        TauBranch endBranch = tMod.getTauBranch(endBranchNum, isPWave);
        double minRayParam = endSeg.minRayParam;
        double maxRayParam = endSeg.maxRayParam;
        TauBranch priorEndBranch = tMod.getTauBranch(priorEndBranchNum, endSeg.isPWave);
        switch (endSeg.endAction) {
            case TRANSDOWN: 
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: {
                maxRayParam = Math.min(maxRayParam, startBranch.getTopRayParam());
                break;
            }
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: 
            case TRANSUP: {
                maxRayParam = Math.min(maxRayParam, startBranch.getBotRayParam());
            }
        }
        switch (endAction) {
            case REFLECT_TOPSIDE_CRITICAL: {
                minRayParam = Math.max(minRayParam, endBranch.getMinRayParam());
            }
            case REFLECT_TOPSIDE: 
            case TRANSDOWN: 
            case END_DOWN: {
                maxRayParam = Math.min(maxRayParam, endBranch.getMinTurnRayParam());
                maxRayParam = Math.min(maxRayParam, endBranch.getBotRayParam());
                break;
            }
            case TURN: {
                minRayParam = Math.max(minRayParam, endBranch.getBotRayParam());
                maxRayParam = Math.min(maxRayParam, startBranch.getTopRayParam());
                break;
            }
            case TRANSUP: {
                maxRayParam = Math.min(maxRayParam, endBranch.getTopRayParam());
            }
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: 
            case END: {
                maxRayParam = Math.min(maxRayParam, endBranch.getMaxRayParam());
            }
        }
        SeismicPhaseSegment nextSeg = maxRayParam < minRayParam ? SeismicPhaseSegment.failSegment(tMod, startBranchNum, endBranchNum, isPWave, isDowngoing, nextLegName) : new SeismicPhaseSegment(tMod, startBranchNum, endBranchNum, isPWave, endAction, isDowngoing, nextLegName, minRayParam, maxRayParam);
        nextSeg.prevEndAction = endSeg.endAction;
        this.validateSegList();
        out.add(nextSeg);
        ProtoSeismicPhase proto = new ProtoSeismicPhase(out, this.receiverDepth);
        proto.validateSegList();
        return proto;
    }

    public static int findEndDiscon(TauModel tMod, int startBranchNum, boolean isPWave, boolean isDowngoing) {
        int endBranchNum;
        if (isDowngoing) {
            for (endBranchNum = startBranchNum; endBranchNum < tMod.getNumBranches() - 1 && tMod.isNoDisconDepth(tMod.getTauBranch(endBranchNum, isPWave).getBotDepth()); ++endBranchNum) {
            }
        } else {
            while (endBranchNum > 0 && tMod.isNoDisconDepth(tMod.getTauBranch(endBranchNum, isPWave).getTopDepth())) {
                --endBranchNum;
            }
        }
        return endBranchNum;
    }

    public void validateSegList() throws TauModelException {
        if (this.segmentList.isEmpty()) {
            return;
        }
        if (this.endSegment().endAction == PhaseInteraction.FAIL) {
            return;
        }
        SeismicPhaseSegment prev = null;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (seg.maxRayParam < 0.0) {
                throw new TauModelException("maxRayParam is zero: " + this.phaseNameForSegments());
            }
            if (seg.endBranch == seg.tMod.getNumBranches() - 1 && seg.isDownGoing && seg.endAction != PhaseInteraction.TURN) {
                throw new TauModelException("down not turn in innermost core layer: " + this.phaseNameForSegments() + " " + seg.endBranch + " " + seg.tMod.getNumBranches() + " " + seg.endAction);
            }
            if (prev != null) {
                String currLeg = seg.legName;
                if (seg.prevEndAction != prev.endAction) {
                    throw new TauModelException("segment prevEndAction is not prev segment endAction: " + this.phaseNameForSegments() + " " + seg.prevEndAction + " " + prev.endAction);
                }
                if (prev.endAction == PhaseInteraction.TRANSDOWN && prev.endBranch != seg.startBranch - 1) {
                    throw new TauModelException("prev is TRANSDOWN, but seg is not +1\n" + this.phaseNameForSegments() + " " + prev.endAction + "  " + seg.startBranch + "\n" + this.phaseNameForSegments());
                }
                if (prev.endAction == PhaseInteraction.TURN && (seg.endAction == PhaseInteraction.TURN || seg.endAction == PhaseInteraction.TRANSDOWN || seg.endAction == PhaseInteraction.DIFFRACTTURN || seg.endAction == PhaseInteraction.END_DOWN || seg.endAction == PhaseInteraction.REFLECT_TOPSIDE)) {
                    throw new TauModelException("prev is TURN, but seg is " + this.phaseNameForSegments() + " " + seg.endAction);
                }
                if (prev.isDownGoing && seg.isDownGoing && prev.endBranch + 1 != seg.startBranch) {
                    throw new TauModelException("Prev and Curr both downgoing but prev.endBranch+1 != seg.startBranch" + this.phaseNameForSegments() + "  pdown: " + prev.isDownGoing + " currdown " + seg.isDownGoing + " && " + prev.endBranch + " +1 != " + seg.startBranch);
                }
                if (prev.isFlat) {
                    if (seg.isDownGoing) {
                        if (prev.endsAtTop() && prev.endBranch != seg.startBranch) {
                            throw new TauModelException(this.getName() + ": Flat Segment is ends at top, but start is not current branch: " + currLeg);
                        }
                        if (!prev.endsAtTop() && prev.endBranch != seg.startBranch - 1) {
                            throw new TauModelException(this.getName() + ": Flat Segment is ends at bottom, but start is not next deeper branch: " + currLeg);
                        }
                    } else {
                        if (prev.endsAtTop() && prev.endBranch != seg.startBranch + 1) {
                            throw new TauModelException(this.getName() + ": Flat Segment is ends at top, but upgoing start is not next shallower branch: " + currLeg + " " + prev.endBranch + "!= " + seg.startBranch + "+1");
                        }
                        if (!prev.endsAtTop() && prev.endBranch != seg.startBranch) {
                            throw new TauModelException(this.getName() + ": Flat Segment is ends at bottom, but upgoing start is not current branch: " + currLeg + " " + prev.endBranch + "!= " + seg.startBranch);
                        }
                    }
                } else if (seg.isDownGoing) {
                    if (prev.endBranch > seg.startBranch) {
                        throw new TauModelException(this.getName() + ": Segment is downgoing, but we are already below the start: " + currLeg);
                    }
                    if (prev.endAction == PhaseInteraction.REFLECT_TOPSIDE || prev.endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                        throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to reflect up: " + currLeg + " " + prev.endAction + " " + seg);
                    }
                    if (prev.endAction == PhaseInteraction.TURN) {
                        throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to turn: " + currLeg);
                    }
                    if (prev.endAction == PhaseInteraction.DIFFRACTTURN) {
                        throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to diff turn: " + currLeg);
                    }
                    if (prev.endAction == PhaseInteraction.TRANSUP) {
                        throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to transmit up: " + currLeg);
                    }
                    if (prev.endBranch == seg.startBranch && !prev.isDownGoing && prev.endAction != PhaseInteraction.REFLECT_UNDERSIDE && prev.endAction != PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                        throw new TauModelException(this.getName() + ": Segment " + currLeg + " is downgoing, but previous action was not to reflect underside: " + currLeg + " " + SeismicPhaseFactory.endActionString(prev.endAction));
                    }
                } else {
                    if (prev.endAction == PhaseInteraction.REFLECT_UNDERSIDE || prev.endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                        throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was to underside reflect down: " + currLeg);
                    }
                    if (prev.endAction == PhaseInteraction.TRANSDOWN) {
                        throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was  to trans down: " + currLeg);
                    }
                    if (prev.endBranch == seg.startBranch && prev.isDownGoing && prev.endAction != PhaseInteraction.TURN && prev.endAction != PhaseInteraction.DIFFRACTTURN && prev.endAction != PhaseInteraction.DIFFRACT && prev.endAction != PhaseInteraction.HEAD && prev.endAction != PhaseInteraction.REFLECT_TOPSIDE && prev.endAction != PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                        throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was not to reflect topside: " + currLeg + " " + SeismicPhaseFactory.endActionString(prev.endAction));
                    }
                }
            }
            prev = seg;
        }
        SeismicPhaseSegment endSeg = this.endSegment();
        int receiverBranch = this.tMod.findBranch(this.receiverDepth);
        if (endSeg.prevEndAction != PhaseInteraction.KMPS) {
            if (endSeg.endAction == PhaseInteraction.END && endSeg.endBranch != receiverBranch) {
                throw new TauModelException(this.getName() + " End is upgoing, but last branch num is not receiver branch: " + endSeg.endBranch + " != " + receiverBranch + " rec depth: " + this.receiverDepth);
            }
            if (endSeg.endAction == PhaseInteraction.END_DOWN && endSeg.endBranch != receiverBranch - 1) {
                throw new TauModelException(this.getName() + " End is downgoing, but last branch num is not receiver branch-1: " + endSeg.endBranch + " != " + receiverBranch + " rec depth: " + this.receiverDepth);
            }
        }
        if (TauPConfig.VERBOSE) {
            Alert.debug("#### VALIDATE OK " + this.getName());
        }
    }

    public List<ShadowOrProto> splitForAllHighSlowness() throws TauModelException {
        List<ShadowOrProto> shadowSplits = List.of(new ShadowOrProto(this));
        for (int psIdx = 0; psIdx < 2; ++psIdx) {
            TauBranch prevTB = null;
            boolean isPWave = psIdx == 0;
            for (int tbNum = 0; tbNum < this.tMod.getNumBranches(); ++tbNum) {
                List<ShadowOrProto> splitList;
                ArrayList<ShadowOrProto> outList;
                TauBranch tb = this.tMod.getTauBranch(tbNum, isPWave);
                if (tb.isHighSlowness() && tb.getTopRayParam() <= this.endSegment().maxRayParam && tb.getTopRayParam() > this.endSegment().minRayParam) {
                    outList = new ArrayList<ShadowOrProto>();
                    for (ShadowOrProto inVal : shadowSplits) {
                        if (inVal.isProto()) {
                            splitList = inVal.getProto().splitForHighSlowness(tb);
                            outList.addAll(splitList);
                            continue;
                        }
                        outList.add(inVal);
                    }
                    shadowSplits = outList;
                }
                if (prevTB != null && prevTB.getBotRayParam() < tb.getTopRayParam() && this.endSegment().minRayParam < prevTB.getBotRayParam() && prevTB.getBotRayParam() < this.endSegment().maxRayParam) {
                    outList = new ArrayList();
                    for (ShadowOrProto inVal : shadowSplits) {
                        if (inVal.isProto()) {
                            splitList = inVal.getProto().splitForHighSlownessDiscon(tbNum, isPWave);
                            outList.addAll(splitList);
                            continue;
                        }
                        outList.add(inVal);
                    }
                    shadowSplits = outList;
                }
                prevTB = tb;
            }
        }
        return shadowSplits;
    }

    public List<ShadowOrProto> splitForHighSlowness(TauBranch hszBranch) throws TauModelException {
        boolean found = false;
        int hszBranchNum = -1;
        for (int bNum = 0; bNum < this.tMod.getNumBranches(); ++bNum) {
            if (this.tMod.getTauBranch(bNum, hszBranch.isPWave) != hszBranch) continue;
            hszBranchNum = bNum;
        }
        if (hszBranchNum == -1) {
            throw new TauModelException("Unable to find TauBranch in TauModel: " + hszBranch);
        }
        SeismicPhaseSegment endSeg = this.endSegment();
        double minRayParam = endSeg.minRayParam;
        double maxRayParam = endSeg.maxRayParam;
        double hszRayParam = hszBranch.getTopRayParam();
        if (!hszBranch.isHighSlowness() || hszRayParam < minRayParam || maxRayParam < hszRayParam) {
            return List.of(new ShadowOrProto(this));
        }
        ArrayList<SeismicPhaseSegment> preShadowSegList = new ArrayList<SeismicPhaseSegment>();
        ArrayList<SeismicPhaseSegment> postShadowSegList = new ArrayList<SeismicPhaseSegment>();
        SeismicPhaseSegment seg = null;
        for (SeismicPhaseSegment next : this.segmentList) {
            if (seg != null && seg.endAction == PhaseInteraction.TURN && seg.isPWave == hszBranch.isPWave && hszRayParam < seg.maxRayParam && seg.startBranch <= hszBranchNum && seg.endBranch >= hszBranchNum) {
                found = true;
                SeismicPhaseSegment downSplitSeg = new SeismicPhaseSegment(seg.tMod, seg.startBranch, hszBranchNum - 1, seg.isPWave, seg.endAction, seg.isDownGoing, seg.legName, hszRayParam, seg.maxRayParam);
                downSplitSeg.prevEndAction = seg.prevEndAction;
                preShadowSegList.add(downSplitSeg);
                SeismicPhaseSegment upSplitSeg = new SeismicPhaseSegment(next.tMod, hszBranchNum - 1, next.endBranch, next.isPWave, next.endAction, next.isDownGoing, next.legName, hszRayParam, seg.maxRayParam);
                upSplitSeg.prevEndAction = next.prevEndAction;
                preShadowSegList.add(upSplitSeg);
                if (hszBranchNum == seg.startBranch) {
                    downSplitSeg.maxRayParam = -1.0;
                    downSplitSeg.minRayParam = -1.0;
                    upSplitSeg.maxRayParam = -1.0;
                    upSplitSeg.minRayParam = -1.0;
                }
                if (downSplitSeg.maxRayParam < downSplitSeg.minRayParam) {
                    throw new RuntimeException("downSplitSeg max rp < min rp");
                }
                if (upSplitSeg.maxRayParam < upSplitSeg.minRayParam) {
                    throw new RuntimeException("upSplitSeg max rp < min rp");
                }
                TauBranch transBranch = this.tMod.getTauBranch(hszBranchNum - 1, seg.isPWave);
                SeismicPhaseSegment downTransSeg = new SeismicPhaseSegment(seg.tMod, seg.startBranch, hszBranchNum - 1, seg.isPWave, PhaseInteraction.TRANSDOWN, seg.isDownGoing, seg.legName, seg.minRayParam, Math.min(hszRayParam, transBranch.getBotRayParam()));
                downTransSeg.prevEndAction = seg.prevEndAction;
                postShadowSegList.add(downTransSeg);
                SeismicPhaseSegment downBelowSeg = new SeismicPhaseSegment(seg.tMod, hszBranchNum, seg.endBranch, seg.isPWave, seg.endAction, seg.isDownGoing, seg.legName, seg.minRayParam, hszRayParam);
                downBelowSeg.prevEndAction = downTransSeg.endAction;
                if (downBelowSeg.maxRayParam < downBelowSeg.minRayParam) {
                    throw new RuntimeException("downBelowSeg max rp < min rp");
                }
                postShadowSegList.add(downBelowSeg);
                SeismicPhaseSegment upBelowSeg = new SeismicPhaseSegment(next.tMod, next.startBranch, next.endBranch, next.isPWave, next.endAction, next.isDownGoing, next.legName, seg.minRayParam, hszRayParam);
                upBelowSeg.prevEndAction = next.prevEndAction;
                if (upBelowSeg.maxRayParam < upBelowSeg.minRayParam) {
                    throw new RuntimeException("upBelowSeg max rp < min rp");
                }
                postShadowSegList.add(upBelowSeg);
                seg = null;
                continue;
            }
            if (seg != null) {
                preShadowSegList.add(seg);
                postShadowSegList.add(seg);
            }
            seg = next;
        }
        if (found) {
            if (seg != null) {
                preShadowSegList.add(seg);
                postShadowSegList.add(seg);
            }
            ProtoSeismicPhase preShadow = new ProtoSeismicPhase(preShadowSegList, this.receiverDepth, this.phaseName);
            preShadow.calcEndSegRayParam();
            if (preShadow.countFlatLegs() == 0 && preShadow.endSegment().maxRayParam == preShadow.endSegment().minRayParam) {
                preShadow.failNext("Single ray parameter with no flat segments");
            }
            ProtoSeismicPhase postShadow = new ProtoSeismicPhase(postShadowSegList, this.receiverDepth, this.phaseName);
            postShadow.calcEndSegRayParam();
            if (postShadow.countFlatLegs() == 0 && postShadow.endSegment().maxRayParam == postShadow.endSegment().minRayParam) {
                postShadow.failNext("Single ray parameter with no flat segments");
            }
            if (preShadow.isFail) {
                return List.of(new ShadowOrProto(postShadow));
            }
            if (postShadow.isFail) {
                return List.of(new ShadowOrProto(preShadow));
            }
            if (preShadow.endSegment().minRayParam != postShadow.endSegment().maxRayParam) {
                throw new TauModelException("Shadow ray params don't match: " + preShadow.endSegment().maxRayParam + " != " + postShadow.endSegment().minRayParam);
            }
            ShadowZone shadow = new ShadowZone(preShadow.endSegment().minRayParam, hszBranch);
            return List.of(new ShadowOrProto(preShadow), new ShadowOrProto(shadow), new ShadowOrProto(postShadow));
        }
        return List.of(new ShadowOrProto(this));
    }

    public List<ShadowOrProto> splitForHighSlownessDiscon(int hszBranchNum, boolean isPWave) throws TauModelException {
        if (hszBranchNum == 0) {
            return List.of(new ShadowOrProto(this));
        }
        TauBranch abovehszBranch = this.tMod.getTauBranch(hszBranchNum - 1, isPWave);
        TauBranch hszBranch = this.tMod.getTauBranch(hszBranchNum, isPWave);
        if (abovehszBranch.getBotRayParam() >= hszBranch.getTopRayParam()) {
            return List.of(new ShadowOrProto(this));
        }
        SeismicPhaseSegment endSeg = this.endSegment();
        double minRayParam = endSeg.minRayParam;
        double maxRayParam = endSeg.maxRayParam;
        if (minRayParam > hszBranch.getTopRayParam() || maxRayParam <= abovehszBranch.getBotRayParam()) {
            return List.of(new ShadowOrProto(this));
        }
        double hszRayParam = abovehszBranch.getBotRayParam();
        boolean foundSegRPOverlap = false;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (seg.maxRayParam < hszRayParam) {
                hszRayParam = seg.maxRayParam;
            }
            if (seg == null || seg.isPWave != hszBranch.isPWave || seg.startBranch > hszBranchNum || seg.endBranch < hszBranchNum) continue;
            foundSegRPOverlap = true;
        }
        if (!foundSegRPOverlap || hszRayParam < minRayParam || maxRayParam < hszRayParam) {
            return List.of(new ShadowOrProto(this));
        }
        ArrayList<SeismicPhaseSegment> preShadowSegList = new ArrayList<SeismicPhaseSegment>();
        ArrayList<SeismicPhaseSegment> postShadowSegList = new ArrayList<SeismicPhaseSegment>();
        SeismicPhaseSegment seg = null;
        boolean found = false;
        for (SeismicPhaseSegment next : this.segmentList) {
            if (seg != null && seg.endAction == PhaseInteraction.TURN && seg.isPWave == hszBranch.isPWave && hszRayParam < seg.maxRayParam && seg.minRayParam < hszRayParam && seg.startBranch < hszBranchNum && seg.endBranch >= hszBranchNum) {
                found = true;
                SeismicPhaseSegment downSplitSeg = new SeismicPhaseSegment(seg.tMod, seg.startBranch, hszBranchNum - 1, seg.isPWave, seg.endAction, seg.isDownGoing, seg.legName, hszRayParam, seg.maxRayParam);
                downSplitSeg.prevEndAction = seg.prevEndAction;
                preShadowSegList.add(downSplitSeg);
                if (next.endBranch > hszBranchNum - 1) {
                    throw new RuntimeException("next seg ends before HSZ: " + next.endBranch + " > " + (hszBranchNum - 1));
                }
                SeismicPhaseSegment upSplitSeg = new SeismicPhaseSegment(next.tMod, hszBranchNum - 1, next.endBranch, next.isPWave, next.endAction, next.isDownGoing, next.legName, hszRayParam, seg.maxRayParam);
                upSplitSeg.prevEndAction = next.prevEndAction;
                preShadowSegList.add(upSplitSeg);
                if (hszBranchNum == seg.startBranch) {
                    downSplitSeg.maxRayParam = -1.0;
                    downSplitSeg.minRayParam = -1.0;
                    upSplitSeg.maxRayParam = -1.0;
                    upSplitSeg.minRayParam = -1.0;
                }
                if (downSplitSeg.maxRayParam < downSplitSeg.minRayParam) {
                    throw new RuntimeException("downSplitSeg max rp < min rp");
                }
                if (upSplitSeg.maxRayParam < upSplitSeg.minRayParam) {
                    throw new RuntimeException("upSplitSeg max rp < min rp");
                }
                SeismicPhaseSegment downTransSeg = new SeismicPhaseSegment(seg.tMod, seg.startBranch, hszBranchNum, seg.isPWave, PhaseInteraction.TRANSDOWN, seg.isDownGoing, seg.legName, seg.minRayParam, hszRayParam);
                downTransSeg.prevEndAction = seg.prevEndAction;
                postShadowSegList.add(downTransSeg);
                SeismicPhaseSegment downBelowSeg = new SeismicPhaseSegment(seg.tMod, hszBranchNum + 1, seg.endBranch, seg.isPWave, seg.endAction, seg.isDownGoing, seg.legName, seg.minRayParam, hszRayParam);
                downBelowSeg.prevEndAction = downTransSeg.endAction;
                if (downBelowSeg.maxRayParam < downBelowSeg.minRayParam) {
                    throw new RuntimeException("downBelowSeg max rp < min rp");
                }
                postShadowSegList.add(downBelowSeg);
                SeismicPhaseSegment upBelowSeg = new SeismicPhaseSegment(next.tMod, next.startBranch, next.endBranch, next.isPWave, next.endAction, next.isDownGoing, next.legName, seg.minRayParam, hszRayParam);
                upBelowSeg.prevEndAction = next.prevEndAction;
                if (upBelowSeg.maxRayParam < upBelowSeg.minRayParam) {
                    throw new RuntimeException("upBelowSeg max rp < min rp");
                }
                postShadowSegList.add(upBelowSeg);
                seg = null;
                continue;
            }
            if (seg != null) {
                preShadowSegList.add(seg);
                postShadowSegList.add(seg);
            }
            seg = next;
        }
        if (found) {
            if (seg != null) {
                preShadowSegList.add(seg);
                postShadowSegList.add(seg);
            }
            ProtoSeismicPhase preShadow = new ProtoSeismicPhase(preShadowSegList, this.receiverDepth, this.phaseName);
            preShadow.calcEndSegRayParam();
            if (preShadow.countFlatLegs() == 0 && preShadow.endSegment().maxRayParam == preShadow.endSegment().minRayParam) {
                preShadow.failNext("Single ray parameter with no flat segments");
            }
            ProtoSeismicPhase postShadow = new ProtoSeismicPhase(postShadowSegList, this.receiverDepth, this.phaseName);
            postShadow.calcEndSegRayParam();
            if (postShadow.countFlatLegs() == 0 && postShadow.endSegment().maxRayParam == postShadow.endSegment().minRayParam) {
                postShadow.failNext("Single ray parameter with no flat segments");
            }
            if (preShadow.isFail) {
                return List.of(new ShadowOrProto(postShadow));
            }
            if (postShadow.isFail) {
                return List.of(new ShadowOrProto(preShadow));
            }
            if (preShadow.endSegment().minRayParam != postShadow.endSegment().maxRayParam) {
                throw new TauModelException("Shadow ray params don't match: " + preShadow.endSegment().maxRayParam + " != " + postShadow.endSegment().minRayParam);
            }
            ShadowZone shadow = new ShadowZone(preShadow.endSegment().minRayParam, hszBranch);
            return List.of(new ShadowOrProto(preShadow), new ShadowOrProto(shadow), new ShadowOrProto(postShadow));
        }
        return List.of(new ShadowOrProto(this));
    }

    public void calcEndSegRayParam() throws TauModelException {
        double maxRP = -1.0;
        double minRP = Double.MAX_VALUE;
        for (SeismicPhaseSegment s : this.segmentList) {
            maxRP = Math.max(maxRP, s.maxRayParam);
            minRP = Math.min(minRP, s.minRayParam);
        }
        SeismicPhaseSegment end = this.endSegment();
        if (end.maxRayParam != maxRP || end.minRayParam != minRP) {
            this.segmentList.remove(end);
            if (maxRP < minRP || maxRP < 0.0 || maxRP == minRP && this.countFlatLegs() == 0) {
                this.failNext("No ray parameters exists for phase");
            } else {
                this.addToBranch(end.endBranch, end.isPWave, end.isPWave, end.endAction, end.legName);
                this.endSegment().maxRayParam = maxRP;
                this.endSegment().minRayParam = minRP;
            }
        }
    }

    public final List<SeismicPhaseSegment> getSegmentList() {
        return this.segmentList;
    }

    public final SeismicPhaseSegment get(int i) {
        return this.segmentList.get(i);
    }

    public final boolean isEmpty() {
        return this.segmentList.isEmpty();
    }

    public final PhaseInteraction getEndAction() {
        if (this.isEmpty()) {
            return PhaseInteraction.START;
        }
        return this.endSegment().endAction;
    }

    public final SeismicPhaseSegment endSegment() {
        if (this.isEmpty()) {
            throw new RuntimeException("Segment list is empty");
        }
        return this.segmentList.get(this.segmentList.size() - 1);
    }

    public final SeismicPhaseSegment sourceSegment() {
        if (this.isEmpty()) {
            throw new RuntimeException("Segment list is empty");
        }
        return this.segmentList.get(0);
    }

    public boolean isSuccessful() {
        return !this.isFail && this.endSegment().endAction != PhaseInteraction.FAIL;
    }

    public final int size() {
        return this.segmentList.size();
    }

    public int countFlatLegs() {
        int countHeadLegs = 0;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (!seg.isFlat) continue;
            ++countHeadLegs;
        }
        return countHeadLegs;
    }

    public int countHeadLegs() {
        int countHeadLegs = 0;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (!seg.isFlat || seg.prevEndAction != PhaseInteraction.HEAD) continue;
            ++countHeadLegs;
        }
        return countHeadLegs;
    }

    public int countDiffLegs() {
        int countHeadLegs = 0;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (!seg.isFlat || seg.prevEndAction != PhaseInteraction.DIFFRACT && seg.prevEndAction != PhaseInteraction.TRANSUPDIFFRACT) continue;
            ++countHeadLegs;
        }
        return countHeadLegs;
    }

    public final void add(SeismicPhaseSegment seg) {
        if (seg.prevEndAction != PhaseInteraction.KMPS) {
            seg.prevEndAction = this.segmentList.isEmpty() ? PhaseInteraction.START : this.endSegment().endAction;
        }
        this.segmentList.add(seg);
    }

    public int calcStartBranch(String currLeg) {
        int currBranch = currLeg.endsWith("kmps") ? 0 : (!this.isEmpty() ? this.endSegment().endBranch + PhaseInteraction.endOffset(this.endSegment().endAction) : (PhaseSymbols.isDowngoingSymbol(currLeg) ? this.tMod.getSourceBranch() : this.tMod.getSourceBranch() - 1));
        return currBranch;
    }

    /*
     * Unable to fully structure code
     */
    public SeismicPhaseSegment addToBranch(int endBranch, boolean isPWave, boolean nextIsPWave, PhaseInteraction endAction, String currLeg) throws TauModelException {
        if (this.isFail) {
            return this.segmentList.get(this.segmentList.size() - 1);
        }
        startBranch = this.calcStartBranch(currLeg);
        if (startBranch < 0 || startBranch > this.tMod.getNumBranches()) {
            throw new TauModelException(this.getName() + ": start branch outside range: (0-" + this.tMod.getNumBranches() + ") " + startBranch);
        }
        if (endBranch < 0 || endBranch > this.tMod.getNumBranches()) {
            throw new TauModelException(this.getName() + ": end branch outside range: " + endBranch);
        }
        if (endAction == PhaseInteraction.TRANSUP && endBranch == 0) {
            this.failNext("cannot TRANSUP with end branch zero, already at surface: " + endBranch);
        }
        if (!isPWave && this.tMod.isFluidBranch(startBranch)) {
            this.failNext("Attempt to have S wave in fluid layer in " + this.getName() + " " + startBranch + " to " + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
        }
        prevEndAction = this.isEmpty() != false ? PhaseInteraction.START : this.endSegment().endAction;
        v0 = minRayParam = this.isEmpty() != false ? 0.0 : this.endSegment().minRayParam;
        if (!this.isEmpty()) ** GOTO lbl31
        if (PhaseSymbols.isDowngoingSymbol(currLeg) || this.tMod.getSourceDepth() == 0.0) {
            maxRayParam = this.tMod.getTauBranch(this.tMod.getSourceBranch(), isPWave).getMaxRayParam();
        } else if (PhaseSymbols.isUpgoingSymbol(currLeg)) {
            try {
                sLayerNum = this.tMod.getSlownessModel().layerNumberAbove(this.tMod.getSourceDepth(), isPWave);
                maxRayParam = this.tMod.getSlownessModel().getSlownessLayer(sLayerNum, isPWave).getBotP();
                highSZoneDepth = new DepthRange();
                if (!this.tMod.getSlownessModel().depthInHighSlowness(this.tMod.getSourceDepth(), maxRayParam, highSZoneDepth, isPWave)) ** GOTO lbl32
                maxRayParam = Math.min(maxRayParam, highSZoneDepth.rayParam);
            }
            catch (NoSuchLayerException e) {
                throw new TauModelException("Should not happen", e);
            }
        } else {
            throw new TauModelException("Unknown starting max ray param for " + currLeg + " in " + this.getName() + " at " + this.tMod.getSourceDepth());
lbl31:
            // 1 sources

            maxRayParam = this.endSegment().maxRayParam;
        }
lbl32:
        // 4 sources

        if (TauPConfig.DEBUG) {
            Alert.debug("before addToBranch: minRP=" + minRayParam + "  maxRP=" + maxRayParam);
            Alert.debug("  addToBranch( start=" + startBranch + " end=" + endBranch + " endAction=" + SeismicPhaseFactory.endActionString(endAction) + " " + currLeg + ") isP:" + (isPWave != false ? "P" : "S"));
        }
        if (endAction == PhaseInteraction.TURN || endAction == PhaseInteraction.DIFFRACTTURN) {
            if (isPWave != nextIsPWave && endAction == PhaseInteraction.TURN) {
                throw new TauModelException(this.getName() + " phase conversion not allowed for TURN");
            }
            endOffset = 0;
            isDownGoing = true;
            maxTurnInSegRayParam = this.tMod.getTauBranch(startBranch, isPWave).getTopRayParam();
            minTurnInSegRayParam = this.tMod.getTauBranch(startBranch, isPWave).getMinTurnRayParam();
            for (bnum = startBranch; bnum <= endBranch; ++bnum) {
                minTurnInSegRayParam = Math.min(minTurnInSegRayParam, this.tMod.getTauBranch(bnum, isPWave).getMinTurnRayParam());
            }
            minRayParam = Math.max(minRayParam, minTurnInSegRayParam);
            maxRayParam = Math.min(maxRayParam, maxTurnInSegRayParam);
            if (!isPWave) {
                for (bNum = startBranch + 1; bNum <= endBranch; ++bNum) {
                    if (!this.tMod.isFluidBranch(bNum)) continue;
                    endBranch = bNum - 1;
                    minRayParam = Math.max(minRayParam, this.tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
                    break;
                }
            }
            for (bNum = endBranch; bNum >= startBranch && (tauBranch = this.tMod.getTauBranch(bNum, isPWave)).isHighSlowness() && (bNum + 1 >= this.tMod.getNumBranches() || bNum > startBranch && tauBranch.getMinTurnRayParam() > this.tMod.getTauBranch(bNum - 1, isPWave).getBotRayParam() || tauBranch.getMinTurnRayParam() >= this.tMod.getTauBranch(bNum + 1, isPWave).getTopRayParam()); --bNum) {
                if (TauPConfig.DEBUG) {
                    Alert.debug("Warn, ray cannot turn in layer " + bNum + " due to high slowness layer " + tauBranch.getBotDepth());
                }
                endBranch = bNum - 1;
            }
            if (TauPConfig.DEBUG) {
                Alert.debug("after addToBranch: minRP=" + minRayParam + "  maxRP=" + maxRayParam);
            }
        } else if (endAction == PhaseInteraction.REFLECT_UNDERSIDE || endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
            endOffset = 0;
            isDownGoing = false;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, isPWave).getTopRayParam());
            if (isPWave != nextIsPWave) {
                maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, nextIsPWave).getMaxRayParam());
            }
            if (endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                minRayParam = Math.max(minRayParam, this.tMod.getTauBranch(endBranch - 1, isPWave).getBotRayParam());
            }
        } else if (endAction == PhaseInteraction.END) {
            endOffset = 0;
            isDownGoing = false;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, isPWave).getTopRayParam());
        } else if (endAction == PhaseInteraction.END_DOWN) {
            endOffset = 0;
            isDownGoing = true;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, isPWave).getBotRayParam());
        } else if (endAction == PhaseInteraction.REFLECT_TOPSIDE || endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
            endOffset = 0;
            isDownGoing = true;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, isPWave).getBotRayParam());
            if (isPWave != nextIsPWave) {
                maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, nextIsPWave).getMinTurnRayParam());
            }
            if (endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                minRayParam = Math.max(minRayParam, this.tMod.getTauBranch(endBranch + 1, isPWave).getTopRayParam());
            }
        } else if (endAction == PhaseInteraction.TRANSUP) {
            endOffset = -1;
            isDownGoing = false;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, isPWave).getTopRayParam());
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch - 1, nextIsPWave).getBotRayParam());
        } else if (endAction == PhaseInteraction.TRANSDOWN) {
            endOffset = 1;
            isDownGoing = true;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            if (endBranch == this.tMod.getNumBranches() - 1) {
                this.failNext(" Cannot TRANSDOWN center of earth, endBranch: " + endBranch + " == numBranchs: " + this.tMod.getNumBranches());
            }
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch + 1, nextIsPWave).getTopRayParam());
        } else if (endAction == PhaseInteraction.HEAD) {
            if (endBranch == this.tMod.getNumBranches() - 1) {
                this.failNext(" Cannot head wave at center of earth, endBranch: " + endBranch + " == numBranchs: " + this.tMod.getNumBranches());
            }
            endOffset = 0;
            isDownGoing = true;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch + 1, nextIsPWave).getTopRayParam());
            minRayParam = Math.max(minRayParam, maxRayParam);
        } else if (endAction == PhaseInteraction.DIFFRACT) {
            if (endBranch == this.tMod.getNumBranches() - 1) {
                this.failNext("No diffraction if diffraction is at center of earth.");
                minRayParam = -1.0;
                maxRayParam = -1.0;
            }
            endOffset = 0;
            isDownGoing = true;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            if (isPWave != nextIsPWave) {
                maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch, nextIsPWave).getMinTurnRayParam());
            }
            minRayParam = Math.max(minRayParam, maxRayParam);
            if (this.tMod.getTauBranch(endBranch, isPWave).isHighSlowness()) {
                this.failNext("No diffraction as above branch is a high slowness gradient");
                minRayParam = -1.0;
                maxRayParam = -1.0;
            }
        } else if (endAction == PhaseInteraction.TRANSUPDIFFRACT) {
            endOffset = -1;
            isDownGoing = false;
            maxRayParam = this.calcMaxTransitRP(startBranch, endBranch, isPWave, prevEndAction, maxRayParam);
            maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(endBranch - 1, nextIsPWave).getMinTurnRayParam());
            minRayParam = Math.max(minRayParam, maxRayParam);
            if (this.tMod.getTauBranch(endBranch - 1, nextIsPWave).isHighSlowness()) {
                this.failNext("No transup diffraction as above branch is a high slowness gradient");
                minRayParam = -1.0;
                maxRayParam = -1.0;
            }
        } else {
            throw new TauModelException(this.getName() + ": Illegal endAction: endAction=" + endAction);
        }
        segment = new SeismicPhaseSegment(this.tMod, startBranch, endBranch, isPWave, endAction, isDownGoing, currLeg, minRayParam, maxRayParam);
        if (!(isPWave || currLeg.startsWith("K") || currLeg.equals("k"))) {
            for (i = Math.min(startBranch, endBranch); i <= Math.max(startBranch, endBranch); ++i) {
                tb = this.tMod.getTauBranch(i, isPWave);
                for (DepthRange fluidDR : this.tMod.getSlownessModel().fluidLayerDepths) {
                    if (!(tb.getTopDepth() >= fluidDR.topDepth && tb.getTopDepth() < fluidDR.botDepth) && (!(tb.getBotDepth() > fluidDR.topDepth) || !(tb.getBotDepth() <= fluidDR.botDepth))) continue;
                    this.failNext("S wave branch " + currLeg + "(" + isPWave + ") in " + this.getName() + " is in fluid: " + tb + " " + fluidDR + " " + startBranch + " " + endBranch + " " + isDownGoing);
                }
            }
        }
        if (isDownGoing) {
            if (startBranch > endBranch) {
                minRayParam = -1.0;
                maxRayParam = -1.0;
                this.failNext("can't be downgoing as we are already below: " + startBranch + " " + endBranch + " in " + this.getName());
            } else if (TauPConfig.DEBUG) {
                for (i = startBranch; i <= endBranch; ++i) {
                    Alert.debug("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
                }
            }
        } else if (startBranch < endBranch) {
            minRayParam = -1.0;
            maxRayParam = -1.0;
            this.failNext("can't be upgoing as we are already above: " + startBranch + " " + endBranch + " " + currLeg + " in " + this.getName());
        } else if (TauPConfig.DEBUG) {
            for (i = startBranch; i >= endBranch; --i) {
                Alert.debug("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
            }
        }
        if (TauPConfig.DEBUG) {
            Alert.debug("after addToBranch: minRP=" + minRayParam + "  maxRP=" + maxRayParam + " endOffset=" + endOffset + " isDownGoing=" + isDownGoing);
        }
        this.add(segment);
        return segment;
    }

    protected double calcMaxTransitRP(int startBranch, int endBranch, boolean isPWave, PhaseInteraction prevEndAction, double maxRayParam) {
        if (prevEndAction != PhaseInteraction.TURN) {
            for (int bnum = startBranch; bnum <= endBranch; ++bnum) {
                maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(bnum, isPWave).getTopRayParam());
                maxRayParam = Math.min(maxRayParam, this.tMod.getTauBranch(bnum, isPWave).getBotRayParam());
            }
        }
        return maxRayParam;
    }

    protected SeismicPhaseSegment addFlatBranch(boolean isPWave, PhaseInteraction prevEndAction, PhaseInteraction endAction, String currLeg) throws TauModelException {
        SeismicPhaseSegment flatSegment;
        double maxRayParam;
        double minRayParam;
        switch (endAction) {
            case TRANSDOWN: 
            case TRANSUP: 
            case END: 
            case END_DOWN: 
            case FAIL: 
            case DIFFRACTTURN: {
                break;
            }
            default: {
                throw new TauModelException("End action for flat branch not allowed: " + endAction);
            }
        }
        switch (prevEndAction) {
            case DIFFRACT: 
            case TRANSUPDIFFRACT: 
            case HEAD: 
            case KMPS: {
                break;
            }
            case END: 
            case END_DOWN: 
            case FAIL: {
                throw new TauModelException("Phase already finished: " + prevEndAction);
            }
            default: {
                throw new TauModelException("End action before flat branch not allowed: " + endAction);
            }
        }
        int branch = this.calcStartBranch(currLeg);
        boolean flatIsDownGoing = false;
        if (prevEndAction == PhaseInteraction.KMPS) {
            double velocity = Double.parseDouble(currLeg.substring(0, currLeg.length() - 4));
            maxRayParam = minRayParam = this.tMod.radiusOfEarth / velocity;
            flatSegment = new SeismicPhaseSegment(this.tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg, minRayParam, maxRayParam);
        } else {
            double d = minRayParam = this.isEmpty() ? 0.0 : this.endSegment().minRayParam;
            if (this.isEmpty()) {
                throw new TauModelException("Cannot have flat leg as starting leg in phase: " + currLeg + " " + this.getName());
            }
            maxRayParam = this.endSegment().maxRayParam;
            if (TauPConfig.DEBUG) {
                Alert.debug("before addFlatBranch: minRP=" + minRayParam + "  maxRP=" + maxRayParam);
                Alert.debug("addFlatBranch( " + branch + " endAction=" + SeismicPhaseFactory.endActionString(endAction) + " " + currLeg + ") isP:" + (isPWave ? "P" : "S"));
            }
            if (prevEndAction == PhaseInteraction.HEAD) {
                double headRP = this.tMod.getTauBranch(branch, isPWave).getMaxRayParam();
                if (minRayParam > headRP || maxRayParam < headRP) {
                    minRayParam = -1.0;
                    maxRayParam = -1.0;
                    return this.failNext("Head wave ray parameter, " + headRP + ", outside of min,max rayparameter for phase " + minRayParam + " " + maxRayParam);
                }
                minRayParam = headRP;
                maxRayParam = headRP;
                flatSegment = new SeismicPhaseSegment(this.tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg, minRayParam, maxRayParam);
            } else if (prevEndAction == PhaseInteraction.DIFFRACT || prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                double diffRP = this.tMod.getTauBranch(branch, isPWave).getMinTurnRayParam();
                if (minRayParam > diffRP || maxRayParam < diffRP) {
                    minRayParam = -1.0;
                    maxRayParam = -1.0;
                    return this.failNext("Diffraction ray parameter, " + diffRP + ", outside of min,max rayparameter for phase " + minRayParam + " " + maxRayParam);
                }
                minRayParam = diffRP;
                maxRayParam = diffRP;
                flatSegment = new SeismicPhaseSegment(this.tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg, minRayParam, maxRayParam);
            } else {
                throw new TauModelException("Cannot addFlatBranch for prevEndAction: " + prevEndAction + " for " + currLeg);
            }
        }
        flatSegment.isFlat = true;
        flatSegment.prevEndAction = prevEndAction;
        if (TauPConfig.DEBUG) {
            Alert.debug("after addFlatBranch: minRP=" + minRayParam + "  maxRP=" + maxRayParam);
        }
        this.add(flatSegment);
        return flatSegment;
    }

    public int calcInteractionNumber() {
        int count = 0;
        SeismicPhaseSegment prev = null;
        if (this.segmentList.size() > 30) {
            return 9999999;
        }
        for (SeismicPhaseSegment seg : this.segmentList) {
            switch (seg.endAction) {
                case REFLECT_TOPSIDE: 
                case REFLECT_TOPSIDE_CRITICAL: 
                case REFLECT_UNDERSIDE: 
                case REFLECT_UNDERSIDE_CRITICAL: 
                case SCATTER: 
                case BACKSCATTER: 
                case SCATTER_DOWN: 
                case BACKSCATTER_DOWN: {
                    ++count;
                }
            }
            if (prev != null && prev.isPWave != seg.isPWave) {
                ++count;
            }
            prev = seg;
        }
        return count;
    }

    public String phaseNameForSegments() {
        return this.phaseNameForSegments(true);
    }

    public String phaseNameForSegments(boolean zapED) {
        Object name = "";
        if (this.segmentList.isEmpty()) {
            return name;
        }
        if (this.segmentList.size() == 1 && this.segmentList.get((int)0).legName.endsWith("kmps")) {
            return this.segmentList.get((int)0).legName;
        }
        TauModel tMod = this.segmentList.get((int)0).tMod;
        SeismicPhaseSegment seg = null;
        SeismicPhaseSegment next = this.segmentList.get(0);
        block11: for (int idx = 0; idx < this.segmentList.size(); ++idx) {
            SeismicPhaseSegment prev = seg;
            seg = next;
            if (seg.endAction == PhaseInteraction.FAIL) {
                name = (String)name + "FAIL";
                return name;
            }
            if (idx < this.segmentList.size() - 1) {
                next = this.segmentList.get(idx + 1);
            }
            double botDepth = tMod.getTauBranch(seg.endBranch, seg.isPWave).getBotDepth();
            double topDepth = tMod.getTauBranch(seg.endBranch, seg.isPWave).getTopDepth();
            if (prev == null || prev.endAction != PhaseInteraction.TURN || prev.isPWave != seg.isPWave || !prev.legName.equalsIgnoreCase(seg.legName) && prev.legName.equals("I") && seg.legName.equals("y")) {
                String legName = ProtoSeismicPhase.legNameForSegment(tMod, seg);
                String nextLegName = ProtoSeismicPhase.legNameForSegment(tMod, next);
                if (zapED && legName.endsWith("ed")) {
                    if ((seg.endAction == PhaseInteraction.DIFFRACT || seg.endAction == PhaseInteraction.HEAD) && seg.isPWave == next.isPWave) {
                        legName = legName.substring(0, 1);
                    } else if (!(seg.endAction != PhaseInteraction.TRANSDOWN || !legName.startsWith("P") && !legName.startsWith("S") || nextLegName.startsWith("P") || nextLegName.startsWith("S") || !legName.startsWith("K") || nextLegName.startsWith("K") || !legName.startsWith("I") && !legName.startsWith("J") || nextLegName.startsWith("I") || nextLegName.startsWith("J"))) {
                        legName = legName.substring(0, 1);
                    } else if (seg.endAction == PhaseInteraction.REFLECT_TOPSIDE || seg.endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL || seg.endAction == PhaseInteraction.TRANSDOWN && (botDepth == tMod.cmbDepth || botDepth == tMod.iocbDepth)) {
                        legName = legName.substring(0, 1);
                    }
                }
                if (!(seg.endAction != PhaseInteraction.END && seg.endAction != PhaseInteraction.REFLECT_UNDERSIDE && (seg.endAction != PhaseInteraction.TURN && seg.endAction != PhaseInteraction.DIFFRACTTURN && seg.endAction != PhaseInteraction.TRANSUP && seg.endAction != PhaseInteraction.REFLECT_UNDERSIDE || next.endBranch != 0) || prev == null || prev.endAction != PhaseInteraction.DIFFRACT && prev.endAction != PhaseInteraction.DIFFRACTTURN && prev.endAction != PhaseInteraction.HEAD && prev.endAction != PhaseInteraction.TRANSUP || seg.isPWave != prev.isPWave || !seg.legName.equals(prev.legName))) {
                    legName = "";
                } else if (prev != null && prev.endAction == PhaseInteraction.TURN && prev.isPWave == seg.isPWave && !seg.isDownGoing) {
                    legName = "";
                }
                if (seg.isFlat && prev.isPWave == seg.isPWave) {
                    legName = "";
                }
                name = (String)name + legName;
            }
            switch (seg.endAction) {
                case REFLECT_TOPSIDE: {
                    if (botDepth == tMod.cmbDepth) {
                        name = (String)name + "c";
                        continue block11;
                    }
                    if (botDepth == tMod.iocbDepth) {
                        name = (String)name + "i";
                        continue block11;
                    }
                    if (botDepth == tMod.mohoDepth) {
                        name = (String)name + "vm";
                        continue block11;
                    }
                    name = (String)name + "v" + (int)botDepth;
                    continue block11;
                }
                case REFLECT_TOPSIDE_CRITICAL: {
                    name = (String)name + "V";
                    if (botDepth == tMod.cmbDepth) {
                        name = (String)name + "c";
                        continue block11;
                    }
                    if (botDepth == tMod.iocbDepth) {
                        name = (String)name + "i";
                        continue block11;
                    }
                    if (botDepth == tMod.mohoDepth) {
                        name = (String)name + "m";
                        continue block11;
                    }
                    name = (String)name + (int)botDepth;
                    continue block11;
                }
                case REFLECT_UNDERSIDE: {
                    if (topDepth == 0.0 || topDepth == tMod.cmbDepth || topDepth == tMod.iocbDepth) continue block11;
                    if (topDepth == tMod.mohoDepth) {
                        name = (String)name + "^m";
                        continue block11;
                    }
                    name = (String)name + "^" + (int)topDepth;
                    continue block11;
                }
                case TURN: 
                case DIFFRACTTURN: {
                    continue block11;
                }
                case TRANSDOWN: {
                    if (seg.isFlat || botDepth == tMod.cmbDepth || botDepth == tMod.iocbDepth) continue block11;
                    if (botDepth == tMod.mohoDepth) {
                        name = (String)name + "m";
                        continue block11;
                    }
                    name = (String)name + (int)botDepth;
                    continue block11;
                }
                case TRANSUP: {
                    if (topDepth == tMod.cmbDepth || topDepth == tMod.iocbDepth || topDepth == tMod.surfaceDepth || topDepth == tMod.mohoDepth && (next.endAction == PhaseInteraction.END || next.endAction == PhaseInteraction.REFLECT_UNDERSIDE && next.endBranch == 0) && seg.isPWave == next.isPWave) continue block11;
                    if (topDepth == tMod.mohoDepth) {
                        name = (String)name + "m";
                        continue block11;
                    }
                    name = (String)name + (int)topDepth;
                    continue block11;
                }
                case HEAD: {
                    name = (String)name + "n";
                    continue block11;
                }
                case DIFFRACT: 
                case TRANSUPDIFFRACT: {
                    String diff = "diff";
                    if (next != null && next.endAction == PhaseInteraction.TRANSDOWN) {
                        diff = "diffdn";
                    }
                    if (seg.endAction == PhaseInteraction.DIFFRACT) {
                        if (botDepth == tMod.cmbDepth || botDepth == tMod.iocbDepth) {
                            name = (String)name + diff;
                            continue block11;
                        }
                        name = (String)name + (int)botDepth + diff;
                        continue block11;
                    }
                    if (seg.endAction != PhaseInteraction.TRANSUPDIFFRACT) continue block11;
                    if (topDepth == tMod.cmbDepth || topDepth == tMod.iocbDepth) {
                        name = (String)name + diff;
                        continue block11;
                    }
                    name = (String)name + (int)topDepth + diff;
                    continue block11;
                }
                case END: 
                case END_DOWN: {
                    continue block11;
                }
                default: {
                    name = (String)name + seg.endAction.name();
                }
            }
        }
        return name;
    }

    public static String legNameForSegment(TauModel tMod, SeismicPhaseSegment seg) {
        return ProtoSeismicPhase.legNameForSegment(tMod, seg.endBranch, seg.isPWave, seg.isDownGoing, seg.isFlat, seg.endAction);
    }

    public static String legNameForSegment(TauModel tMod, int endBranch, boolean isPWave, boolean isDownGoing, boolean isFlat, PhaseInteraction endAction) {
        String name = SeismicPhaseWalk.legNameForTauBranch(tMod, endBranch, isPWave, isDownGoing, isFlat);
        if (endAction == PhaseInteraction.TURN && name.endsWith("ed")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    public List<Integer> branchNumSeg() {
        ArrayList<Integer> branchSeq = new ArrayList<Integer>();
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (seg.endAction == PhaseInteraction.FAIL) break;
            int indexIncr = seg.isDownGoing ? 1 : -1;
            int finish = seg.endBranch + indexIncr;
            for (int branchNum = seg.startBranch; branchNum != finish; branchNum += indexIncr) {
                branchSeq.add(branchNum);
            }
        }
        return branchSeq;
    }

    public String branchNumSeqStr() {
        Object out = "";
        for (Integer i : this.branchNumSeg()) {
            out = (String)out + i + " ";
        }
        return ((String)out).trim();
    }

    public String branchNumSeqStrWithSegBreaks() {
        StringBuilder out = new StringBuilder();
        for (SeismicPhaseSegment seg : this.segmentList) {
            out.append(seg.legName);
            if (seg.endAction == PhaseInteraction.FAIL) break;
            int indexIncr = seg.isDownGoing ? 1 : -1;
            int finish = seg.endBranch + indexIncr;
            for (int branchNum = seg.startBranch; branchNum != finish; branchNum += indexIncr) {
                out.append(" ").append(branchNum);
            }
            out.append(" " + seg.endAction).append(",");
        }
        return out.toString();
    }

    public SimpleSeismicPhase asSeismicPhase() throws TauModelException {
        return SeismicPhaseFactory.sumBranches(this);
    }

    public String getName() {
        if (this.phaseName != null) {
            return this.phaseName;
        }
        return this.getPuristName();
    }

    public String getPuristName() {
        String pure = this.phaseNameForSegments();
        return pure;
    }

    public TauModel gettMod() {
        return this.tMod;
    }

    public String segmentListAsString() {
        StringBuffer sb = new StringBuffer();
        for (SeismicPhaseSegment seg : this.segmentList) {
            sb.append(", " + seg.startBranch + " as " + (seg.isPWave ? "P" : "S") + " " + seg.endBranch + " then " + seg.endAction);
        }
        return sb.substring(2);
    }

    @Override
    public int compareTo(ProtoSeismicPhase o) {
        return this.phaseName.compareTo(o.phaseName);
    }
}

