/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.PhaseParseException;
import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.VelocityModel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegPuller {
    public static final String number = "((([0-9]*[.])?[0-9]+)|([0-9]*[.]))";
    public static final String customDiscon = "(_[a-zA-Z][0-9a-zA-Z-]*_)";
    public static final String discon = "[mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)";
    public static final String travelSuffix = "((?:diffdn)|(?:diff)|(?:ed)|n|g)";
    public static final String headDiffRE = "(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))";
    public static final String namedHeadDiffRE = "(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diffdn)|(?:diff)|n))";
    public static final String upDiffRE = "(([pskyj]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)(?<hd>(?:diff)))";
    public static final String travelLeg = "(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))";
    public static final String interactPrefix = "[vV^]";
    public static final String interactPointsRE = "(([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))";
    public static final String surfaceWave = "(((([0-9]*[.])?[0-9]+)|([0-9]*[.]))kmps)";
    public static final String bodyWave = "(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*";
    public static final String scatterWave = "(?<inscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)(?<scat>[oO])(?<outscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)";
    public static final Pattern phaseRegEx = Pattern.compile("^((((([0-9]*[.])?[0-9]+)|([0-9]*[.]))kmps)|(?<inscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)(?<scat>[oO])(?<outscat>(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)|(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_)))?(([PpSsKkIyJj]((?:diffdn)|(?:diff)|(?:ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))|(_[a-zA-Z][0-9a-zA-Z-]*_))?)((?:diffdn)|(?:diff)|n))))*)$");
    public static final double DISCON_DEPTH_TOLERANCE = 10.0;

    public static boolean regExCheck(String name) {
        Matcher m = phaseRegEx.matcher(name);
        return m.matches();
    }

    protected static ArrayList<String> legPuller(String name) throws PhaseParseException {
        int offset = 0;
        ArrayList<String> legs = new ArrayList<String>();
        if (name.endsWith("kmps")) {
            legs.add(name);
        } else {
            while (offset < name.length()) {
                if (offset + 2 < name.length() && name.startsWith("ed", offset + 1) && !PhaseSymbols.isDowngoingSymbol(name, offset)) {
                    throw new PhaseParseException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by ed in " + name + " at " + offset, name, offset);
                }
                if (PhaseSymbols.isUpgoingSymbol(name, offset)) {
                    if (PhaseSymbols.isUpDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'm') {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'c' || name.charAt(offset) == 'i') {
                    if (offset == name.length() - 1) {
                        throw new PhaseParseException("Invalid phase name:\n" + name.charAt(offset) + " cannot be last char in " + name + " at " + offset, name, offset);
                    }
                    if (name.charAt(offset + 1) == 'x') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'I' || name.charAt(offset) == 'J') {
                    if (offset + 1 == name.length() || name.charAt(offset + 1) == 'c' || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || PhaseSymbols.isUpgoingSymbol(name, offset + 1) && !PhaseSymbols.isInnerCoreLeg(name, offset + 1)) {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (name.length() >= offset + 3 && PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isHead(name, offset)) {
                        String headLeg = name.substring(offset, name.indexOf("n", offset + 1) + "n".length());
                        legs.add(headLeg);
                        offset += headLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffractedDown(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diffdn", offset + 1) + "diffdn".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    throw new PhaseParseException("Invalid phase name:\n" + name.substring(offset) + " in " + name + " at " + offset, name, offset);
                }
                if (name.charAt(offset) == 'P' || name.charAt(offset) == 'S') {
                    if (offset + 1 == name.length() || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c') {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (PhaseSymbols.isUpgoingSymbol(name, offset + 1)) {
                        throw new PhaseParseException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by upgoing phase" + name.charAt(offset + 1) + " in " + name + " at " + offset, name, offset);
                    }
                    if (name.charAt(offset + 1) == 'g' || name.charAt(offset + 1) == 'b') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        if (name.length() > offset + 3 && PhaseSymbols.isBoundary(name, offset + 3)) {
                            offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 3, legs);
                            continue;
                        }
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isHead(name, offset)) {
                        String headLeg = name.substring(offset, name.indexOf("n", offset + 1) + "n".length());
                        legs.add(headLeg);
                        offset += headLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffractedDown(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diffdn", offset + 1) + "diffdn".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    throw new PhaseParseException("Invalid phase name:\n" + name.substring(offset) + " in " + name + " at " + offset, name, offset);
                }
                if (name.charAt(offset) == 'K') {
                    if (offset + 1 == name.length() || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isUpgoingSymbol(name, offset + 1) && PhaseSymbols.isCrustMantleLeg(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isHead(name, offset)) {
                        String headLeg = name.substring(offset, name.indexOf("n", offset + 1) + "n".length());
                        legs.add(headLeg);
                        offset += headLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffractedDown(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diffdn", offset + 1) + "diffdn".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    throw new PhaseParseException("Invalid phase name:\n" + name.substring(offset) + " in " + name + " at " + offset, name, offset);
                }
                if (PhaseSymbols.isScatterSymbol(name, offset)) {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (PhaseSymbols.isReflectSymbol(name, offset)) {
                    if (offset == name.length() - 1) {
                        throw new PhaseParseException("Invalid phase name:\n" + name.charAt(offset) + " reflection cannot be last char in " + name + " at " + offset, name, offset);
                    }
                    int criticalOffset = 0;
                    if (name.charAt(offset + 1) == 'x') {
                        criticalOffset = 1;
                    }
                    if (name.charAt(offset + criticalOffset + 1) == 'm' || name.charAt(offset + criticalOffset + 1) == 'c' || name.charAt(offset + criticalOffset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + criticalOffset + 2));
                        offset = offset + criticalOffset + 2;
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + criticalOffset + 1)) {
                        String prefix = name.substring(offset, offset + criticalOffset + 1);
                        String boundId = LegPuller.extractBoundaryId(name, offset + criticalOffset + 1, false);
                        legs.add(prefix + boundId);
                        if ((offset += prefix.length() + boundId.length()) != name.length()) continue;
                        throw new PhaseParseException("Invalid phase name:\n" + prefix + " followed by " + boundId + " cannot be last in " + name + " at " + offset, name, offset);
                    }
                    throw new PhaseParseException("Invalid phase name:\n" + name.substring(offset) + " in " + name + " at " + offset, name, offset);
                }
                if (PhaseSymbols.isBoundary(name, offset)) {
                    String boundId = LegPuller.extractBoundaryId(name, offset, false);
                    legs.add(boundId);
                    if ((offset += boundId.length()) != name.length()) continue;
                    throw new PhaseParseException("Invalid phase name: " + boundId + " cannot be last in " + name + " at " + offset, name, offset);
                }
                throw new PhaseParseException("Invalid phase name at " + name.substring(offset) + " in " + name + " at " + offset + " '" + name.substring(0, offset) + "' '" + name.substring(offset) + "'", name, offset);
            }
        }
        legs.add("END");
        String validationMsg = LegPuller.phaseValidate(legs);
        if (validationMsg != null) {
            throw new PhaseParseException("Phase failed validation: " + name + "  " + validationMsg, name, 0);
        }
        return legs;
    }

    public static int extractPhaseBoundaryInteraction(String name, int offset, int phaseCharLength, List<String> legs) throws PhaseParseException {
        int idx = offset;
        String phaseChar = name.substring(offset, offset + phaseCharLength);
        String boundId = LegPuller.extractBoundaryId(name, idx += phaseCharLength, true);
        if (boundId.isEmpty()) {
            throw new PhaseParseException("Got empty boundary from extractBoundaryId() in phaseBoundary " + phaseChar + " " + offset + " in " + name, name, offset);
        }
        if (boundId.endsWith("diff") || boundId.endsWith("diffdn") || boundId.endsWith("n")) {
            legs.add(phaseChar + boundId);
            idx += boundId.length();
        } else {
            if (offset + phaseChar.length() + boundId.length() == name.length()) {
                throw new PhaseParseException("Invalid phase name: " + phaseChar + " cannot be followed by " + boundId + " in " + name, name, offset);
            }
            legs.add(phaseChar);
            legs.add(boundId);
            idx += boundId.length();
        }
        return idx;
    }

    public static String extractBoundaryId(String name, int offset, boolean includeHeadDiff) throws PhaseParseException {
        int startIdx;
        if (offset == name.length() - 1) {
            throw new PhaseParseException("Invalid phase name:\n" + name.charAt(offset) + " cannot be last char in " + name, name, offset);
        }
        int idx = startIdx = offset;
        if (PhaseSymbols.isCustomBoundarySymbol(name, startIdx)) {
            idx = name.indexOf(95, startIdx + 1);
            if (idx == -1) {
                throw new PhaseParseException("Unable to find end custom discon symbol: _ in " + name.substring(startIdx), name, offset);
            }
            ++idx;
        } else {
            while (startIdx < name.length() && !PhaseSymbols.isBoundary(name, startIdx)) {
                ++startIdx;
            }
            for (idx = startIdx; idx < name.length() && PhaseSymbols.isBoundary(name, idx); ++idx) {
            }
        }
        if (includeHeadDiff && name.length() >= idx + "diff".length() && name.startsWith("diff", idx)) {
            idx += "diff".length();
        } else if (includeHeadDiff && name.length() >= idx + "diffdn".length() && name.startsWith("diffdn", idx)) {
            idx += "diffdn".length();
        } else if (includeHeadDiff && idx < name.length() && name.startsWith("n", idx)) {
            ++idx;
        }
        if (idx == offset) {
            throw new PhaseParseException("Attempt to extract boundary but empty starting at " + offset + " in " + name, name, offset);
        }
        return name.substring(offset, idx);
    }

    public static boolean isBoundary(String leg) {
        if (leg.length() == 1 && (leg.charAt(0) == 'm' || leg.charAt(0) == 'c' || leg.charAt(0) == 'i')) {
            return true;
        }
        if (PhaseSymbols.isCustomBoundarySymbol(leg, 0) && PhaseSymbols.isCustomBoundarySymbol(leg, leg.length() - 1)) {
            return true;
        }
        try {
            Double.parseDouble(leg);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Double legAsDepthBoundary(TauModel tMod, String leg) {
        int branch = LegPuller.closestDisconBranchToDepth(tMod, leg);
        return tMod.getTauBranch(branch, true).getTopDepth();
    }

    public static int closestDisconBranchToDepth(TauModel tMod, String depthString) {
        return LegPuller.closestDisconBranchToDepth(tMod, depthString, 10.0);
    }

    public static int closestDisconBranchToDepth(TauModel tMod, String depthString, double tolerance) {
        switch (depthString) {
            case "m": {
                return tMod.getMohoBranch();
            }
            case "c": {
                return tMod.getCmbBranch();
            }
            case "i": {
                return tMod.getIocbBranch();
            }
        }
        if (depthString.charAt(0) == '_') {
            VelocityModel vMod = tMod.getVelocityModel();
            String customName = depthString.substring(1, depthString.indexOf(95, 1));
            for (NamedVelocityDiscon namedDiscon : vMod.namedDiscon) {
                if (!customName.equalsIgnoreCase(namedDiscon.getName()) && !customName.equalsIgnoreCase(namedDiscon.getPreferredName())) continue;
                try {
                    return tMod.findBranch(namedDiscon.getDepth());
                }
                catch (TauModelException e) {
                    Alert.debug("Unable to find tau branch for named discon: " + namedDiscon);
                    return -1;
                }
            }
            Alert.debug("Unable to find named discontinuity " + customName + " within velocity model " + vMod.modelName);
            return -1;
        }
        int disconBranch = -1;
        double disconMax = tolerance;
        double disconDepth = Double.parseDouble(depthString);
        TauBranch tBranch = tMod.getTauBranch(0, true);
        for (int i = 0; i < tMod.getNumBranches(); ++i) {
            double foundDepth;
            double depthDelta;
            if (!tMod.isDiscontinuityBranch(i, true) && !tMod.isDiscontinuityBranch(i, false) || !((depthDelta = Math.abs(disconDepth - (foundDepth = (tBranch = tMod.getTauBranch(i, true)).getTopDepth()))) < disconMax) || tMod.isNoDisconDepth(foundDepth)) continue;
            disconBranch = i;
            disconMax = Math.abs(disconDepth - foundDepth);
        }
        if (disconBranch == -1) {
            // empty if block
        }
        return disconBranch;
    }

    public static String createPuristName(TauModel tMod, List<String> legs) {
        StringBuilder puristName = new StringBuilder();
        String currLeg = legs.get(0);
        if (legs.size() == 2 && currLeg.endsWith("kmps")) {
            puristName.append(legs.get(0));
            return puristName.toString();
        }
        Pattern reflectDepthPattern = Pattern.compile("[Vv^][0-9.]+");
        for (int legNum = 0; legNum < legs.size() - 1; ++legNum) {
            int intLegDepth;
            double legDepth;
            int disconBranch;
            currLeg = legs.get(legNum);
            Matcher matcher = reflectDepthPattern.matcher(currLeg);
            if (matcher.matches()) {
                puristName.append(currLeg.charAt(0));
                disconBranch = LegPuller.closestDisconBranchToDepth(tMod, currLeg.substring(1));
                if (disconBranch == tMod.getMohoBranch()) {
                    puristName.append('m');
                    continue;
                }
                if (disconBranch == tMod.getCmbBranch()) {
                    puristName.append('c');
                    continue;
                }
                if (disconBranch == tMod.getIocbBranch()) {
                    puristName.append('i');
                    continue;
                }
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    puristName.append(intLegDepth);
                    continue;
                }
                puristName.append(legDepth);
                continue;
            }
            try {
                Double.parseDouble(currLeg);
                disconBranch = LegPuller.closestDisconBranchToDepth(tMod, currLeg);
                if (disconBranch == tMod.getMohoBranch()) {
                    puristName.append('m');
                    continue;
                }
                if (disconBranch == tMod.getCmbBranch()) {
                    puristName.append('c');
                    continue;
                }
                if (disconBranch == tMod.getIocbBranch()) {
                    puristName.append('i');
                    continue;
                }
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    puristName.append(intLegDepth);
                    continue;
                }
                puristName.append(legDepth);
                continue;
            }
            catch (NumberFormatException e) {
                puristName.append(currLeg);
            }
        }
        return puristName.toString();
    }

    public static String phaseValidate(ArrayList<String> legs) {
        String currToken = legs.get(0);
        boolean prevIsReflect = false;
        if (legs.size() == 2 && (PhaseSymbols.isDiffracted(currToken, 0) || PhaseSymbols.isSurfaceWave(currToken, 0)) && legs.get(1).equals("END")) {
            return null;
        }
        Pattern headDiffRegEx = Pattern.compile(headDiffRE);
        if (!(PhaseSymbols.is(currToken, "Pg") || PhaseSymbols.is(currToken, "Pb") || PhaseSymbols.is(currToken, "Sg") || PhaseSymbols.is(currToken, "Sb") || PhaseSymbols.is(currToken, "Ped") || PhaseSymbols.is(currToken, "Sed") || PhaseSymbols.is(currToken, 'P') || PhaseSymbols.is(currToken, 'S') || PhaseSymbols.is(currToken, 'p') || PhaseSymbols.is(currToken, 's') || PhaseSymbols.is(currToken, 'K') || PhaseSymbols.is(currToken, "Ked") || PhaseSymbols.is(currToken, 'k') || PhaseSymbols.is(currToken, 'I') || PhaseSymbols.is(currToken, 'J') || PhaseSymbols.is(currToken, 'y') || PhaseSymbols.is(currToken, 'j') || headDiffRegEx.matcher(currToken).matches())) {
            return "First leg (" + currToken + ") must be one of Pg, Pb, Pn, Pdiff, Sg, Sb, Sn, Sdiff, P, S, p, s, Ped, Sed, k, K, Ked, I, J, y, j,  or like P410diff or P410n";
        }
        for (int i = 1; i < legs.size(); ++i) {
            String prevToken = currToken;
            currToken = legs.get(i);
            if (currToken.isEmpty()) {
                return "currToken is empty, after " + prevToken + " " + i + "/" + legs.size();
            }
            String nextToken = i < legs.size() - 1 ? legs.get(i + 1) : "";
            if ((PhaseSymbols.is(prevToken, 'o') || PhaseSymbols.is(prevToken, 'O')) && (PhaseSymbols.is(currToken, 'o') || PhaseSymbols.is(currToken, 'O'))) {
                return "Repeated scattering code no allowed.";
            }
            if (PhaseSymbols.isReflectSymbol(currToken, 0) || PhaseSymbols.is(currToken, 'm') || PhaseSymbols.is(currToken, 'c') || PhaseSymbols.is(currToken, 'i')) {
                if (prevIsReflect) {
                    return "Two reflections or depths with no leg in between: " + prevToken + ", " + currToken;
                }
                prevIsReflect = true;
            } else {
                prevIsReflect = false;
            }
            if (PhaseSymbols.is(prevToken, "END")) {
                return "Legs ended but more tokens exist: " + currToken;
            }
            Pattern upDiffREEx = Pattern.compile(upDiffRE);
            if (PhaseSymbols.isUpgoingSymbol(prevToken, 0) && !upDiffREEx.matcher(prevToken).matches() && PhaseSymbols.isUpgoingSymbol(currToken, 0)) {
                if (PhaseSymbols.isCrustMantleLeg(prevToken, 0) && PhaseSymbols.isCrustMantleLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken + " ishead: " + upDiffREEx.matcher(prevToken).matches();
                }
                if (PhaseSymbols.isOuterCoreLeg(prevToken, 0) && PhaseSymbols.isOuterCoreLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken;
                }
                if (PhaseSymbols.isInnerCoreLeg(prevToken, 0) && PhaseSymbols.isInnerCoreLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken;
                }
            }
            if (!(!PhaseSymbols.startsWith(prevToken, "Ped") && !PhaseSymbols.startsWith(prevToken, "Sed") || PhaseSymbols.is(currToken, "END") || PhaseSymbols.is(currToken, "Pdiff") || PhaseSymbols.is(currToken, "Sdiff") || PhaseSymbols.is(currToken, 'P') || PhaseSymbols.is(currToken, 'S') || PhaseSymbols.is(currToken, 'K') || PhaseSymbols.is(currToken, "Ked") || PhaseSymbols.startsWith(currToken, 'K') && (currToken.endsWith("diff") || currToken.endsWith("diffdn") || currToken.endsWith("n")) || PhaseSymbols.startsWith(currToken, 'v') || PhaseSymbols.startsWith(currToken, 'V') || PhaseSymbols.is(currToken, 'c') || PhaseSymbols.is(currToken, 'm') || PhaseSymbols.is(currToken, 'o') || PhaseSymbols.is(currToken, 'O') || LegPuller.isBoundary(currToken))) {
                return "'Ped' or 'Sed' can only be before Pdiff,P,S,Sdiff,K,c,v,V,m or token immediately before END:  " + prevToken + " " + currToken;
            }
            if ((PhaseSymbols.startsWith(prevToken, 'k') || PhaseSymbols.startsWith(prevToken, 'K')) && (PhaseSymbols.startsWith(currToken, 'P') || PhaseSymbols.startsWith(currToken, 'S') || PhaseSymbols.startsWith(currToken, 'p') || PhaseSymbols.startsWith(currToken, 's')) && (PhaseSymbols.startsWith(nextToken, 'k') || PhaseSymbols.startsWith(nextToken, 'K'))) {
                return "Cannot have P,S,p,s preceeded and followed by K,k:  " + prevToken + ", " + currToken + ", " + nextToken;
            }
            if ((PhaseSymbols.startsWith(prevToken, 'I') || PhaseSymbols.startsWith(prevToken, 'J')) && (PhaseSymbols.startsWith(currToken, 'K') || PhaseSymbols.startsWith(currToken, 'k')) && (PhaseSymbols.startsWith(nextToken, 'I') || PhaseSymbols.startsWith(nextToken, 'J'))) {
                return "Cannot have K,k preceeded and followed by I,J:  " + prevToken + ", " + currToken + ", " + nextToken;
            }
            if ((PhaseSymbols.startsWith(prevToken, 'p') || PhaseSymbols.startsWith(prevToken, 's') || PhaseSymbols.is(prevToken, 'm') || PhaseSymbols.is(prevToken, 'c')) && (PhaseSymbols.is(currToken, 'I') || PhaseSymbols.is(currToken, 'J') || PhaseSymbols.is(currToken, 'i'))) {
                return "Cannot have P,S,p,s,m,c followed by I,J,i: " + prevToken + ", " + currToken;
            }
            if ((PhaseSymbols.is(prevToken, 'I') || PhaseSymbols.is(prevToken, 'J') || PhaseSymbols.is(prevToken, 'i')) && (PhaseSymbols.is(currToken, 'm') || PhaseSymbols.is(currToken, 'c'))) {
                return "Cannot have I,J,i followed by  m,c: " + prevToken + ", " + currToken;
            }
            if ((PhaseSymbols.is(prevToken, 'm') || PhaseSymbols.is(prevToken, 'c')) && PhaseSymbols.is(currToken, 'K')) {
                return "Cannot have m,c followed by K,I,i,J";
            }
            if ((PhaseSymbols.is(currToken, 'c') || PhaseSymbols.is(currToken, 'i')) && (PhaseSymbols.is(prevToken, 'p') || PhaseSymbols.is(prevToken, 's'))) {
                return "Cannot have p,s followed by c,i " + prevToken + " " + currToken;
            }
            if (!PhaseSymbols.is(currToken, 'i') || !PhaseSymbols.is(prevToken, 'k')) continue;
            return "Cannot have i followed by k";
        }
        if (!PhaseSymbols.is(currToken, "END")) {
            return "Last token must be END";
        }
        return null;
    }
}

