/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;

public class EventStation
extends LatLonable {
    LatLonLocatable evt;
    LatLonLocatable sta;

    public EventStation(LatLonLocatable evt, LatLonLocatable sta) {
        this.evt = evt;
        this.sta = sta;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        if (this.isGeodetic()) {
            throw new RuntimeException("geodetic not yet");
        }
        Location evtLoc = this.evt.asLocation();
        Location staLoc = this.sta.asLocation();
        double azimuth = SphericalCoords.azimuth(evtLoc, staLoc);
        out[0] = SphericalCoords.latFor(evtLoc, calcDist, azimuth);
        out[1] = SphericalCoords.lonFor(evtLoc, calcDist, azimuth);
        return out;
    }
}

