/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import com.google.gson.JsonObject;
import edu.sc.seis.TauP.AbstractPathSegment;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.List;

public class ArrivalPathSegment
extends AbstractPathSegment {
    SeismicPhaseSegment phaseSegment;
    Arrival arrival;

    public ArrivalPathSegment(List<TimeDist> path, boolean isPWave, String segmentName, TimeDist prevEnd, Arrival arrival, SeismicPhaseSegment phaseSegment, int segmentIndex, int totalNumSegments) {
        super(path, isPWave, segmentName, prevEnd, segmentIndex, totalNumSegments, arrival.getPhase());
        this.arrival = arrival;
        this.phaseSegment = phaseSegment;
    }

    public static List<TimeDist> adjustPierce(List<TimeDist> inPath, Arrival arrival) {
        double shifty = ArrivalPathSegment.calcShiftyForDist(inPath.get(0), inPath.get(inPath.size() - 1), arrival);
        List<TimeDist> out = ArrivalPathSegment.adjustPathForShifty(inPath, shifty);
        return out;
    }

    public static List<ArrivalPathSegment> adjustPath(List<ArrivalPathSegment> inPath, Arrival arrival) {
        double distRadian = arrival.getDist();
        if (inPath.isEmpty()) {
            throw new RuntimeException("can adjust empty path for phase " + arrival.getName());
        }
        TimeDist firstPoint = inPath.get(0).getPathStart();
        ArrivalPathSegment lastSeg = inPath.get(inPath.size() - 1);
        double finalPathDist = lastSeg.getPathEnd().getDistRadian() - firstPoint.getDistRadian();
        if (finalPathDist != 0.0 && !inPath.isEmpty()) {
            double shifty = ArrivalPathSegment.calcShiftyForDist(firstPoint, lastSeg.getPathEnd(), arrival);
            if (Math.abs(1.0 - shifty) > 0.02 && Math.abs(1.0 + shifty) > 1.0E-5) {
                Alert.warning("Path error is greater than 2%, correction may cause errors. " + shifty);
                Alert.warning("  " + arrival);
                Alert.warning("  " + distRadian + " " + finalPathDist + "  " + arrival.isLongWayAround());
            }
            ArrayList<ArrivalPathSegment> out = new ArrayList<ArrivalPathSegment>();
            TimeDist prevEnd = inPath.get((int)0).prevEnd;
            for (ArrivalPathSegment seg : inPath) {
                ArrivalPathSegment shiftySeg = new ArrivalPathSegment(ArrivalPathSegment.adjustPathForShifty(seg.path, shifty), seg.isPWave, seg.segmentName, prevEnd, seg.arrival, seg.phaseSegment, seg.segmentIndex, seg.totalNumSegments);
                prevEnd = shiftySeg.getPathEnd();
                out.add(shiftySeg);
            }
            return out;
        }
        return inPath;
    }

    public static double calcShiftyForDist(TimeDist firstPoint, TimeDist lastPoint, Arrival arrival) {
        double distRadian = arrival.getDist();
        double finalPathDist = lastPoint.getDistRadian() - firstPoint.getDistRadian();
        double shifty = 0.0;
        if (distRadian != 0.0 && finalPathDist != 0.0) {
            shifty = distRadian / finalPathDist;
            if (arrival.isLongWayAround()) {
                shifty *= -1.0;
            }
        }
        return shifty;
    }

    public static List<TimeDist> adjustPathForShifty(List<TimeDist> path, double shifty) {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        for (TimeDist td : path) {
            out.add(new TimeDist(td.getP(), td.getTime(), td.getDistRadian() * shifty, td.getDepth()));
        }
        return out;
    }

    @Override
    public JsonObject asJsonObject() {
        return super.asJsonObject(this.arrival);
    }

    @Override
    public String description() {
        return "seg " + this.segmentIndex + "/" + this.totalNumSegments + " " + this.segmentName + " of " + this.arrival.getCommentLine() + " in " + this.phaseSegment.describeBranchRange();
    }

    public SeismicPhaseSegment getPhaseSegment() {
        return this.phaseSegment;
    }

    public Arrival getArrival() {
        return this.arrival;
    }
}

