/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.gson.LocationSerializer;
import edu.sc.seis.seisFile.Location;
import java.lang.reflect.Type;

public class DistanceAngleRaySerializier
implements JsonSerializer<DistanceAngleRay> {
    LocationSerializer locSerial = new LocationSerializer();

    public JsonElement serialize(DistanceAngleRay src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject out = new JsonObject();
        if (src.isDegrees()) {
            out.add("deg", (JsonElement)new JsonPrimitive((Number)Float.valueOf((float)src.getDegrees())));
        } else {
            out.add("radian", (JsonElement)new JsonPrimitive((Number)Float.valueOf((float)src.getRadians())));
        }
        if (src.hasAzimuth()) {
            out.add("az", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getAzimuth().floatValue())));
        }
        if (src.hasBackAzimuth()) {
            out.add("baz", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getBackAzimuth().floatValue())));
        }
        if (src.hasSource()) {
            out.add("source", this.locSerial.serialize(src.getSource(), (Type)((Object)Location.class), context));
        }
        if (src.hasReceiver()) {
            out.add("receiver", this.locSerial.serialize(src.getSource(), (Type)((Object)Location.class), context));
        }
        return out;
    }
}

