/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractRayTool;
import edu.sc.seis.TauP.cmdline.args.AmplitudeArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="time", description={"Calculate travel times for seismic phases in an earth model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Time
extends TauP_AbstractRayTool {
    @CommandLine.Option(names={"--rayp", "--onlyrayp"}, description={"only output the ray parameter"})
    protected boolean onlyPrintRayP = false;
    @CommandLine.Option(names={"--time", "--onlytime"}, description={"only output travel time"})
    protected boolean onlyPrintTime = false;
    @CommandLine.Option(names={"--first", "--onlyfirst"}, description={"only output the first arrival for each phase, no triplications"})
    protected boolean onlyFirst = false;
    @CommandLine.Mixin
    AmplitudeArgs sourceArgs = new AmplitudeArgs();
    @CommandLine.Option(names={"--rel"}, split=",", paramLabel="phase", description={"times relative to the first of the given phases"})
    protected List<String> relativePhaseName = new ArrayList<String>();
    protected List<SeismicPhase> relativePhaseList = new ArrayList<SeismicPhase>();
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;

    public AmplitudeArgs getSourceArgs() {
        return this.sourceArgs;
    }

    public boolean isWithAmplitude() {
        return this.getSourceArgs().isWithAmplitude();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public TauP_Time() {
        super(new TextOutputTypeArgs("text", "-"));
    }

    public TauP_Time(TauModel tMod) {
        this();
        this.setTauModel(tMod);
    }

    public TauP_Time(String modelName) throws TauModelException {
        this();
        this.modelArgs.setModelName(modelName);
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> rayCalcList) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            for (RayCalculateable rayCalc : rayCalcList) {
                if (rayCalc.hasSourceDepth() && rayCalc.getSourceDepth().doubleValue() != phase.getSourceDepth() || rayCalc.hasReceiverDepth() && rayCalc.getReceiverDepth().doubleValue() != phase.getReceiverDepth()) continue;
                List<Arrival> rayArrivals = rayCalc.calculate(phase);
                Arrival.sortArrivals(rayArrivals);
                if (this.onlyFirst && !rayArrivals.isEmpty()) {
                    rayArrivals = List.of(rayArrivals.get(0));
                }
                arrivals.addAll(rayArrivals);
            }
        }
        if (!this.relativePhaseList.isEmpty() && !arrivals.isEmpty()) {
            Arrival.sortArrivalsBySourceReceiverDepth(arrivals);
            HashSet distList = new HashSet();
            double calcDepth = -1.0;
            double calcRecDepth = -1.0;
            List<Object> relPhaseList = new ArrayList();
            for (Arrival arrival : arrivals) {
                if (calcDepth != arrival.getSourceDepth() || calcRecDepth != arrival.getReceiverDepth()) {
                    relPhaseList = this.calcRelativeSeismicPhases(arrival.getTauModel(), arrival.getReceiverDepth(), this.getScatterer());
                    calcDepth = ((Arrival)arrivals.get(0)).getSourceDepth();
                    calcRecDepth = ((Arrival)arrivals.get(0)).getReceiverDepth();
                }
                DistanceAngleRay distRay = DistanceRay.ofRadians(arrival.getModuloDist());
                ArrayList<Arrival> relativeArrivals = new ArrayList<Arrival>();
                for (SeismicPhase seismicPhase : relPhaseList) {
                    relativeArrivals.addAll(distRay.calculate(seismicPhase));
                }
                if (relativeArrivals.isEmpty()) continue;
                Arrival.sortArrivals(relativeArrivals);
                arrival.setRelativeToArrival((Arrival)relativeArrivals.get(0));
            }
        }
        Arrival.sortArrivals(arrivals);
        return arrivals;
    }

    @Override
    public synchronized List<SeismicPhase> calcSeismicPhases(double sourceDepth, List<Double> receiverDepths, Scatterer scatterer) throws TauModelException {
        List<SeismicPhase> phaseList = super.calcSeismicPhases(sourceDepth, receiverDepths, scatterer);
        this.relativePhaseList = new ArrayList<SeismicPhase>();
        if (!this.relativePhaseName.isEmpty()) {
            for (Double recDepth : receiverDepths) {
                TauModel sourceReceiverTMod = this.modelArgs.depthCorrected(sourceDepth).splitBranch(recDepth);
                for (String sName : this.relativePhaseName) {
                    try {
                        List<SeismicPhase> calcRelPhaseList = SeismicPhaseFactory.createSeismicPhases(sName, sourceReceiverTMod, sourceDepth, recDepth, this.modelArgs.getScatterer(), this.isDEBUG());
                        this.relativePhaseList.addAll(calcRelPhaseList);
                    }
                    catch (ScatterArrivalFailException e) {
                        Alert.warning(e.getMessage(), "    Skipping this relative phase");
                        if (!this.isVerbose() && !this.isDEBUG()) continue;
                        e.printStackTrace();
                    }
                }
            }
        }
        return phaseList;
    }

    public List<SeismicPhase> calcRelativeSeismicPhases(TauModel tauModel, double receiverDepth, Scatterer scatterer) throws TauModelException {
        ArrayList<SeismicPhase> relativePhaseList = new ArrayList<SeismicPhase>();
        for (String sName : this.relativePhaseName) {
            try {
                List<SeismicPhase> calcRelPhaseList = SeismicPhaseFactory.createSeismicPhases(sName, tauModel, tauModel.getSourceDepth(), receiverDepth, this.modelArgs.getScatterer(), this.isDEBUG());
                relativePhaseList.addAll(calcRelPhaseList);
            }
            catch (ScatterArrivalFailException e) {
                Alert.warning(e.getMessage(), "    Skipping this relative phase");
                if (!this.isVerbose() && !this.isDEBUG()) continue;
                e.printStackTrace();
            }
        }
        return relativePhaseList;
    }

    public GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBld = GsonUtil.createGsonBuilder();
        gsonBld.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(false, false, this.isWithAmplitude()));
        return gsonBld;
    }

    @Override
    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        if (this.getOutputFormat().equals("json")) {
            TimeResult result = this.createTimeResult(this.isWithAmplitude(), this.sourceArgs, arrivalList);
            GsonBuilder gsonBld = this.createGsonBuilder();
            out.println(gsonBld.create().toJson((Object)result));
        } else if (this.getOutputFormat().equals("html")) {
            this.printResultHtml(out, arrivalList);
        } else {
            this.printResultText(out, arrivalList);
        }
        out.flush();
    }

    public void printResultText(PrintWriter out, List<Arrival> arrivalList) {
        TauP_Time.printArrivalsAsText(out, arrivalList, this.modelArgs.getModelName(), this.getScatterer(), this.onlyPrintTime, this.onlyPrintRayP, this.isWithAmplitude(), this.sourceArgs, this.relativePhaseName);
    }

    public void printResultHtml(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        TauP_Time.printArrivalsAsHtml(out, arrivalList, this.modelArgs.getModelName(), this.getScatterer(), this.isWithAmplitude(), this.sourceArgs, this.relativePhaseName, "Time");
    }

    public static List<List<String>> createHeaderLines(List<Arrival> arrivalList, String modelName, Scatterer scatterer, boolean withAmplitude, SeismicSourceArgs sourceArgs, List<String> relativePhaseName, String phaseFormat, String phasePuristFormat) {
        ArrayList<String> modelLine = new ArrayList<String>(List.of("Model: ", modelName));
        if (scatterer != null && scatterer.depth != 0.0) {
            modelLine.addAll(List.of("  Scatter Depth: ", scatterer.depth + " km", " Dist: ", scatterer.getDistanceDegree() + " deg"));
        }
        ArrayList<String> lineOne = new ArrayList<String>(List.of("Distance   ", "Depth   ", String.format(phaseFormat, "Phase") + "   ", "Travel    ", "Ray Param  ", "Takeoff  ", "Incident ", "Station   ", "Purist   ", "", String.format(phasePuristFormat, "Purist")));
        ArrayList<String> lineTwo = new ArrayList<String>(List.of("  (deg)    ", " (km)   ", String.format(phaseFormat, "Name ") + "   ", "Time (s)  ", "p (s/deg)  ", " (deg)   ", " (deg)   ", " (km)     ", "Distance ", "", String.format(phasePuristFormat, "Name  ")));
        if (withAmplitude) {
            lineOne.addAll(List.of("    Amp  ", "~" + Outputs.formatDistanceNoPad(sourceArgs.getMw()) + " Mw  "));
            lineTwo.addAll(List.of("  Factor PSv", "   Sh"));
        }
        if (!relativePhaseName.isEmpty()) {
            Object allRelPhase = "";
            for (String s : relativePhaseName) {
                allRelPhase = (String)allRelPhase + s + ",";
            }
            allRelPhase = ((String)allRelPhase).substring(0, ((String)allRelPhase).length() - 1);
            lineOne.add(" Relative");
            String space = " ";
            lineTwo.add(space.repeat((11 - ((String)allRelPhase).length()) / 2) + "  " + String.format(phaseFormat, allRelPhase));
            lineOne.add(" to");
            lineTwo.add("");
        }
        for (Arrival arrival : arrivalList) {
            if (!arrival.getRayCalculateable().hasDescription()) continue;
            lineOne.add(" Description");
            lineTwo.add("            ");
            break;
        }
        for (int i = 0; i < lineOne.size(); ++i) {
            if (((String)lineOne.get(i)).length() == ((String)lineTwo.get(i)).length()) continue;
            System.err.println("now same length: " + i + " '" + (String)lineOne.get(i) + "' '" + (String)lineTwo.get(i) + "' " + ((String)lineOne.get(i)).length() + " != " + ((String)lineTwo.get(i)).length());
        }
        return List.of(modelLine, lineOne, lineTwo);
    }

    public static void printArrivalsAsText(PrintWriter out, List<Arrival> arrivalList, String modelName, Scatterer scatterer, boolean onlyPrintTime, boolean onlyPrintRayP, boolean withAmplitude, SeismicSourceArgs sourceArgs, List<String> relativePhaseName) {
        int maxNameLength = 5;
        int maxPuristNameLength = 6;
        for (Arrival arrival : arrivalList) {
            if (arrival.getName().length() > maxNameLength) {
                maxNameLength = arrival.getName().length();
            }
            if (arrival.getPuristName().length() <= maxPuristNameLength) continue;
            maxPuristNameLength = arrival.getPuristName().length();
        }
        String phaseFormat = "%-" + maxNameLength + "s";
        String phasePuristFormat = "%-" + maxPuristNameLength + "s";
        if (!onlyPrintRayP && !onlyPrintTime) {
            List<List<String>> headLines = TauP_Time.createHeaderLines(arrivalList, modelName, scatterer, withAmplitude, sourceArgs, relativePhaseName, phaseFormat, phasePuristFormat);
            if (withAmplitude) {
                out.println("    WARNING: \n      Amplitudes are an experimental feature and may not generate correct\n      results. They are provided in the hope that they are helpful and to\n      allow feedback from the community, but testing of their correctness\n      is ongoing.");
            }
            String modelLine = String.join((CharSequence)"", (Iterable<? extends CharSequence>)headLines.get(0));
            out.println("\n" + modelLine);
            String lineOne = String.join((CharSequence)"", (Iterable<? extends CharSequence>)headLines.get(1));
            out.println(lineOne);
            String lineTwo = String.join((CharSequence)"", (Iterable<? extends CharSequence>)headLines.get(2));
            out.println(lineTwo);
            StringBuilder dashes = new StringBuilder();
            dashes.append("-".repeat(Math.max(lineOne.length(), lineTwo.length())));
            out.write(dashes.append("\n").toString());
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                List<String> lineItems = arrival.asStringList(false, phaseFormat, phasePuristFormat, withAmplitude, !relativePhaseName.isEmpty());
                out.println(String.join((CharSequence)"", lineItems));
            }
        } else if (onlyPrintTime) {
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                out.print((float)currArrival.getTime() + " ");
            }
            out.println();
        } else {
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                out.write((float)(Math.PI / 180 * currArrival.getRayParam()) + " ");
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void printArrivalsAsHtml(PrintWriter out, List<Arrival> arrivalList, String modelName, Scatterer scatterer, boolean withAmplitude, SeismicSourceArgs sourceArgs, List<String> relativePhaseName, String toolname) throws TauPException {
        String phaseFormat;
        String phasePuristFormat = phaseFormat = "%s";
        List<List<String>> headLines = TauP_Time.createHeaderLines(arrivalList, modelName, scatterer, withAmplitude, sourceArgs, relativePhaseName, phaseFormat, phasePuristFormat);
        HTMLUtil.createHtmlStart(out, "TauP " + toolname, HTMLUtil.createTableCSS(), true);
        if (withAmplitude) {
            out.println("<p>    WARNING: \n      Amplitudes are an experimental feature and may not generate correct\n      results. They are provided in the hope that they are helpful and to\n      allow feedback from the community, but testing of their correctness\n      is ongoing.</p>");
        }
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (Arrival arrival : arrivalList) {
            List<String> lineItems = arrival.asStringList(false, phaseFormat, phasePuristFormat, withAmplitude, !relativePhaseName.isEmpty());
            values.add(lineItems);
        }
        out.println(HTMLUtil.createBasicTableMoHeaders(headLines, values));
        HTMLUtil.addSortTableJS(out);
        out.println(HTMLUtil.createHtmlEnding());
        out.flush();
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauPException {
        List<RayCalculateable> distanceValues = this.getDistanceArgs().getRayCalculatables(this.sourceArgs);
        List<Arrival> arrivalList = this.calcAll(this.getSeismicPhases(), distanceValues);
        if (this.getDistanceArgs().isAllIndexRays()) {
            ArrayList<Arrival> indexArrivalList = new ArrayList<Arrival>();
            for (SeismicPhase phase : this.getSeismicPhases()) {
                if (!(phase instanceof SimpleSeismicPhase)) continue;
                SimpleSeismicPhase simpPhase = (SimpleSeismicPhase)phase;
                for (int i = 0; i < simpPhase.getNumRays(); ++i) {
                    indexArrivalList.addAll(new RayParamIndexRay(i).calculate(simpPhase));
                }
            }
            arrivalList.addAll(indexArrivalList);
        }
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        this.printResult(writer, arrivalList);
        writer.close();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        super.validateArguments();
        this.sourceArgs.validateArguments();
        if (this.isWithAmplitude()) {
            this.sourceArgs.validateArgumentsForAmplitude(this.modelArgs, this.getDistanceArgs().getRayCalculatables(this.sourceArgs));
        }
    }
}

