/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.PhaseArgs;
import edu.sc.seis.TauP.cmdline.args.TableModelArgs;
import edu.sc.seis.TauP.cmdline.args.TableOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="table", description={"Create a table of travel times for a range of depths and distances."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Table
extends TauP_Tool {
    protected String headerFile;
    protected double[] depths = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 19.0, 21.0, 25.0, 30.0, 33.0, 35.0, 40.0, 45.0, 49.0, 51.0, 55.0, 60.0, 70.0, 80.0, 90.0, 100.0, 120.0, 140.0, 160.0, 180.0, 200.0, 220.0, 240.0, 260.0, 280.0, 300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0};
    protected double[] distances = new double[]{0.0, 0.1f, 0.2f, 0.3f, 0.4f, 0.5, 0.6f, 0.7f, 0.8f, 0.9f, 1.0, 1.1f, 1.2f, 1.3f, 1.4f, 1.5, 1.6f, 1.7f, 1.8f, 1.9f, 2.0, 2.1f, 2.2f, 2.3f, 2.4f, 2.5, 2.6f, 2.7f, 2.8f, 2.9f, 3.0, 3.1f, 3.2f, 3.3f, 3.4f, 3.5, 3.6f, 3.7f, 3.8f, 3.9f, 4.0, 4.1f, 4.2f, 4.3f, 4.4f, 4.5, 4.6f, 4.7f, 4.8f, 4.9f, 5.0, 5.1f, 5.2f, 5.3f, 5.4f, 5.5, 5.6f, 5.7f, 5.8f, 5.9f, 6.0, 6.1f, 6.2f, 6.3f, 6.4f, 6.5, 6.6f, 6.7f, 6.8f, 6.9f, 7.0, 7.1f, 7.2f, 7.3f, 7.4f, 7.5, 7.6f, 7.7f, 7.8f, 7.9f, 8.0, 8.1f, 8.2f, 8.3f, 8.4f, 8.5, 8.6f, 8.7f, 8.8f, 8.9f, 9.0, 9.1f, 9.2f, 9.3f, 9.4f, 9.5, 9.6f, 9.7f, 9.8f, 9.9f, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 105.0, 110.0, 115.0, 120.0, 125.0, 130.0, 135.0, 140.0, 145.0, 150.0, 155.0, 160.0, 165.0, 170.0, 175.0, 180.0};
    @CommandLine.Mixin
    TableOutputTypeArgs outputTypeArgs;
    @CommandLine.ArgGroup(heading="Model Args %n", exclusive=false)
    TableModelArgs modelArgs = new TableModelArgs();
    @CommandLine.ArgGroup(heading="Phase Names %n", exclusive=false)
    PhaseArgs phaseArgs = new PhaseArgs();

    public TauP_Table() {
        super(new TableOutputTypeArgs("text", "taup_table"));
        this.outputTypeArgs = (TableOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
        if (this.headerFile != null) {
            try {
                int i;
                StreamTokenizer head = new StreamTokenizer(new BufferedReader(new FileReader(this.headerFile)));
                head.commentChar(35);
                head.nextToken();
                if (head.ttype == -3 && head.sval.equals("n")) {
                    head.nextToken();
                } else {
                    Alert.warning("First character of header file is not 'n'", "'" + head.ttype + "'  " + head.sval);
                }
                if (head.ttype != -2) {
                    if (head.ttype == -3) {
                        Alert.error("Expected a number of depth samples, but got ", head.sval);
                    } else {
                        Alert.error("Expected a number of depth samples, but got ", "'" + head.ttype + "'");
                    }
                    System.exit(101);
                }
                if (head.nval != Math.rint(head.nval)) {
                    Alert.error("Expected a number of depth samples, but got ", head.sval);
                }
                this.depths = new double[(int)head.nval];
                for (i = 0; i < this.depths.length; ++i) {
                    head.nextToken();
                    if (head.ttype != -2) {
                        if (head.ttype == -3) {
                            Alert.error("Expected a number of depth samples, but got ", head.sval);
                        } else {
                            Alert.error("Expected a number of depth samples, but got ", "'" + head.ttype + "'");
                        }
                        System.exit(102);
                    }
                    this.depths[i] = head.nval;
                }
                head.nextToken();
                if (head.ttype != -2) {
                    if (head.ttype == -3) {
                        Alert.error("Expected a number of distance samples, but got ", head.sval);
                    } else {
                        Alert.error("Expected a number of distance samples, but got ", "'" + head.ttype + "'");
                    }
                    System.exit(103);
                }
                if (head.nval != Math.rint(head.nval)) {
                    Alert.error("Expected a number of distance samples, but got ", head.sval);
                }
                this.distances = new double[(int)head.nval];
                for (i = 0; i < this.distances.length; ++i) {
                    head.nextToken();
                    if (head.ttype != -2) {
                        if (head.ttype == -3) {
                            Alert.error("Expected a distance sample, but got ", head.sval);
                        } else {
                            Alert.error("Expected a distance sample, but got ", "'" + head.ttype + "'");
                        }
                        System.exit(104);
                    }
                    this.distances[i] = head.nval;
                }
            }
            catch (FileNotFoundException e) {
                Alert.error("Couldn't find file.", e.getMessage());
                System.exit(105);
            }
            catch (IOException e) {
                Alert.error("Caught IOException.", e.getMessage());
                System.exit(106);
            }
        }
    }

    @Override
    public void start() throws TauPException, IOException {
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        List<PhaseName> phaseNames = this.phaseArgs.parsePhaseNameList();
        TauModel tMod = this.modelArgs.getTauModel();
        ArrayList<RayCalculateable> rayCalcList = new ArrayList<RayCalculateable>();
        double receiverDepth = this.modelArgs.getReceiverDepths().get(0);
        for (double distance : this.distances) {
            rayCalcList.add(DistanceRay.ofDegrees(distance));
        }
        if (this.outputTypeArgs.isCSV()) {
            this.csvTable(writer, tMod, phaseNames, this.depths, receiverDepth, this.modelArgs.getScatterer(), rayCalcList);
        } else if (this.outputTypeArgs.isHTML()) {
            this.htmlTable(writer, tMod, phaseNames, this.depths, receiverDepth, this.modelArgs.getScatterer(), rayCalcList);
        } else if (this.outputTypeArgs.isLocsat()) {
            this.locsatTable(writer, tMod, phaseNames, this.depths, receiverDepth, this.modelArgs.getScatterer(), rayCalcList);
        } else if (this.outputTypeArgs.isJSON()) {
            this.jsonTable(writer, tMod, phaseNames, this.depths, receiverDepth, this.modelArgs.getScatterer(), rayCalcList);
        } else if (this.outputTypeArgs.isText()) {
            this.genericTable(writer, tMod, phaseNames, this.depths, receiverDepth, this.modelArgs.getScatterer(), rayCalcList);
        } else {
            throw new TauPException("TauP_Table: undefined state for output type: " + this.getOutputFormat());
        }
        writer.close();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.modelArgs.getReceiverDepths().size() > 1) {
            throw new TauModelException("Table only allows a single receiver depth, but was given " + this.modelArgs.getReceiverDepths().size() + " depths.");
        }
    }

    @Override
    public String getOutFileExtension() {
        return "";
    }

    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> shootables) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            for (RayCalculateable shoot : shootables) {
                arrivals.addAll(shoot.calculate(phase));
            }
        }
        Arrival.sortArrivals(arrivals);
        return arrivals;
    }

    protected void jsonTable(PrintWriter out, TauModel tMod, List<PhaseName> phaseNames, double[] depths, double receiverDepth, Scatterer scatterer, List<RayCalculateable> rayCalcList) throws TauPException {
        out.println("[");
        for (double depth : depths) {
            List<SeismicPhase> phaseList = this.recalcPhases(tMod, phaseNames, depth, receiverDepth, scatterer);
            for (RayCalculateable distCalc : rayCalcList) {
                List<Arrival> arrivals = this.calcAll(phaseList, List.of(distCalc));
                TimeResult result = new TimeResult(tMod.getModelName(), List.of(Double.valueOf(depth)), List.of(Double.valueOf(receiverDepth)), phaseNames, scatterer, false, null, arrivals);
                out.println(GsonUtil.toJson(result));
            }
        }
        out.println("]");
    }

    protected List<SeismicPhase> recalcPhases(TauModel tMod, List<PhaseName> phaseNames, double depth, double receiverDepth, Scatterer scatterer) throws TauModelException {
        ArrayList<SeismicPhase> newPhases = new ArrayList<SeismicPhase>();
        TauModel tModDepth = tMod.depthCorrect(depth);
        TauModel tModRecDepth = tModDepth.splitBranch(receiverDepth);
        for (PhaseName phaseName : phaseNames) {
            List<SeismicPhase> calcPhaseList = SeismicPhaseFactory.createSeismicPhases(phaseName.getName(), tModRecDepth, depth, receiverDepth, scatterer, this.isDEBUG());
            newPhases.addAll(calcPhaseList);
        }
        return newPhases;
    }

    protected void csvTable(PrintWriter out, TauModel tMod, List<PhaseName> phaseNames, double[] depths, double receiverDepth, Scatterer scatterer, List<RayCalculateable> rayCalcList) throws TauPException {
        out.println(Arrival.CSVHeader());
        for (double depth : depths) {
            List<SeismicPhase> phaseList = this.recalcPhases(tMod, phaseNames, depth, receiverDepth, scatterer);
            for (RayCalculateable distCalc : rayCalcList) {
                List<Arrival> arrivals = this.calcAll(phaseList, List.of(distCalc));
                for (Arrival currArrival : arrivals) {
                    out.println(currArrival.asCSVRow());
                }
            }
        }
        out.flush();
    }

    protected void htmlTable(PrintWriter out, TauModel tMod, List<PhaseName> phaseNames, double[] depths, double receiverDepth, Scatterer scatterer, List<RayCalculateable> rayCalcList) throws TauPException {
        HTMLUtil.createHtmlStart(out, "TauP Table", HTMLUtil.createTableCSS(), false);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (double depth : depths) {
            List<SeismicPhase> phaseList = this.recalcPhases(tMod, phaseNames, depth, receiverDepth, scatterer);
            for (RayCalculateable distCalc : rayCalcList) {
                List<Arrival> arrivals = this.calcAll(phaseList, List.of(distCalc));
                for (Arrival currArrival : arrivals) {
                    values.add(currArrival.asStringList(true, "%s", "%s", false, false));
                }
            }
        }
        out.println(HTMLUtil.createBasicTable(Arrival.headerNames(true), values));
        out.println(HTMLUtil.createHtmlEnding());
        out.flush();
    }

    protected void genericTable(PrintWriter out, TauModel tMod, List<PhaseName> phaseNames, double[] depths, double receiverDepth, Scatterer scatterer, List<RayCalculateable> rayCalcList) throws TauPException {
        for (double depth : depths) {
            List<SeismicPhase> phaseList = this.recalcPhases(tMod, phaseNames, depth, receiverDepth, scatterer);
            for (RayCalculateable distCalc : rayCalcList) {
                List<Arrival> arrivals = this.calcAll(phaseList, List.of(distCalc));
                for (Arrival currArrival : arrivals) {
                    double moduloDist = currArrival.getModuloDistDeg();
                    out.print(this.modelArgs.getModelName() + " " + Outputs.formatDistance(moduloDist) + " " + Outputs.formatDepth(depth) + " ");
                    out.print(currArrival.getName());
                    out.print("  " + Outputs.formatTime(currArrival.getTime()) + "  ");
                    out.print(Outputs.formatRayParam(Math.PI / 180 * currArrival.getRayParam()) + "   ");
                    out.print(Outputs.formatDistance(currArrival.getDistDeg()));
                    out.print("  " + currArrival.getPuristName());
                    out.println();
                }
            }
        }
        out.flush();
    }

    protected void locsatTable(PrintWriter out, TauModel tMod, List<PhaseName> phaseNames, double[] depths, double receiverDepth, Scatterer scatterer, List<RayCalculateable> rayCalcList) throws TauPException {
        String float15_4 = "%15.4f";
        String float7_2 = "%7.2f";
        String decimal7 = "%-7d";
        double maxDiff = Double.parseDouble(this.toolProps.getProperty("taup.table.locsat.maxdiff", "105.0"));
        out.print("n # " + PhaseArgs.getPhaseNamesAsString(phaseNames) + " travel-time tables for " + tMod.getModelName() + " structure. (From TauP_Table)\n");
        out.print(String.format(decimal7, depths.length) + "# number of depth samples\n");
        for (int depthNum = 0; depthNum < depths.length; ++depthNum) {
            out.print(String.format(float7_2, depths[depthNum]));
            if (depthNum % 10 != 9) continue;
            out.println();
        }
        if ((depths.length - 1) % 10 != 9) {
            out.println();
        }
        out.println(String.format(decimal7, rayCalcList.size()) + "# number of distances");
        for (int distNum = 0; distNum < rayCalcList.size(); ++distNum) {
            RayCalculateable rayCalc = rayCalcList.get(distNum);
            if (!(rayCalc instanceof DistanceRay)) {
                throw new TauPException("RayCalc is not a distance: " + String.valueOf(rayCalc));
            }
            DistanceRay dr = (DistanceRay)rayCalc;
            out.print(String.format(float7_2, dr.getDegrees(tMod.getRadiusOfEarth())));
            if (distNum % 10 != 9) continue;
            out.println();
        }
        if ((rayCalcList.size() - 1) % 10 != 9) {
            out.println();
        }
        for (double depth : depths) {
            out.println("#  Travel time for z =    " + depth);
            List<SeismicPhase> phaseList = this.recalcPhases(tMod, phaseNames, depth, receiverDepth, scatterer);
            for (RayCalculateable distCalc : rayCalcList) {
                DistanceRay dr = (DistanceRay)distCalc;
                double distance = dr.getDegrees(tMod.getRadiusOfEarth());
                List<Arrival> arrivals = this.calcAll(phaseList, List.of(distCalc));
                String outString = String.format(float15_4, -1.0) + "    none\n";
                for (Arrival currArrival : arrivals) {
                    if (distance > maxDiff && currArrival.getName().endsWith("diff")) continue;
                    outString = String.format(float15_4, currArrival.getTime()) + "    " + currArrival.getName() + "\n";
                    break;
                }
                out.print(outString);
            }
        }
        out.flush();
    }

    public String getHeaderFile() {
        return this.headerFile;
    }

    @CommandLine.Option(names={"--header"}, description={"reads depth and distance spacing data from a LOCSAT style file."})
    public void setHeaderFile(String headerFile) {
        this.headerFile = headerFile;
    }
}

