/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import picocli.CommandLine;

public class SeismogramOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type %n")
    SeismogramOutputType outputType = new SeismogramOutputType();

    public SeismogramOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public boolean isMS3() {
        return this.outputType._isMS3;
    }

    public boolean isSAC() {
        return this.outputType._isSAC;
    }

    @Override
    public String getOutputFormat() {
        if (this.isSAC()) {
            return "sac";
        }
        return "ms3";
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isMS3 = false;
        this.outputType._isSAC = false;
        if (oType.equalsIgnoreCase("ms3")) {
            this.outputType._isMS3 = true;
        } else if (oType.equalsIgnoreCase("sac")) {
            this.outputType._isSAC = true;
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    @Override
    public String getOutFileExtension() {
        String extention = "ms3";
        if (this.isSAC()) {
            extention = "sac";
        }
        return extention;
    }

    static class SeismogramOutputType {
        @CommandLine.Option(names={"--ms3"}, required=true, description={"outputs as mseed3"})
        boolean _isMS3 = false;
        @CommandLine.Option(names={"--sac"}, required=true, description={"outputs as SAC"})
        boolean _isSAC = false;

        SeismogramOutputType() {
        }
    }
}

