/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.DistAz;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.IRISFedCatQuerier;
import edu.sc.seis.seisFile.fdsnws.IRISFedCatQueryParams;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import picocli.CommandLine;

public class QmlStaxmlArgs {
    public static final String staSourceIdRegExString = "FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})";
    public static final Pattern staSourceIdRegEx = Pattern.compile("FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})");
    @CommandLine.Option(names={"--eid"}, paramLabel="evt", split=",", description={"event id, like us7000pn9s, for lookup via USGS fdsn event web service. Creates a distance if station is also given."})
    public List<String> eidList = new ArrayList<String>();
    @CommandLine.Option(names={"--sid"}, paramLabel="sta", split=",", description={"station id, like CO.HAW or FDSN:CO_HAW, for lookup via fedcat web service. Creates a distance if event is also given."})
    public List<String> sidList = new ArrayList<String>();
    protected String quakemlFilename = null;
    protected String stationxmlFilename = null;

    public static List<Location> loadStationsForSid(List<String> sidList) throws FDSNSourceIdException, FDSNWSException {
        if (sidList.isEmpty()) {
            return List.of();
        }
        FDSNStationQueryParams staQP = new FDSNStationQueryParams();
        staQP.setLevel("station");
        for (String sid : sidList) {
            if (sid.startsWith("FDSN:")) {
                Matcher m = staSourceIdRegEx.matcher(sid);
                if (m.matches()) {
                    staQP.appendToNetwork(m.group(1));
                    staQP.appendToStation(m.group(2));
                    continue;
                }
                FDSNSourceId fdsn = FDSNSourceId.parse((String)sid);
                staQP.appendToNetwork(fdsn.getNetworkCode());
                staQP.appendToStation(fdsn.getStationCode());
                continue;
            }
            String[] splitSid = sid.split("[_\\.]");
            if (splitSid.length < 2) continue;
            staQP.appendToNetwork(splitSid[0]);
            staQP.appendToStation(splitSid[1]);
        }
        ArrayList<Location> out = new ArrayList<Location>();
        IRISFedCatQueryParams qp = new IRISFedCatQueryParams(staQP);
        qp.setFormat("text");
        IRISFedCatQuerier querier = new IRISFedCatQuerier(qp);
        querier.setUserAgent(QmlStaxmlArgs.getTaupUserAgent());
        ArrayList<Station> staList = querier.getStationsFromText();
        ArrayList<Station> uniq = new ArrayList<Station>();
        for (int i = 0; i < staList.size(); ++i) {
            Station a = (Station)staList.get(i);
            boolean found = false;
            for (int j = i + 1; j < staList.size(); ++j) {
                DistAz distAz;
                Station b = (Station)staList.get(j);
                if (!Objects.equals(a.getNetworkCode(), b.getNetworkCode()) || !Objects.equals(a.getStationCode(), b.getStationCode()) || !((distAz = new DistAz(a.asLocation(), b.asLocation())).getDelta() < 0.01)) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniq.add(a);
        }
        staList = uniq;
        for (Station sta : staList) {
            Location staLoc = sta.asLocation();
            String desc = sta.getNetworkCode() + "." + sta.getStationCode() + " " + Outputs.formatLatLon(staLoc.getLatitude()).trim() + "/" + Outputs.formatLatLon(staLoc.getLongitude()).trim();
            staLoc.setDescription(desc);
            out.add(staLoc);
        }
        return out;
    }

    public List<Location> getStationLocations() throws TauPException {
        ArrayList<Location> staList = new ArrayList<Location>();
        staList.addAll(this.getSidLocations());
        staList.addAll(this.getStationXMLLocations());
        return staList;
    }

    public List<Location> getStationXMLLocations() throws TauPException {
        ArrayList<Location> staList = new ArrayList<Location>();
        Map<Network, List<Station>> networks = this.loadStationXML();
        for (Network net : networks.keySet()) {
            for (Station sta : networks.get(net)) {
                ArrayList<Location> allChans = new ArrayList<Location>();
                for (Channel chan : sta.getChannelList()) {
                    Location cLoc = new Location(chan);
                    boolean found = false;
                    for (Location prev : allChans) {
                        if (!prev.equals((Object)cLoc)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    String desc = sta.getNetworkCode() + "." + sta.getStationCode() + " " + Outputs.formatLatLon(cLoc.getLatitude()).trim() + "/" + Outputs.formatLatLon(cLoc.getLongitude()).trim();
                    cLoc.setDescription(desc);
                    allChans.add(cLoc);
                }
                if (sta.getChannelList().isEmpty()) {
                    Location staLoc = new Location(sta);
                    String desc = sta.getNetworkCode() + "." + sta.getStationCode() + " " + Outputs.formatLatLon(staLoc.getLatitude()).trim() + "/" + Outputs.formatLatLon(staLoc.getLongitude()).trim();
                    staLoc.setDescription(desc);
                    allChans.add(staLoc);
                }
                staList.addAll(allChans);
            }
        }
        return staList;
    }

    public List<Location> getEventLocations() throws TauPException {
        ArrayList<Location> eventLocs = new ArrayList<Location>();
        ArrayList<Event> quakes = new ArrayList<Event>();
        quakes.addAll(this.loadQuakeML());
        quakes.addAll(this.loadEventsFromUSGS(this.getEventIdList()));
        DateTimeFormatter dformat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(TimeUtils.TZ_UTC);
        for (Event evt : quakes) {
            Location evtLoc = new Location(evt);
            Origin origin = evt.getPreferredOrigin();
            Magnitude mag = evt.getPreferredMagnitude();
            StringBuilder desc = new StringBuilder();
            if (origin != null) {
                desc.append(dformat.format(origin.getTime().asInstant()));
            }
            if (mag != null) {
                if (desc.length() != 0) {
                    desc.append(" ");
                }
                desc.append(mag.getMag().getValue()).append(" ").append(mag.getType());
            }
            if (desc.length() != 0) {
                desc.append(" ");
            }
            desc.append(Outputs.formatLatLon(evtLoc.getLatitude()).trim()).append("/").append(Outputs.formatLatLon(evtLoc.getLongitude()).trim());
            if (desc.length() != 0) {
                evtLoc.setDescription(desc.toString());
            }
            eventLocs.add(evtLoc);
        }
        return eventLocs;
    }

    public boolean hasQml() {
        return this.getQuakemlFilename() != null || !this.getEventIdList().isEmpty();
    }

    public boolean hasStationXML() {
        return this.getStationxmlFilename() != null || !this.sidList.isEmpty();
    }

    public Map<Network, List<Station>> loadStationXML() throws TauPException {
        Map<Object, List<Object>> networks = new HashMap<Network, List<Station>>();
        try {
            if (this.stationxmlFilename != null) {
                FDSNStationXML staxml = FDSNStationXML.loadStationXML((String)this.stationxmlFilename);
                networks = staxml.extractAllNetworks();
            }
        }
        catch (SeisFileException | IOException | XMLStreamException e) {
            throw new TauPException("Unable to process stationxml from " + this.stationxmlFilename, e);
        }
        return networks;
    }

    public List<Event> loadQuakeML() throws TauPException {
        List<Object> quakes = new ArrayList<Event>();
        try {
            if (this.quakemlFilename != null) {
                FileReader reader = new FileReader(this.quakemlFilename);
                Quakeml quakeml = Quakeml.loadQuakeML((Reader)reader);
                quakes = quakeml.extractAllEvents();
                reader.close();
            }
        }
        catch (SeisFileException | IOException | XMLStreamException e) {
            throw new TauPException("Unable to process quakeml from " + this.quakemlFilename, e);
        }
        return quakes;
    }

    public String getQuakemlFilename() {
        return this.quakemlFilename;
    }

    @CommandLine.Option(names={"--qml", "--quakeml"}, description={"QuakeML file to load for earthquake origins to use"})
    public void setQuakemlFilename(String quakemlFilename) {
        this.quakemlFilename = quakemlFilename;
    }

    public List<String> getEventIdList() {
        return this.eidList;
    }

    public List<Event> loadEventsFromUSGS(List<String> eidList) throws TauPException {
        ArrayList<Event> out = new ArrayList<Event>();
        try {
            for (String eid : eidList) {
                FDSNEventQueryParams qp = new FDSNEventQueryParams();
                qp.setEventid(eid);
                FDSNEventQuerier querier = new FDSNEventQuerier(qp);
                querier.setUserAgent(QmlStaxmlArgs.getTaupUserAgent());
                out.addAll(querier.getQuakeML().extractAllEvents());
            }
        }
        catch (SeisFileException | XMLStreamException e) {
            throw new TauPException("Unable to load station locations from fedcat service", e);
        }
        return out;
    }

    public String getStationxmlFilename() {
        return this.stationxmlFilename;
    }

    @CommandLine.Option(names={"--staxml"}, description={"StationXML file to extract station latitudes and longitudes from"})
    public void setStationxmlFilename(String stationxmlFilename) {
        this.stationxmlFilename = stationxmlFilename;
    }

    public List<String> getSidList() {
        return this.sidList;
    }

    public List<Location> getSidLocations() throws TauPException {
        try {
            return QmlStaxmlArgs.loadStationsForSid(this.getSidList());
        }
        catch (FDSNWSException | FDSNSourceIdException e) {
            throw new TauPException("Unable to load station locations from fedcat service", e);
        }
    }

    public static String createDescription(Location evtLoc) {
        Object evtDesc = evtLoc.hasDescription() ? evtLoc.getDescription() : Outputs.formatLatLon(evtLoc.getLatitude()).trim() + "/" + Outputs.formatLatLon(evtLoc.getLongitude()).trim();
        return evtDesc;
    }

    public static String getTaupUserAgent() {
        return BuildVersion.getName() + "/" + BuildVersion.getVersion();
    }
}

