/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.CompositeSeismicPhase;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SeismicPhaseWalk;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.cmdline.FindResult;
import edu.sc.seis.TauP.cmdline.FindTimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.cmdline.args.AmplitudeArgs;
import edu.sc.seis.TauP.cmdline.args.DistanceArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="find", description={"Find seismic phases in an earth model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Find
extends TauP_AbstractPhaseTool {
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs;
    @CommandLine.Option(names={"--showrayparam"}, description={"show min and max ray parameter for each phase name"})
    boolean showrayparam = false;
    @CommandLine.Option(names={"--max"}, required=true, description={"Maximum number of reflections and phase conversion"})
    int maxActions;
    @CommandLine.Option(names={"--rayparamdeg"}, arity="1..2", paramLabel="s/deg", description={"only keep phases that overlap the given ray parameter range in s/deg"})
    Double[] rayParamRangeDeg;
    @CommandLine.Option(names={"--rayparamkm"}, arity="1..2", paramLabel="s/km", description={"only keep phases that overlap the given ray parameter range in s/km"})
    Double[] rayParamRangeKm;
    double excludeDepthTol = 10.0;
    @CommandLine.Option(names={"--exclude"}, arity="1..", paramLabel="depth", split=",", description={"Exclude boundaries from phase conversion or reflection interactions", "May be depth (within tol) or named boundary like moho, cmb, iocb"})
    List<String> excludeDepthNames = new ArrayList<String>();
    @CommandLine.Option(names={"--onlynameddiscon"}, description={"only interact with named discontinuities like moho, cmb, iocb"})
    boolean onlyNamedDiscon = false;
    @CommandLine.Option(names={"--pwaveonly"}, description={"only P wave legs, no S"})
    boolean onlyPWave = false;
    @CommandLine.Option(names={"--swaveonly"}, description={"only S wave legs, no P"})
    boolean onlySWave = false;
    @CommandLine.Option(names={"--time"}, arity="1..2", paramLabel="t", description={"find arrivals within the given range"})
    List<Double> times = new ArrayList<Double>();
    @CommandLine.Option(names={"--deltatime"}, paramLabel="dt", description={"find arrivals within the +- deltatime, --times must have single time"})
    Double deltaTime = 5.0;
    Double deltaRayParam = 0.057295779513082325;
    @CommandLine.Mixin
    AmplitudeArgs sourceArgs = new AmplitudeArgs();
    @CommandLine.Option(names={"--az"}, description={"azimuth in degrees, for amp calculations"})
    protected Double azimuth = null;
    DistanceArgs distanceArgs = new DistanceArgs();

    public TauP_Find() {
        super(new TextOutputTypeArgs("text", "-"));
        this.outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    public SeismicPhaseWalk createWalker(TauModel tMod, double receiverDepth, List<Double> excludeDepths) throws TauModelException {
        Double minRP = null;
        Double maxRP = null;
        if (this.getRayParamRange() != null && this.getRayParamRange().length > 0) {
            maxRP = minRP = this.getRayParamRange()[0];
            if (this.getRayParamRange().length > 1) {
                maxRP = this.getRayParamRange()[1];
            }
        }
        SeismicPhaseWalk walker = new SeismicPhaseWalk(tMod, minRP, maxRP, tMod.findBranch(receiverDepth));
        if (this.onlyPWave) {
            walker.setAllowSWave(false);
        } else if (this.onlySWave) {
            walker.setAllowPWave(false);
        }
        walker.excludeBoundaries(excludeDepths);
        if (this.isVerbose() && !this.getExcludedDepths(tMod).isEmpty()) {
            System.out.println("Exclude: " + this.getExcludedDepths(tMod).size() + " depths:");
            for (int i : walker.getExcludeBranch()) {
                System.out.println(i + " " + walker.gettMod().getTauBranch(i, true).getTopDepth() + " km");
            }
        }
        return walker;
    }

    @Override
    public void start() throws IOException, TauPException {
        List<RayCalculateable> distanceValues = this.distanceArgs.getRayCalculatables(this.sourceArgs);
        if (this.azimuth != null) {
            for (RayCalculateable rc : distanceValues) {
                rc.setAzimuth(this.azimuth);
            }
        }
        ArrayList<Arrival> arrivalList = new ArrayList<Arrival>();
        ArrayList<ProtoSeismicPhase> allwalk = new ArrayList<ProtoSeismicPhase>();
        for (Double sourceDepth : this.modelArgs.getSourceDepths()) {
            TauModel tMod = this.modelArgs.depthCorrected(sourceDepth);
            for (Double recDepth : this.modelArgs.getReceiverDepths()) {
                TauModel tModRecDepth = tMod.splitBranch(recDepth);
                List<Double> excludeDepths = this.getExcludedDepths(tModRecDepth);
                List<Double> actualExcludeDepths = this.matchDepthToDiscon(excludeDepths, tMod.getVelocityModel(), this.excludeDepthTol);
                SeismicPhaseWalk walker = this.createWalker(tModRecDepth, recDepth, actualExcludeDepths);
                List<ProtoSeismicPhase> walk = walker.findEndingPaths(this.maxActions);
                if (!distanceValues.isEmpty()) {
                    double[] rayParamRange = new double[2];
                    if (this.getRayParamRange().length == 0) {
                        rayParamRange = new double[]{};
                    } else if (this.getRayParamRange().length == 1) {
                        rayParamRange[0] = this.getRayParamRange()[0] - this.deltaRayParam;
                        rayParamRange[1] = this.getRayParamRange()[0] + this.deltaRayParam;
                    } else {
                        rayParamRange[0] = this.getRayParamRange()[0];
                        rayParamRange[1] = this.getRayParamRange()[1];
                    }
                    arrivalList.addAll(this.findForDist(walk, tModRecDepth, distanceValues, rayParamRange));
                    continue;
                }
                allwalk.addAll(this.findForAllDepth(walk));
            }
        }
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        if (!distanceValues.isEmpty()) {
            this.printResult(writer, arrivalList);
            writer.flush();
        } else if (this.outputTypeArgs.isText()) {
            this.printResultText(writer, allwalk);
        } else if (this.outputTypeArgs.isJSON()) {
            this.printResultJson(writer, allwalk);
        } else if (this.outputTypeArgs.isHTML()) {
            this.printResultHtml(writer, allwalk);
        }
        writer.close();
    }

    /*
     * WARNING - void declaration
     */
    public List<Arrival> findForDist(List<ProtoSeismicPhase> walk, TauModel tMod, List<RayCalculateable> distanceValues, double[] rayParamRange) throws TauPException {
        void var8_15;
        ArrayList<SeismicPhase> phaseList = new ArrayList<SeismicPhase>();
        ArrayList<String> phaseNameList = new ArrayList<String>();
        for (ProtoSeismicPhase protoSeismicPhase : walk) {
            phaseNameList.add(protoSeismicPhase.getName());
            phaseList.add(protoSeismicPhase.asSeismicPhase());
        }
        if (!this.phaseArgs.isEmpty()) {
            List<PhaseName> givenPhases = this.parsePhaseNameList();
            for (PhaseName pn : givenPhases) {
                phaseNameList.add(pn.getName());
                for (Double rd : this.modelArgs.getReceiverDepths()) {
                    phaseList.addAll(SeismicPhaseFactory.createSeismicPhases(pn.getName(), tMod, tMod.getSourceDepth(), rd, this.modelArgs.getScatterer(), this.isDEBUG()));
                }
            }
        }
        TauP_Time timeTool = new TauP_Time();
        timeTool.setPhaseNames(phaseNameList);
        timeTool.modelArgs = this.modelArgs;
        timeTool.outputTypeArgs = this.outputTypeArgs;
        timeTool.sourceArgs = this.sourceArgs;
        List<Arrival> list = timeTool.calcAll(phaseList, distanceValues);
        if (!this.times.isEmpty()) {
            double maxTime;
            double minTime = this.times.get(0);
            if (this.times.size() > 1) {
                maxTime = this.times.get(1);
            } else {
                maxTime = minTime + this.deltaTime;
                minTime -= this.deltaTime.doubleValue();
            }
            ArrayList<Arrival> timedArrivalList = new ArrayList<Arrival>();
            for (Arrival a : list) {
                if (!(minTime <= a.getTime()) || !(a.getTime() <= maxTime)) continue;
                timedArrivalList.add(a);
            }
            ArrayList<Arrival> arrayList = timedArrivalList;
        }
        if (rayParamRange != null && rayParamRange.length == 2) {
            void var8_13;
            ArrayList<Arrival> rpArrivalList = new ArrayList<Arrival>();
            for (Arrival a : var8_13) {
                if (!(rayParamRange[0] <= a.getRayParam()) || !(a.getRayParam() <= rayParamRange[1])) continue;
                rpArrivalList.add(a);
            }
            ArrayList<Arrival> arrayList = rpArrivalList;
        }
        return var8_15;
    }

    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        if (this.getOutputFormat().equals("json")) {
            FindTimeResult result = this.createTimeResult(arrivalList, this.modelArgs.getTauModel());
            out.println(GsonUtil.toJson(result));
        } else {
            boolean onlyPrintTime = false;
            boolean onlyPrintRayP = false;
            ArrayList<String> relativePhaseName = new ArrayList<String>();
            if (this.getOutputFormat().equals("html")) {
                TauP_Time.printArrivalsAsHtml(out, arrivalList, this.modelArgs.getModelName(), this.getScatterer(), this.isWithAmplitude(), this.sourceArgs, relativePhaseName, "Find");
            } else {
                TauP_Time.printArrivalsAsText(out, arrivalList, this.modelArgs.getModelName(), this.getScatterer(), onlyPrintTime, onlyPrintRayP, this.isWithAmplitude(), this.sourceArgs, relativePhaseName);
            }
        }
        out.flush();
    }

    public List<ProtoSeismicPhase> findForAllDepth(List<ProtoSeismicPhase> walk) throws TauPException {
        List<Object> givenPhases = new ArrayList();
        if (!this.phaseArgs.isEmpty()) {
            givenPhases = this.getSeismicPhases();
        }
        for (SeismicPhase sp : givenPhases) {
            if (sp instanceof SimpleContigSeismicPhase) {
                SimpleContigSeismicPhase ssp = (SimpleContigSeismicPhase)sp;
                walk.add(ssp.getProto());
                continue;
            }
            if (sp instanceof CompositeSeismicPhase) {
                CompositeSeismicPhase csp = (CompositeSeismicPhase)sp;
                for (SimpleContigSeismicPhase subsp : csp.getSubPhaseList()) {
                    walk.add(subsp.getProto());
                }
                continue;
            }
            ScatteredSeismicPhase scat = (ScatteredSeismicPhase)sp;
            if (scat.getScatteredPhase() instanceof SimpleContigSeismicPhase) {
                SimpleContigSeismicPhase ssp = (SimpleContigSeismicPhase)scat.getScatteredPhase();
                walk.add(ssp.getProto());
                continue;
            }
            if (!(scat.getScatteredPhase() instanceof CompositeSeismicPhase)) continue;
            CompositeSeismicPhase csp = (CompositeSeismicPhase)scat.getScatteredPhase();
            for (SimpleContigSeismicPhase subsp : csp.getSubPhaseList()) {
                walk.add(subsp.getProto());
            }
        }
        return walk;
    }

    public List<Double> matchDepthToDiscon(List<Double> excludeDepth, VelocityModel vMod, double tol) throws NoSuchLayerException {
        ArrayList<Double> out = new ArrayList<Double>();
        double[] disconDepths = vMod.getDisconDepths();
        for (Double d : excludeDepth) {
            double best = Double.MAX_VALUE;
            for (double discon : disconDepths) {
                if (!(Math.abs(d - discon) < Math.abs(d - best)) || !(Math.abs(d - discon) < tol)) continue;
                best = discon;
            }
            if (best != Double.MAX_VALUE) {
                out.add(best);
                continue;
            }
            Object disconList = "";
            for (double v : disconDepths) {
                disconList = (String)disconList + " " + v;
            }
            throw new NoSuchLayerException(vMod.getRadiusOfEarth() - d, "Unable to find discontinuity within " + tol + " km of " + d + " in " + vMod.getModelName() + "\nDiscons in model: " + (String)disconList);
        }
        return out;
    }

    public void printResultHtml(PrintWriter writer, List<ProtoSeismicPhase> walk) throws TauPException {
        ArrayList<String> head = new ArrayList<String>();
        head.add("Phase");
        if (this.showrayparam) {
            head.addAll(List.of("Min", "Max (s/deg)"));
        }
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (ProtoSeismicPhase segList : walk) {
            SeismicPhaseSegment endSeg = segList.get(segList.size() - 1);
            ArrayList<String> row = new ArrayList<String>();
            row.add(segList.phaseNameForSegments());
            if (this.showrayparam) {
                row.add(Outputs.formatRayParam(endSeg.getMinRayParam() / 57.29577951308232));
                row.add(Outputs.formatRayParam(endSeg.getMaxRayParam() / 57.29577951308232));
            }
            values.add(row);
        }
        HTMLUtil.createHtmlStart(writer, "TauP Find", HTMLUtil.createTableCSS(), true);
        writer.println(HTMLUtil.createBasicTable(head, values));
        HTMLUtil.addSortTableJS(writer);
        writer.println(HTMLUtil.createHtmlEnding());
        writer.flush();
    }

    public void printResultText(PrintWriter writer, List<ProtoSeismicPhase> walk) throws IOException {
        int maxNameLength = 1;
        for (ProtoSeismicPhase segList : walk) {
            maxNameLength = Math.max(maxNameLength, segList.phaseNameForSegments().length());
        }
        String phaseFormat = "%-" + maxNameLength + "s";
        if (this.showrayparam) {
            writer.println(String.format(phaseFormat, "Phase") + "    Min     Max (s/deg)");
            for (int i = 0; i < maxNameLength; ++i) {
                writer.print("-");
            }
            writer.println("-----------------------");
        }
        for (ProtoSeismicPhase segList : walk) {
            SeismicPhaseSegment endSeg = segList.get(segList.size() - 1);
            if (this.showrayparam) {
                writer.print(String.format(phaseFormat, segList.phaseNameForSegments()) + " " + Outputs.formatRayParam(endSeg.getMinRayParam() / 57.29577951308232) + " " + Outputs.formatRayParam(endSeg.getMaxRayParam() / 57.29577951308232));
            } else {
                writer.print(segList.phaseNameForSegments());
            }
            writer.println();
        }
        writer.flush();
    }

    FindTimeResult createTimeResult(List<Arrival> arrivals, TauModel optTauModel) throws TauPException {
        TauModel tMod = optTauModel;
        if (!arrivals.isEmpty()) {
            tMod = arrivals.get(0).getTauModel();
        }
        ArrayList<Float> excludeList = new ArrayList<Float>();
        for (double d : this.getExcludedDepths(tMod)) {
            excludeList.add(Float.valueOf((float)d));
        }
        ArrayList<String> phases = new ArrayList<String>();
        FindTimeResult result = new FindTimeResult(this.getTauModelName(), this.getSourceDepths(), this.getReceiverDepths(), this.getPhaseArgs().parsePhaseNameList(), this.getScatterer(), false, this.sourceArgs, arrivals, this.maxActions, excludeList, phases);
        return result;
    }

    FindResult createResult(List<ProtoSeismicPhase> walk, TauModel optTauModel) throws TauPException {
        TauModel tMod = optTauModel;
        if (!walk.isEmpty()) {
            tMod = walk.get(0).gettMod();
        }
        ArrayList<Float> excludeList = new ArrayList<Float>();
        for (double d : this.getExcludedDepths(tMod)) {
            excludeList.add(Float.valueOf((float)d));
        }
        ArrayList<String> phases = new ArrayList<String>();
        for (ProtoSeismicPhase segList : walk) {
            phases.add(segList.phaseNameForSegments());
        }
        FindResult result = new FindResult(this.getTauModelName(), this.getSourceDepths(), this.getReceiverDepths(), this.getPhaseArgs().parsePhaseNameList(), this.getScatterer(), this.maxActions, excludeList, phases);
        return result;
    }

    public void printResultJson(PrintWriter writer, List<ProtoSeismicPhase> walk) throws IOException, TauPException {
        FindResult result = this.createResult(walk, this.modelArgs.getTauModel());
        Gson gson = GsonUtil.createGsonBuilder().create();
        writer.println(gson.toJson((Object)result));
        writer.flush();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.onlyPWave && this.onlySWave) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Only one of --pwaveonly and --swaveonly may be used");
        }
        TauModel tMod = this.modelArgs.getTauModel();
        List<Double> excludeDepths = this.getExcludedDepths(tMod);
        List<Double> actualExcludeDepths = this.matchDepthToDiscon(excludeDepths, tMod.getVelocityModel(), this.excludeDepthTol);
        if (this.rayParamRangeDeg != null && this.rayParamRangeKm != null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Only one of --rayparamdeg and --rayparamkm may be used");
        }
        if (this.isWithAmplitude() && this.modelArgs.getTauModel().getVelocityModel().densityIsDefault()) {
            throw new TauModelException("model " + this.modelArgs.getModelName() + " does not include density, but amplitude requires density.");
        }
        if (this.isWithAmplitude() && this.modelArgs.getTauModel().getVelocityModel().QIsDefault()) {
            throw new TauModelException("model " + this.modelArgs.getModelName() + " does not include Q, but amplitude requires Q. Please choose a differet model.");
        }
        this.sourceArgs.validateArguments();
        if (this.sourceArgs.hasStrikeDipRake() && this.azimuth == null) {
            throw new TauModelException("strike,dip,rake requires azimuth");
        }
        if (!(this.distanceArgs.getRayCalculatables(this.sourceArgs).isEmpty() || this.rayParamRangeDeg == null && this.rayParamRangeKm == null || this.getRayParamRange().length != 1)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Single value for --rayparamdeg or --rayparamkm not allowed when also giving --degree distance.");
        }
    }

    protected Double[] getRayParamRange() throws TauModelException {
        if (this.rayParamRangeDeg == null && this.rayParamRangeKm == null) {
            return new Double[0];
        }
        if (this.rayParamRangeDeg != null && this.rayParamRangeKm != null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Only one of --rayparamdeg and --rayparamkm may be used");
        }
        Double[] rpRange = new Double[]{};
        if (this.rayParamRangeKm != null) {
            rpRange = new Double[this.rayParamRangeKm.length];
            rpRange[0] = this.rayParamRangeKm[0] / this.modelArgs.getTauModel().getRadiusOfEarth();
            if (this.rayParamRangeKm.length > 1) {
                rpRange[1] = this.rayParamRangeKm[1] / this.modelArgs.getTauModel().getRadiusOfEarth();
            }
        } else if (this.rayParamRangeDeg != null) {
            rpRange = new Double[this.rayParamRangeDeg.length];
            rpRange[0] = this.rayParamRangeDeg[0] / (Math.PI / 180);
            if (this.rayParamRangeDeg.length > 1) {
                rpRange[1] = this.rayParamRangeDeg[1] / (Math.PI / 180);
            }
        }
        return rpRange;
    }

    public List<Double> getExcludedDepths(TauModel tMod) {
        double[] branchDepths;
        ArrayList<Double> exList = new ArrayList<Double>(this.getExcludeDepth(tMod.getVelocityModel()));
        for (double branchDepth : branchDepths = tMod.getBranchDepths()) {
            if (!this.onlyNamedDiscon || branchDepth == 0.0 || tMod.isNoDisconDepth(branchDepth) || tMod.getVelocityModel().isNamedDisconDepth(branchDepth)) continue;
            exList.add(branchDepth);
        }
        return exList;
    }

    List<Double> getExcludeDepth(VelocityModel vMod) {
        ArrayList<Double> excludeDepth = new ArrayList<Double>();
        for (String discon : this.excludeDepthNames) {
            if (NamedVelocityDiscon.isMoho(discon)) {
                excludeDepth.add(vMod.getMohoDepth());
                continue;
            }
            if (NamedVelocityDiscon.isCmb(discon)) {
                excludeDepth.add(vMod.getCmbDepth());
                continue;
            }
            if (NamedVelocityDiscon.isIcocb(discon)) {
                excludeDepth.add(vMod.getIocbDepth());
                continue;
            }
            boolean found = false;
            for (NamedVelocityDiscon nd : vMod.namedDiscon) {
                if (!discon.equals(nd.getName())) continue;
                excludeDepth.add(nd.getDepth());
                found = true;
                break;
            }
            if (found) continue;
            try {
                double d = Double.parseDouble(discon);
                excludeDepth.add(d);
            }
            catch (NumberFormatException e) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Unable to find discontinuity depth for " + discon);
            }
        }
        return excludeDepth;
    }

    public boolean isWithAmplitude() {
        return this.getSourceArgs().isWithAmplitude();
    }

    public AmplitudeArgs getSourceArgs() {
        return this.sourceArgs;
    }

    @CommandLine.Option(names={"--deg", "--degree"}, paramLabel="d", description={"distance in degrees"}, split=",")
    protected void setDegree(List<Double> degreesList) {
        this.distanceArgs.setDegreeList(degreesList);
    }
}

