/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.AxisType;
import edu.sc.seis.TauP.CompositeSeismicPhase;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.TauP.XYPlotOutput;
import edu.sc.seis.TauP.XYPlottingData;
import edu.sc.seis.TauP.XYSegment;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="curve", description={"Plot travel time vs. distance and other curves for seismic phases."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Curve
extends TauP_AbstractPhaseTool {
    protected String relativePhaseName = "";
    protected AxisType xAxisType = AxisType.degree;
    protected AxisType yAxisType = AxisType.time;
    @CommandLine.Mixin
    SeismicSourceArgs sourceArgs = new SeismicSourceArgs();
    @CommandLine.Option(names={"--az"}, description={"azimuth in degrees, for amp calculations"})
    protected Double azimuth = null;
    protected boolean xAxisAbs = false;
    protected boolean yAxisAbs = false;
    protected boolean xAxisLog = false;
    protected boolean yAxisLog = false;
    protected Double reduceVelDeg = null;
    protected Double reduceVelKm = null;
    protected String redVelString = "";
    protected double[] xAxisMinMax = new double[0];
    protected double[] yAxisMinMax = new double[0];
    @CommandLine.Mixin
    GraphicOutputTypeArgs outputTypeArgs;
    @CommandLine.Mixin
    ColoringArgs coloring = new ColoringArgs();
    @CommandLine.Option(names={"--legend"}, description={"create a legend"})
    boolean isLegend = false;

    public TauP_Curve() {
        super(new GraphicOutputTypeArgs("text", "taup_curve"));
        this.outputTypeArgs = (GraphicOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauPException {
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        List<XYPlottingData> xy = this.calculate(this.xAxisType, this.yAxisType);
        if (this.xAxisMinMax.length == 2 || this.yAxisMinMax.length == 2) {
            xy = XYPlottingData.trimAllToMinMax(xy, this.xAxisMinMax, this.yAxisMinMax);
        }
        this.printResult(writer, xy);
        writer.close();
    }

    public List<XYPlottingData> calculate(AxisType xAxisType, AxisType yAxisType) throws TauPException {
        List<XYPlottingData> xy = this.calculateLinear(xAxisType, yAxisType);
        if (this.isReduceTime()) {
            xy = this.reduce(xy);
        }
        if (this.isxAxisAbs() || this.isyAxisAbs()) {
            xy = XYPlotOutput.recalcForAbs(xy, this.isxAxisAbs(), this.isyAxisAbs());
        }
        if (this.isxAxisLog() || this.isyAxisLog()) {
            xy = XYPlotOutput.recalcForLog(xy, this.isxAxisLog(), this.isyAxisLog());
        }
        return xy;
    }

    public List<XYPlottingData> calculateLinear(AxisType xAxisType, AxisType yAxisType) throws TauPException {
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        ArrayList<XYPlottingData> out = new ArrayList<XYPlottingData>();
        for (SeismicPhase phase : phaseList) {
            ArrayList<String> cssClassesCopy;
            List<XYSegment> sh_segments;
            AxisType yOther;
            AxisType xOther;
            boolean ensure180;
            String phaseDesc = String.valueOf((Object)xAxisType) + "/" + String.valueOf((Object)yAxisType) + " " + phase.getName() + " for a source depth of " + phase.getSourceDepth() + " kilometers in the " + phase.getTauModel().getModelName() + " model";
            String p_or_s = "both_p_swave";
            if (phase.isAllSWave()) {
                p_or_s = "swave";
            } else if (phase.isAllPWave()) {
                p_or_s = "pwave";
            }
            boolean bl = ensure180 = xAxisType == AxisType.degree180 || yAxisType == AxisType.degree180 || xAxisType == AxisType.kilometer180 || yAxisType == AxisType.kilometer180 || xAxisType == AxisType.radian180 || yAxisType == AxisType.radian180;
            if (!phase.hasArrivals()) continue;
            if (yAxisType == AxisType.theta) {
                double dist = 15.0;
                List<Arrival> arrivals = DistanceRay.ofDegrees(dist).calculate(phase);
                for (Arrival arrival : arrivals) {
                    Theta theta = new Theta(arrival);
                    List<double[]> xData = SeismicPhase.splitForRepeatRayParam(phase.getRayParams(), phase.getRayParams());
                    List<double[]> yData = SeismicPhase.splitForRepeatRayParam(theta.getRayParams(), theta.getThetaAtX());
                    ArrayList<XYSegment> segmentList = new ArrayList<XYSegment>();
                    for (int i = 0; i < xData.size(); ++i) {
                        XYSegment seg = new XYSegment(xData.get(i), yData.get(i));
                        segmentList.add(seg);
                    }
                    ArrayList<String> cssClasses = new ArrayList<String>();
                    cssClasses.add(p_or_s);
                    cssClasses.add(SvgUtil.classForPhase(arrival.getName()));
                    XYPlottingData xyp = new XYPlottingData(segmentList, xAxisType.name(), "rayparam", phase.getName(), phaseDesc, cssClasses);
                    out.add(xyp);
                }
                continue;
            }
            SeismicPhase interpolatedPhase = phase.interpolatePhase(Double.parseDouble(this.toolProps.getProperty("taup.curve.maxPathInc", "2")));
            List<double[]> xData = this.calculatePlotForType(interpolatedPhase, xAxisType, ensure180);
            List<double[]> yData = this.calculatePlotForType(interpolatedPhase, yAxisType, ensure180);
            List<XYSegment> segments = XYSegment.createFromLists(xData, yData);
            ArrayList<String> cssClasses = new ArrayList<String>();
            cssClasses.add(p_or_s);
            cssClasses.add(SvgUtil.classForPhase(phase.getName()));
            XYPlottingData xyp = new XYPlottingData(segments, xAxisType.name(), yAxisType.name(), phase.getName(), phaseDesc, cssClasses);
            xyp.cssClasses.add(p_or_s);
            out.add(xyp);
            if (!phase.isAllSWave()) continue;
            if (xAxisType == AxisType.amp || yAxisType == AxisType.amp) {
                xOther = xAxisType == AxisType.amp ? AxisType.ampsh : xAxisType;
                yOther = yAxisType == AxisType.amp ? AxisType.ampsh : yAxisType;
                xData = this.calculatePlotForType(interpolatedPhase, xOther, ensure180);
                yData = this.calculatePlotForType(interpolatedPhase, yOther, ensure180);
                sh_segments = XYSegment.createFromLists(xData, yData);
                cssClassesCopy = new ArrayList<String>(cssClasses);
                cssClassesCopy.add("ampsh");
                out.add(new XYPlottingData(sh_segments, xAxisType.name(), yAxisType.name(), "tr " + phase.getName(), phaseDesc, cssClassesCopy));
            }
            if (xAxisType == AxisType.radiation || yAxisType == AxisType.radiation) {
                xOther = xAxisType == AxisType.radiation ? AxisType.radiationsh : xAxisType;
                yOther = yAxisType == AxisType.radiation ? AxisType.radiationsh : yAxisType;
                xData = this.calculatePlotForType(interpolatedPhase, xOther, ensure180);
                yData = this.calculatePlotForType(interpolatedPhase, yOther, ensure180);
                sh_segments = XYSegment.createFromLists(xData, yData);
                cssClassesCopy = new ArrayList<String>(cssClasses);
                cssClassesCopy.add("radiationsh");
                out.add(new XYPlottingData(sh_segments, xAxisType.name(), yAxisType.name(), "tr " + phase.getName(), phaseDesc, cssClassesCopy));
            }
            if (xAxisType != AxisType.refltran && yAxisType != AxisType.refltran) continue;
            xOther = xAxisType == AxisType.refltran ? AxisType.refltransh : xAxisType;
            yOther = yAxisType == AxisType.refltran ? AxisType.refltransh : yAxisType;
            xData = this.calculatePlotForType(interpolatedPhase, xOther, ensure180);
            yData = this.calculatePlotForType(interpolatedPhase, yOther, ensure180);
            sh_segments = XYSegment.createFromLists(xData, yData);
            cssClassesCopy = new ArrayList<String>(cssClasses);
            cssClassesCopy.add("refltransh");
            out.add(new XYPlottingData(sh_segments, xAxisType.name(), yAxisType.name(), phase.getName(), phaseDesc, cssClassesCopy));
        }
        return out;
    }

    public List<XYPlottingData> reduce(List<XYPlottingData> xy) throws TauModelException {
        Double velFactor;
        ArrayList<XYPlottingData> out = new ArrayList<XYPlottingData>();
        if (TauP_Curve.axisIsDistanceLike(this.xAxisType) && TauP_Curve.axisIsTimeLike(this.yAxisType)) {
            velFactor = this.reduceVelForAxis(this.xAxisType);
        } else if (TauP_Curve.axisIsDistanceLike(this.yAxisType) && TauP_Curve.axisIsTimeLike(this.xAxisType)) {
            velFactor = this.reduceVelForAxis(this.yAxisType);
        } else {
            throw new IllegalArgumentException("axis are not time and distance: " + String.valueOf((Object)this.xAxisType) + " " + String.valueOf((Object)this.yAxisType));
        }
        if (velFactor == null || velFactor == 1.0 || velFactor == 0.0) {
            throw new IllegalArgumentException("Unable to reduce, red vel is invalid: " + velFactor);
        }
        for (XYPlottingData xyp : xy) {
            ArrayList<XYSegment> redSeg = new ArrayList<XYSegment>();
            for (XYSegment xyseg : xyp.segmentList) {
                double[] time;
                double[] dist;
                if (TauP_Curve.axisIsDistanceLike(this.xAxisType)) {
                    dist = xyseg.x;
                    time = xyseg.y;
                } else {
                    dist = xyseg.y;
                    time = xyseg.x;
                }
                for (int i = 0; i < dist.length; ++i) {
                    time[i] = time[i] - dist[i] / velFactor;
                }
                if (TauP_Curve.axisIsDistanceLike(this.xAxisType)) {
                    redSeg.add(new XYSegment(dist, time));
                    continue;
                }
                redSeg.add(new XYSegment(time, dist));
            }
            XYPlottingData redxyp = new XYPlottingData(redSeg, xyp.xAxisType, xyp.yAxisType, xyp.label, xyp.description + ", reduce: " + this.getRedVelLabel(), xyp.cssClasses);
            out.add(redxyp);
        }
        return out;
    }

    public List<double[]> calculatePlotForType(SeismicPhase phase, AxisType axisType, boolean ensure180) throws SlownessModelException, TauModelException {
        if (phase instanceof CompositeSeismicPhase) {
            ArrayList<double[]> out = new ArrayList<double[]>();
            for (SimpleContigSeismicPhase subphase : ((CompositeSeismicPhase)phase).getSubPhaseList()) {
                out.addAll(this.calculatePlotForTypeContig(subphase, axisType, ensure180));
            }
            return out;
        }
        return this.calculatePlotForTypeContig(phase, axisType, ensure180);
    }

    protected List<double[]> calculatePlotForTypeContig(SeismicPhase phase, AxisType axisType, boolean ensure180) throws SlownessModelException, TauModelException {
        Arrival arrival;
        double[] out;
        boolean flatPhase;
        boolean bl = flatPhase = phase.getMaxRayParam() == phase.getMinRayParam();
        if (axisType == AxisType.radian || axisType == AxisType.radian180) {
            out = phase.getDist();
        } else if (axisType == AxisType.degree || axisType == AxisType.degree180) {
            out = phase.getDist();
            int i = 0;
            while (i < out.length) {
                int n = i++;
                out[n] = out[n] * 57.29577951308232;
            }
        } else if (axisType == AxisType.kilometer || axisType == AxisType.kilometer180) {
            out = phase.getDist();
            double radToKm = this.getRadiusOfEarth();
            int i = 0;
            while (i < out.length) {
                int n = i++;
                out[n] = out[n] * radToKm;
            }
        } else if (axisType == AxisType.rayparamrad) {
            out = phase.getRayParams();
        } else if (axisType == AxisType.rayparamdeg) {
            out = phase.getRayParams();
            int i = 0;
            while (i < out.length) {
                int n = i++;
                out[n] = out[n] / 57.29577951308232;
            }
        } else if (axisType == AxisType.rayparamkm) {
            out = phase.getRayParams();
            double radToKm = this.getRadiusOfEarth();
            int i = 0;
            while (i < out.length) {
                int n = i++;
                out[n] = out[n] / radToKm;
            }
        } else if (axisType == AxisType.time) {
            out = phase.getTime();
        } else if (axisType == AxisType.tau) {
            out = phase.getTau();
        } else if (axisType == AxisType.takeoffangle) {
            double[] dist = phase.getDist();
            out = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival2 = this.arrivalAtIndex(i, phase);
                out[i] = arrival2.getTakeoffAngleDegree();
            }
        } else if (axisType == AxisType.incidentangle) {
            double[] dist = phase.getDist();
            out = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival3 = this.arrivalAtIndex(i, phase);
                out[i] = arrival3.getIncidentAngleDegree();
            }
        } else if (axisType == AxisType.turndepth) {
            double[] dist = phase.getDist();
            out = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival4 = this.arrivalAtIndex(i, phase);
                out[i] = arrival4.getDeepestPierce().getDepth();
            }
        } else if (axisType == AxisType.radiation || axisType == AxisType.radiationpsv) {
            double[] dist = phase.getDist();
            out = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival5 = this.arrivalAtIndex(i, phase);
                out[i] = arrival5.getRadiationPatternPSV();
            }
        } else if (axisType == AxisType.radiationsh) {
            double[] dist = phase.getDist();
            out = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival6 = this.arrivalAtIndex(i, phase);
                out[i] = arrival6.getRadiationPatternSH();
            }
        } else if (axisType == AxisType.amp || axisType == AxisType.amppsv || axisType == AxisType.ampsh) {
            boolean isAmpSH = axisType == AxisType.ampsh;
            double[] dist = phase.getDist();
            double[] amp = new double[dist.length];
            if (!isAmpSH || phase.isAllSWave()) {
                for (int i = 0; i < dist.length; ++i) {
                    arrival = this.arrivalAtIndex(i, phase);
                    amp[i] = isAmpSH ? arrival.getAmplitudeFactorSH() : arrival.getAmplitudeFactorPSV();
                }
            }
            out = amp;
        } else if (axisType == AxisType.geospread) {
            double[] dist = phase.getDist();
            double[] amp = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival7 = this.arrivalAtIndex(i, phase);
                amp[i] = arrival7.getAmplitudeGeometricSpreadingFactor();
            }
            out = amp;
        } else if (axisType == AxisType.refltran || axisType == AxisType.refltranpsv || axisType == AxisType.refltransh) {
            boolean isSH = axisType == AxisType.refltransh;
            double[] dist = phase.getDist();
            double[] amp = new double[dist.length];
            if (!isSH || phase.isAllSWave()) {
                for (int i = 0; i < dist.length; ++i) {
                    arrival = this.arrivalAtIndex(i, phase);
                    if (isSH) {
                        amp[i] = arrival.getEnergyFluxFactorReflTransSH();
                        continue;
                    }
                    amp[i] = arrival.getEnergyFluxFactorReflTransPSV();
                    if (amp[i] != 0.0) continue;
                    System.out.println(arrival);
                    System.out.println("index: " + arrival.getRayParamIndex());
                }
            }
            out = amp;
        } else if (axisType == AxisType.tstar) {
            out = new double[phase.getRayParams().length];
            for (int i = 0; i < out.length; ++i) {
                Arrival arrival8 = this.arrivalAtIndex(i, phase);
                out[i] = arrival8.calcTStar();
            }
        } else if (axisType == AxisType.attenuation) {
            out = new double[phase.getRayParams().length];
            for (int i = 0; i < out.length; ++i) {
                Arrival arrival9 = this.arrivalAtIndex(i, phase);
                out[i] = arrival9.calcAttenuation(this.sourceArgs.getAttenuationFrequency(), this.sourceArgs.getNumFrequencies());
            }
        } else if (axisType == AxisType.index) {
            out = new double[phase.getRayParams().length];
            for (int i = phase.getMaxRayParamIndex(); i <= phase.getMinRayParamIndex(); ++i) {
                out[i - phase.getMaxRayParamIndex()] = i;
            }
        } else if (axisType == AxisType.energygeospread) {
            double[] dist = phase.getDist();
            double[] amp = new double[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                Arrival arrival10 = this.arrivalAtIndex(i, phase);
                amp[i] = arrival10.getEnergyGeometricSpreadingFactor();
            }
            out = amp;
        } else if (axisType == AxisType.pathlength) {
            out = new double[phase.getRayParams().length];
            for (int i = 0; i < out.length; ++i) {
                Arrival arrival11 = this.arrivalAtIndex(i, phase);
                out[i] = arrival11.calcPathLength();
            }
        } else {
            throw new IllegalArgumentException("Unknown axisType: " + String.valueOf((Object)axisType));
        }
        double[] rayParams = phase.getRayParams();
        if (ensure180) {
            int j;
            double[] dist = new double[phase.getDist().length];
            System.arraycopy(phase.getDist(), 0, dist, 0, dist.length);
            int wrapMinIndex = (int)Math.round(Math.floor(phase.getMinDistance() / Math.PI));
            int wrapMaxIndex = (int)Math.round(Math.ceil(phase.getMaxDistance() / Math.PI));
            block17: for (j = wrapMinIndex; j <= wrapMaxIndex; ++j) {
                double wrapRadian = (double)j * Math.PI;
                for (int i = 1; i < out.length; ++i) {
                    if (!(dist[i - 1] < wrapRadian && wrapRadian < dist[i]) && (!(dist[i - 1] > wrapRadian) || !(wrapRadian > dist[i]))) continue;
                    double[] outSeg = new double[out.length + 1];
                    double[] distSeg = new double[out.length + 1];
                    double[] rpSeg = new double[rayParams.length + 1];
                    System.arraycopy(out, 0, outSeg, 0, i);
                    System.arraycopy(dist, 0, distSeg, 0, i);
                    System.arraycopy(rayParams, 0, rpSeg, 0, i);
                    outSeg[i] = LinearInterpolation.linearInterp(dist[i - 1], out[i - 1], dist[i], out[i], wrapRadian);
                    distSeg[i] = wrapRadian;
                    rpSeg[i] = LinearInterpolation.linearInterp(dist[i - 1], rayParams[i - 1], dist[i], rayParams[i], wrapRadian);
                    System.arraycopy(out, i, outSeg, i + 1, out.length - i);
                    System.arraycopy(dist, i, distSeg, i + 1, out.length - i);
                    System.arraycopy(rayParams, i, rpSeg, i + 1, out.length - i);
                    out = outSeg;
                    dist = distSeg;
                    rayParams = rpSeg;
                    continue block17;
                }
            }
            if (axisType == AxisType.degree180) {
                for (j = 0; j < out.length; ++j) {
                    out[j] = Math.abs(out[j] % 360.0);
                    if (!(out[j] > 180.0)) continue;
                    out[j] = 360.0 - out[j];
                }
            } else if (axisType == AxisType.radian180) {
                for (j = 0; j < out.length; ++j) {
                    out[j] = Math.abs(out[j] % (Math.PI * 2));
                    if (!(out[j] > Math.PI)) continue;
                    out[j] = Math.PI * 2 - out[j];
                }
            } else if (axisType == AxisType.kilometer180) {
                double km180 = phase.getTauModel().getRadiusOfEarth() * Math.PI;
                for (int j2 = 0; j2 < out.length; ++j2) {
                    out[j2] = Math.abs(out[j2] % (2.0 * km180));
                    if (!(out[j2] > km180)) continue;
                    out[j2] = 2.0 * km180 - out[j2];
                }
            }
        }
        List<double[]> splitCurve = !flatPhase ? SeismicPhase.splitForRepeatRayParam(rayParams, out) : List.of(out);
        return splitCurve;
    }

    public Arrival arrivalAtIndex(int i, SeismicPhase phase) throws SlownessModelException, NoSuchLayerException {
        RayParamIndexRay rc = new RayParamIndexRay(i);
        rc.setSourceArgs(this.sourceArgs);
        rc.setAzimuth(this.azimuth);
        rc.setDescription("Index " + i);
        return rc.calculate(phase).get(0);
    }

    public void printResult(PrintWriter writer, List<XYPlottingData> xyPlots) throws TauPException {
        XYPlotOutput xyOut = new XYPlotOutput(xyPlots, this.modelArgs);
        xyOut.setColoringArgs(this.coloring);
        List<PhaseName> phaseNameList = this.parsePhaseNameList();
        xyOut.setPhaseNames(phaseNameList);
        xyOut.setxAxisMinMax(this.xAxisMinMax);
        xyOut.setyAxisMinMax(this.yAxisMinMax);
        xyOut.setXLabel((this.isxAxisLog() ? "Log " : "") + this.axisLabel(this.xAxisType));
        xyOut.setYLabel((this.isyAxisLog() ? "Log " : "") + this.axisLabel(this.yAxisType));
        if (this.yAxisType == AxisType.turndepth) {
            xyOut.setyAxisInvert(true);
        }
        if (this.outputTypeArgs.isJSON()) {
            xyOut.printAsJSON(writer, 2);
        } else if (this.outputTypeArgs.isText()) {
            xyOut.printAsGmtText(writer);
        } else if (this.outputTypeArgs.isGMT()) {
            xyOut.printAsGmtScript(writer, TauP_Curve.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs, this.isLegend);
        } else if (this.outputTypeArgs.isSVG() || this.outputTypeArgs.isHTML()) {
            Object cssExtra = "";
            switch (this.coloring.getColoring()) {
                case auto: {
                    break;
                }
                case phase: {
                    cssExtra = (String)cssExtra + String.valueOf(SvgUtil.createPhaseColorCSS(phaseNameList, this.coloring));
                    break;
                }
                case wavetype: {
                    cssExtra = (String)cssExtra + String.valueOf(SvgUtil.createWaveTypeColorCSS(this.coloring));
                    break;
                }
                default: {
                    cssExtra = (String)cssExtra + String.valueOf(SvgUtil.createNoneColorCSS(this.coloring));
                }
            }
            if (this.outputTypeArgs.isSVG()) {
                xyOut.printAsSvg(writer, TauP_Curve.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), (CharSequence)cssExtra, this.isLegend);
            } else {
                xyOut.printAsHtml(writer, TauP_Curve.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), (CharSequence)cssExtra, this.isLegend);
            }
        } else {
            throw new IllegalArgumentException("Unknown output format: " + this.outputTypeArgs.getOutputFormat());
        }
        writer.flush();
    }

    @Override
    public void destroy() throws TauPException {
    }

    public static boolean axisIsDistanceLike(AxisType axisType) {
        return axisType == AxisType.degree || axisType == AxisType.degree180 || axisType == AxisType.radian || axisType == AxisType.radian180 || axisType == AxisType.kilometer || axisType == AxisType.kilometer180;
    }

    public static boolean axisIsTimeLike(AxisType axisType) {
        return axisType == AxisType.time;
    }

    @Override
    public void validateArguments() throws TauModelException {
        if ((AxisType.needsDensity(this.xAxisType) || AxisType.needsDensity(this.yAxisType)) && this.modelArgs.getTauModel().getVelocityModel().densityIsDefault()) {
            throw new TauModelException("model " + this.modelArgs.getModelName() + " does not include density, but " + String.valueOf((Object)this.xAxisType) + "/" + String.valueOf((Object)this.yAxisType) + " requires density.");
        }
        if ((AxisType.needsQ(this.xAxisType) || AxisType.needsQ(this.yAxisType)) && this.modelArgs.getTauModel().getVelocityModel().QIsDefault()) {
            throw new TauModelException("model " + this.modelArgs.getModelName() + " does not include Q, but " + String.valueOf((Object)this.xAxisType) + "/" + String.valueOf((Object)this.yAxisType) + " requires Q. Please choose a different model.");
        }
        this.sourceArgs.validateArguments();
        if (this.sourceArgs.hasStrikeDipRake() && this.azimuth == null) {
            throw new TauModelException("strike,dip,rake requires azimuth");
        }
    }

    public AxisType getxAxisType() {
        return this.xAxisType;
    }

    @CommandLine.Option(names={"-x", "--xaxis"}, paramLabel="type", description={"X axis data type, default is ${DEFAULT-VALUE}, one of ${COMPLETION-CANDIDATES}"}, defaultValue="degree180")
    public void setxAxisType(AxisType xAxisType) {
        this.xAxisType = xAxisType;
    }

    public AxisType getyAxisType() {
        return this.yAxisType;
    }

    @CommandLine.Option(names={"-y", "--yaxis"}, paramLabel="type", description={"Y axis data type, default is ${DEFAULT-VALUE}, one of ${COMPLETION-CANDIDATES}"}, defaultValue="time")
    public void setyAxisType(AxisType yAxisType) {
        this.yAxisType = yAxisType;
    }

    public double[] getxAxisMinMax() {
        return this.xAxisMinMax;
    }

    @CommandLine.Option(names={"--xminmax"}, arity="2", paramLabel="x", description={"min and max x axis for plotting"})
    public void setxAxisMinMax(double[] xAxisMinMax) {
        this.xAxisMinMax = xAxisMinMax;
    }

    public double[] getyAxisMinMax() {
        return this.yAxisMinMax;
    }

    @CommandLine.Option(names={"--yminmax"}, arity="2", paramLabel="y", description={"min and max y axis for plotting"})
    public void setyAxisMinMax(double[] yAxisMinMax) {
        this.yAxisMinMax = yAxisMinMax;
    }

    public boolean isxAxisAbs() {
        return this.xAxisAbs;
    }

    @CommandLine.Option(names={"--xabs"}, description={"X axis is absolute value"})
    public void setxAxisAbs(boolean xAxisAbs) {
        this.xAxisAbs = xAxisAbs;
    }

    public boolean isyAxisAbs() {
        return this.yAxisAbs;
    }

    @CommandLine.Option(names={"--yabs"}, description={"Y axis is absolute value"})
    public void setyAxisAbs(boolean yAxisAbs) {
        this.yAxisAbs = yAxisAbs;
    }

    public boolean isxAxisLog() {
        return this.xAxisLog;
    }

    @CommandLine.Option(names={"--xlog"}, description={"X axis is log"})
    public void setxAxisLog(boolean xAxisLog) {
        this.xAxisLog = xAxisLog;
    }

    public boolean isyAxisLog() {
        return this.yAxisLog;
    }

    @CommandLine.Option(names={"--ylog"}, description={"Y axis is log"})
    public void setyAxisLog(boolean yAxisLog) {
        this.yAxisLog = yAxisLog;
    }

    public String axisLabel(AxisType axisType) {
        switch (axisType) {
            case amp: {
                return "Amplitude (m) PSv,Sh " + Outputs.formatDistanceNoPad(this.sourceArgs.getMw()) + " Mw";
            }
            case ampsh: {
                return "Amplitude (m) Sh " + Outputs.formatDistanceNoPad(this.sourceArgs.getMw()) + " Mw";
            }
            case amppsv: {
                return "Amplitude (m) PSv " + Outputs.formatDistanceNoPad(this.sourceArgs.getMw()) + " Mw";
            }
            case time: {
                return "Time (s)";
            }
            case degree: 
            case degree180: {
                return "Degrees";
            }
            case radian: 
            case radian180: {
                return "Radian";
            }
            case rayparamrad: {
                return "Ray Param (s/rad)";
            }
            case rayparamdeg: {
                return "Ray Param (s/deg)";
            }
            case rayparamkm: {
                return "Ray Param (s/km)";
            }
            case tau: {
                return "Tau";
            }
            case kilometer: 
            case kilometer180: {
                return "Kilometers";
            }
            case index: {
                return "Index";
            }
            case geospread: {
                return "Geometric Spreading (1/km)";
            }
            case energygeospread: {
                return "Energy Geometric Spreading (1/km2)";
            }
            case takeoffangle: {
                return "Takeoff Angle (deg)";
            }
            case incidentangle: {
                return "Incident Angle (deg)";
            }
            case turndepth: {
                return "Turn Depth (km)";
            }
            case refltran: {
                return "Energy Flux Factor Reflection/Transmission Coef. PSv,Sh";
            }
            case refltranpsv: {
                return "Energy Flux Factor Reflection/Transmission Coef. PSv";
            }
            case refltransh: {
                return "Energy Flux Factor Reflection/Transmission Coef. Sh";
            }
            case pathlength: {
                return "Path Length (km)";
            }
            case radiation: {
                return "PSvSh Radiation Pattern";
            }
            case radiationpsv: {
                return "PSv Radiation Pattern";
            }
            case radiationsh: {
                return "Sh Radiation Pattern";
            }
        }
        return axisType.name();
    }

    public boolean isReduceTime() {
        return this.reduceVelKm != null || this.reduceVelDeg != null;
    }

    public String getRelativePhaseName() {
        return this.relativePhaseName;
    }

    @CommandLine.Option(names={"--rel"}, paramLabel="phase", description={"plot relative to the given phase, no effect unless distance/time"})
    public void setRelativePhaseName(String relativePhaseName) {
        this.relativePhaseName = relativePhaseName;
    }

    public double getReduceVelRadian() {
        if (this.reduceVelKm != null) {
            try {
                return this.reduceVelKm / this.modelArgs.getTauModel().getRadiusOfEarth();
            }
            catch (TauModelException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.reduceVelDeg != null) {
            return this.reduceVelDeg * Math.PI / 180.0;
        }
        return 0.0;
    }

    public Double getReduceVelDeg() {
        return this.reduceVelDeg;
    }

    @CommandLine.Option(names={"--reddeg"}, paramLabel="deg/s", description={"outputs curves with a reducing velocity (deg/sec), no effect if axis is not distance-like/time"})
    public void setReduceVelDeg(double reduceVel) {
        if (reduceVel != 0.0) {
            this.redVelString = reduceVel + " deg/s";
            this.reduceVelDeg = reduceVel;
        }
    }

    public Double getReduceVelKm() {
        return this.reduceVelKm;
    }

    public Double reduceVelForAxis(AxisType axisType) throws TauModelException {
        if (axisType == AxisType.degree || axisType == AxisType.degree180) {
            if (this.getReduceVelDeg() != null) {
                return this.getReduceVelDeg();
            }
            if (this.getReduceVelKm() != null) {
                return this.getReduceVelRadian() * 180.0 / Math.PI;
            }
        } else if (axisType == AxisType.kilometer || axisType == AxisType.kilometer180) {
            if (this.getReduceVelKm() != null) {
                return this.getReduceVelKm();
            }
            if (this.getReduceVelDeg() != 0.0) {
                return this.getReduceVelRadian() * this.modelArgs.getTauModel().getRadiusOfEarth();
            }
        } else if (axisType == AxisType.radian) {
            return this.getReduceVelRadian();
        }
        throw new IllegalArgumentException("axis type not distance-like: " + String.valueOf((Object)axisType));
    }

    @CommandLine.Option(names={"--redkm"}, paramLabel="km/s", description={"outputs curves with a reducing velocity (km/sec), no effect if axis is not distance-like/time"})
    public void setReduceVelKm(double reduceVel) {
        this.redVelString = reduceVel + " km/s";
        if (reduceVel == 0.0) {
            throw new IllegalArgumentException("Reducing velocity must be positive: " + reduceVel);
        }
        this.reduceVelKm = reduceVel;
    }

    public String getRedVelLabel() {
        return this.redVelString;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public void setxMinMax(double min, double max) {
        if (!(min < max)) {
            throw new IllegalArgumentException("min must be < max: " + min + " < " + max);
        }
        this.xAxisMinMax = new double[]{min, max};
    }

    public void setyMinMax(double min, double max) {
        if (!(min < max)) {
            throw new IllegalArgumentException("min must be < max: " + min + " < " + max);
        }
        this.yAxisMinMax = new double[]{min, max};
    }
}

