/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.Location;

public class StationBackAzimuth
extends LatLonable {
    Location staLatLon;
    double backAzimuth;

    public StationBackAzimuth(Location staLatLon, Double backAzimuth) {
        this.staLatLon = staLatLon;
        this.backAzimuth = backAzimuth;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        if (this.isGeodetic()) {
            throw new RuntimeException("geodetic not yet");
        }
        double evtLat = SphericalCoords.latFor(this.staLatLon.getLatitude(), this.staLatLon.getLongitude(), this.backAzimuth, totalDist);
        double evtLon = SphericalCoords.lonFor(this.staLatLon.getLatitude(), this.staLatLon.getLongitude(), this.backAzimuth, totalDist);
        double azimuth = SphericalCoords.azimuth(evtLat, evtLon, this.staLatLon.getLatitude(), this.staLatLon.getLongitude());
        out[0] = SphericalCoords.latFor(evtLat, evtLon, calcDist, azimuth);
        out[1] = SphericalCoords.lonFor(evtLat, evtLon, calcDist, azimuth);
        return out;
    }
}

