/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceKmRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.FixedHemisphereDistanceRay;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.seisFile.Location;
import java.util.ArrayList;
import java.util.List;

public class ExactDistanceRay
extends DistanceRay {
    private final DistanceRay distanceRay;

    ExactDistanceRay(DistanceRay dr) {
        this.distanceRay = dr;
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) {
        List<Arrival> phaseArrivals = phase instanceof SimpleSeismicPhase ? ((SimpleSeismicPhase)phase).calcTimeExactDistance(this.getRadians(phase.getTauModel().getRadiusOfEarth())) : this.calcScatteredPhase((ScatteredSeismicPhase)phase);
        return phaseArrivals;
    }

    @Override
    public List<Arrival> calcScatteredPhase(ScatteredSeismicPhase phase) {
        double deg = this.getDegrees(phase.getTauModel().getRadiusOfEarth());
        double scatDistDeg = ScatteredSeismicPhase.calcScatterDistDeg(deg, phase.getScattererDistanceDeg(), phase.isBackscatter());
        FixedHemisphereDistanceRay scatRay = DistanceRay.ofFixedHemisphereDegrees(scatDistDeg);
        SimpleSeismicPhase scatteredPhase = phase.getScatteredPhase();
        List<Double> arrivalDistList = scatRay.calcRadiansInRange(scatteredPhase.getMinDistance(), scatteredPhase.getMaxDistance(), phase.getTauModel().getRadiusOfEarth(), false);
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (Double distRadian : arrivalDistList) {
            arrivals.addAll(phase.getScatteredPhase().calcTimeExactDistance(distRadian));
        }
        ArrayList<Arrival> scatArrivals = new ArrayList<Arrival>();
        for (Arrival a : arrivals) {
            a.setSearchValue(scatRay);
            scatArrivals.add(new ScatteredArrival(phase, this, phase.getInboundArrival(), a, phase.isBackscatter()));
        }
        Arrival.sortArrivals(scatArrivals);
        return scatArrivals;
    }

    @Override
    public void copyFrom(DistanceRay dr) {
        this.distanceRay.copyFrom(dr);
    }

    @Override
    public double getDegrees(double radius) {
        return this.distanceRay.getDegrees(radius);
    }

    @Override
    public double getRadians(double radius) {
        return this.distanceRay.getRadians(radius);
    }

    @Override
    public double getKilometers(double radius) {
        return this.distanceRay.getKilometers(radius);
    }

    @Override
    public void withEventAzimuth(Location evt, double azimuth) {
        this.distanceRay.withEventAzimuth(evt, azimuth);
    }

    @Override
    public void withStationBackAzimuth(Location sta, double backazimuth) {
        this.distanceRay.withStationBackAzimuth(sta, backazimuth);
    }

    @Override
    public boolean hasSourceDepth() {
        return this.distanceRay.hasSourceDepth();
    }

    @Override
    public Double getSourceDepth() {
        return this.distanceRay.getSourceDepth();
    }

    @Override
    public boolean hasReceiverDepth() {
        return this.distanceRay.hasReceiverDepth();
    }

    @Override
    public Double getReceiverDepth() {
        return this.distanceRay.getReceiverDepth();
    }

    @Override
    public boolean hasAzimuth() {
        return this.distanceRay.hasAzimuth();
    }

    @Override
    public Double getNormalizedAzimuth() {
        return this.distanceRay.getNormalizedAzimuth();
    }

    @Override
    public Double getAzimuth() {
        return this.distanceRay.getAzimuth();
    }

    @Override
    public void setAzimuth(Double azimuth) {
        this.distanceRay.setAzimuth(azimuth);
    }

    @Override
    public boolean hasBackAzimuth() {
        return this.distanceRay.hasBackAzimuth();
    }

    @Override
    public Double getNormalizedBackAzimuth() {
        return this.distanceRay.getNormalizedBackAzimuth();
    }

    @Override
    public Double getBackAzimuth() {
        return this.distanceRay.getBackAzimuth();
    }

    @Override
    public void setBackAzimuth(Double backAzimuth) {
        this.distanceRay.setBackAzimuth(backAzimuth);
    }

    @Override
    public boolean hasSourceArgs() {
        return this.distanceRay.hasSourceArgs();
    }

    @Override
    public void setSourceArgs(SeismicSourceArgs sourceArgs) {
        this.distanceRay.setSourceArgs(sourceArgs);
    }

    @Override
    public SeismicSourceArgs getSourceArgs() {
        return this.distanceRay.getSourceArgs();
    }

    @Override
    public boolean hasDescription() {
        return this.distanceRay.hasDescription();
    }

    @Override
    public String getDescription() {
        return this.distanceRay.getDescription();
    }

    @Override
    public void setDescription(String desc) {
        this.distanceRay.setDescription(desc);
    }

    @Override
    public boolean isLatLonable() {
        return this.distanceRay.isLatLonable();
    }

    @Override
    public LatLonable getLatLonable() {
        return this.distanceRay.getLatLonable();
    }

    @Override
    public List<Double> calcRadiansInRange(double minRadian, double maxRadian, double radius, boolean phaseBothHemisphere) {
        double radianVal = this.distanceRay.getRadians(radius);
        if (phaseBothHemisphere) {
            radianVal = Math.abs(radianVal);
        }
        ArrayList<Double> out = new ArrayList<Double>();
        if (minRadian <= radianVal && radianVal <= maxRadian) {
            out.add(radianVal);
        }
        return out;
    }

    protected ExactDistanceRay duplicate() {
        DistanceRay inner;
        if (this.distanceRay instanceof DistanceAngleRay) {
            inner = ((DistanceAngleRay)this.distanceRay).duplicate();
        } else if (this.distanceRay instanceof DistanceKmRay) {
            inner = ((DistanceKmRay)this.distanceRay).duplicate();
        } else {
            throw new RuntimeException("duplicate unknown inner DistanceRay: " + this.distanceRay.getClass().getName());
        }
        ExactDistanceRay dr = new ExactDistanceRay(inner);
        dr.copyFrom(this);
        return dr;
    }

    @Override
    public String toString() {
        return "exactly " + this.distanceRay.toString();
    }
}

