/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SacIncrementalloader {
    DataInput in;
    SacHeader header;
    int chunkSize;
    int ptsRead = 0;
    String filename;
    File file;
    public static final int DEFAULT_SIZE = 10000;

    public SacIncrementalloader(String filename) throws IOException {
        this(filename, 10000);
    }

    public SacIncrementalloader(String filename, int chunkSize) throws IOException {
        this(new File(filename), chunkSize);
    }

    public SacIncrementalloader(File file) throws IOException {
        this(file, 10000);
    }

    public SacIncrementalloader(File file, int chunkSize) throws IOException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(file))), chunkSize);
    }

    public SacIncrementalloader(DataInput in, int chunkSize) throws IOException {
        this.in = in;
        this.header = new SacHeader(in);
    }

    public SacHeader getHeader() {
        return this.header;
    }

    public float[] next() throws IOException {
        int remaining = this.header.getNpts() - this.ptsRead;
        float[] dataSection = new float[this.chunkSize < remaining ? this.chunkSize : remaining];
        if (this.ptsRead < this.header.getNpts()) {
            SacTimeSeries.readSomeData(this.in, dataSection, this.header.getByteOrder());
            this.ptsRead += dataSection.length;
            return dataSection;
        }
        return new float[0];
    }

    public void skip(int samples) throws IOException {
        int remaining = this.header.getNpts() - this.ptsRead;
        this.in.skipBytes(samples < remaining ? samples : remaining);
        this.ptsRead += samples < remaining ? samples : remaining;
    }

    public int getNumRemaining() {
        return this.header.getNpts() - this.ptsRead;
    }

    public int getNumRead() {
        return this.ptsRead;
    }

    public void close() {
        if (this.in != null && this.in instanceof DataInputStream) {
            try {
                ((DataInputStream)this.in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in = null;
    }
}

