/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StationMagnitudeContribution {
    public static final String ELEMENT_NAME = "stationMagnitudeContribution";
    private String stationMagnitudeID;
    private float residual;
    private float weight;

    public StationMagnitudeContribution(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("stationMagnitudeID")) {
                    this.stationMagnitudeID = StaxUtil.pullText(reader, "stationMagnitudeID");
                    continue;
                }
                if (elName.equals("residual")) {
                    this.residual = StaxUtil.pullFloat(reader, "residual");
                    continue;
                }
                if (elName.equals("weight")) {
                    this.weight = StaxUtil.pullFloat(reader, "weight");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public float getResidual() {
        return this.residual;
    }

    public String getStationMagnitudeID() {
        return this.stationMagnitudeID;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setResidual(float residual) {
        this.residual = residual;
    }

    public void setStationMagnitudeID(String stationMagnitudeID) {
        this.stationMagnitudeID = stationMagnitudeID;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }
}

