/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.ConfidenceEllipsoid;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class OriginUncertainty {
    public static final String ELEMENT_NAME = "originUncertainty";
    Float horizontalUncertainty;
    Float minHorizontalUncertainty;
    Float maxHorizontalUncertainty;
    Float azimuthMaxHorizontalUncertainty;
    ConfidenceEllipsoid confidenceEllipsoid;
    Float confidenceLevel;
    String preferredDescription;

    public OriginUncertainty(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("horizontalUncertainty")) {
                    this.horizontalUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "horizontalUncertainty")));
                    continue;
                }
                if (elName.equals("minHorizontalUncertainty")) {
                    this.minHorizontalUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "minHorizontalUncertainty")));
                    continue;
                }
                if (elName.equals("maxHorizontalUncertainty")) {
                    this.maxHorizontalUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "maxHorizontalUncertainty")));
                    continue;
                }
                if (elName.equals("azimuthMaxHorizontalUncertainty")) {
                    this.azimuthMaxHorizontalUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "azimuthMaxHorizontalUncertainty")));
                    continue;
                }
                if (elName.equals("confidenceLevel")) {
                    this.confidenceLevel = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "confidenceLevel")));
                    continue;
                }
                if (elName.equals("confidenceEllipsoid")) {
                    this.confidenceEllipsoid = new ConfidenceEllipsoid(reader);
                    continue;
                }
                if (elName.equals("preferredDescription")) {
                    this.preferredDescription = StaxUtil.pullText(reader, "preferredDescription");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Float getAzimuthMaxHorizontalUncertainty() {
        return this.azimuthMaxHorizontalUncertainty;
    }

    public ConfidenceEllipsoid getConfidenceEllipsoid() {
        return this.confidenceEllipsoid;
    }

    public Float getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public Float getHorizontalUncertainty() {
        return this.horizontalUncertainty;
    }

    public Float getMaxHorizontalUncertainty() {
        return this.maxHorizontalUncertainty;
    }

    public Float getMinHorizontalUncertainty() {
        return this.minHorizontalUncertainty;
    }

    public String getPreferredDescription() {
        return this.preferredDescription;
    }

    public void setAzimuthMaxHorizontalUncertainty(Float azimuthMaxHorizontalUncertainty) {
        this.azimuthMaxHorizontalUncertainty = azimuthMaxHorizontalUncertainty;
    }

    public void setConfidenceEllipsoid(ConfidenceEllipsoid confidenceEllipsoid) {
        this.confidenceEllipsoid = confidenceEllipsoid;
    }

    public void setConfidenceLevel(Float confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public void setHorizontalUncertainty(Float horizontalUncertainty) {
        this.horizontalUncertainty = horizontalUncertainty;
    }

    public void setMaxHorizontalUncertainty(Float maxHorizontalUncertainty) {
        this.maxHorizontalUncertainty = maxHorizontalUncertainty;
    }

    public void setMinHorizontalUncertainty(Float minHorizontalUncertainty) {
        this.minHorizontalUncertainty = minHorizontalUncertainty;
    }

    public void setPreferredDescription(String preferredDescription) {
        this.preferredDescription = preferredDescription;
    }
}

