/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import edu.sc.seis.seisFile.fdsnws.quakeml.TimeWindow;
import edu.sc.seis.seisFile.fdsnws.quakeml.WaveformStreamID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Amplitude {
    public static final String ELEMENT_NAME = "amplitude";
    String publicID;
    String pickID;
    String type;
    RealQuantity genericAmplitude;
    RealQuantity period;
    TimeWindow timeWindow;
    Time scalingTime;
    Float snr;
    String category;
    String unit;
    String methodID;
    WaveformStreamID waveformID;
    String filterID;
    String magnitudeHint;
    String evaluationMode;
    String evaluationStatus;
    CreationInfo creationInfo;
    List<Comment> commentList = new ArrayList<Comment>();

    public static String getElementName() {
        return ELEMENT_NAME;
    }

    public Amplitude(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicID = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("category")) {
                    this.category = StaxUtil.pullText(reader, "category");
                    continue;
                }
                if (elName.equals("unit")) {
                    this.unit = StaxUtil.pullText(reader, "unit");
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("snr")) {
                    this.snr = Float.valueOf(StaxUtil.pullFloat(reader, "snr"));
                    continue;
                }
                if (elName.equals("scalingTime")) {
                    this.scalingTime = new Time(reader, "scalingTime");
                    continue;
                }
                if (elName.equals("timeWindow")) {
                    this.timeWindow = new TimeWindow(reader);
                    continue;
                }
                if (elName.equals("waveformID")) {
                    this.waveformID = new WaveformStreamID(reader, "waveformID");
                    continue;
                }
                if (elName.equals("filterID")) {
                    this.filterID = StaxUtil.pullText(reader, "filterID");
                    continue;
                }
                if (elName.equals("magnitudeHint")) {
                    this.magnitudeHint = StaxUtil.pullText(reader, "magnitudeHint");
                    continue;
                }
                if (elName.equals("pickID")) {
                    this.pickID = StaxUtil.pullText(reader, "pickID");
                    continue;
                }
                if (elName.equals("period")) {
                    this.period = new RealQuantity(reader, "period");
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("genericAmplitude")) {
                    this.genericAmplitude = new RealQuantity(reader, "genericAmplitude");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getCategory() {
        return this.category;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public RealQuantity getGenericAmplitude() {
        return this.genericAmplitude;
    }

    public String getMagnitudeHint() {
        return this.magnitudeHint;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public RealQuantity getPeriod() {
        return this.period;
    }

    public String getPickID() {
        return this.pickID;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public Time getScalingTime() {
        return this.scalingTime;
    }

    public Float getSnr() {
        return this.snr;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public String getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public WaveformStreamID getWaveformID() {
        return this.waveformID;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setEvaluationMode(String evaluationMode) {
        this.evaluationMode = evaluationMode;
    }

    public void setEvaluationStatus(String evaluationStatus) {
        this.evaluationStatus = evaluationStatus;
    }

    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    public void setGenericAmplitude(RealQuantity genericAmplitude) {
        this.genericAmplitude = genericAmplitude;
    }

    public void setMagnitudeHint(String magnitudeHint) {
        this.magnitudeHint = magnitudeHint;
    }

    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    public void setPeriod(RealQuantity period) {
        this.period = period;
    }

    public void setPickID(String pickID) {
        this.pickID = pickID;
    }

    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    public void setScalingTime(Time scalingTime) {
        this.scalingTime = scalingTime;
    }

    public void setSnr(Float snr) {
        this.snr = snr;
    }

    public void setTimeWindow(TimeWindow timeWindow) {
        this.timeWindow = timeWindow;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setWaveformID(WaveformStreamID waveformID) {
        this.waveformID = waveformID;
    }
}

