/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FDSNEventCatalogQuerier
extends AbstractFDSNQuerier {
    FDSNEventQueryParams queryParams;
    String fdsnQueryStyle = "catalogs";

    public FDSNEventCatalogQuerier(FDSNEventQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public URL getSchemaURL() {
        return null;
    }

    public List<String> getCatalogs() throws FDSNWSException {
        return this.getList("Catalog");
    }

    public List<String> getContributors() throws FDSNWSException {
        return this.getList("Contributor");
    }

    List<String> getList(String style) throws FDSNWSException {
        try {
            this.fdsnQueryStyle = style.toLowerCase() + "s";
            this.connect();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    try {
                        XMLEventReader in = this.getReader();
                        return FDSNEventCatalogQuerier.parse(in, style);
                    }
                    catch (XMLStreamException e) {
                        this.handleXmlStreamException(e);
                        throw new RuntimeException("Should not happen");
                    }
                }
                return new ArrayList<String>();
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(this.getConnectionUri());
                throw (FDSNWSException)e;
            }
            throw new FDSNWSException(e.getMessage(), e, this.getConnectionUri());
        }
    }

    static List<String> parse(XMLEventReader reader, String style) throws XMLStreamException, StationXMLException {
        ArrayList<String> out = new ArrayList<String>();
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement(style + "s", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals(style)) {
                    out.add(StaxUtil.pullText(reader, style));
                    continue;
                }
                System.err.println(style + " skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                break;
            }
            e = reader.nextEvent();
        }
        return out;
    }

    String getFdsnQueryStyle() {
        return this.fdsnQueryStyle;
    }

    @Override
    public URI formURI() throws URISyntaxException {
        FDSNEventQueryParams catalogQP = this.queryParams.clone();
        catalogQP.fdsnQueryStyle = this.getFdsnQueryStyle();
        catalogQP.clear();
        return catalogQP.formURI();
    }
}

