/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SeedlinkState {
    private String globalLastSequence = "000000";
    private Map<String, String> lastSeq;
    private List<String> commandList;
    String host;
    int port;

    protected SeedlinkState() {
        this(null, 0, new HashMap<String, String>(), new ArrayList<String>());
    }

    public SeedlinkState(String host, int port, List<String> commandList) {
        this(host, port, new HashMap<String, String>(), commandList);
    }

    public SeedlinkState(String host, int port, Map<String, String> lastSeq, List<String> commandList) {
        this.host = host;
        this.port = port;
        this.commandList = commandList;
        this.lastSeq = lastSeq;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean contains(String netCode, String staCode) {
        return this.lastSeq.containsKey(netCode.trim() + "." + staCode.trim());
    }

    public boolean containsKey(String key) {
        return this.lastSeq.containsKey(key);
    }

    public Set<String> keySet() {
        return this.lastSeq.keySet();
    }

    public void put(String netCode, String staCode, String seq) {
        this.globalLastSequence = seq;
        this.lastSeq.put(netCode.trim() + "." + staCode.trim(), seq);
    }

    public String getForStation(String netCode, String staCode) {
        return this.lastSeq.get(netCode.trim() + "." + staCode.trim());
    }

    public String getGlobalLastSequence() {
        return this.globalLastSequence;
    }

    public void updateGlobalSequence(String seq) {
        this.globalLastSequence = seq;
    }

    public void update(SeedlinkPacket slp) throws SeedFormatException, IOException {
        this.put(slp.getMiniSeed().getHeader().getNetworkCode(), slp.getMiniSeed().getHeader().getStationIdentifier(), slp.getSeqNum());
    }

    public Map<String, String> getMap() {
        return this.lastSeq;
    }

    public List<String> getCommandList() {
        return this.commandList;
    }

    public JSONObject exportToJson() {
        JSONObject json = new JSONObject();
        json.put("host", (Object)this.getHost());
        json.put("port", this.getPort());
        json.put("globalSequence", (Object)this.globalLastSequence);
        JSONArray cmds = new JSONArray();
        for (String c : this.commandList) {
            cmds.put((Object)c);
        }
        json.put("commands", (Object)cmds);
        JSONObject seqVals = new JSONObject();
        json.put("sequence", (Object)seqVals);
        for (String k : this.lastSeq.keySet()) {
            seqVals.put(k, (Object)this.lastSeq.get(k));
        }
        return json;
    }

    public static SeedlinkState importFromJson(JSONObject json) {
        SeedlinkState ls = new SeedlinkState();
        ls.host = json.getString("host");
        ls.port = json.getInt("port");
        ls.globalLastSequence = json.getString("globalSequence");
        JSONObject seqVals = json.getJSONObject("sequence");
        for (String k : seqVals.keySet()) {
            ls.lastSeq.put(k, seqVals.getString(k));
        }
        JSONArray cmdList = json.getJSONArray("commands");
        ls.commandList = new ArrayList<String>();
        for (int i = 0; i < cmdList.length(); ++i) {
            ls.commandList.add(cmdList.getString(i));
        }
        return ls;
    }
}

