/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.IRISFedCatQueryParams;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRISFedCatQuerier
extends AbstractFDSNQuerier {
    public static final String SERVICE_NAME = "fedcatalog";
    IRISFedCatQueryParams queryParams;
    private static Logger logger = LoggerFactory.getLogger(IRISFedCatQuerier.class);

    public IRISFedCatQuerier(IRISFedCatQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public URI formURI() throws URISyntaxException {
        return this.queryParams.formURI();
    }

    @Override
    public URL getSchemaURL() {
        if (this.queryParams.isStation()) {
            FDSNStationXML.findInternalSchema();
        }
        return null;
    }

    public List<Station> getStationsFromText() throws FDSNWSException {
        this.queryParams.setFormat("text");
        if (Objects.equals(this.queryParams.params.get("format"), "text")) {
            this.setAcceptHeader("text/plain");
        }
        try {
            this.connect();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream()));
                    String line = in.readLine().trim();
                    while (line.length() == 0 || line.startsWith("#")) {
                        line = in.readLine().trim();
                    }
                    HashMap<String, Network> networks = new HashMap<String, Network>();
                    ArrayList<Station> staList = new ArrayList<Station>();
                    while (line != null && line.length() != 0) {
                        Network net;
                        String[] split = line.split("\\|");
                        if (networks.containsKey(split[0])) {
                            net = (Network)networks.get(split[0]);
                        } else {
                            net = new Network(split[0]);
                            networks.put(net.getNetworkId(), net);
                        }
                        Station sta = new Station(net, split[1]);
                        sta.setLatitude(Float.parseFloat(split[2]));
                        sta.setLongitude(Float.parseFloat(split[3]));
                        sta.setName(split[4]);
                        sta.setStartDate(split[5]);
                        if (split[6].startsWith("19") || split[6].startsWith("20")) {
                            sta.setEndDate(split[6]);
                        }
                        staList.add(sta);
                        line = in.readLine().trim();
                    }
                    return staList;
                }
                return List.of();
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (IOException e) {
            throw new FDSNWSException("Error parsing text format from server", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(this.getConnectionUri());
                throw (FDSNWSException)e;
            }
            throw new FDSNWSException(e.getMessage(), e, this.getConnectionUri());
        }
    }
}

