/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.Daz;
import edu.sc.seis.TauP.gson.LocationSerializer;
import edu.sc.seis.seisFile.Location;
import java.lang.reflect.Type;

public class DazSerializier
implements JsonSerializer<Daz> {
    LocationSerializer locSerial = new LocationSerializer();

    public JsonElement serialize(Daz src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject out = new JsonObject();
        out.add("deg", (JsonElement)new JsonPrimitive((Number)Float.valueOf((float)src.getDegrees())));
        if (src.getKm() != null) {
            out.add("km", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getKm().floatValue())));
        }
        out.add("az", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getAzimuth().floatValue())));
        out.add("baz", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getBackAzimuth().floatValue())));
        if (src.isGeodetic()) {
            out.add("calctype", (JsonElement)new JsonPrimitive("geodetic"));
            out.add("invflattening", (JsonElement)new JsonPrimitive((Number)src.getInvFlattening()));
        } else {
            out.add("calctype", (JsonElement)new JsonPrimitive("spherical"));
        }
        if (src.hasSource()) {
            out.add("source", this.locSerial.serialize(src.getSource(), (Type)((Object)Location.class), context));
        }
        if (src.hasReceiver()) {
            out.add("receiver", this.locSerial.serialize(src.getReceiver(), (Type)((Object)Location.class), context));
        }
        return out;
    }
}

