/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.AxisType;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.ModelAxisType;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PlotTicks;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.XYPlottingData;
import edu.sc.seis.TauP.XYSegment;
import edu.sc.seis.TauP.cmdline.args.ColorType;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class XYPlotOutput {
    String xLabel = "";
    String yLabel = "";
    List<XYPlottingData> xyPlots;
    ModelArgs modelArgs;
    List<PhaseName> phaseNames = new ArrayList<PhaseName>();
    String title = null;
    ColoringArgs coloringArgs = new ColoringArgs();
    int numXTicks = 8;
    int numYTicks = 8;
    double[] xAxisMinMax = new double[0];
    double[] yAxisMinMax = new double[0];
    boolean xAxisInvert = false;
    boolean yAxisInvert = false;

    public XYPlotOutput(List<XYPlottingData> xyPlots, ModelArgs modelArgs) {
        this.xyPlots = xyPlots;
        this.modelArgs = modelArgs;
    }

    public static void checkEqualMinMax(double[] minmax, double xpercent, double ypercent) {
        double shift;
        if (minmax[0] == minmax[1]) {
            if (minmax[0] == 0.0) {
                minmax[0] = -1.0;
                minmax[1] = 1.0;
            } else {
                shift = Math.abs(minmax[0]) * xpercent;
                minmax[0] = minmax[0] - shift;
                minmax[1] = minmax[1] + shift;
            }
        }
        if (minmax[2] == minmax[3]) {
            if (minmax[2] == 0.0) {
                minmax[2] = -1.0;
                minmax[3] = 1.0;
            } else {
                shift = Math.abs(minmax[2]) * ypercent;
                minmax[2] = minmax[2] - shift;
                minmax[3] = minmax[3] + shift;
            }
        }
    }

    public static List<XYPlottingData> recalcForAbs(List<XYPlottingData> xy, boolean xAxisAbs, boolean yAxisAbs) {
        ArrayList<XYPlottingData> out = new ArrayList<XYPlottingData>();
        for (XYPlottingData xyp : xy) {
            out.add(xyp.recalcForAbs(xAxisAbs, yAxisAbs));
        }
        return out;
    }

    public static List<XYPlottingData> recalcForLog(List<XYPlottingData> xy, boolean xAxisLog, boolean yAxisLog) {
        ArrayList<XYPlottingData> out = new ArrayList<XYPlottingData>();
        for (XYPlottingData xyp : xy) {
            out.add(xyp.recalcForLog(xAxisLog, yAxisLog));
        }
        return out;
    }

    public void setPhaseNames(List<PhaseName> phaseNames) {
        this.phaseNames = phaseNames;
    }

    public void setxAxisMinMax(double[] minMax) {
        this.xAxisMinMax = minMax;
    }

    public void setyAxisMinMax(double[] minMax) {
        this.yAxisMinMax = minMax;
    }

    public void printAsJSON(PrintWriter writer, int indentFactor) {
        writer.println(GsonUtil.toJson(this));
    }

    public void printAsGmtScript(PrintWriter writer, String toolname, List<String> cmdLineArgs, GraphicOutputTypeArgs outputTypeArgs, boolean isLegend) {
        this.printGmtScriptBeginning(writer, toolname, cmdLineArgs, outputTypeArgs);
        int idx = 0;
        for (XYPlottingData xyplotItem : this.xyPlots) {
            Object lineColor = "";
            if (this.coloringArgs.getColoring() == ColorType.auto || this.coloringArgs.getColoring() == ColorType.phase) {
                lineColor = "-W," + this.coloringArgs.colorForIndex(idx);
            } else if (this.coloringArgs.getColoring() == ColorType.wavetype) {
                HashMap<String, String> colorMap = this.coloringArgs.getWavetypeColors();
                for (String colorval : colorMap.keySet()) {
                    if (!xyplotItem.cssClasses.contains(colorval)) continue;
                    lineColor = "-W," + colorMap.get(colorval);
                    break;
                }
            } else if (this.coloringArgs.getColoring() == ColorType.none) {
                lineColor = "-W,black";
            }
            writer.println("# " + xyplotItem.label);
            writer.println("gmt plot  -l'" + xyplotItem.label + "' " + (String)lineColor + " <<END");
            xyplotItem.asGMT(writer);
            writer.println("END");
            writer.println("# end of " + xyplotItem.label);
            ++idx;
        }
        if (isLegend) {
            this.printGmtScriptLegend(writer);
        }
        writer.println("gmt end ");
    }

    public void printGmtScriptBeginning(PrintWriter writer, String toolname, List<String> cmdLineArgs, GraphicOutputTypeArgs outputTypeArgs) {
        String psFile = outputTypeArgs.getGmtOutFileBase(toolname);
        psFile = psFile.replaceAll(" ", "_");
        writer.println("#!/usr/bin/env bash");
        SvgUtil.taupMetadataGMT(writer, toolname, cmdLineArgs, null);
        writer.println("gmt begin " + psFile + "\n");
        double[] minmax = this.calcMinMax();
        ArrayList<Double> xTicks = PlotTicks.getTicks(minmax[0], minmax[1], this.numXTicks, false);
        double xTickStep = xTicks.size() > 1 ? xTicks.get(1) - xTicks.get(0) : 1.0;
        ArrayList<Double> yTicks = PlotTicks.getTicks(minmax[2], minmax[3], this.numYTicks, false);
        double yTickStep = yTicks.size() > 1 ? yTicks.get(1) - yTicks.get(0) : 1.0;
        String xLabelParam = " -Bxa" + xTickStep;
        if (!this.getXLabel().isEmpty()) {
            xLabelParam = xLabelParam + "+l'" + this.getXLabel() + "'";
        }
        String yLabelParam = " -Bya" + yTickStep;
        if (!this.getYLabel().isEmpty()) {
            yLabelParam = yLabelParam + "+l'" + this.getYLabel() + "'";
        }
        Object xScale = outputTypeArgs.mapWidthGMT();
        if (this.isxAxisInvert()) {
            xScale = "-" + (String)xScale;
        }
        Object yScale = outputTypeArgs.mapWidthGMT();
        if (this.isyAxisInvert()) {
            yScale = "-" + (String)yScale;
        }
        String dataRange = " -R" + minmax[0] + "/" + minmax[1] + "/" + minmax[2] + "/" + minmax[3];
        writer.println("gmt basemap -JX" + (String)xScale + "/" + (String)yScale + dataRange + xLabelParam + yLabelParam + " -BWSne+t'" + this.getTitle() + "' ");
    }

    public void printGmtScriptLegend(PrintWriter writer) {
        writer.println("gmt legend -DjTL+o0.25i -Mh -F ");
    }

    public void printAsGmtText(PrintWriter writer) {
        for (XYPlottingData xyplotItem : this.xyPlots) {
            xyplotItem.asGMT(writer);
        }
    }

    public double[] calcMinMax() {
        double[] minmax = XYPlottingData.initMinMax();
        for (XYPlottingData xyplot : this.xyPlots) {
            if (this.xAxisMinMax.length == 2 && this.yAxisMinMax.length == 0) {
                minmax = xyplot.minMaxInXRange(minmax, this.xAxisMinMax);
                continue;
            }
            if (this.xAxisMinMax.length == 0 && this.yAxisMinMax.length == 2) {
                minmax = xyplot.minMaxInYRange(minmax, this.yAxisMinMax);
                continue;
            }
            minmax = xyplot.minMax(minmax);
        }
        if (this.xAxisMinMax.length == 2) {
            minmax[0] = this.xAxisMinMax[0];
            minmax[1] = this.xAxisMinMax[1];
        }
        if (this.yAxisMinMax.length == 2) {
            minmax[2] = this.yAxisMinMax[0];
            minmax[3] = this.yAxisMinMax[1];
        }
        XYPlotOutput.checkEqualMinMax(minmax, 0.05, 0.05);
        return minmax;
    }

    public void printAsHtml(PrintWriter writer, String toolname, List<String> cmdLineArgs, CharSequence extraCSS, boolean isLegend) throws TauPException {
        this.printAsHtml(writer, toolname, cmdLineArgs, 1000.0f, extraCSS, isLegend);
    }

    public void printAsHtml(PrintWriter writer, String toolname, List<String> cmdLineArgs, float pixelWidth, CharSequence extraCSS, boolean isLegend) throws TauPException {
        HTMLUtil.createHtmlStart(writer, "TauP " + toolname, "", false);
        this.printAsSvg(writer, toolname, cmdLineArgs, pixelWidth, extraCSS, isLegend);
        writer.println(HTMLUtil.createHtmlEnding());
    }

    public void printAsSvg(PrintWriter writer, String toolname, List<String> cmdLineArgs, float pixelWidth, CharSequence extraCSS, boolean isLegend) {
        double tmp;
        int margin = 80;
        double[] minmax = this.calcMinMax();
        SvgUtil.xyplotScriptBeginning(writer, toolname, cmdLineArgs, pixelWidth, margin, this.coloringArgs.getColorList(), extraCSS, minmax);
        float plotWidth = pixelWidth - (float)(2 * margin);
        double[] axisMinMax = new double[4];
        System.arraycopy(minmax, 0, axisMinMax, 0, minmax.length);
        if (this.xAxisInvert) {
            tmp = axisMinMax[1];
            axisMinMax[1] = axisMinMax[0];
            axisMinMax[0] = tmp;
        }
        if (this.yAxisInvert) {
            tmp = axisMinMax[3];
            axisMinMax[3] = axisMinMax[2];
            axisMinMax[2] = tmp;
        }
        int xflip = this.xAxisInvert ? -1 : 1;
        int yflip = this.yAxisInvert ? -1 : 1;
        float xfliptrans = this.xAxisInvert ? -1.0f * (float)(minmax[1] + minmax[0]) : 0.0f;
        float yfliptrans = this.yAxisInvert ? -1.0f * (float)(minmax[3] + minmax[2]) : 0.0f;
        float xtrans = (float)minmax[0];
        float ytrans = (float)minmax[2];
        float minMaxScaleX = (float)((double)plotWidth / (minmax[1] - minmax[0]));
        float minMaxScaleY = (float)((double)plotWidth / (minmax[3] - minmax[2]));
        SvgUtil.createXYAxes(writer, axisMinMax[0], axisMinMax[1], this.numXTicks, false, axisMinMax[2], axisMinMax[3], this.numYTicks, false, pixelWidth, margin, this.getTitle(), this.getXLabel(), this.getYLabel());
        writer.println("<g clip-path=\"url(#curve_clip)\">");
        writer.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        writer.println("<g transform=\"scale(" + minMaxScaleX + "," + minMaxScaleY + ")\" >");
        writer.println("<g transform=\"translate(" + -1.0f * xtrans + ", " + -1.0f * ytrans + ")\">");
        if (this.coloringArgs.getColoring() == ColorType.auto) {
            writer.println("    <g class=\"autocolor\">");
        }
        for (XYPlottingData xyplotItem : this.xyPlots) {
            if (this.xAxisInvert || this.yAxisInvert) {
                writer.println("<g transform=\"scale(" + xflip + "," + yflip + ") translate(" + xfliptrans + ", " + yfliptrans + ")\" > <!-- invert axis -->");
            }
            xyplotItem.asSVG(writer);
            if (!this.xAxisInvert && !this.yAxisInvert) continue;
            writer.println("    </g> <!-- end invert axis -->");
        }
        if (this.coloringArgs.getColoring() == ColorType.auto) {
            writer.println("    </g> <!-- end autocolor g -->");
        }
        writer.println("    <g class=\"phasename\">  <!-- begin labels -->");
        writer.println("    </g> <!-- end labels -->");
        writer.println("  </g> <!-- end translate -->");
        writer.println("  </g> <!-- end scale -->");
        writer.println("  </g> <!-- end scaletranslate -->");
        writer.println("  </g> <!-- end clip-path -->");
        if (isLegend) {
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> labelClasses = new ArrayList<String>();
            for (XYPlottingData xyp : this.xyPlots) {
                labels.add(xyp.label);
                labelClasses.add(xyp.cssClassesAsString());
            }
            String autocolorStr = this.coloringArgs.getColoring() == ColorType.auto ? "autocolor" : "";
            SvgUtil.createLegend(writer, labels, labelClasses, autocolorStr, (int)((double)plotWidth * 0.1), (int)((double)plotWidth * 0.1));
        }
        writer.println("</svg>");
    }

    public String getTitle() {
        if (this.title == null && this.modelArgs != null) {
            return this.modelArgs.getModelName() + " (h=" + ModelArgs.depthsToString(this.modelArgs.getSourceDepths()) + " km)";
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String x) {
        this.xLabel = x;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String y) {
        this.yLabel = y;
    }

    public XYPlotOutput convertToCartesian() throws TauPException {
        ArrayList<XYPlottingData> convXYPlotList = new ArrayList<XYPlottingData>();
        for (XYPlottingData xyp : this.xyPlots) {
            if (!(Objects.equals(xyp.xAxisType, AxisType.radian.name()) || Objects.equals(xyp.xAxisType, AxisType.degree180.name()) || Objects.equals(xyp.xAxisType, AxisType.degree.name()) || Objects.equals(xyp.yAxisType, ModelAxisType.depth.name()) || Objects.equals(xyp.yAxisType, ModelAxisType.radius.name()))) {
                throw new TauPException("Unable to convert to cartesian for axis: " + xyp.xAxisType + " " + xyp.yAxisType);
            }
            ArrayList<XYSegment> convSegList = new ArrayList<XYSegment>();
            for (XYSegment seg : xyp.segmentList) {
                double[] xVal = new double[seg.x.length];
                double[] yVal = new double[xVal.length];
                for (int i = 0; i < xVal.length; ++i) {
                    double radian = 0.0;
                    if (Objects.equals(xyp.xAxisType, AxisType.radian.name())) {
                        radian = seg.x[i] - 1.5707963267948966;
                    } else if (Objects.equals(xyp.xAxisType, AxisType.degree.name()) || Objects.equals(xyp.xAxisType, AxisType.degree180.name())) {
                        radian = (seg.x[i] - 90.0) * Math.PI / 180.0;
                    }
                    double radius = 0.0;
                    if (Objects.equals(xyp.yAxisType, ModelAxisType.depth.name())) {
                        radius = this.modelArgs.getTauModel().getRadiusOfEarth() - seg.y[i];
                    } else if (Objects.equals(xyp.yAxisType, ModelAxisType.radius.name())) {
                        radius = seg.y[i];
                    }
                    xVal[i] = radius * Math.cos(radian);
                    yVal[i] = radius * Math.sin(radian);
                }
                XYSegment convSeg = new XYSegment(xVal, yVal);
                convSeg.cssClasses = List.copyOf(seg.cssClasses);
                convSeg.description = seg.description;
                convSegList.add(convSeg);
            }
            convXYPlotList.add(new XYPlottingData(convSegList, AxisType.kilometer.name(), AxisType.kilometer.name(), xyp.label, xyp.description, xyp.cssClasses));
        }
        XYPlotOutput out = new XYPlotOutput(convXYPlotList, this.modelArgs);
        out.setPhaseNames(this.phaseNames);
        out.title = this.title;
        out.coloringArgs = this.coloringArgs;
        return out;
    }

    public boolean isAutoColor() {
        return this.coloringArgs.getColoring() == ColorType.auto;
    }

    public void setAutoColor(boolean autoColor) {
        this.coloringArgs.setColoring(ColorType.auto);
    }

    public ColoringArgs getColoringArgs() {
        return this.coloringArgs;
    }

    public void setColoringArgs(ColoringArgs ca) {
        this.coloringArgs = ca;
    }

    public int getNumXTicks() {
        return this.numXTicks;
    }

    public void setNumXTicks(int numXTicks) {
        this.numXTicks = numXTicks;
    }

    public int getNumYTicks() {
        return this.numYTicks;
    }

    public void setNumYTicks(int numYTicks) {
        this.numYTicks = numYTicks;
    }

    public boolean isxAxisInvert() {
        return this.xAxisInvert;
    }

    public void setxAxisInvert(boolean xAxisInvert) {
        this.xAxisInvert = xAxisInvert;
    }

    public boolean isyAxisInvert() {
        return this.yAxisInvert;
    }

    public void setyAxisInvert(boolean yAxisInvert) {
        this.yAxisInvert = yAxisInvert;
    }

    public ModelArgs getModelArgs() {
        return this.modelArgs;
    }

    public List<PhaseName> getPhaseNames() {
        return this.phaseNames;
    }

    public List<XYPlottingData> getXYPlots() {
        return this.xyPlots;
    }
}

